/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.python.ultimate.django;

import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PrivacyPathCheckerKt;
import com.intellij.ml.llm.privacy.extensions.ExternalAiIgnoreAwarePrivacyWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.django.model.applications.DjangoApplicationModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ml/llm/python/ultimate/django/DjangoApplicationModelPrivacyWrapper;", "Lcom/intellij/ml/llm/privacy/extensions/ExternalAiIgnoreAwarePrivacyWrapper;", "djangoApplicationModel", "Lcom/jetbrains/django/model/applications/DjangoApplicationModel;", "<init>", "(Lcom/jetbrains/django/model/applications/DjangoApplicationModel;)V", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "name", "Lcom/intellij/ml/llm/privacy/PSString;", "getName", "()Lcom/intellij/ml/llm/privacy/PSString;", "intellij.ml.llm.python.ultimate"})
public final class DjangoApplicationModelPrivacyWrapper
extends ExternalAiIgnoreAwarePrivacyWrapper {
    @NotNull
    private final DjangoApplicationModel djangoApplicationModel;

    public DjangoApplicationModelPrivacyWrapper(@NotNull DjangoApplicationModel djangoApplicationModel) {
        Intrinsics.checkNotNullParameter((Object)djangoApplicationModel, (String)"djangoApplicationModel");
        this.djangoApplicationModel = djangoApplicationModel;
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.djangoApplicationModel.getApplicationRootFolder().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        return project2;
    }

    @Nullable
    public final PSString getName() {
        Project project2 = this.getProject();
        VirtualFile virtualFile2 = this.djangoApplicationModel.getApplicationRootFolder().getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
        if (PrivacyPathCheckerKt.isAiIgnoreBlocked(project2, virtualFile2)) {
            return null;
        }
        String string = this.djangoApplicationModel.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return this.promisedSafety(string);
    }
}

