/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.python.ultimate.intentions.chat;

import com.intellij.ml.llm.core.chat.attachments.ChatAttachment;
import com.intellij.ml.llm.core.chat.attachments.RelatedCodeChatAttachment;
import com.intellij.ml.llm.core.chat.context.ChatCodeDescription;
import com.intellij.ml.llm.intentions.chat.AbstractChatIntention;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.PrivacyPathCheckerKt;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.python.context.PythonContextUtils;
import com.intellij.ml.llm.python.ultimate.PythonUltimateLLMBundle;
import com.intellij.ml.llm.python.ultimate.intentions.chat.PyLLMDjangoUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.jetbrains.django.model.modelApi.DjangoModelClass;
import com.jetbrains.python.psi.PyClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J*\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/python/ultimate/intentions/chat/PythonDjangoCreateForModelAbstractChatIntention;", "Lcom/intellij/ml/llm/intentions/chat/AbstractChatIntention;", "<init>", "()V", "getFamilyName", "", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "getAttachments", "", "Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment;", "codeContext", "Lcom/intellij/ml/llm/core/chat/context/ChatCodeDescription;", "elementToExplain", "Lcom/intellij/psi/PsiElement;", "intellij.ml.llm.python.ultimate"})
@SourceDebugExtension(value={"SMAP\nPythonDjangoCreateForModelAbstractChatIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PythonDjangoCreateForModelAbstractChatIntention.kt\ncom/intellij/ml/llm/python/ultimate/intentions/chat/PythonDjangoCreateForModelAbstractChatIntention\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n1563#2:70\n1634#2,3:71\n774#2:74\n865#2,2:75\n1563#2:77\n1634#2,3:78\n774#2:81\n865#2,2:82\n*S KotlinDebug\n*F\n+ 1 PythonDjangoCreateForModelAbstractChatIntention.kt\ncom/intellij/ml/llm/python/ultimate/intentions/chat/PythonDjangoCreateForModelAbstractChatIntention\n*L\n41#1:70\n41#1:71,3\n41#1:74\n41#1:75,2\n42#1:77\n42#1:78,3\n42#1:81\n42#1:82,2\n*E\n"})
public abstract class PythonDjangoCreateForModelAbstractChatIntention
extends AbstractChatIntention {
    public PythonDjangoCreateForModelAbstractChatIntention() {
        super(null, 1, null);
    }

    @NotNull
    public String getFamilyName() {
        return PythonUltimateLLMBundle.message("intentions.django.family.name", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project2, @Nullable Editor editor2, @Nullable PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (psiFile == null) {
            return false;
        }
        if (editor2 == null) {
            return false;
        }
        if (!PyLLMDjangoUtils.INSTANCE.isDjangoProject(project2)) {
            return false;
        }
        PsiElement psiElement = psiFile.findElementAt(editor2.getCaretModel().getOffset());
        if (psiElement == null) {
            return false;
        }
        PsiElement element2 = psiElement;
        if (PrivacyPathCheckerKt.isAiIgnoreBlocked(element2)) {
            return false;
        }
        PyClass modelClass = PyLLMDjangoUtils.INSTANCE.findModelClass(element2);
        return modelClass != null && PyLLMDjangoUtils.INSTANCE.isDjangoModelClass(modelClass);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<ChatAttachment> getAttachments(@Nullable ChatCodeDescription codeContext, @Nullable PsiElement elementToExplain, @NotNull Project project2) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapTo$iv$iv;
        void $this$filterTo$iv$iv2;
        void $this$filter$iv2;
        PyClass it;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        int maxLength = 10000;
        PyClass elementClass = elementToExplain instanceof PyClass ? (PyClass)elementToExplain : null;
        PsiElement psiElement = elementToExplain;
        if (psiElement == null || (psiElement = psiElement.getProject()) == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement project3 = psiElement;
        PsiFile containingFile = elementToExplain.getContainingFile();
        List<DjangoModelClass> models2 = PyLLMDjangoUtils.INSTANCE.getAllModels((Project)project3);
        Iterable $this$map$iv = models2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            DjangoModelClass djangoModelClass = (DjangoModelClass)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPyClass());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv2 = $this$filter$iv2;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (PyClass)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getContainingFile(), (Object)containingFile) && !Intrinsics.areEqual((Object)it, (Object)elementClass))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List sameFileModels = (List)destination$iv$iv;
        Iterable $this$map$iv2 = models2;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            DjangoModelClass bl = (DjangoModelClass)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it2.getPyClass());
        }
        $this$map$iv2 = (List)destination$iv$iv2;
        boolean $i$f$filter2 = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PyClass it3 = (PyClass)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it3.getContainingFile(), (Object)containingFile))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List otherModels = (List)destination$iv$iv2;
        Ref.IntRef lengthCnt = new Ref.IntRef();
        ArrayList<RelatedCodeChatAttachment> result2 = new ArrayList<RelatedCodeChatAttachment>();
        if (elementClass != null) {
            PythonDjangoCreateForModelAbstractChatIntention.getAttachments$addToResultIfEnoughLength(lengthCnt, maxLength, result2, elementClass);
        }
        for (PyClass model : sameFileModels) {
            if (PythonDjangoCreateForModelAbstractChatIntention.getAttachments$addToResultIfEnoughLength(lengthCnt, maxLength, result2, model)) continue;
            return result2;
        }
        for (PyClass model : otherModels) {
            if (PythonDjangoCreateForModelAbstractChatIntention.getAttachments$addToResultIfEnoughLength(lengthCnt, maxLength, result2, model)) continue;
            return result2;
        }
        return result2;
    }

    private static final boolean getAttachments$addToResultIfEnoughLength(Ref.IntRef lengthCnt, int maxLength, ArrayList<RelatedCodeChatAttachment> result2, PyClass model) {
        PSString signatureText = PythonContextUtils.INSTANCE.getClassSignatureMarkdownSnippet(model);
        lengthCnt.element += signatureText.length();
        if (lengthCnt.element > maxLength) {
            return false;
        }
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{ExtensionsKtKt.getPrivacySafe((PsiNamedElement)model).getName()};
        result2.add(new RelatedCodeChatAttachment(ConstantsKt.getPrivacyConst((String)"Django model %s").format(pSStringConvertibleArray), signatureText, null, 4, null));
        return true;
    }
}

