/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.recap.chronicles;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.ml.llm.recap.IsChroniclesEnabledKt;
import com.intellij.ml.llm.recap.chronicles.ChronicleEntry;
import com.intellij.ml.llm.recap.chronicles.events.storage.ChroniclesEventExtensionsKt;
import com.intellij.ml.llm.recap.chronicles.events.storage.ChroniclesStorage;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import java.io.BufferedReader;
import java.io.Closeable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bJ\u0006\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/recap/chronicles/ChroniclesMock;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getPath", "Ljava/nio/file/Path;", "tryReadMockEntries", "", "Lcom/intellij/ml/llm/recap/chronicles/ChronicleEntry;", "dump", "", "Companion", "intellij.ml.llm.recap"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nChroniclesMock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChroniclesMock.kt\ncom/intellij/ml/llm/recap/chronicles/ChroniclesMock\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,82:1\n13#2:83\n*S KotlinDebug\n*F\n+ 1 ChroniclesMock.kt\ncom/intellij/ml/llm/recap/chronicles/ChroniclesMock\n*L\n24#1:83\n*E\n"})
public final class ChroniclesMock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    public static final int $stable = 8;
    @NotNull
    private static final Logger log;

    public ChroniclesMock(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final Path getPath() {
        String string = this.project.getBasePath();
        if (string == null) {
            return null;
        }
        String basePath = string;
        String[] stringArray = new String[]{".mock", "chronicles", "chronicles.csv"};
        return Paths.get(basePath, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final List<ChronicleEntry> tryReadMockEntries() {
        try {
            if (!IsChroniclesEnabledKt.isChroniclesEnabled()) {
                return null;
            }
            if (!Registry.Companion.is("llm.riderNext.chronicles.mock", false)) {
                return null;
            }
            Path path = this.getPath();
            if (path == null) {
                return null;
            }
            Path mockPath = path;
            if (!Files.exists(mockPath, new LinkOption[0])) {
                return null;
            }
            List entries = new ArrayList();
            Closeable closeable = Files.newBufferedReader(mockPath);
            Throwable throwable = null;
            try {
                BufferedReader reader2 = (BufferedReader)closeable;
                boolean bl = false;
                reader2.lines().forEach(arg_0 -> ChroniclesMock.tryReadMockEntries$lambda$0$1(arg_0 -> ChroniclesMock.tryReadMockEntries$lambda$0$0(this, entries, arg_0), arg_0));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return entries;
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Throwable t) {
            log.warn("Failed to read mock chronicles: " + t.getMessage());
            return null;
        }
    }

    public final void dump() {
        FileSaverDescriptor descriptor2 = new FileSaverDescriptor("Save Chronicles", "Save chronicles.csv file", "csv");
        FileSaverDialog fileSaverDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor2, this.project);
        Intrinsics.checkNotNullExpressionValue((Object)fileSaverDialog, (String)"createSaveFileDialog(...)");
        FileSaverDialog dialog2 = fileSaverDialog;
        VirtualFileWrapper wrapper = dialog2.save("chronicles.csv");
        if (wrapper != null) {
            Path target = wrapper.getFile().toPath();
            Path source = ChroniclesStorage.Companion.getInstance(this.project).getCsvPath();
            try {
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Files.copy(source, target, copyOptionArray);
            }
            catch (ProcessCanceledException pce) {
                throw pce;
            }
            catch (Throwable e) {
                log.error("Failed to copy mock chronicles: " + e.getMessage());
            }
        }
    }

    private static final Unit tryReadMockEntries$lambda$0$0(ChroniclesMock this$0, List $entries, String line) {
        Object object;
        Object $this$tryReadMockEntries_u24lambda_u240_u240_u240;
        Intrinsics.checkNotNull((Object)line);
        if (StringsKt.isBlank((CharSequence)line)) {
            return Unit.INSTANCE;
        }
        Object object2 = this$0;
        try {
            $this$tryReadMockEntries_u24lambda_u240_u240_u240 = object2;
            boolean bl = false;
            object = new String[]{","};
            List csv = StringsKt.split$default((CharSequence)line, (String[])object, (boolean)false, (int)0, (int)6, null);
            $this$tryReadMockEntries_u24lambda_u240_u240_u240 = Result.constructor-impl((Object)Result.box-impl((Object)ChroniclesEventExtensionsKt.fromCsv(ChronicleEntry.Companion, csv)));
        }
        catch (Throwable bl) {
            $this$tryReadMockEntries_u24lambda_u240_u240_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$tryReadMockEntries_u24lambda_u240_u240_u240;
        if (Result.isSuccess-impl((Object)object2)) {
            Object result2 = ((Result)object2).unbox-impl();
            boolean bl = false;
            if (Result.isSuccess-impl((Object)result2)) {
                object = result2;
                ResultKt.throwOnFailure((Object)object);
                $entries.add(object);
            }
        }
        return Unit.INSTANCE;
    }

    private static final void tryReadMockEntries$lambda$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ChroniclesMock.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/recap/chronicles/ChroniclesMock$Companion;", "", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/intellij/ml/llm/recap/chronicles/ChroniclesMock;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.ml.llm.recap"})
    @SourceDebugExtension(value={"SMAP\nChroniclesMock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChroniclesMock.kt\ncom/intellij/ml/llm/recap/chronicles/ChroniclesMock$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,82:1\n30#2,2:83\n*S KotlinDebug\n*F\n+ 1 ChroniclesMock.kt\ncom/intellij/ml/llm/recap/chronicles/ChroniclesMock$Companion\n*L\n25#1:83,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ChroniclesMock getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<ChroniclesMock> serviceClass$iv = ChroniclesMock.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ChroniclesMock)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

