/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.recap.chronicles.events.listeners;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.ml.llm.recap.IsChroniclesEnabledKt;
import com.intellij.ml.llm.recap.chronicles.ChronicleEntry;
import com.intellij.ml.llm.recap.chronicles.ChroniclePath;
import com.intellij.ml.llm.recap.chronicles.events.ChronicleEvent;
import com.intellij.ml.llm.recap.chronicles.events.ChroniclesEvents;
import com.intellij.ml.llm.recap.chronicles.events.mergeableEvents.ChronicleEventFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u001aH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ml/llm/recap/chronicles/events/listeners/ChroniclesFileListener;", "Lcom/intellij/openapi/vfs/AsyncFileListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "chroniclesEvents", "Lcom/intellij/ml/llm/recap/chronicles/events/ChroniclesEvents;", "getChroniclesEvents", "()Lcom/intellij/ml/llm/recap/chronicles/events/ChroniclesEvents;", "chroniclesEvents$delegate", "Lkotlin/Lazy;", "prepareChange", "Lcom/intellij/openapi/vfs/AsyncFileListener$ChangeApplier;", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "handleCopy", "", "event", "Lcom/intellij/openapi/vfs/newvfs/events/VFileCopyEvent;", "handleMove", "Lcom/intellij/openapi/vfs/newvfs/events/VFileMoveEvent;", "handlePropertyChange", "Lcom/intellij/openapi/vfs/newvfs/events/VFilePropertyChangeEvent;", "intellij.ml.llm.recap"})
@StabilityInferred(parameters=0)
public final class ChroniclesFileListener
implements AsyncFileListener {
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy chroniclesEvents$delegate;
    public static final int $stable = 8;

    public ChroniclesFileListener(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.chroniclesEvents$delegate = LazyKt.lazy(() -> ChroniclesFileListener.chroniclesEvents_delegate$lambda$0(this));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final ChroniclesEvents getChroniclesEvents() {
        Lazy lazy = this.chroniclesEvents$delegate;
        return (ChroniclesEvents)lazy.getValue();
    }

    @Nullable
    public AsyncFileListener.ChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        if (!IsChroniclesEnabledKt.isChroniclesEnabled()) {
            return null;
        }
        return new AsyncFileListener.ChangeApplier(events, this){
            final /* synthetic */ List<VFileEvent> $events;
            final /* synthetic */ ChroniclesFileListener this$0;
            {
                this.$events = $events;
                this.this$0 = $receiver;
            }

            public void afterVfsChange() {
                if (!IsChroniclesEnabledKt.isChroniclesEnabled()) {
                    return;
                }
                for (VFileEvent event2 : this.$events) {
                    VFileEvent vFileEvent = event2;
                    if (vFileEvent instanceof VFileCopyEvent) {
                        ChroniclesFileListener.access$handleCopy(this.this$0, (VFileCopyEvent)event2);
                        continue;
                    }
                    if (vFileEvent instanceof VFileMoveEvent) {
                        ChroniclesFileListener.access$handleMove(this.this$0, (VFileMoveEvent)event2);
                        continue;
                    }
                    if (!(vFileEvent instanceof VFilePropertyChangeEvent)) continue;
                    ChroniclesFileListener.access$handlePropertyChange(this.this$0, (VFilePropertyChangeEvent)event2);
                }
            }
        };
    }

    private final void handleCopy(VFileCopyEvent event2) {
        String to = event2.getNewParent().getPath() + "/" + event2.getNewChildName();
        ChroniclesEvents chroniclesEvents = this.getChroniclesEvents();
        String string = event2.getFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        chroniclesEvents.add(new ChronicleEventFile(string, new ChronicleEventFile.Kind.CopyFile(to), null));
    }

    private final void handleMove(VFileMoveEvent event2) {
        String string = event2.getOldPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOldPath(...)");
        String oldPath = string;
        String string2 = event2.getNewPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getNewPath(...)");
        String newPath = string2;
        this.getChroniclesEvents().add(new ChronicleEventFile(oldPath, new ChronicleEventFile.Kind.MoveFile(newPath), null));
    }

    private final void handlePropertyChange(VFilePropertyChangeEvent event2) {
        if (Intrinsics.areEqual((Object)event2.getPropertyName(), (Object)"name")) {
            String oldPath = event2.getFile().getParent().getPath() + "/" + event2.getOldValue();
            String newPath = event2.getFile().getParent().getPath() + "/" + event2.getNewValue();
            this.getChroniclesEvents().add(new ChronicleEvent.Lazy((Function2<? super Project, ? super Continuation<? super ChronicleEntry>, ? extends Object>)((Function2)new Function2<Project, Continuation<? super ChronicleEntry>, Object>(oldPath, newPath, null){
                Object L$1;
                int label;
                /* synthetic */ Object L$0;
                final /* synthetic */ String $oldPath;
                final /* synthetic */ String $newPath;
                {
                    this.$oldPath = $oldPath;
                    this.$newPath = $newPath;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = (Project)this.L$0;
                    var5_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.L$0 = it;
                            this.label = 1;
                            v0 = ChroniclePath.Companion.createSafe(this.$oldPath, (Project)it, (Continuation<? super ChroniclePath>)((Continuation)this));
                            if (v0 == var5_3) {
                                return var5_3;
                            }
                            ** GOTO lbl15
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl15:
                            // 2 sources

                            v1 = (ChroniclePath)v0;
                            if (v1 == null) {
                                return null;
                            }
                            old = v1;
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)it);
                            this.L$1 = old;
                            this.label = 2;
                            v2 = ChroniclePath.Companion.createSafe(this.$newPath, (Project)it, (Continuation<? super ChroniclePath>)((Continuation)this));
                            if (v2 == var5_3) {
                                return var5_3;
                            }
                            ** GOTO lbl30
                        }
                        case 2: {
                            old = (ChroniclePath)this.L$1;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl30:
                            // 2 sources

                            v3 = (ChroniclePath)v2;
                            if (v3 == null) {
                                return null;
                            }
                            new = v3;
                            return new ChronicleEntry.MoveFile(old, new, 0L, 4, null);
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(Project p1, Continuation<? super ChronicleEntry> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            })));
        }
    }

    private static final ChroniclesEvents chroniclesEvents_delegate$lambda$0(ChroniclesFileListener this$0) {
        return ChroniclesEvents.Companion.getInstance(this$0.project);
    }

    public static final /* synthetic */ void access$handleCopy(ChroniclesFileListener $this, VFileCopyEvent event2) {
        $this.handleCopy(event2);
    }

    public static final /* synthetic */ void access$handleMove(ChroniclesFileListener $this, VFileMoveEvent event2) {
        $this.handleMove(event2);
    }

    public static final /* synthetic */ void access$handlePropertyChange(ChroniclesFileListener $this, VFilePropertyChangeEvent event2) {
        $this.handlePropertyChange(event2);
    }
}

