/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.recap.chronicles.events.storage;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.ml.llm.recap.chronicles.ChronicleEntry;
import com.intellij.ml.llm.recap.chronicles.events.storage.ChroniclesEventExtensionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.registry.Registry;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0014\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fJ\b\u0010\u0010\u001a\u00020\fH\u0002J\u0016\u0010\u0011\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/recap/chronicles/events/storage/ChroniclesStorageFile;", "", "csvPath", "Ljava/nio/file/Path;", "entries", "", "Lcom/intellij/ml/llm/recap/chronicles/ChronicleEntry;", "<init>", "(Ljava/nio/file/Path;Ljava/util/List;)V", "getCsvPath", "()Ljava/nio/file/Path;", "append", "", "newEntries", "getEntries", "", "cutOff", "flush", "events", "Companion", "intellij.ml.llm.recap"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nChroniclesStorageFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChroniclesStorageFile.kt\ncom/intellij/ml/llm/recap/chronicles/events/storage/ChroniclesStorageFile\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,112:1\n13#2:113\n*S KotlinDebug\n*F\n+ 1 ChroniclesStorageFile.kt\ncom/intellij/ml/llm/recap/chronicles/events/storage/ChroniclesStorageFile\n*L\n16#1:113\n*E\n"})
public final class ChroniclesStorageFile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path csvPath;
    @NotNull
    private List<ChronicleEntry> entries;
    public static final int $stable = 8;
    @NotNull
    private static final Logger log;

    public ChroniclesStorageFile(@NotNull Path csvPath, @NotNull List<ChronicleEntry> entries) {
        Intrinsics.checkNotNullParameter((Object)csvPath, (String)"csvPath");
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        this.csvPath = csvPath;
        this.entries = entries;
    }

    @NotNull
    public final Path getCsvPath() {
        return this.csvPath;
    }

    public final void append(@NotNull List<ChronicleEntry> newEntries) {
        Intrinsics.checkNotNullParameter(newEntries, (String)"newEntries");
        this.flush(newEntries);
        this.entries.addAll((Collection<ChronicleEntry>)newEntries);
        this.cutOff();
    }

    @NotNull
    public final List<ChronicleEntry> getEntries() {
        return this.entries;
    }

    private final void cutOff() {
        int maxEntries = Registry.Companion.intValue("llm.riderNext.chronicles.maxEntries");
        if (this.entries.size() <= maxEntries) {
            return;
        }
        int cutoff = maxEntries / 2;
        log.debug("Chronicles storage file " + this.csvPath + " is too large, " + this.entries.size() + " entries. Cutoff to " + cutoff + " entries.");
        List lastEntries = CollectionsKt.takeLast(this.entries, (int)cutoff);
        this.entries = CollectionsKt.toMutableList((Collection)lastEntries);
        Files.deleteIfExists(this.csvPath);
        Files.createFile(this.csvPath, new FileAttribute[0]);
        this.flush(this.entries);
        log.debug("Chronicles storage file " + this.csvPath + " has been trimmed to " + this.entries.size() + " entries.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void flush(List<? extends ChronicleEntry> events) {
        Object object = new OpenOption[]{StandardOpenOption.APPEND};
        object = Files.newBufferedWriter(this.csvPath, object);
        Throwable throwable = null;
        try {
            BufferedWriter writer = (BufferedWriter)object;
            boolean bl = false;
            for (ChronicleEntry chronicleEntry : events) {
                String csv = ChroniclesEventExtensionsKt.toCsv(chronicleEntry);
                Intrinsics.checkNotNull((Object)writer);
                ((Appendable)writer).append(csv).append('\n');
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ChroniclesStorageFile.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/recap/chronicles/events/storage/ChroniclesStorageFile$Companion;", "", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "load", "Lcom/intellij/ml/llm/recap/chronicles/events/storage/ChroniclesStorageFile;", "project", "Lcom/intellij/openapi/project/Project;", "createNewCsvFile", "", "csvPath", "Ljava/nio/file/Path;", "readCsvFile", "", "Lcom/intellij/ml/llm/recap/chronicles/ChronicleEntry;", "intellij.ml.llm.recap"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ChroniclesStorageFile load(@NotNull Project project2) {
            List list;
            Path csvPath;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Path dirPath = ProjectUtil.getProjectDataPath((Project)project2, (String)"chronicles");
            if (!Files.exists(dirPath, new LinkOption[0])) {
                Files.createDirectories(dirPath, new FileAttribute[0]);
            }
            if (!Files.exists(csvPath = dirPath.resolve("chronicles.csv"), new LinkOption[0])) {
                Intrinsics.checkNotNull((Object)csvPath);
                this.createNewCsvFile(csvPath);
                list = new ArrayList();
            } else {
                Intrinsics.checkNotNull((Object)csvPath);
                list = this.readCsvFile(csvPath);
            }
            List entries = list;
            return new ChroniclesStorageFile(csvPath, entries);
        }

        private final void createNewCsvFile(Path csvPath) {
            Files.createFile(csvPath, new FileAttribute[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final List<ChronicleEntry> readCsvFile(Path csvPath) {
            List list;
            Closeable closeable = Files.newBufferedReader(csvPath);
            Throwable throwable = null;
            try {
                BufferedReader reader2 = (BufferedReader)closeable;
                boolean bl = false;
                List entries = new ArrayList();
                reader2.lines().forEach(arg_0 -> Companion.readCsvFile$lambda$0$1(arg_0 -> Companion.readCsvFile$lambda$0$0(entries, arg_0), arg_0));
                list = entries;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return list;
        }

        private static final Unit readCsvFile$lambda$0$0(List $entries, String line) {
            Intrinsics.checkNotNull((Object)line);
            if (StringsKt.isBlank((CharSequence)line)) {
                return Unit.INSTANCE;
            }
            try {
                String[] stringArray = new String[]{","};
                List csv = StringsKt.split$default((CharSequence)line, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                Object entry = ChroniclesEventExtensionsKt.fromCsv(ChronicleEntry.Companion, csv);
                if (Result.isSuccess-impl((Object)entry)) {
                    Object object = entry;
                    ResultKt.throwOnFailure((Object)object);
                    $entries.add(object);
                } else {
                    Throwable throwable = Result.exceptionOrNull-impl((Object)entry);
                    log.warn("Failed to parse csv line " + line + ": " + (throwable != null ? throwable.getMessage() : null));
                }
            }
            catch (ProcessCanceledException pce) {
                throw pce;
            }
            catch (Throwable e) {
                log.error(e);
            }
            return Unit.INSTANCE;
        }

        private static final void readCsvFile$lambda$0$1(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

