/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.recap.chronicles.lvcsUtils;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.IdeaTextPatchBuilder;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.UnifiedDiffWriter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.LocalFilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.project.ProjectKt;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fJ&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/recap/chronicles/lvcsUtils/RecapPatchesUtils;", "", "<init>", "()V", "writePatches", "", "project", "Lcom/intellij/openapi/project/Project;", "vcsChanges", "", "Lcom/intellij/openapi/vcs/changes/Change;", "writer", "Ljava/io/StringWriter;", "patches", "", "Lcom/intellij/openapi/diff/impl/patch/FilePatch;", "shortenDeletedFiles", "", "intellij.ml.llm.recap"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nRecapPatchesUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecapPatchesUtils.kt\ncom/intellij/ml/llm/recap/chronicles/lvcsUtils/RecapPatchesUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,45:1\n1#2:46\n1869#3,2:47\n*S KotlinDebug\n*F\n+ 1 RecapPatchesUtils.kt\ncom/intellij/ml/llm/recap/chronicles/lvcsUtils/RecapPatchesUtils\n*L\n29#1:47,2\n*E\n"})
public final class RecapPatchesUtils {
    @NotNull
    public static final RecapPatchesUtils INSTANCE = new RecapPatchesUtils();
    public static final int $stable;

    private RecapPatchesUtils() {
    }

    public final void writePatches(@NotNull Project project2, @NotNull Collection<? extends Change> vcsChanges, @NotNull StringWriter writer) {
        List list;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(vcsChanges, (String)"vcsChanges");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        List $this$writePatches_u24lambda_u240 = list = IdeaTextPatchBuilder.buildPatch((Project)project2, vcsChanges, (Path)ProjectKt.getStateStore((Project)project2).getProjectBasePath(), (boolean)false, (boolean)true);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$writePatches_u24lambda_u240);
        INSTANCE.writePatches(writer, $this$writePatches_u24lambda_u240, true);
    }

    private final void writePatches(StringWriter writer, List<? extends FilePatch> patches, boolean shortenDeletedFiles) {
        Iterable $this$forEach$iv = patches;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FilePatch patch = (FilePatch)element$iv;
            boolean bl = false;
            if (patch instanceof TextFilePatch && ((TextFilePatch)patch).isDeletedFile() && shortenDeletedFiles) {
                String string = "\n            deleted file %s\n        ";
                Object[] objectArray = new Object[]{new LocalFilePath(((TextFilePatch)patch).getBeforeName(), false).getPath()};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                writer.write(StringsKt.trimIndent((String)string2) + "\n");
                continue;
            }
            UnifiedDiffWriter.writeBeforePath((Writer)writer, (FilePatch)patch, (String)"\n", (boolean)false);
            UnifiedDiffWriter.writeAfterPath((Writer)writer, (FilePatch)patch, (String)"\n", (boolean)false);
            if (!(patch instanceof TextFilePatch)) continue;
            UnifiedDiffWriter.writeHunk((Writer)writer, (TextFilePatch)((TextFilePatch)patch), (String)"\n", (String)"\n");
        }
    }
}

