/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.recap.chronicles.statistics;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.ml.llm.recap.chronicles.ai.RecapAgentResult;
import com.intellij.ml.llm.recap.chronicles.statistics.RecapCorrelationId;
import com.intellij.ml.llm.recap.chronicles.statistics.RecapRating;
import com.intellij.ml.llm.recap.chronicles.statistics.RecapTraceLlmcLogger;
import com.intellij.ml.llm.recap.chronicles.view.ChroniclePresenterAISection;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.concurrent.atomics.AtomicsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0015\u001a\u00020\bJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\bJ\u0010\u0010\u0019\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u0010J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\bH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0010H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Lcom/intellij/ml/llm/recap/chronicles/statistics/RecapStatisticsAggregator;", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "sendChannel", "Lkotlinx/coroutines/channels/Channel;", "Lcom/intellij/ml/llm/recap/chronicles/statistics/RecapCorrelationId;", "correlationIdCounter", "Lkotlin/concurrent/atomics/AtomicLong;", "Ljava/util/concurrent/atomic/AtomicLong;", "sent", "Ljava/util/concurrent/atomic/AtomicBoolean;", "currentImpl", "Lkotlin/concurrent/atomics/AtomicReference;", "Lcom/intellij/ml/llm/recap/chronicles/ai/RecapAgentResult;", "Ljava/util/concurrent/atomic/AtomicReference;", "current", "getCurrent", "()Lcom/intellij/ml/llm/recap/chronicles/ai/RecapAgentResult;", "getCorrelationId", "scheduleLog", "", "correlationId", "onUpdate", "new", "flushImpl", "id", "hasVotes", "", "result", "Companion", "intellij.ml.llm.recap"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nRecapStatisticsAggregator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecapStatisticsAggregator.kt\ncom/intellij/ml/llm/recap/chronicles/statistics/RecapStatisticsAggregator\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n57#2:80\n35#2,2:81\n1761#3,3:83\n1761#3,3:86\n*S KotlinDebug\n*F\n+ 1 RecapStatisticsAggregator.kt\ncom/intellij/ml/llm/recap/chronicles/statistics/RecapStatisticsAggregator\n*L\n60#1:80\n60#1:81,2\n76#1:83,3\n77#1:86,3\n*E\n"})
public final class RecapStatisticsAggregator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Channel<RecapCorrelationId> sendChannel;
    @NotNull
    private final AtomicLong correlationIdCounter;
    @NotNull
    private final AtomicBoolean sent;
    @NotNull
    private final AtomicReference<RecapAgentResult> currentImpl;
    public static final int $stable = 8;
    private static final long THROTTLE_MS = 30000L;

    public RecapStatisticsAggregator(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.sendChannel = ChannelKt.Channel$default((int)Integer.MAX_VALUE, null, null, (int)6, null);
        this.correlationIdCounter = new AtomicLong(0L);
        this.sent = new AtomicBoolean(false);
        this.currentImpl = new AtomicReference<Object>(null);
        BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ RecapStatisticsAggregator this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowKt.debounce((Flow)FlowKt.consumeAsFlow((ReceiveChannel)((ReceiveChannel)this.this$0.sendChannel)), (long)30000L).collect(new FlowCollector(){

                            public final Object emit(RecapCorrelationId it, Continuation<? super Unit> $completion) {
                                this$0.flushImpl(it);
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Nullable
    public final RecapAgentResult getCurrent() {
        return this.currentImpl.get();
    }

    @NotNull
    public final RecapCorrelationId getCorrelationId() {
        long id = AtomicsKt.incrementAndFetch((AtomicLong)this.correlationIdCounter);
        return new RecapCorrelationId(id);
    }

    public final void scheduleLog(@NotNull RecapCorrelationId correlationId) {
        Intrinsics.checkNotNullParameter((Object)correlationId, (String)"correlationId");
        this.sent.set(false);
        this.sendChannel.trySend-JP2dKIU((Object)correlationId);
    }

    public final void onUpdate(@Nullable RecapAgentResult recapAgentResult) {
        RecapAgentResult oldState = this.currentImpl.getAndSet(recapAgentResult);
        if (!this.sent.get() && oldState != null && this.hasVotes(oldState)) {
            boolean $i$f$fileLogger = false;
            boolean $i$f$currentClassLogger = false;
            Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
            Logger logger = Logger.getInstance(clazz$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.trace("Flushing old state");
            RecapTraceLlmcLogger.INSTANCE.log(oldState);
        }
        this.sent.set(false);
    }

    private final void flushImpl(RecapCorrelationId id) {
        RecapAgentResult result2 = this.currentImpl.get();
        if (result2 != null && Intrinsics.areEqual((Object)result2.getLog().getCorrelationId(), (Object)id) && this.hasVotes(result2)) {
            RecapTraceLlmcLogger.INSTANCE.log(result2);
            this.sent.set(true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasVotes(RecapAgentResult result2) {
        boolean bl;
        ChroniclePresenterAISection it;
        boolean bl2;
        Iterable $this$any$iv = result2.getItemsShort();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl2 = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                it = (ChroniclePresenterAISection)element$iv;
                boolean bl3 = false;
                if (it.getRating() != RecapRating.UNSPECIFIED) {
                    return true;
                }
                boolean bl4 = false;
                if (!bl4) continue;
                return true;
            }
            bl2 = false;
        }
        if (bl2) return true;
        $this$any$iv = result2.getItemsLong();
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            Object element$iv;
            if (!iterator.hasNext()) return false;
            element$iv = iterator.next();
            it = (ChroniclePresenterAISection)element$iv;
            boolean bl5 = false;
            if (it.getRating() != RecapRating.UNSPECIFIED) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/recap/chronicles/statistics/RecapStatisticsAggregator$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ml/llm/recap/chronicles/statistics/RecapStatisticsAggregator;", "project", "Lcom/intellij/openapi/project/Project;", "THROTTLE_MS", "", "intellij.ml.llm.recap"})
    @SourceDebugExtension(value={"SMAP\nRecapStatisticsAggregator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecapStatisticsAggregator.kt\ncom/intellij/ml/llm/recap/chronicles/statistics/RecapStatisticsAggregator$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,79:1\n30#2,2:80\n*S KotlinDebug\n*F\n+ 1 RecapStatisticsAggregator.kt\ncom/intellij/ml/llm/recap/chronicles/statistics/RecapStatisticsAggregator$Companion\n*L\n25#1:80,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RecapStatisticsAggregator getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<RecapStatisticsAggregator> serviceClass$iv = RecapStatisticsAggregator.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (RecapStatisticsAggregator)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

