/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.recap.chronicles.view;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ml.llm.recap.chronicles.ChronicleEntry;
import com.intellij.ml.llm.recap.chronicles.ChroniclesMock;
import com.intellij.ml.llm.recap.chronicles.ai.ChroniclesAgentService;
import com.intellij.ml.llm.recap.chronicles.ai.RecapAgentResult;
import com.intellij.ml.llm.recap.chronicles.events.storage.ChroniclesStorage;
import com.intellij.ml.llm.recap.chronicles.view.ChronicleDetails;
import com.intellij.ml.llm.recap.chronicles.view.ChronicleKind;
import com.intellij.ml.llm.recap.chronicles.view.ChronicleKindKt;
import com.intellij.ml.llm.recap.chronicles.view.ChroniclePresenter;
import com.intellij.ml.llm.recap.chronicles.view.ChroniclePresenterAISection;
import com.intellij.ml.llm.recap.chronicles.view.ChroniclePresenterParent;
import com.intellij.ml.llm.recap.chronicles.view.ChroniclesListener;
import com.intellij.ml.llm.recap.chronicles.view.ChroniclesPanel;
import com.intellij.ml.llm.recap.chronicles.view.ChroniclesTree;
import com.intellij.ml.llm.recap.chronicles.view.ChroniclesViewService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 42\u00020\u00012\u00020\u00022\u00020\u0003:\u00014B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u001f\u001a\u00020\u0015H\u0002J\b\u0010\"\u001a\u00020\u0015H\u0016J\b\u0010#\u001a\u00020\u0015H\u0016J\b\u0010$\u001a\u00020\u0015H\u0002J\b\u0010%\u001a\u00020\u0015H\u0002J\u0010\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020\u0001H\u0002J\b\u0010*\u001a\u00020+H\u0002J\b\u0010,\u001a\u00020+H\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u000200H\u0002J\u001e\u00101\u001a\u00020\u00152\u0006\u0010/\u001a\u00020\u00012\u0006\u00102\u001a\u00020\u0001H\u0082@\u00a2\u0006\u0002\u00103R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/intellij/ml/llm/recap/chronicles/view/ChroniclesPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/ml/llm/recap/chronicles/view/ChroniclesListener;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/wm/ToolWindow;)V", "getToolWindow", "()Lcom/intellij/openapi/wm/ToolWindow;", "service", "Lcom/intellij/ml/llm/recap/chronicles/view/ChroniclesViewService;", "propertiesComponent", "Lcom/intellij/ide/util/PropertiesComponent;", "kotlin.jvm.PlatformType", "detailsPanel", "mainContentPanel", "updateChannel", "Lkotlinx/coroutines/channels/Channel;", "", "loadingChannel", "", "loadingIcon", "Lcom/intellij/ui/AnimatedIcon$Default;", "loadingLabel", "Lcom/intellij/ui/components/JBLabel;", "selectedKinds", "", "Lcom/intellij/ml/llm/recap/chronicles/view/ChronicleKind;", "saveSelectedKinds", "chroniclesTree", "Lcom/intellij/ml/llm/recap/chronicles/view/ChroniclesTree;", "onChroniclesChanged", "dispose", "setupUpdateChannel", "triggerUpdate", "toggleDetails", "presenter", "Lcom/intellij/ml/llm/recap/chronicles/view/ChronicleDetails;", "createFilterByKindDropdown", "createFlatListPanel", "Ljavax/swing/JComponent;", "createAITreePanel", "findTreeInContentPanel", "Lcom/intellij/ui/treeStructure/Tree;", "contentPanel", "Ljava/awt/Container;", "updateAITree", "deepTreeDetailsPanel", "(Ljavax/swing/JPanel;Ljavax/swing/JPanel;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.ml.llm.recap"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nChroniclesPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChroniclesPanel.kt\ncom/intellij/ml/llm/recap/chronicles/view/ChroniclesPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,700:1\n774#2:701\n865#2,2:702\n1617#2,9:704\n1869#2:713\n1870#2:716\n1626#2:717\n1374#2:718\n1460#2,5:719\n1869#2,2:724\n1#3:714\n1#3:715\n*S KotlinDebug\n*F\n+ 1 ChroniclesPanel.kt\ncom/intellij/ml/llm/recap/chronicles/view/ChroniclesPanel\n*L\n76#1:701\n76#1:702,2\n77#1:704,9\n77#1:713\n77#1:716\n77#1:717\n447#1:718\n447#1:719,5\n448#1:724,2\n77#1:715\n*E\n"})
public final class ChroniclesPanel
extends JPanel
implements ChroniclesListener,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ToolWindow toolWindow;
    @NotNull
    private final ChroniclesViewService service;
    private final PropertiesComponent propertiesComponent;
    @NotNull
    private final JPanel detailsPanel;
    @NotNull
    private final JPanel mainContentPanel;
    @NotNull
    private final Channel<Unit> updateChannel;
    @NotNull
    private final Channel<Boolean> loadingChannel;
    @NotNull
    private final AnimatedIcon.Default loadingIcon;
    @NotNull
    private final JBLabel loadingLabel;
    @NotNull
    private final Set<ChronicleKind> selectedKinds;
    @NotNull
    private final ChroniclesTree chroniclesTree;
    public static final int $stable = 8;
    @NotNull
    private static final String SELECTED_KINDS_PROPERTY = "ijnext.chronicles.selected.kinds";

    /*
     * WARNING - void declaration
     */
    public ChroniclesPanel(@NotNull Project project2, @NotNull ToolWindow toolWindow) {
        void $this$selectedKinds_u24lambda_u240;
        Set set;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        this.project = project2;
        this.toolWindow = toolWindow;
        this.service = ChroniclesViewService.Companion.getInstance(this.project);
        this.propertiesComponent = PropertiesComponent.getInstance((Project)this.project);
        this.detailsPanel = new JPanel(new BorderLayout());
        this.mainContentPanel = new JPanel(new BorderLayout());
        this.updateChannel = ChannelKt.Channel$default((int)-1, null, null, (int)6, null);
        this.loadingChannel = ChannelKt.Channel$default((int)Integer.MAX_VALUE, null, null, (int)6, null);
        this.loadingIcon = new AnimatedIcon.Default();
        this.loadingLabel = new JBLabel((Icon)this.loadingIcon);
        Set set2 = set = (Set)new LinkedHashSet();
        ChroniclesPanel chroniclesPanel = this;
        boolean bl = false;
        String savedKinds = this.propertiesComponent.getValue(SELECTED_KINDS_PROPERTY);
        if (savedKinds != null) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Object it;
            void $this$filterTo$iv$iv;
            String[] stringArray = new String[]{","};
            Iterable $this$filter$iv = StringsKt.split$default((CharSequence)savedKinds, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl2 = false;
                boolean bl3 = ((CharSequence)it).length() > 0;
                if (!bl3) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List kindNames = (List)destination$iv$iv;
            $this$filter$iv = kindNames;
            void var17_24 = $this$selectedKinds_u24lambda_u240;
            boolean $i$f$mapNotNull = false;
            $this$filterTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            it = $this$forEach$iv$iv$iv.iterator();
            while (it.hasNext()) {
                ChronicleKind it$iv$iv;
                Object v1;
                block5: {
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = it.next();
                    boolean bl4 = false;
                    String name = (String)element$iv$iv;
                    boolean bl5 = false;
                    Iterable iterable2 = (Iterable)ChronicleKind.getEntries();
                    for (Object t : iterable2) {
                        ChronicleKind it2 = (ChronicleKind)((Object)t);
                        boolean bl6 = false;
                        if (!Intrinsics.areEqual((Object)it2.name(), (Object)name)) continue;
                        v1 = t;
                        break block5;
                    }
                    v1 = null;
                }
                if ((ChronicleKind)v1 == null) continue;
                boolean bl7 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            var17_24.addAll((List)destination$iv$iv);
        }
        if ($this$selectedKinds_u24lambda_u240.isEmpty()) {
            $this$selectedKinds_u24lambda_u240.add(ChronicleKind.Run);
            $this$selectedKinds_u24lambda_u240.add(ChronicleKind.Tests);
            $this$selectedKinds_u24lambda_u240.add(ChronicleKind.FileSwitch);
            $this$selectedKinds_u24lambda_u240.add(ChronicleKind.FindUsages);
            $this$selectedKinds_u24lambda_u240.add(ChronicleKind.FindInFile);
            $this$selectedKinds_u24lambda_u240.add(ChronicleKind.FindInPath);
            $this$selectedKinds_u24lambda_u240.add(ChronicleKind.GotoDeclaration);
            $this$selectedKinds_u24lambda_u240.add(ChronicleKind.CodeChanges);
            $this$selectedKinds_u24lambda_u240.add(ChronicleKind.BreakpointSet);
            $this$selectedKinds_u24lambda_u240.add(ChronicleKind.BreakpointRemoved);
            $this$selectedKinds_u24lambda_u240.add(ChronicleKind.BreakpointHit);
            $this$selectedKinds_u24lambda_u240.add(ChronicleKind.DebugStart);
            $this$selectedKinds_u24lambda_u240.add(ChronicleKind.DebugStop);
            $this$selectedKinds_u24lambda_u240.add(ChronicleKind.BuildStart);
            $this$selectedKinds_u24lambda_u240.add(ChronicleKind.BuildSuccess);
            $this$selectedKinds_u24lambda_u240.add(ChronicleKind.BuildFailed);
            $this$selectedKinds_u24lambda_u240.add(ChronicleKind.Scroll);
            $this$selectedKinds_u24lambda_u240.add(ChronicleKind.ChangeBranches);
        }
        chroniclesPanel.selectedKinds = set;
        this.chroniclesTree = new ChroniclesTree();
        this.setLayout(new BorderLayout());
        JPanel buttonPanel2 = new JPanel(new BorderLayout());
        JPanel filterPanel = new JPanel(new FlowLayout(0));
        filterPanel.add(this.createFilterByKindDropdown());
        buttonPanel2.add((Component)filterPanel, "West");
        JPanel rightPanel = new JPanel(new FlowLayout(2));
        rightPanel.add((Component)this.loadingLabel);
        this.loadingLabel.setVisible(false);
        JButton dumpResponseButton = new JButton("Dump response", AllIcons.Actions.Dump);
        dumpResponseButton.addActionListener(arg_0 -> ChroniclesPanel._init_$lambda$0(this, arg_0));
        rightPanel.add(dumpResponseButton);
        JButton dumpLLMMockButton = new JButton("Dump llm mock", AllIcons.Actions.Dump);
        dumpLLMMockButton.addActionListener(arg_0 -> ChroniclesPanel._init_$lambda$1(this, arg_0));
        rightPanel.add(dumpLLMMockButton);
        JButton dumpFileButton = new JButton("Dump file", AllIcons.Actions.MenuSaveall);
        dumpFileButton.addActionListener(arg_0 -> ChroniclesPanel._init_$lambda$2(this, arg_0));
        rightPanel.add(dumpFileButton);
        JButton loadCsvDirButton = new JButton("Load CSV directory", AllIcons.Actions.Install);
        loadCsvDirButton.setToolTipText("Process *.csv chronicles in a selected directory and save recaps as .response.json");
        loadCsvDirButton.addActionListener(arg_0 -> ChroniclesPanel._init_$lambda$3(this, arg_0));
        rightPanel.add(loadCsvDirButton);
        buttonPanel2.add((Component)rightPanel, "East");
        this.add((Component)buttonPanel2, "North");
        this.detailsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, JBColor.border()), JBUI.Borders.empty((int)10)));
        this.detailsPanel.setVisible(false);
        JBScrollPane detailsScrollPane = new JBScrollPane((Component)this.detailsPanel);
        JBSplitter splitPane = new JBSplitter(true, 0.7f);
        splitPane.setFirstComponent(this.chroniclesTree.getComponent());
        splitPane.setSecondComponent((JComponent)detailsScrollPane);
        splitPane.setOpaque(false);
        JBTabbedPane tabbedPane = new JBTabbedPane();
        JComponent deepTreePanel = this.createAITreePanel();
        tabbedPane.addTab("AI Tree", (Component)deepTreePanel);
        tabbedPane.addTab("Chronicles Tree", (Component)splitPane);
        JComponent flatListPanel = this.createFlatListPanel();
        tabbedPane.addTab("Items List", (Component)flatListPanel);
        this.mainContentPanel.add((Component)tabbedPane, "Center");
        this.add((Component)this.mainContentPanel, "Center");
        this.service.addListener(this);
        this.setupUpdateChannel();
        this.setBorder(JBUI.Borders.empty((int)10));
        this.chroniclesTree.addTreeSelectionListener((Function1<? super ChronicleDetails, Unit>)((Function1)arg_0 -> ChroniclesPanel._init_$lambda$4(this, arg_0)));
    }

    @NotNull
    public final ToolWindow getToolWindow() {
        return this.toolWindow;
    }

    private final void saveSelectedKinds() {
        String kindNames = CollectionsKt.joinToString$default((Iterable)this.selectedKinds, (CharSequence)",", null, null, (int)0, null, ChroniclesPanel::saveSelectedKinds$lambda$0, (int)30, null);
        this.propertiesComponent.setValue(SELECTED_KINDS_PROPERTY, kindNames);
    }

    @Override
    public void onChroniclesChanged() {
        this.chroniclesTree.update(this.service);
    }

    public void dispose() {
        this.service.removeListener(this);
        SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)this.updateChannel), null, (int)1, null);
        SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)this.loadingChannel), null, (int)1, null);
    }

    private final void setupUpdateChannel() {
        BuildersKt.launch$default((CoroutineScope)this.service.getScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ChroniclesPanel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowKt.consumeAsFlow((ReceiveChannel)((ReceiveChannel)ChroniclesPanel.access$getLoadingChannel$p(this.this$0))).collect(new FlowCollector(this.this$0){
                            final /* synthetic */ ChroniclesPanel this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            public final Object emit(boolean isLoading, Continuation<? super Unit> $completion) {
                                Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, isLoading, null){
                                    int label;
                                    final /* synthetic */ ChroniclesPanel this$0;
                                    final /* synthetic */ boolean $isLoading;
                                    {
                                        this.this$0 = $receiver;
                                        this.$isLoading = $isLoading;
                                        super(2, $completion);
                                    }

                                    public final Object invokeSuspend(Object $result) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                ChroniclesPanel.access$getLoadingLabel$p(this.this$0).setVisible(this.$isLoading);
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), $completion);
                                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                    return object;
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        BuildersKt.launch$default((CoroutineScope)this.service.getScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int I$0;
            int label;
            final /* synthetic */ ChroniclesPanel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        int timeout;
                        ResultKt.throwOnFailure((Object)$result);
                        this.I$0 = timeout = Registry.Companion.intValue("llm.riderNext.chronicles.ui.timeout", 5000);
                        this.label = 1;
                        Object object2 = com.intellij.platform.util.coroutines.flow.FlowKt.throttle((Flow)FlowKt.receiveAsFlow((ReceiveChannel)((ReceiveChannel)ChroniclesPanel.access$getUpdateChannel$p(this.this$0))), (long)timeout).collect(new FlowCollector(this.this$0){
                            final /* synthetic */ ChroniclesPanel this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * Unable to fully structure code
                             */
                            public final Object emit(Unit it, Continuation<? super Unit> $completion) {
                                if (!($completion instanceof setupUpdateChannel.emit.1)) ** GOTO lbl-1000
                                var5_3 = $completion;
                                if ((var5_3.label & -2147483648) != 0) {
                                    var5_3.label -= -2147483648;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    $continuation = new ContinuationImpl(this, $completion){
                                        Object L$0;
                                        Object L$1;
                                        /* synthetic */ Object result;
                                        final /* synthetic */ setupUpdateChannel.1<T> this$0;
                                        int label;
                                        {
                                            this.this$0 = this$0;
                                            super($completion);
                                        }

                                        public final Object invokeSuspend(Object $result) {
                                            this.result = $result;
                                            this.label |= Integer.MIN_VALUE;
                                            return this.this$0.emit(null, (Continuation<Unit>)((Continuation)this));
                                        }
                                    };
                                }
                                $result = $continuation.result;
                                var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch ($continuation.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        if (!this.this$0.getToolWindow().isVisible()) ** GOTO lbl27
                                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)it);
                                        $continuation.label = 1;
                                        v0 = ChroniclesPanel.access$getService$p(this.this$0).reload(ChroniclesPanel.access$getSelectedKinds$p(this.this$0), (Continuation<? super Unit>)$continuation);
                                        ** if (v0 != var6_5) goto lbl20
lbl19:
                                        // 1 sources

                                        return var6_5;
lbl20:
                                        // 1 sources

                                        ** GOTO lbl27
                                    }
                                    case 1: {
                                        it = (Unit)$continuation.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl27:
                                        // 3 sources

                                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)it);
                                        $continuation.label = 2;
                                        v1 = ChroniclesPanel.access$getLoadingChannel$p(this.this$0).send((Object)Boxing.boxBoolean((boolean)false), (Continuation)$continuation);
                                        if (v1 == var6_5) {
                                            return var6_5;
                                        }
                                        break;
                                    }
                                    case 2: {
                                        it = (Unit)$continuation.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
                                        break;
                                    }
                                }
                                catch (Throwable var3_6) {
                                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)it);
                                    $continuation.L$1 = var3_6;
                                    $continuation.label = 3;
                                    v2 = ChroniclesPanel.access$getLoadingChannel$p(this.this$0).send((Object)Boxing.boxBoolean((boolean)false), (Continuation)$continuation);
                                    if (v2 == var6_5) {
                                        return var6_5;
                                    }
                                    ** GOTO lbl51
                                }
                                {
                                    case 3: {
                                        var3_7 = (Throwable)$continuation.L$1;
                                        it = (Unit)$continuation.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v2 = $result;
lbl51:
                                        // 2 sources

                                        throw var3_7;
                                    }
                                }
                                return Unit.INSTANCE;
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }
                        }, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        int timeout = this.I$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        messageBusConnection.subscribe(topic, (Object)new BulkFileListener(this){
            final /* synthetic */ ChroniclesPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void after(List<? extends VFileEvent> events) {
                Intrinsics.checkNotNullParameter(events, (String)"events");
                if (!((Collection)events).isEmpty()) {
                    ChroniclesPanel.access$triggerUpdate(this.this$0);
                }
            }
        });
        BuildersKt.launch$default((CoroutineScope)this.service.getScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ChroniclesPanel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = ChroniclesStorage.Companion.getInstance(ChroniclesPanel.access$getProject$p(this.this$0)).getOnSave().collect(new FlowCollector(this.this$0){
                            final /* synthetic */ ChroniclesPanel this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            public final Object emit(ChronicleEntry event2, Continuation<? super Unit> $completion) {
                                ChroniclesPanel.access$triggerUpdate(this.this$0);
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) throw new KotlinNothingValueException();
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        this.triggerUpdate();
    }

    private final void triggerUpdate() {
        this.loadingChannel.trySend-JP2dKIU((Object)true);
        this.updateChannel.trySend-JP2dKIU((Object)Unit.INSTANCE);
    }

    private final void toggleDetails(ChronicleDetails presenter) {
        this.detailsPanel.removeAll();
        Component details = presenter.getDetails(this.project);
        if (details != null) {
            this.detailsPanel.add(details, "Center");
            this.detailsPanel.setVisible(true);
        } else {
            this.detailsPanel.setVisible(false);
        }
        this.revalidate();
        this.repaint();
    }

    private final JPanel createFilterByKindDropdown() {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setBorder(new EmptyBorder(0, 5, 0, 5));
        JBLabel label = new JBLabel("Filter by Kind:");
        panel2.add((Component)label, "West");
        JButton button2 = new JButton("Select...");
        button2.addActionListener(arg_0 -> ChroniclesPanel.createFilterByKindDropdown$lambda$0(this, button2, arg_0));
        panel2.add((Component)button2, "Center");
        return panel2;
    }

    private final JComponent createFlatListPanel() {
        DefaultListModel<ChroniclePresenter> listModel = new DefaultListModel<ChroniclePresenter>();
        JList<ChroniclePresenter> itemsList = new JList<ChroniclePresenter>((ListModel)listModel);
        itemsList.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component component2 = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof ChroniclePresenter) {
                    this.setText(((ChroniclePresenter)value).getCaption());
                    this.setIcon(ChronicleKindKt.icon(((ChroniclePresenter)value).getKind()));
                }
                Intrinsics.checkNotNull((Object)component2);
                return component2;
            }
        });
        JBScrollPane listScrollPane = new JBScrollPane((Component)itemsList);
        JPanel flatListDetailsPanel = new JPanel(new BorderLayout());
        flatListDetailsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, JBColor.border()), JBUI.Borders.empty((int)10)));
        flatListDetailsPanel.setVisible(false);
        JBScrollPane detailsScrollPane = new JBScrollPane((Component)flatListDetailsPanel);
        JBSplitter splitPane = new JBSplitter(true, 0.7f);
        splitPane.setFirstComponent((JComponent)listScrollPane);
        splitPane.setSecondComponent((JComponent)detailsScrollPane);
        splitPane.setOpaque(false);
        itemsList.addListSelectionListener(arg_0 -> ChroniclesPanel.createFlatListPanel$lambda$0(itemsList, flatListDetailsPanel, this, splitPane, arg_0));
        ChroniclesPanel.createFlatListPanel$updateList(listModel, this, itemsList);
        this.service.addListener(new ChroniclesListener(listModel, this, itemsList){
            final /* synthetic */ DefaultListModel<ChroniclePresenter> $listModel;
            final /* synthetic */ ChroniclesPanel this$0;
            final /* synthetic */ JList<ChroniclePresenter> $itemsList;
            {
                this.$listModel = $listModel;
                this.this$0 = $receiver;
                this.$itemsList = $itemsList;
            }

            public void onChroniclesChanged() {
                ChroniclesPanel.access$createFlatListPanel$updateList(this.$listModel, this.this$0, this.$itemsList);
            }
        });
        return (JComponent)splitPane;
    }

    private final JComponent createAITreePanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        JPanel buttonPanel2 = new JPanel(new FlowLayout(0));
        JButton updateButton = new JButton("Update", AllIcons.Actions.Refresh);
        buttonPanel2.add(updateButton);
        mainPanel.add((Component)buttonPanel2, "North");
        JPanel contentPanel2 = new JPanel(new BorderLayout());
        JPanel deepTreeDetailsPanel = new JPanel(new BorderLayout());
        deepTreeDetailsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, JBColor.border()), JBUI.Borders.empty((int)10)));
        deepTreeDetailsPanel.setVisible(false);
        JBScrollPane detailsScrollPane = new JBScrollPane((Component)deepTreeDetailsPanel);
        JBSplitter splitPane = new JBSplitter(true, 0.7f);
        splitPane.setFirstComponent((JComponent)contentPanel2);
        splitPane.setSecondComponent((JComponent)detailsScrollPane);
        splitPane.setOpaque(false);
        mainPanel.add((Component)splitPane, "Center");
        updateButton.addActionListener(arg_0 -> ChroniclesPanel.createAITreePanel$lambda$0(this, contentPanel2, deepTreeDetailsPanel, updateButton, splitPane, arg_0));
        return mainPanel;
    }

    private final Tree findTreeInContentPanel(Container contentPanel2) {
        Component[] componentArray = contentPanel2.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        for (Component component2 : componentArray) {
            Tree tree;
            if (component2 instanceof JBScrollPane) {
                Component viewportView;
                JViewport viewport = ((JBScrollPane)component2).getViewport();
                if (viewport == null || !((viewportView = viewport.getView()) instanceof Tree)) continue;
                return (Tree)viewportView;
            }
            if (!(component2 instanceof Container) || (tree = this.findTreeInContentPanel((Container)component2)) == null) continue;
            return tree;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private final Object updateAITree(JPanel contentPanel, JPanel deepTreeDetailsPanel, Continuation<? super Unit> $completion) {
        if (!($completion instanceof updateAITree.1)) ** GOTO lbl-1000
        var9_4 = $completion;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ ChroniclesPanel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ChroniclesPanel.access$updateAITree(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                rootNode = new DefaultMutableTreeNode("Root");
                treeModel = new DefaultTreeModel(rootNode);
                $continuation.L$0 = contentPanel;
                $continuation.L$1 = deepTreeDetailsPanel;
                $continuation.L$2 = rootNode;
                $continuation.L$3 = treeModel;
                $continuation.label = 1;
                v0 = ChroniclesAgentService.Companion.getInstance(this.project).getAIGroupedChronicles(true, (Continuation<? super RecapAgentResult>)$continuation);
                if (v0 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl30
            }
            case 1: {
                treeModel = (DefaultTreeModel)$continuation.L$3;
                rootNode = (DefaultMutableTreeNode)$continuation.L$2;
                deepTreeDetailsPanel = (JPanel)$continuation.L$1;
                contentPanel = (JPanel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl30:
                // 2 sources

                v1 = (RecapAgentResult)v0;
                aiGroups = v1 != null ? v1.getItemsShort() : null;
                var7_16 = aiGroups;
                if (!(var7_16 == null || var7_16.isEmpty() != false)) break;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)contentPanel);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)deepTreeDetailsPanel);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)rootNode);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)treeModel);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable(aiGroups);
                $continuation.label = 2;
                v2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(contentPanel, deepTreeDetailsPanel, null){
                    int label;
                    final /* synthetic */ JPanel $contentPanel;
                    final /* synthetic */ JPanel $deepTreeDetailsPanel;
                    {
                        this.$contentPanel = $contentPanel;
                        this.$deepTreeDetailsPanel = $deepTreeDetailsPanel;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.$contentPanel.removeAll();
                                this.$contentPanel.add((Component)new JBLabel("No AI chronicles found"), "Center");
                                this.$contentPanel.revalidate();
                                this.$contentPanel.repaint();
                                this.$deepTreeDetailsPanel.setVisible(false);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v2 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl52
            }
            case 2: {
                aiGroups = (List)$continuation.L$4;
                treeModel = (DefaultTreeModel)$continuation.L$3;
                rootNode = (DefaultMutableTreeNode)$continuation.L$2;
                deepTreeDetailsPanel = (JPanel)$continuation.L$1;
                contentPanel = (JPanel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl52:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)contentPanel);
        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)deepTreeDetailsPanel);
        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)rootNode);
        $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)treeModel);
        $continuation.L$4 = SpillingKt.nullOutSpilledVariable(aiGroups);
        $continuation.label = 3;
        v3 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(aiGroups, treeModel, contentPanel, rootNode, this, deepTreeDetailsPanel, null){
            int label;
            final /* synthetic */ List<ChroniclePresenterAISection> $aiGroups;
            final /* synthetic */ DefaultTreeModel $treeModel;
            final /* synthetic */ JPanel $contentPanel;
            final /* synthetic */ DefaultMutableTreeNode $rootNode;
            final /* synthetic */ ChroniclesPanel this$0;
            final /* synthetic */ JPanel $deepTreeDetailsPanel;
            {
                this.$aiGroups = $aiGroups;
                this.$treeModel = $treeModel;
                this.$contentPanel = $contentPanel;
                this.$rootNode = $rootNode;
                this.this$0 = $receiver;
                this.$deepTreeDetailsPanel = $deepTreeDetailsPanel;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$forEach$iv;
                        ResultKt.throwOnFailure((Object)$result);
                        Iterable iterable = this.$aiGroups;
                        DefaultMutableTreeNode defaultMutableTreeNode = this.$rootNode;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            ChroniclePresenterAISection presenter = (ChroniclePresenterAISection)element$iv;
                            boolean bl = false;
                            DefaultMutableTreeNode aiGroupNode = new DefaultMutableTreeNode(presenter);
                            defaultMutableTreeNode.add(aiGroupNode);
                            for (ChroniclePresenter child : presenter.getChildren()) {
                                DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(child);
                                aiGroupNode.add(childNode);
                            }
                        }
                        Tree tree = new Tree((TreeModel)this.$treeModel);
                        tree.setRootVisible(false);
                        tree.setShowsRootHandles(true);
                        tree.setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(this.$rootNode){
                            final /* synthetic */ DefaultMutableTreeNode $rootNode;
                            {
                                this.$rootNode = $rootNode;
                            }

                            public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                                Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
                                DefaultMutableTreeNode defaultMutableTreeNode = value instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)value : null;
                                if (defaultMutableTreeNode == null) {
                                    return;
                                }
                                DefaultMutableTreeNode node = defaultMutableTreeNode;
                                Object userObject = node.getUserObject();
                                if (userObject instanceof ChroniclePresenter) {
                                    this.setIcon(ChronicleKindKt.icon(((ChroniclePresenter)userObject).getKind()));
                                    JBColor color = ChronicleKindKt.color(((ChroniclePresenter)userObject).getKind());
                                    String timestampStr = ChroniclePresenter.Companion.formatChronicleDateTime(((ChroniclePresenter)userObject).getTimestamp());
                                    String text2 = ((ChroniclePresenter)userObject).getCaption() + " at " + timestampStr;
                                    this.append(text2, new SimpleTextAttributes(0, (Color)color));
                                } else if (userObject instanceof ChroniclePresenterAISection) {
                                    this.setIcon(AllIcons.Toolwindows.ToolWindowAskAI);
                                    this.append(((ChroniclePresenterAISection)userObject).getCaption(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                                } else if (userObject instanceof String) {
                                    if (Intrinsics.areEqual((Object)node.getParent(), (Object)this.$rootNode)) {
                                        try {
                                            ChronicleKind kind = ChronicleKind.valueOf((String)userObject);
                                            this.setIcon(ChronicleKindKt.icon(kind));
                                            this.append((String)userObject, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                                        }
                                        catch (ProcessCanceledException pce) {
                                            throw pce;
                                        }
                                        catch (Exception e) {
                                            this.append((String)userObject, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                                        }
                                    } else {
                                        this.append((String)userObject, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                                    }
                                }
                            }
                        });
                        int n = tree.getRowCount();
                        for (int i = 0; i < n; ++i) {
                            tree.expandRow(i);
                        }
                        tree.addTreeSelectionListener(arg_0 -> updateAITree.3.invokeSuspend$lambda$1(tree, this.this$0, this.$deepTreeDetailsPanel, arg_0));
                        JBScrollPane scrollPane = new JBScrollPane((Component)tree);
                        this.$contentPanel.removeAll();
                        this.$contentPanel.add((Component)scrollPane, "Center");
                        this.$contentPanel.revalidate();
                        this.$contentPanel.repaint();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$1(Tree $tree, ChroniclesPanel this$0, JPanel $deepTreeDetailsPanel, TreeSelectionEvent e) {
                Object userObject;
                Object node = $tree.getLastSelectedPathComponent();
                if (node instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)node).getUserObject()) instanceof ChronicleDetails) {
                    Component details = ((ChronicleDetails)userObject).getDetails(ChroniclesPanel.access$getProject$p(this$0));
                    if (details != null) {
                        $deepTreeDetailsPanel.removeAll();
                        $deepTreeDetailsPanel.add(details, "Center");
                        $deepTreeDetailsPanel.setVisible(true);
                    } else {
                        $deepTreeDetailsPanel.removeAll();
                        $deepTreeDetailsPanel.setVisible(false);
                    }
                }
            }
        }), (Continuation)$continuation);
        if (v3 == var10_6) {
            return var10_6;
        }
        ** GOTO lbl71
        {
            case 3: {
                aiGroups = (List)$continuation.L$4;
                treeModel = (DefaultTreeModel)$continuation.L$3;
                rootNode = (DefaultMutableTreeNode)$continuation.L$2;
                deepTreeDetailsPanel = (JPanel)$continuation.L$1;
                contentPanel = (JPanel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl71:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final CharSequence saveSelectedKinds$lambda$0(ChronicleKind it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return it.name();
    }

    private static final void _init_$lambda$0(ChroniclesPanel this$0, ActionEvent it) {
        String dump = ChroniclesAgentService.Companion.getInstance(this$0.project).getResponseJsonDump();
        if (dump != null) {
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(dump));
        }
    }

    private static final void _init_$lambda$1(ChroniclesPanel this$0, ActionEvent it) {
        String dump = this$0.service.dump();
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(dump));
    }

    private static final void _init_$lambda$2(ChroniclesPanel this$0, ActionEvent it) {
        ChroniclesMock.Companion.getInstance(this$0.project).dump();
    }

    private static final void _init_$lambda$3(ChroniclesPanel this$0, ActionEvent it) {
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(false, true, false, false, false, false).withTitle("Select Chronicles CSV Directory").withDescription("The service will scan this folder for *.csv, summarize them, and save <file>.response.json next to each CSV");
        FileChooser.chooseFile((FileChooserDescriptor)descriptor2, (Project)this$0.project, null, arg_0 -> ChroniclesPanel.lambda$3$1(arg_0 -> ChroniclesPanel.lambda$3$0(this$0, arg_0), arg_0));
    }

    private static final Unit lambda$3$0(ChroniclesPanel this$0, VirtualFile vFile) {
        if (vFile != null) {
            BuildersKt.launch$default((CoroutineScope)this$0.service.getScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, vFile, null){
                Object L$0;
                int I$0;
                int I$1;
                int label;
                final /* synthetic */ ChroniclesPanel this$0;
                final /* synthetic */ VirtualFile $vFile;
                {
                    this.this$0 = $receiver;
                    this.$vFile = $vFile;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var11_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = ChroniclesAgentService.Companion.getInstance(ChroniclesPanel.access$getProject$p(this.this$0));
                            v1 = this.$vFile.getPath();
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getPath(...)");
                            this.label = 1;
                            v2 = v0.recapChroniclesFromDirectory(v1, ChroniclesAgentService.RecapWindow.TwoHours, (Continuation<? super ChroniclesAgentService.RecapDirectoryResult>)((Continuation)this));
                            ** if (v2 != var11_2) goto lbl14
lbl13:
                            // 1 sources

                            return var11_2;
lbl14:
                            // 1 sources

                            ** GOTO lbl20
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl20:
                            // 2 sources

                            result = (ChroniclesAgentService.RecapDirectoryResult)v2;
                            $this$count$iv = result.getFiles();
                            $i$f$count = false;
                            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                                v3 = 0;
                            } else {
                                count$iv = 0;
                                for (T element$iv : $this$count$iv) {
                                    it = (ChroniclesAgentService.FileRecapResult)element$iv;
                                    $i$a$-count-ChroniclesPanel$4$1$1$processed$1 = false;
                                    if (!(it.getRawJson() != null) || ++count$iv >= 0) continue;
                                    CollectionsKt.throwCountOverflow();
                                }
                                v3 = count$iv;
                            }
                            processed = v3;
                            skipped = result.getFiles().size() - processed;
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)result);
                            this.I$0 = processed;
                            this.I$1 = skipped;
                            this.label = 2;
                            v4 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, processed, skipped, null){
                                int label;
                                final /* synthetic */ ChroniclesPanel this$0;
                                final /* synthetic */ int $processed;
                                final /* synthetic */ int $skipped;
                                {
                                    this.this$0 = $receiver;
                                    this.$processed = $processed;
                                    this.$skipped = $skipped;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            Messages.showInfoMessage((Component)this.this$0, (String)("Processed: " + this.$processed + "\nSkipped: " + this.$skipped + "\nOutput files saved next to CSV as .response.json"), (String)"Chronicles: CSV Recap");
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            ** if (v4 != var11_2) goto lbl43
lbl42:
                            // 1 sources

                            return var11_2;
lbl43:
                            // 1 sources

                            ** GOTO lbl66
                        }
                        case 2: {
                            skipped = this.I$1;
                            processed = this.I$0;
                            result = (ChroniclesAgentService.RecapDirectoryResult)this.L$0;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v4 = $result;
                                ** GOTO lbl66
                            }
                            catch (ProcessCanceledException e) {
                                throw e;
                            }
                            catch (Throwable t) {
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)t);
                                this.label = 3;
                                v5 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, t, null){
                                    int label;
                                    final /* synthetic */ ChroniclesPanel this$0;
                                    final /* synthetic */ Throwable $t;
                                    {
                                        this.this$0 = $receiver;
                                        this.$t = $t;
                                        super(2, $completion);
                                    }

                                    public final Object invokeSuspend(Object $result) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                Component component2 = this.this$0;
                                                String string = this.$t.getMessage();
                                                if (string == null) {
                                                    string = "Unknown error";
                                                }
                                                Messages.showErrorDialog((Component)component2, (String)string, (String)"Chronicles: CSV Recap Failed");
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)((Continuation)this));
                                if (v5 == var11_2) {
                                    return var11_2;
                                }
                                ** GOTO lbl66
                            }
                        }
                        case 3: {
                            t = (Throwable)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v5 = $result;
lbl66:
                            // 4 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
        return Unit.INSTANCE;
    }

    private static final void lambda$3$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit _init_$lambda$4(ChroniclesPanel this$0, ChronicleDetails selected) {
        Intrinsics.checkNotNullParameter((Object)selected, (String)"selected");
        this$0.toggleDetails(selected);
        return Unit.INSTANCE;
    }

    private static final void createFilterByKindDropdown$lambda$0(ChroniclesPanel this$0, JButton $button, ActionEvent it) {
        JPopupMenu popup2 = new JPopupMenu();
        JBCheckBox selectAllCheckBox = new JBCheckBox("Select all");
        selectAllCheckBox.setSelected(this$0.selectedKinds.size() == ChronicleKind.getEntries().size());
        selectAllCheckBox.addItemListener(arg_0 -> ChroniclesPanel.createFilterByKindDropdown$lambda$0$0(this$0, arg_0));
        JPanel selectAllPanel = new JPanel(new BorderLayout());
        selectAllPanel.add((Component)selectAllCheckBox, "West");
        popup2.add(selectAllPanel);
        popup2.addSeparator();
        for (ChronicleKind kind : ChronicleKind.getEntries()) {
            String kindName = kind.name();
            JBCheckBox checkBox = new JBCheckBox(kindName);
            checkBox.setSelected(this$0.selectedKinds.contains((Object)kind));
            checkBox.addItemListener(arg_0 -> ChroniclesPanel.createFilterByKindDropdown$lambda$0$1(this$0, kind, arg_0));
            JPanel checkBoxPanel = new JPanel(new BorderLayout());
            checkBoxPanel.add((Component)checkBox, "West");
            popup2.add(checkBoxPanel);
        }
        popup2.show($button, 0, $button.getHeight());
    }

    private static final void createFilterByKindDropdown$lambda$0$0(ChroniclesPanel this$0, ItemEvent e) {
        boolean selected;
        boolean bl = selected = e.getStateChange() == 1;
        if (selected) {
            this$0.selectedKinds.addAll((Collection)ChronicleKind.getEntries());
        } else {
            this$0.selectedKinds.clear();
        }
        this$0.saveSelectedKinds();
        this$0.triggerUpdate();
    }

    private static final void createFilterByKindDropdown$lambda$0$1(ChroniclesPanel this$0, ChronicleKind $kind, ItemEvent e) {
        boolean selected = e.getStateChange() == 1;
        boolean bl = selected ? this$0.selectedKinds.add($kind) : this$0.selectedKinds.remove((Object)$kind);
        this$0.saveSelectedKinds();
        this$0.triggerUpdate();
    }

    private static final void createFlatListPanel$lambda$0(JList $itemsList, JPanel $flatListDetailsPanel, ChroniclesPanel this$0, JBSplitter $splitPane, ListSelectionEvent e) {
        block3: {
            ChroniclePresenter selectedItem;
            if (e.getValueIsAdjusting()) break block3;
            Object e2 = $itemsList.getSelectedValue();
            ChroniclePresenter chroniclePresenter = selectedItem = e2 instanceof ChroniclePresenter ? (ChroniclePresenter)e2 : null;
            if (chroniclePresenter != null) {
                ChroniclePresenter it = chroniclePresenter;
                boolean bl = false;
                $flatListDetailsPanel.removeAll();
                Component details = it.getDetails(this$0.project);
                if (details != null) {
                    $flatListDetailsPanel.add(details, "Center");
                    $flatListDetailsPanel.setVisible(true);
                } else {
                    $flatListDetailsPanel.setVisible(false);
                }
                $splitPane.revalidate();
                $splitPane.repaint();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void createFlatListPanel$updateList(DefaultListModel<ChroniclePresenter> listModel, ChroniclesPanel this$0, JList<ChroniclePresenter> itemsList) {
        void $this$flatMapTo$iv$iv;
        listModel.clear();
        Iterable $this$flatMap$iv = this$0.service.getContent();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ChroniclePresenterParent it = (ChroniclePresenterParent)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getLeafs();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List allItems = (List)destination$iv$iv;
        Iterable $this$forEach$iv = allItems;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChroniclePresenter it = (ChroniclePresenter)element$iv;
            boolean bl = false;
            listModel.addElement(it);
        }
        if (listModel.size() > 0) {
            itemsList.setSelectedIndex(0);
        }
    }

    private static final void createAITreePanel$lambda$0(ChroniclesPanel this$0, JPanel $contentPanel, JPanel $deepTreeDetailsPanel, JButton $updateButton, JBSplitter $splitPane, ActionEvent it) {
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, $contentPanel, $deepTreeDetailsPanel, $updateButton, $splitPane, null){
            Object L$0;
            int label;
            final /* synthetic */ ChroniclesPanel this$0;
            final /* synthetic */ JPanel $contentPanel;
            final /* synthetic */ JPanel $deepTreeDetailsPanel;
            final /* synthetic */ JButton $updateButton;
            final /* synthetic */ JBSplitter $splitPane;
            {
                this.this$0 = $receiver;
                this.$contentPanel = $contentPanel;
                this.$deepTreeDetailsPanel = $deepTreeDetailsPanel;
                this.$updateButton = $updateButton;
                this.$splitPane = $splitPane;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$updateButton, this.$deepTreeDetailsPanel, this.$contentPanel, null){
                            int label;
                            final /* synthetic */ JButton $updateButton;
                            final /* synthetic */ JPanel $deepTreeDetailsPanel;
                            final /* synthetic */ JPanel $contentPanel;
                            {
                                this.$updateButton = $updateButton;
                                this.$deepTreeDetailsPanel = $deepTreeDetailsPanel;
                                this.$contentPanel = $contentPanel;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.$updateButton.setEnabled(false);
                                        this.$deepTreeDetailsPanel.setVisible(false);
                                        this.$contentPanel.removeAll();
                                        JPanel loadingPanel = new JPanel(new FlowLayout(1));
                                        loadingPanel.add((Component)new JBLabel("Loading AI tree...", (Icon)new AnimatedIcon.Default(), 10));
                                        this.$contentPanel.add((Component)loadingPanel, "Center");
                                        this.$contentPanel.revalidate();
                                        this.$contentPanel.repaint();
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl14
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl14:
                        // 3 sources

                        this.label = 2;
                        v1 = ChroniclesPanel.access$updateAITree(this.this$0, this.$contentPanel, this.$deepTreeDetailsPanel, (Continuation)this);
                        ** if (v1 != var3_2) goto lbl19
lbl18:
                        // 1 sources

                        return var3_2;
lbl19:
                        // 1 sources

                        ** GOTO lbl25
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl25:
                        // 2 sources

                        this.label = 3;
                        v2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$updateButton, this.$contentPanel, null){
                            int label;
                            final /* synthetic */ JButton $updateButton;
                            final /* synthetic */ JPanel $contentPanel;
                            {
                                this.$updateButton = $updateButton;
                                this.$contentPanel = $contentPanel;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.$updateButton.setEnabled(true);
                                        v0 = this.$contentPanel.getComponents();
                                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getComponents(...)");
                                        $this$any$iv = v0;
                                        $i$f$any = false;
                                        for (Object element$iv : $this$any$iv) {
                                            it = (Component)element$iv;
                                            $i$a$-any-ChroniclesPanel$createAITreePanel$1$1$2$stillLoading$1 = false;
                                            if (it instanceof JBLabel) ** GOTO lbl-1000
                                            if (!(it instanceof JPanel)) ** GOTO lbl-1000
                                            v1 = ((JPanel)it).getComponents();
                                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getComponents(...)");
                                            $this$any$iv = v1;
                                            $i$f$any = false;
                                            for (Object element$iv : $this$any$iv) {
                                                c = (Component)element$iv;
                                                $i$a$-any-ChroniclesPanel$createAITreePanel$1$1$2$stillLoading$1$1 = false;
                                                if (!(c instanceof JBLabel)) continue;
                                                v2 = true;
                                                ** GOTO lbl27
                                            }
                                            v2 = false;
lbl27:
                                            // 2 sources

                                            if (v2) lbl-1000:
                                            // 2 sources

                                            {
                                                v3 = true;
                                            } else lbl-1000:
                                            // 2 sources

                                            {
                                                v3 = false;
                                            }
                                            if (!v3) continue;
                                            v4 = true;
                                            ** GOTO lbl35
                                        }
                                        v4 = stillLoading = false;
lbl35:
                                        // 2 sources

                                        if (stillLoading) {
                                            this.$contentPanel.removeAll();
                                            this.$contentPanel.revalidate();
                                            this.$contentPanel.repaint();
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v2 == var3_2) {
                            return var3_2;
                        }
                        break;
                    }
                    case 3: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
                        break;
                    }
                }
                catch (Throwable var2_3) {
                    this.L$0 = var2_3;
                    this.label = 4;
                    v3 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new /* invalid duplicate definition of identical inner class */), (Continuation)((Continuation)this));
                    if (v3 == var3_2) {
                        return var3_2;
                    }
                    ** GOTO lbl45
                }
                {
                    case 4: {
                        var2_4 = (Throwable)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl45:
                        // 2 sources

                        throw var2_4;
                    }
                }
                this.label = 5;
                v4 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$contentPanel, this.$deepTreeDetailsPanel, this.$splitPane, null){
                    int label;
                    final /* synthetic */ ChroniclesPanel this$0;
                    final /* synthetic */ JPanel $contentPanel;
                    final /* synthetic */ JPanel $deepTreeDetailsPanel;
                    final /* synthetic */ JBSplitter $splitPane;
                    {
                        this.this$0 = $receiver;
                        this.$contentPanel = $contentPanel;
                        this.$deepTreeDetailsPanel = $deepTreeDetailsPanel;
                        this.$splitPane = $splitPane;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                Tree tree;
                                ResultKt.throwOnFailure((Object)$result);
                                Tree tree2 = tree = ChroniclesPanel.access$findTreeInContentPanel(this.this$0, this.$contentPanel);
                                if (tree2 != null) {
                                    tree2.addTreeSelectionListener(arg_0 -> createAITreePanel.1.3.invokeSuspend$lambda$0(tree, this.$deepTreeDetailsPanel, this.this$0, this.$splitPane, arg_0));
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }

                    private static final void invokeSuspend$lambda$0(Tree $tree, JPanel $deepTreeDetailsPanel, ChroniclesPanel this$0, JBSplitter $splitPane, TreeSelectionEvent it) {
                        Object userObject;
                        DefaultMutableTreeNode node;
                        Object object = $tree.getLastSelectedPathComponent();
                        DefaultMutableTreeNode defaultMutableTreeNode = node = object instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)object : null;
                        if (node != null && (userObject = node.getUserObject()) instanceof ChroniclePresenter) {
                            $deepTreeDetailsPanel.removeAll();
                            Component details = ((ChroniclePresenter)userObject).getDetails(ChroniclesPanel.access$getProject$p(this$0));
                            if (details != null) {
                                $deepTreeDetailsPanel.add(details, "Center");
                                $deepTreeDetailsPanel.setVisible(true);
                            } else {
                                $deepTreeDetailsPanel.setVisible(false);
                            }
                            $splitPane.revalidate();
                            $splitPane.repaint();
                        }
                    }
                }), (Continuation)((Continuation)this));
                if (v4 == var3_2) {
                    return var3_2;
                }
                ** GOTO lbl54
                {
                    case 5: {
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
lbl54:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static final /* synthetic */ Channel access$getLoadingChannel$p(ChroniclesPanel $this) {
        return $this.loadingChannel;
    }

    public static final /* synthetic */ JBLabel access$getLoadingLabel$p(ChroniclesPanel $this) {
        return $this.loadingLabel;
    }

    public static final /* synthetic */ Channel access$getUpdateChannel$p(ChroniclesPanel $this) {
        return $this.updateChannel;
    }

    public static final /* synthetic */ ChroniclesViewService access$getService$p(ChroniclesPanel $this) {
        return $this.service;
    }

    public static final /* synthetic */ Set access$getSelectedKinds$p(ChroniclesPanel $this) {
        return $this.selectedKinds;
    }

    public static final /* synthetic */ void access$triggerUpdate(ChroniclesPanel $this) {
        $this.triggerUpdate();
    }

    public static final /* synthetic */ Project access$getProject$p(ChroniclesPanel $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$createFlatListPanel$updateList(DefaultListModel listModel, ChroniclesPanel this$0, JList itemsList) {
        ChroniclesPanel.createFlatListPanel$updateList(listModel, this$0, itemsList);
    }

    public static final /* synthetic */ Object access$updateAITree(ChroniclesPanel $this, JPanel contentPanel2, JPanel deepTreeDetailsPanel, Continuation $completion) {
        return $this.updateAITree(contentPanel2, deepTreeDetailsPanel, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Tree access$findTreeInContentPanel(ChroniclesPanel $this, Container contentPanel2) {
        return $this.findTreeInContentPanel(contentPanel2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/recap/chronicles/view/ChroniclesPanel$Companion;", "", "<init>", "()V", "SELECTED_KINDS_PROPERTY", "", "intellij.ml.llm.recap"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

