/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.recap.chronicles.view;

import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.ViewModel;
import com.intellij.ml.llm.recap.chronicles.ai.RecapAgentResult;
import com.intellij.ml.llm.recap.chronicles.settings.RecapApplicationSettings;
import com.intellij.ml.llm.recap.chronicles.settings.RecapSettings;
import com.intellij.ml.llm.recap.chronicles.view.ChronicleKind;
import com.intellij.ml.llm.recap.chronicles.view.ChroniclePresenter;
import com.intellij.ml.llm.recap.chronicles.view.ChroniclePresenterParent;
import com.intellij.ml.llm.recap.chronicles.view.ChroniclesViewService;
import com.intellij.ml.llm.recap.chronicles.view.RecapResultsStorage;
import com.intellij.ml.llm.recap.chronicles.view.RecapSpentCounter;
import com.intellij.ml.llm.recap.chronicles.view.RecapUselessUpdatesCounter;
import com.intellij.ml.llm.recap.chronicles.view.RecapViewModel;
import com.intellij.ml.llm.recap.chronicles.view.RecapViewState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 E2\u00020\u0001:\u0001EB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010.\u001a\u00020/J\u0006\u00100\u001a\u00020/J\u0006\u00101\u001a\u00020/J\u000e\u00102\u001a\u00020\u000fH\u0086@\u00a2\u0006\u0002\u00103J\u0016\u00104\u001a\u00020\u000f2\u0006\u00105\u001a\u00020\u000fH\u0082@\u00a2\u0006\u0002\u00106J \u00107\u001a\u00020\u000f2\b\u00108\u001a\u0004\u0018\u00010+2\u0006\u00105\u001a\u00020\u000fH\u0082@\u00a2\u0006\u0002\u00109J \u0010:\u001a\u00020\u000f2\u0006\u00105\u001a\u00020\u000f2\b\u00108\u001a\u0004\u0018\u00010+H\u0082@\u00a2\u0006\u0002\u0010;J\u0010\u0010<\u001a\u0004\u0018\u00010+H\u0082@\u00a2\u0006\u0002\u00103J\"\u0010=\u001a\u00020\u000f2\b\u0010>\u001a\u0004\u0018\u00010+2\b\u0010?\u001a\u0004\u0018\u00010+H\u0082@\u00a2\u0006\u0002\u0010@J\u000e\u0010A\u001a\u00020\u000fH\u0086@\u00a2\u0006\u0002\u00103J\u0012\u0010B\u001a\u00020/2\b\u0010C\u001a\u0004\u0018\u00010DH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f8F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R+\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f8F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\u0016\u001a\u0004\b\u0018\u0010\u0012\"\u0004\b\u0019\u0010\u0014R/\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u001b8F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b!\u0010\u0016\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R+\u0010\"\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f8F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b%\u0010\u0016\u001a\u0004\b#\u0010\u0012\"\u0004\b$\u0010\u0014R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010(\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010*\u001a\u0004\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010,R\u0012\u0010-\u001a\u0004\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010,\u00a8\u0006F"}, d2={"Lcom/intellij/ml/llm/recap/chronicles/view/RecapViewModel;", "Landroidx/lifecycle/ViewModel;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "recapSettings", "Lcom/intellij/ml/llm/recap/chronicles/settings/RecapSettings;", "recapAppSettings", "Lcom/intellij/ml/llm/recap/chronicles/settings/RecapApplicationSettings;", "<set-?>", "", "loading", "getLoading", "()Z", "setLoading", "(Z)V", "loading$delegate", "Landroidx/compose/runtime/MutableState;", "failedToUpdateState", "getFailedToUpdateState", "setFailedToUpdateState", "failedToUpdateState$delegate", "Lcom/intellij/ml/llm/recap/chronicles/view/RecapViewState;", "state", "getState", "()Lcom/intellij/ml/llm/recap/chronicles/view/RecapViewState;", "setState", "(Lcom/intellij/ml/llm/recap/chronicles/view/RecapViewState;)V", "state$delegate", "showExperimentalBanner", "getShowExperimentalBanner", "setShowExperimentalBanner", "showExperimentalBanner$delegate", "persistance", "Lcom/intellij/ml/llm/recap/chronicles/view/RecapResultsStorage;", "currentJob", "Lkotlinx/coroutines/Deferred;", "computingForTimestamp", "", "Ljava/lang/Long;", "lastComputedTimestamp", "restore", "", "dismissExperimentalBanner", "refreshForce", "refreshTriggered", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "refreshAndWaitImpl", "forceRecalculation", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "startNewComputationAndWait", "headTimestamp", "(Ljava/lang/Long;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "computeImpl", "(ZLjava/lang/Long;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getCurrentHeadTimestamp", "isKindaSameRecap", "oldTimestamp", "newTimestamp", "(Ljava/lang/Long;Ljava/lang/Long;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isActualRecapCalculating", "trackSpentUsd", "result", "Lcom/intellij/ml/llm/recap/chronicles/ai/RecapAgentResult;", "Companion", "intellij.ml.llm.recap"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nRecapViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecapViewModel.kt\ncom/intellij/ml/llm/recap/chronicles/view/RecapViewModel\n+ 2 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,231:1\n85#2:232\n117#2,2:233\n85#2:235\n117#2,2:236\n85#2:238\n117#2,2:239\n85#2:241\n117#2,2:242\n57#3:244\n35#3,2:245\n57#3:247\n35#3,2:248\n57#3:250\n35#3,2:251\n57#3:253\n35#3,2:254\n57#3:256\n35#3,2:257\n57#3:259\n35#3,2:260\n57#3:262\n35#3,2:263\n57#3:271\n35#3,2:272\n57#3:286\n35#3,2:287\n1374#4:265\n1460#4,5:266\n1374#4:274\n1460#4,5:275\n774#4:280\n865#4,2:281\n1740#4,3:283\n*S KotlinDebug\n*F\n+ 1 RecapViewModel.kt\ncom/intellij/ml/llm/recap/chronicles/view/RecapViewModel\n*L\n30#1:232\n30#1:233,2\n33#1:235\n33#1:236,2\n36#1:238\n36#1:239,2\n39#1:241\n39#1:242,2\n100#1:244\n100#1:245,2\n109#1:247\n109#1:248,2\n118#1:250\n118#1:251,2\n140#1:253\n140#1:254,2\n147#1:256\n147#1:257,2\n173#1:259\n173#1:260,2\n178#1:262\n178#1:263,2\n191#1:271\n191#1:272,2\n205#1:286\n205#1:287,2\n189#1:265\n189#1:266,5\n202#1:274\n202#1:275,5\n203#1:280\n203#1:281,2\n204#1:283,3\n*E\n"})
public final class RecapViewModel
extends ViewModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final RecapSettings recapSettings;
    @NotNull
    private final RecapApplicationSettings recapAppSettings;
    @NotNull
    private final MutableState loading$delegate;
    @NotNull
    private final MutableState failedToUpdateState$delegate;
    @NotNull
    private final MutableState state$delegate;
    @NotNull
    private final MutableState showExperimentalBanner$delegate;
    @NotNull
    private final RecapResultsStorage persistance;
    @Nullable
    private Deferred<Boolean> currentJob;
    @Nullable
    private Long computingForTimestamp;
    @Nullable
    private Long lastComputedTimestamp;
    public static final int $stable = 8;

    public RecapViewModel(@NotNull Project project2, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.project = project2;
        this.scope = scope;
        this.recapSettings = RecapSettings.Companion.getInstance(this.project);
        this.recapAppSettings = RecapApplicationSettings.Companion.getInstance();
        this.loading$delegate = SnapshotStateKt.mutableStateOf$default((Object)false, null, (int)2, null);
        this.failedToUpdateState$delegate = SnapshotStateKt.mutableStateOf$default((Object)false, null, (int)2, null);
        this.state$delegate = SnapshotStateKt.mutableStateOf$default(null, null, (int)2, null);
        this.showExperimentalBanner$delegate = SnapshotStateKt.mutableStateOf$default((Object)(!((RecapApplicationSettings.State)this.recapAppSettings.getState()).getExperimentalBannerDismissed() ? 1 : 0), null, (int)2, null);
        this.persistance = RecapResultsStorage.Companion.getInstance(this.project);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean getLoading() {
        void $this$getValue$iv;
        State state2 = (State)this.loading$delegate;
        RecapViewModel recapViewModel = this;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (Boolean)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setLoading(boolean bl) {
        void $this$setValue$iv;
        MutableState mutableState = this.loading$delegate;
        RecapViewModel recapViewModel = this;
        Object var4_4 = null;
        Boolean value$iv = bl;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)value$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean getFailedToUpdateState() {
        void $this$getValue$iv;
        State state2 = (State)this.failedToUpdateState$delegate;
        RecapViewModel recapViewModel = this;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (Boolean)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setFailedToUpdateState(boolean bl) {
        void $this$setValue$iv;
        MutableState mutableState = this.failedToUpdateState$delegate;
        RecapViewModel recapViewModel = this;
        Object var4_4 = null;
        Boolean value$iv = bl;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)value$iv);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final RecapViewState getState() {
        void $this$getValue$iv;
        State state2 = (State)this.state$delegate;
        RecapViewModel recapViewModel = this;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (RecapViewState)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setState(RecapViewState recapViewState) {
        void $this$setValue$iv;
        MutableState mutableState = this.state$delegate;
        RecapViewModel recapViewModel = this;
        Object var4_4 = null;
        RecapViewState value$iv = recapViewState;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)value$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean getShowExperimentalBanner() {
        void $this$getValue$iv;
        State state2 = (State)this.showExperimentalBanner$delegate;
        RecapViewModel recapViewModel = this;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (Boolean)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setShowExperimentalBanner(boolean bl) {
        void $this$setValue$iv;
        MutableState mutableState = this.showExperimentalBanner$delegate;
        RecapViewModel recapViewModel = this;
        Object var4_4 = null;
        Boolean value$iv = bl;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)value$iv);
    }

    public final void restore() {
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ RecapViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (RecapUselessUpdatesCounter.Companion.getInstance(this.this$0.getProject()).getSuspended()) {
                            return Unit.INSTANCE;
                        }
                        storedResult = RecapViewModel.access$getPersistance$p(this.this$0).load();
                        if (storedResult == null) ** GOTO lbl25
                        if (this.this$0.getState() != null) {
                            return Unit.INSTANCE;
                        }
                        var3_5 = this.this$0;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)storedResult);
                        this.L$1 = var3_5;
                        this.label = 1;
                        v0 = RecapViewState.Companion.create(storedResult, this.this$0.getProject(), (Continuation<? super RecapViewState>)((Continuation)this));
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl24
                    }
                    case 1: {
                        var3_5 = (RecapViewModel)this.L$1;
                        storedResult = (RecapAgentResult)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl24:
                        // 2 sources

                        RecapViewModel.access$setState(var3_5, (RecapViewState)v0);
lbl25:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void dismissExperimentalBanner() {
        ((RecapApplicationSettings.State)this.recapAppSettings.getState()).setExperimentalBannerDismissed(true);
        this.setShowExperimentalBanner(false);
    }

    public final void refreshForce() {
        if (this.getLoading()) {
            return;
        }
        this.setLoading(true);
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ RecapViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Object invokeSuspend(Object $result) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = RecapViewModel.access$refreshAndWaitImpl(this.this$0, true, (Continuation)this);
                        ** if (v0 != var6_2) goto lbl11
lbl10:
                        // 1 sources

                        return var6_2;
lbl11:
                        // 1 sources

                        ** GOTO lbl17
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
                        }
                        catch (CancellationException e) {
                            throw e;
                            catch (Exception e) {
                                $i$f$fileLogger = false;
                                $i$f$currentClassLogger = false;
                                clazz$iv$iv = MethodHandles.lookup().lookupClass();
                                v1 = Logger.getInstance(clazz$iv$iv);
                                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getInstance(...)");
                                v1.error("Error in refresh", (Throwable)e);
                                return Unit.INSTANCE;
                            }
                        }
lbl17:
                        // 2 sources

                        RecapViewModel.access$setLoading(this.this$0, false);
                        return Unit.INSTANCE;
                    }
                }
                finally {
                    RecapViewModel.access$setLoading(this.this$0, false);
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object refreshTriggered(@NotNull Continuation<? super Boolean> $completion) {
        if (!($completion instanceof refreshTriggered.1)) ** GOTO lbl-1000
        var5_2 = $completion;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ RecapViewModel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.refreshTriggered((Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.setLoading(true);
                $continuation.label = 1;
                v0 = this.refreshAndWaitImpl(false, (Continuation<? super Boolean>)$continuation);
                ** if (v0 != var6_4) goto lbl19
lbl18:
                // 1 sources

                return var6_4;
lbl19:
                // 1 sources

                ** GOTO lbl25
            }
            case 1: {
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl25:
                    // 2 sources

                    var2_5 = v0;
                    return var2_5;
                }
                catch (Throwable var3_6) {
                    throw var3_6;
                }
                finally {
                    this.setLoading(false);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object refreshAndWaitImpl(boolean forceRecalculation, Continuation<? super Boolean> $completion) {
        block19: {
            if (!($completion instanceof refreshAndWaitImpl.1)) ** GOTO lbl-1000
            var9_3 = $completion;
            if ((var9_3.label & -2147483648) != 0) {
                var9_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    boolean Z$0;
                    Object L$0;
                    Object L$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ RecapViewModel this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return RecapViewModel.access$refreshAndWaitImpl(this.this$0, false, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.Z$0 = forceRecalculation;
                    $continuation.label = 1;
                    v0 = this.getCurrentHeadTimestamp((Continuation<? super Long>)$continuation);
                    if (v0 == var10_5) {
                        return var10_5;
                    }
                    ** GOTO lbl22
                }
                case 1: {
                    forceRecalculation = $continuation.Z$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl22:
                    // 2 sources

                    headTimestamp = (Long)v0;
                    existingJob = this.currentJob;
                    $i$f$fileLogger = false;
                    $i$f$currentClassLogger = false;
                    clazz$iv$iv = MethodHandles.lookup().lookupClass();
                    v1 = Logger.getInstance(clazz$iv$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getInstance(...)");
                    v2 = existingJob;
                    v1.debug("Recap computation requested. Force: " + (forceRecalculation != false) + ", existingJobActive: " + (v2 != null ? Boxing.boxBoolean((boolean)v2.isActive()) : null));
                    if (!forceRecalculation) break;
                    v3 = existingJob;
                    if (v3 != null) {
                        Job.DefaultImpls.cancel$default((Job)((Job)v3), null, (int)1, null);
                    }
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)headTimestamp);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable(existingJob);
                    $continuation.Z$0 = forceRecalculation;
                    $continuation.label = 2;
                    v4 = this.startNewComputationAndWait(headTimestamp, forceRecalculation != false, (Continuation<? super Boolean>)$continuation);
                    if (v4 == var10_5) {
                        return var10_5;
                    }
                    ** GOTO lbl50
                }
                case 2: {
                    forceRecalculation = $continuation.Z$0;
                    existingJob = (Deferred)$continuation.L$1;
                    headTimestamp = (Long)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
lbl50:
                    // 2 sources

                    return v4;
                }
            }
            v5 = existingJob;
            v6 = v5 != null ? v5.isActive() : false;
            if (!v6) break block19;
            $continuation.L$0 = headTimestamp;
            $continuation.L$1 = existingJob;
            $continuation.Z$0 = forceRecalculation;
            $continuation.label = 3;
            v7 = this.isKindaSameRecap(this.computingForTimestamp, headTimestamp, (Continuation<? super Boolean>)$continuation);
            if (v7 == var10_5) {
                return var10_5;
            }
            ** GOTO lbl68
            {
                case 3: {
                    forceRecalculation = $continuation.Z$0;
                    existingJob = (Deferred<Boolean>)$continuation.L$1;
                    headTimestamp = (Long)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v7 = $result;
lbl68:
                    // 2 sources

                    if (!((Boolean)v7).booleanValue()) break;
                    $i$f$fileLogger = false;
                    $i$f$currentClassLogger = false;
                    clazz$iv$iv = MethodHandles.lookup().lookupClass();
                    v8 = Logger.getInstance(clazz$iv$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"getInstance(...)");
                    v8.debug("Same recap already computing, waiting for completion");
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)headTimestamp);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable(existingJob);
                    $continuation.Z$0 = forceRecalculation;
                    $continuation.label = 4;
                    v9 = existingJob.await((Continuation)$continuation);
                    if (v9 == var10_5) {
                        return var10_5;
                    }
                    ** GOTO lbl90
                }
                case 4: {
                    forceRecalculation = $continuation.Z$0;
                    existingJob = (Deferred)$continuation.L$1;
                    headTimestamp = (Long)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v9 = $result;
lbl90:
                    // 2 sources

                    return v9;
                }
            }
            Job.DefaultImpls.cancel$default((Job)((Job)existingJob), null, (int)1, null);
        }
        $continuation.L$0 = headTimestamp;
        $continuation.L$1 = SpillingKt.nullOutSpilledVariable(existingJob);
        $continuation.Z$0 = forceRecalculation;
        $continuation.label = 5;
        v10 = this.isKindaSameRecap(this.lastComputedTimestamp, headTimestamp, (Continuation<? super Boolean>)$continuation);
        if (v10 == var10_5) {
            return var10_5;
        }
        ** GOTO lbl107
        {
            case 5: {
                forceRecalculation = $continuation.Z$0;
                existingJob = (Deferred)$continuation.L$1;
                headTimestamp = (Long)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v10 = $result;
lbl107:
                // 2 sources

                if (((Boolean)v10).booleanValue()) {
                    $i$f$fileLogger = false;
                    $i$f$currentClassLogger = false;
                    clazz$iv$iv = MethodHandles.lookup().lookupClass();
                    v11 = Logger.getInstance(clazz$iv$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"getInstance(...)");
                    v11.debug("Recap is already up to date");
                    return Boxing.boxBoolean((boolean)false);
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)headTimestamp);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable(existingJob);
                $continuation.Z$0 = forceRecalculation;
                $continuation.label = 6;
                v12 = this.startNewComputationAndWait(headTimestamp, forceRecalculation != false, (Continuation<? super Boolean>)$continuation);
                if (v12 == var10_5) {
                    return var10_5;
                }
                ** GOTO lbl130
            }
            case 6: {
                forceRecalculation = $continuation.Z$0;
                existingJob = (Deferred)$continuation.L$1;
                headTimestamp = (Long)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v12 = $result;
lbl130:
                // 2 sources

                return v12;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object startNewComputationAndWait(Long headTimestamp, boolean forceRecalculation, Continuation<? super Boolean> $completion) {
        Deferred job2;
        this.computingForTimestamp = headTimestamp;
        this.currentJob = job2 = BuildersKt.async$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this, forceRecalculation, headTimestamp, null){
            int label;
            final /* synthetic */ RecapViewModel this$0;
            final /* synthetic */ boolean $forceRecalculation;
            final /* synthetic */ Long $headTimestamp;
            {
                this.this$0 = $receiver;
                this.$forceRecalculation = $forceRecalculation;
                this.$headTimestamp = $headTimestamp;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = RecapViewModel.access$computeImpl(this.this$0, this.$forceRecalculation, this.$headTimestamp, (Continuation)this);
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return job2.await($completion);
    }

    /*
     * Exception decompiling
     */
    private final Object computeImpl(boolean forceRecalculation, Long headTimestamp, Continuation<? super Boolean> $completion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[SWITCH], 13[CASE]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    private final Object getCurrentHeadTimestamp(Continuation<? super Long> $completion) {
        if (!($completion instanceof getCurrentHeadTimestamp.1)) ** GOTO lbl-1000
        var13_2 = $completion;
        if ((var13_2.label & -2147483648) != 0) {
            var13_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ RecapViewModel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RecapViewModel.access$getCurrentHeadTimestamp(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var14_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = ChroniclesViewService.Companion.getInstance(this.project).reload((Collection)ChronicleKind.getEntries(), (Continuation<? super Unit>)$continuation);
                if (v0 == var14_4) {
                    return var14_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                $this$flatMap$iv = ChroniclesViewService.Companion.getInstance(this.project).getContent();
                $i$f$flatMap = false;
                var5_7 = $this$flatMap$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    it = (ChroniclePresenterParent)element$iv$iv;
                    $i$a$-flatMap-RecapViewModel$getCurrentHeadTimestamp$chronicles$1 = false;
                    list$iv$iv = it.getLeafs();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                chronicles = (List)destination$iv$iv;
                head = (ChroniclePresenter)CollectionsKt.firstOrNull((List)chronicles);
                $i$f$fileLogger = false;
                $i$f$currentClassLogger = false;
                clazz$iv$iv = MethodHandles.lookup().lookupClass();
                v1 = Logger.getInstance(clazz$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getInstance(...)");
                v1.debug("Last 3 chronicles: " + CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)chronicles, (int)3), null, null, null, (int)0, null, (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getCurrentHeadTimestamp$lambda$1(com.intellij.ml.llm.recap.chronicles.view.ChroniclePresenter ), (Lcom/intellij/ml/llm/recap/chronicles/view/ChroniclePresenter;)Ljava/lang/CharSequence;)(), (int)31, null));
                v2 = head;
                return v2 != null ? Boxing.boxLong((long)v2.getTimestamp()) : null;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Object isKindaSameRecap(Long oldTimestamp, Long newTimestamp, Continuation<? super Boolean> $completion) {
        if (!($completion instanceof isKindaSameRecap.1)) ** GOTO lbl-1000
        var16_4 = $completion;
        if ((var16_4.label & -2147483648) != 0) {
            var16_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ RecapViewModel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RecapViewModel.access$isKindaSameRecap(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var17_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (oldTimestamp == null || newTimestamp == null) {
                    return Boxing.boxBoolean((boolean)false);
                }
                if (Intrinsics.areEqual((Object)oldTimestamp, (Object)newTimestamp)) {
                    return Boxing.boxBoolean((boolean)true);
                }
                $continuation.L$0 = oldTimestamp;
                $continuation.L$1 = newTimestamp;
                $continuation.label = 1;
                v0 = ChroniclesViewService.Companion.getInstance(this.project).reload((Collection)ChronicleKind.getEntries(), (Continuation<? super Unit>)$continuation);
                if (v0 == var17_6) {
                    return var17_6;
                }
                ** GOTO lbl28
            }
            case 1: {
                newTimestamp = (Long)$continuation.L$1;
                oldTimestamp = (Long)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                $this$flatMap$iv = ChroniclesViewService.Companion.getInstance(this.project).getContent();
                $i$f$flatMap = false;
                var7_11 = $this$flatMap$iv;
                destination$iv$iv /* !! */  = new ArrayList<E>();
                $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    it = (ChroniclePresenterParent)element$iv$iv;
                    $i$a$-flatMap-RecapViewModel$isKindaSameRecap$chronicles$1 = false;
                    list$iv$iv = it.getLeafs();
                    CollectionsKt.addAll((Collection)destination$iv$iv /* !! */ , (Iterable)list$iv$iv);
                }
                chronicles = (List)destination$iv$iv /* !! */ ;
                $this$filter$iv = chronicles;
                $i$f$filter = false;
                destination$iv$iv /* !! */  = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (E element$iv$iv : $this$filterTo$iv$iv) {
                    it = (ChroniclePresenter)element$iv$iv;
                    $i$a$-filter-RecapViewModel$isKindaSameRecap$eventsAfterOld$1 = false;
                    if (!(it.getTimestamp() > oldTimestamp)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                eventsAfterOld = (List)destination$iv$iv;
                $this$all$iv = eventsAfterOld;
                $i$f$all = false;
                if (!($this$all$iv instanceof Collection) || !((Collection)$this$all$iv).isEmpty()) ** GOTO lbl59
                v1 = true;
                ** GOTO lbl66
lbl59:
                // 2 sources

                for (E element$iv : $this$all$iv) {
                    it = (ChroniclePresenter)element$iv;
                    $i$a$-all-RecapViewModel$isKindaSameRecap$result$1 = false;
                    if (it.getKind() == ChronicleKind.Scroll || it.getKind() == ChronicleKind.FileSwitch) continue;
                    v1 = false;
                    ** GOTO lbl66
                }
                v1 = true;
lbl66:
                // 3 sources

                result = v1;
                $i$f$fileLogger = false;
                $i$f$currentClassLogger = false;
                clazz$iv$iv = MethodHandles.lookup().lookupClass();
                v2 = Logger.getInstance(clazz$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getInstance(...)");
                v2.debug("isKindaSameRecap: result=" + (result != false) + ", old=" + oldTimestamp + ", new=" + newTimestamp + ", eventsAfter=" + eventsAfterOld.size());
                return Boxing.boxBoolean((boolean)(result != false));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object isActualRecapCalculating(@NotNull Continuation<? super Boolean> $completion) {
        if (!($completion instanceof isActualRecapCalculating.1)) ** GOTO lbl-1000
        var5_2 = $completion;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ RecapViewModel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.isActualRecapCalculating((Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = existingJob = this.currentJob;
                if (!(v0 != null ? v0.isActive() : false)) {
                    return Boxing.boxBoolean((boolean)false);
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable(existingJob);
                $continuation.label = 1;
                v1 = this.getCurrentHeadTimestamp((Continuation<? super Long>)$continuation);
                if (v1 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl25
            }
            case 1: {
                existingJob = (Deferred<Boolean>)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl25:
                // 2 sources

                headTimestamp = (Long)v1;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable(existingJob);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)headTimestamp);
                $continuation.label = 2;
                v2 = this.isKindaSameRecap(this.computingForTimestamp, headTimestamp, (Continuation<? super Boolean>)$continuation);
                if (v2 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl38
            }
            case 2: {
                headTimestamp = (Long)$continuation.L$1;
                existingJob = (Deferred)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl38:
                // 2 sources

                return v2;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void trackSpentUsd(RecapAgentResult result2) {
        if (result2 != null) {
            RecapSpentCounter recapSpentCounter;
            RecapSpentCounter $this$trackSpentUsd_u24lambda_u240 = recapSpentCounter = RecapSpentCounter.Companion.getInstance(this.project);
            boolean bl = false;
            $this$trackSpentUsd_u24lambda_u240.track(result2.getLog().getTrack30Min().getSpentUsd());
            $this$trackSpentUsd_u24lambda_u240.track(result2.getLog().getTrack2H().getSpentUsd());
        }
    }

    private static final CharSequence getCurrentHeadTimestamp$lambda$1(ChroniclePresenter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "timestamp=" + it.getTimestamp() + ", text=" + it.getCaption();
    }

    public static final /* synthetic */ RecapResultsStorage access$getPersistance$p(RecapViewModel $this) {
        return $this.persistance;
    }

    public static final /* synthetic */ void access$setState(RecapViewModel $this, RecapViewState recapViewState) {
        $this.setState(recapViewState);
    }

    public static final /* synthetic */ Object access$refreshAndWaitImpl(RecapViewModel $this, boolean forceRecalculation, Continuation $completion) {
        return $this.refreshAndWaitImpl(forceRecalculation, (Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ void access$setLoading(RecapViewModel $this, boolean bl) {
        $this.setLoading(bl);
    }

    public static final /* synthetic */ Object access$startNewComputationAndWait(RecapViewModel $this, Long headTimestamp, boolean forceRecalculation, Continuation $completion) {
        return $this.startNewComputationAndWait(headTimestamp, forceRecalculation, (Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ Object access$computeImpl(RecapViewModel $this, boolean forceRecalculation, Long headTimestamp, Continuation $completion) {
        return $this.computeImpl(forceRecalculation, headTimestamp, (Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ Object access$getCurrentHeadTimestamp(RecapViewModel $this, Continuation $completion) {
        return $this.getCurrentHeadTimestamp((Continuation<? super Long>)$completion);
    }

    public static final /* synthetic */ Object access$isKindaSameRecap(RecapViewModel $this, Long oldTimestamp, Long newTimestamp, Continuation $completion) {
        return $this.isKindaSameRecap(oldTimestamp, newTimestamp, (Continuation<? super Boolean>)$completion);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/recap/chronicles/view/RecapViewModel$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ml/llm/recap/chronicles/view/RecapViewModel;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.ml.llm.recap"})
    @SourceDebugExtension(value={"SMAP\nRecapViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecapViewModel.kt\ncom/intellij/ml/llm/recap/chronicles/view/RecapViewModel$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,231:1\n30#2,2:232\n*S KotlinDebug\n*F\n+ 1 RecapViewModel.kt\ncom/intellij/ml/llm/recap/chronicles/view/RecapViewModel$Companion\n*L\n24#1:232,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RecapViewModel getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<RecapViewModel> serviceClass$iv = RecapViewModel.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (RecapViewModel)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

