/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.rider.cpp.chat;

import com.intellij.ml.llm.chat.session.AgentFinishedFileChange;
import com.intellij.ml.llm.chat.session.AgentFinishedListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.jetbrains.rd.util.reactive.RdFault;
import com.jetbrains.rider.model.RdAddItemData;
import com.jetbrains.rider.model.RdAddItemsCommand;
import com.jetbrains.rider.model.RdExcludeItemsCommand;
import com.jetbrains.rider.model.RdProjectModelCommand;
import com.jetbrains.rider.projectView.ProjectModelEventsService;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/rider/cpp/chat/RiderCppAgentFinishedListener;", "Lcom/intellij/ml/llm/chat/session/AgentFinishedListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "onAgentFinished", "", "changes", "", "Lcom/intellij/ml/llm/chat/session/AgentFinishedFileChange;", "onFileAdd", "Lcom/jetbrains/rider/model/RdProjectModelCommand;", "workspaceModel", "Lcom/intellij/platform/backend/workspace/WorkspaceModel;", "path", "Ljava/nio/file/Path;", "onFileRemove", "findCppParentEntity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "Companion", "intellij.ml.llm.rider.cpp"})
@SourceDebugExtension(value={"SMAP\nRiderCppAgentFinishedListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderCppAgentFinishedListener.kt\ncom/intellij/ml/llm/rider/cpp/chat/RiderCppAgentFinishedListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,101:1\n1#2:102\n1#2:116\n774#3:103\n865#3,2:104\n1617#3,9:106\n1869#3:115\n1870#3:117\n1626#3:118\n669#3,11:119\n23#4:130\n*S KotlinDebug\n*F\n+ 1 RiderCppAgentFinishedListener.kt\ncom/intellij/ml/llm/rider/cpp/chat/RiderCppAgentFinishedListener\n*L\n81#1:116\n80#1:103\n80#1:104,2\n81#1:106,9\n81#1:115\n81#1:117\n81#1:118\n93#1:119,11\n21#1:130\n*E\n"})
public final class RiderCppAgentFinishedListener
implements AgentFinishedListener {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger logger;

    public RiderCppAgentFinishedListener(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    public void onAgentFinished(@NotNull List<? extends AgentFinishedFileChange> changes2) {
        Intrinsics.checkNotNullParameter(changes2, (String)"changes");
        if (changes2.isEmpty()) {
            return;
        }
        ProjectModelEventsService projectModelEventsService = ProjectModelEventsService.Companion.getInstance(this.project);
        WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(this.project);
        List commands = new ArrayList();
        for (AgentFinishedFileChange agentFinishedFileChange : changes2) {
            try {
                RdProjectModelCommand it;
                boolean bl;
                AgentFinishedFileChange agentFinishedFileChange2 = agentFinishedFileChange;
                if (agentFinishedFileChange2 instanceof AgentFinishedFileChange.Add) {
                    if (this.onFileAdd(workspaceModel, ((AgentFinishedFileChange.Add)agentFinishedFileChange).getPath()) != null) {
                        bl = false;
                        commands.add(it);
                    }
                    continue;
                }
                if (agentFinishedFileChange2 instanceof AgentFinishedFileChange.Remove) {
                    if (this.onFileRemove(workspaceModel, ((AgentFinishedFileChange.Remove)agentFinishedFileChange).getPath()) != null) {
                        bl = false;
                        commands.add(it);
                    }
                    continue;
                }
                if (agentFinishedFileChange2 instanceof AgentFinishedFileChange.Move) {
                    if (this.onFileRemove(workspaceModel, ((AgentFinishedFileChange.Move)agentFinishedFileChange).getFrom()) != null) {
                        bl = false;
                        commands.add(it);
                    }
                    if (this.onFileAdd(workspaceModel, ((AgentFinishedFileChange.Move)agentFinishedFileChange).getTo()) == null) continue;
                    bl = false;
                    commands.add(it);
                    continue;
                }
                if (agentFinishedFileChange2 instanceof AgentFinishedFileChange.Edit) continue;
                throw new NoWhenBranchMatchedException();
            }
            catch (Throwable t) {
                logger.error(t);
            }
        }
        if (commands.isEmpty()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> RiderCppAgentFinishedListener.onAgentFinished$lambda$4(projectModelEventsService, commands));
    }

    private final RdProjectModelCommand onFileAdd(WorkspaceModel workspaceModel, Path path) {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.isDirectory(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return null;
        }
        List entities = WorkspaceModelExtensionsKt.getProjectModelEntities((WorkspaceModel)workspaceModel, (Path)path, (Project)this.project);
        if (CollectionsKt.any((Iterable)entities)) {
            return null;
        }
        ProjectModelEntity parentEntity = this.findCppParentEntity(workspaceModel, path);
        Object object = parentEntity;
        if (object == null || (object = ProjectModelEntityExtensionsKt.getId((ProjectModelEntity)object, (Project)this.project)) == null) {
            return null;
        }
        int parentEntityId = (Integer)object;
        return (RdProjectModelCommand)new RdAddItemsCommand(CollectionsKt.listOf((Object)new RdAddItemData(((Object)path).toString(), parentEntityId, null, true)));
    }

    /*
     * WARNING - void declaration
     */
    private final RdProjectModelCommand onFileRemove(WorkspaceModel workspaceModel, Path path) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        if (this.findCppParentEntity(workspaceModel, path) == null) {
            return null;
        }
        Iterable iterable = WorkspaceModelExtensionsKt.getProjectModelEntities((WorkspaceModel)workspaceModel, (Path)path, (Project)this.project);
        boolean $i$f$filter = false;
        void var6_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ProjectModelEntity it = (ProjectModelEntity)element$iv$iv;
            boolean bl = false;
            if (!ProjectModelEntityExtensionsKt.isProjectFile((ProjectModelEntity)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Integer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ProjectModelEntity it = (ProjectModelEntity)element$iv$iv;
            boolean bl2 = false;
            if (ProjectModelEntityExtensionsKt.getId((ProjectModelEntity)it, (Project)this.project) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List entityIds = (List)destination$iv$iv;
        if (entityIds.isEmpty()) {
            return null;
        }
        return (RdProjectModelCommand)new RdExcludeItemsCommand(entityIds);
    }

    private final ProjectModelEntity findCppParentEntity(WorkspaceModel workspaceModel, Path path) {
        Object v1;
        List parentEntities;
        block4: {
            Path path2 = path.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getParent(...)");
            parentEntities = WorkspaceModelExtensionsKt.getProjectModelEntities((WorkspaceModel)workspaceModel, (Path)path2, (Project)this.project);
            if (parentEntities.isEmpty()) {
                return null;
            }
            Iterable $this$singleOrNull$iv = parentEntities;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                ProjectModelEntity it = (ProjectModelEntity)element$iv;
                boolean bl = false;
                if (!ProjectModelEntityExtensionsKt.isFromVcxProject((ProjectModelEntity)it)) continue;
                if (found$iv) {
                    v1 = null;
                    break block4;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v1 = !found$iv ? null : single$iv;
        }
        ProjectModelEntity singleCppParent = v1;
        if (singleCppParent == null) {
            return null;
        }
        logger.trace("Chose single C++ parent " + singleCppParent + " from " + parentEntities.size() + " parents for file " + path);
        return singleCppParent;
    }

    private static final void onAgentFinished$lambda$4(ProjectModelEventsService $projectModelEventsService, List $commands) {
        $projectModelEventsService.addCommands($commands);
        try {
            $projectModelEventsService.flush();
        }
        catch (RdFault ex) {
            logger.warn((Throwable)ex);
        }
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RiderCppAgentFinishedListener.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/rider/cpp/chat/RiderCppAgentFinishedListener$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.ml.llm.rider.cpp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

