/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.frozen.insight.impl.typingTracking;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.ml.llm.riderNext.latest.frozen.insight.impl.typingTracking.ChangesTrackedInsight;
import com.intellij.ml.llm.riderNext.latest.frozen.insight.impl.typingTracking.OnChangeStrategy;
import com.intellij.ml.llm.riderNext.latest.frozen.insight.impl.typingTracking.ThrottlingUpdater;
import com.intellij.ml.llm.riderNext.latest.frozen.insight.impl.widget.AIInsightProgressTracker;
import com.intellij.ml.llm.riderNext.latest.ui.editor.cards.AIDaemon;
import com.intellij.ml.llm.riderNext.latest.ui.editor.cards.AIDaemonId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.observable.util.DisposerUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RemoveUserDataKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000fJ\b\u0010\u0016\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR3\u0010\n\u001a'\u0012\u000e\u0012\f0\f\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u000e\u0012\u000e\u0012\f0\u000f\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u000e0\u000b\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/frozen/insight/impl/typingTracking/AIInsightTypingTracker;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Lkotlinx/coroutines/CoroutineScope;)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "trackedInsights", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/ml/llm/riderNext/latest/ui/editor/cards/AIDaemonId;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lcom/intellij/ml/llm/riderNext/latest/frozen/insight/impl/typingTracking/ChangesTrackedInsight;", "shortThrottlingUpdater", "Lcom/intellij/ml/llm/riderNext/latest/frozen/insight/impl/typingTracking/ThrottlingUpdater;", "longThrottlingUpdater", "track", "", "insight", "dispose", "Companion", "intellij.ml.llm.riderNext.latest"})
@StabilityInferred(parameters=0)
public final class AIInsightTypingTracker
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final ConcurrentMap<AIDaemonId, ChangesTrackedInsight> trackedInsights;
    @NotNull
    private final ThrottlingUpdater shortThrottlingUpdater;
    @NotNull
    private final ThrottlingUpdater longThrottlingUpdater;
    public static final int $stable = 8;
    @NotNull
    private static final Key<AIInsightTypingTracker> CONTAINER_KEY = new Key("AIInsightTypingTracker");

    public AIInsightTypingTracker(@NotNull EditorImpl editor2, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.editor = editor2;
        ConcurrentMap concurrentMap = ConcurrentCollectionFactory.createConcurrentMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentMap(...)");
        this.trackedInsights = concurrentMap;
        this.shortThrottlingUpdater = new ThrottlingUpdater(DurationKt.toDuration((int)Registry.Companion.intValue("llm.riderNext.aiInsight.update.delay.short.sec"), (DurationUnit)DurationUnit.SECONDS), scope, arg_0 -> AIInsightTypingTracker.shortThrottlingUpdater$lambda$0(this, arg_0), null);
        this.longThrottlingUpdater = new ThrottlingUpdater(DurationKt.toDuration((int)Registry.Companion.intValue("llm.riderNext.aiInsight.update.delay.long.sec"), (DurationUnit)DurationUnit.SECONDS), scope, arg_0 -> AIInsightTypingTracker.longThrottlingUpdater$lambda$0(this, arg_0), null);
        this.editor.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent event2) {
                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                for (ChangesTrackedInsight insight : trackedInsights.values()) {
                    Intrinsics.checkNotNull((Object)insight);
                    if (this.disposeIfEmpty(insight) || !insight.getRange().getTextRange().intersects(event2.getOffset(), event2.getOffset() + event2.getNewLength())) continue;
                    this.handleIntersected(insight, event2);
                }
            }

            private final boolean disposeIfEmpty(ChangesTrackedInsight insight) {
                if (insight.getDisposeIdEmpty() && (!insight.getRange().isValid() || insight.getRange().getTextRange().isEmpty())) {
                    Disposer.dispose((Disposable)insight);
                    return true;
                }
                return false;
            }

            private final void handleIntersected(ChangesTrackedInsight insight, DocumentEvent event2) {
                OnChangeStrategy strategy2 = insight.onRangeChanged(event2);
                boolean scheduled = switch (WhenMappings.$EnumSwitchMapping$0[strategy2.ordinal()]) {
                    case 1 -> false;
                    case 2 -> {
                        shortThrottlingUpdater.scheduleUpdate(insight.getId());
                        yield true;
                    }
                    case 3 -> {
                        longThrottlingUpdater.scheduleUpdate(insight.getId());
                        yield true;
                    }
                    default -> throw new NoWhenBranchMatchedException();
                };
                if (scheduled && insight instanceof AIDaemon) {
                    Project project2 = this.getEditor().getProject();
                    Intrinsics.checkNotNull((Object)project2);
                    AIInsightProgressTracker.Companion.getInstance(project2).addPending((AIDaemon)((Object)insight));
                }
            }

            @Metadata(mv={2, 2, 0}, k=3, xi=48)
            public static final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[OnChangeStrategy.values().length];
                    try {
                        nArray[OnChangeStrategy.Nothing.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[OnChangeStrategy.UpdateWithShortThrottling.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[OnChangeStrategy.UpdateWithLongThrottling.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }, (Disposable)this);
    }

    @NotNull
    public final EditorImpl getEditor() {
        return this.editor;
    }

    public final void track(@NotNull ChangesTrackedInsight insight) {
        Intrinsics.checkNotNullParameter((Object)insight, (String)"insight");
        this.trackedInsights.put(insight.getId(), insight);
        Disposer.tryRegister((Disposable)insight, () -> AIInsightTypingTracker.track$lambda$0(this, insight));
    }

    public void dispose() {
    }

    private static final Unit shortThrottlingUpdater$lambda$0(AIInsightTypingTracker this$0, AIDaemonId it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            ChangesTrackedInsight changesTrackedInsight = (ChangesTrackedInsight)this$0.trackedInsights.get(it);
            if (changesTrackedInsight == null) break block0;
            changesTrackedInsight.requestUpdate();
        }
        return Unit.INSTANCE;
    }

    private static final Unit longThrottlingUpdater$lambda$0(AIInsightTypingTracker this$0, AIDaemonId it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            ChangesTrackedInsight changesTrackedInsight = (ChangesTrackedInsight)this$0.trackedInsights.get(it);
            if (changesTrackedInsight == null) break block0;
            changesTrackedInsight.requestUpdate();
        }
        return Unit.INSTANCE;
    }

    private static final void track$lambda$0(AIInsightTypingTracker this$0, ChangesTrackedInsight $insight) {
        this$0.trackedInsights.remove($insight.getId());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/frozen/insight/impl/typingTracking/AIInsightTypingTracker$Companion;", "", "<init>", "()V", "CONTAINER_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/ml/llm/riderNext/latest/frozen/insight/impl/typingTracking/AIInsightTypingTracker;", "getInstance", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "intellij.ml.llm.riderNext.latest"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AIInsightTypingTracker getInstance(@NotNull EditorImpl editor2, @NotNull CoroutineScope scope) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            AIInsightTypingTracker current = (AIInsightTypingTracker)editor2.getUserData(CONTAINER_KEY);
            if (current != null) {
                return current;
            }
            AIInsightTypingTracker aIInsightTypingTracker = new AIInsightTypingTracker(editor2, scope);
            Object object = editor2.putUserDataIfAbsent(CONTAINER_KEY, (Object)aIInsightTypingTracker);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"putUserDataIfAbsent(...)");
            AIInsightTypingTracker tracker = (AIInsightTypingTracker)object;
            if (Intrinsics.areEqual((Object)tracker, (Object)aIInsightTypingTracker)) {
                DisposerUtilKt.whenDisposed((Disposable)tracker, () -> Companion.getInstance$lambda$0(editor2));
                EditorUtil.disposeWithEditor((Editor)((Editor)editor2), (Disposable)tracker);
            }
            return tracker;
        }

        private static final Unit getInstance$lambda$0(EditorImpl $editor) {
            RemoveUserDataKt.removeUserData((UserDataHolder)((UserDataHolder)$editor), (Key)CONTAINER_KEY);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

