/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.frozen.recap.lvcs;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.history.integration.LocalHistoryImpl;
import com.intellij.ml.llm.riderNext.latest.frozen.recap.lvcs.RecapLVCSChange;
import com.intellij.ml.llm.riderNext.latest.frozen.recap.lvcs.RecapLVCSChunk;
import com.intellij.ml.llm.riderNext.latest.frozen.recap.lvcs.RecapLVCSDiffKt;
import com.intellij.ml.llm.riderNext.latest.frozen.recap.lvcs.RecapLVCSTimestamp;
import com.intellij.ml.llm.riderNext.latest.frozen.recap.vcs.RecapLatestCommits;
import com.intellij.ml.llm.tokenizer.Tokenizer;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0001\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/frozen/recap/lvcs/RecapLVCSDiff;", "", "chunksNewToLatest", "", "Lcom/intellij/ml/llm/riderNext/latest/frozen/recap/lvcs/RecapLVCSChunk;", "tokenizer", "Lcom/intellij/ml/llm/tokenizer/Tokenizer;", "<init>", "(Ljava/util/List;Lcom/intellij/ml/llm/tokenizer/Tokenizer;)V", "getChunksNewToLatest", "()Ljava/util/List;", "getTokenizer", "()Lcom/intellij/ml/llm/tokenizer/Tokenizer;", "getOldestToNewestDiff", "Lkotlin/Pair;", "", "Lcom/intellij/ml/llm/riderNext/latest/frozen/recap/lvcs/RecapLVCSTimestamp;", "otherPromptSize", "", "findIndexThatFitLimit", "limit", "Companion", "intellij.ml.llm.riderNext.latest"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nRecapLVCSDiff.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecapLVCSDiff.kt\ncom/intellij/ml/llm/riderNext/latest/frozen/recap/lvcs/RecapLVCSDiff\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,122:1\n13#2:123\n*S KotlinDebug\n*F\n+ 1 RecapLVCSDiff.kt\ncom/intellij/ml/llm/riderNext/latest/frozen/recap/lvcs/RecapLVCSDiff\n*L\n11#1:123\n*E\n"})
public final class RecapLVCSDiff {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<RecapLVCSChunk> chunksNewToLatest;
    @NotNull
    private final Tokenizer tokenizer;
    public static final int $stable = 8;
    @NotNull
    private static final Logger logger;

    public RecapLVCSDiff(@NotNull List<RecapLVCSChunk> chunksNewToLatest, @NotNull Tokenizer tokenizer) {
        Intrinsics.checkNotNullParameter(chunksNewToLatest, (String)"chunksNewToLatest");
        Intrinsics.checkNotNullParameter((Object)tokenizer, (String)"tokenizer");
        this.chunksNewToLatest = chunksNewToLatest;
        this.tokenizer = tokenizer;
    }

    @NotNull
    public final List<RecapLVCSChunk> getChunksNewToLatest() {
        return this.chunksNewToLatest;
    }

    @NotNull
    public final Tokenizer getTokenizer() {
        return this.tokenizer;
    }

    @NotNull
    public final Pair<String, RecapLVCSTimestamp> getOldestToNewestDiff(int otherPromptSize) {
        int limit = 16000 - otherPromptSize;
        if (limit <= 0) {
            logger.error("Limit is empty in RecapLVCSDiff. Other prompt size " + otherPromptSize);
            return new Pair((Object)"", (Object)new RecapLVCSTimestamp(0L));
        }
        int lastIndex = this.findIndexThatFitLimit(limit);
        StringBuilder builder = new StringBuilder();
        for (int i = lastIndex; -1 < i; --i) {
            RecapLVCSChunk chunk = this.chunksNewToLatest.get(i);
            builder.append(chunk.getDiff().toString()).append('\n');
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String diff2 = string;
        RecapLVCSTimestamp timestamp = this.chunksNewToLatest.get(lastIndex).getTimestamp();
        return new Pair((Object)diff2, (Object)timestamp);
    }

    private final int findIndexThatFitLimit(int limit) {
        RecapLVCSChunk chunk;
        int chunkLength;
        int length = 0;
        int lastIndex = -1;
        int i = 0;
        int n = this.chunksNewToLatest.size();
        while (i < n && length + (chunkLength = this.tokenizer.count((chunk = this.chunksNewToLatest.get(i)).getDiff())) <= limit) {
            length += chunkLength;
            lastIndex = i++;
        }
        return lastIndex;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RecapLVCSDiff.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RecapLVCSDiff.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0006\u001a\u0004\u0018\u00010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/frozen/recap/lvcs/RecapLVCSDiff$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "create", "Lcom/intellij/ml/llm/riderNext/latest/frozen/recap/lvcs/RecapLVCSDiff;", "changesNewToLatest", "", "Lcom/intellij/ml/llm/riderNext/latest/frozen/recap/lvcs/RecapLVCSChange;", "localHistoryImpl", "Lcom/intellij/history/integration/LocalHistoryImpl;", "tokenizer", "Lcom/intellij/ml/llm/tokenizer/Tokenizer;", "latestCommits", "Lcom/intellij/ml/llm/riderNext/latest/frozen/recap/vcs/RecapLatestCommits;", "intellij.ml.llm.riderNext.latest"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final RecapLVCSDiff create(@NotNull List<RecapLVCSChange> changesNewToLatest, @NotNull LocalHistoryImpl localHistoryImpl, @NotNull Tokenizer tokenizer, @Nullable RecapLatestCommits latestCommits) {
            Intrinsics.checkNotNullParameter(changesNewToLatest, (String)"changesNewToLatest");
            Intrinsics.checkNotNullParameter((Object)localHistoryImpl, (String)"localHistoryImpl");
            Intrinsics.checkNotNullParameter((Object)tokenizer, (String)"tokenizer");
            ArrayList chunks = RecapLVCSDiffKt.access$getChangesDiffs(changesNewToLatest, localHistoryImpl, tokenizer, latestCommits);
            if (chunks.isEmpty()) {
                return null;
            }
            return new RecapLVCSDiff(chunks, tokenizer);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

