/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.git.selfReview;

import com.intellij.ml.llm.riderNext.latest.git.selfReview.ProjectFilesIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B#\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u001c\u0010\u0013\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\nH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\b\u001a\u001c\u0012\u0018\u0012\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/git/selfReview/BatchedProjectFilesIterator;", "Lcom/intellij/ml/llm/riderNext/latest/git/selfReview/ProjectFilesIterator;", "underlyingIterator", "maxBatchSizeBytes", "", "maxFilesPerBatch", "<init>", "(Lcom/intellij/ml/llm/riderNext/latest/git/selfReview/ProjectFilesIterator;II)V", "dataQueue", "Lkotlin/collections/ArrayDeque;", "Lkotlin/Pair;", "", "", "processedCount", "totalCount", "getTotalCount", "()I", "hasNext", "", "next", "fillQueue", "", "Companion", "intellij.ml.llm.riderNext.latest.git"})
public final class BatchedProjectFilesIterator
implements ProjectFilesIterator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProjectFilesIterator underlyingIterator;
    private final int maxBatchSizeBytes;
    private final int maxFilesPerBatch;
    @NotNull
    private final ArrayDeque<Pair<List<String>, String>> dataQueue;
    private int processedCount;
    private final int totalCount;
    public static final int DEFAULT_MAX_BATCH_SIZE_BYTES = 102400;
    public static final int DEFAULT_MAX_FILES_PER_BATCH = 5;

    public BatchedProjectFilesIterator(@NotNull ProjectFilesIterator underlyingIterator, int maxBatchSizeBytes, int maxFilesPerBatch) {
        Intrinsics.checkNotNullParameter((Object)underlyingIterator, (String)"underlyingIterator");
        this.underlyingIterator = underlyingIterator;
        this.maxBatchSizeBytes = maxBatchSizeBytes;
        this.maxFilesPerBatch = maxFilesPerBatch;
        this.dataQueue = new ArrayDeque();
        this.totalCount = this.underlyingIterator.getTotalCount();
    }

    public /* synthetic */ BatchedProjectFilesIterator(ProjectFilesIterator projectFilesIterator, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = 102400;
        }
        if ((n3 & 4) != 0) {
            n2 = 5;
        }
        this(projectFilesIterator, n, n2);
    }

    @Override
    public int getTotalCount() {
        return this.totalCount;
    }

    @Override
    public boolean hasNext() {
        return !((Collection)this.dataQueue).isEmpty() || this.underlyingIterator.hasNext();
    }

    @Override
    @NotNull
    public Pair<List<String>, String> next() {
        if (!this.hasNext()) {
            return new Pair((Object)CollectionsKt.emptyList(), null);
        }
        if (this.dataQueue.isEmpty()) {
            this.fillQueue();
        }
        if (this.dataQueue.isEmpty()) {
            return new Pair((Object)CollectionsKt.emptyList(), null);
        }
        int n = this.processedCount;
        this.processedCount = n + 1;
        Pair data2 = (Pair)this.dataQueue.removeFirst();
        return data2;
    }

    private final void fillQueue() {
        int currentBatchSize = 0;
        int filesInBatch = 0;
        List batchPaths = new ArrayList();
        StringBuilder batchContent = new StringBuilder();
        while (this.underlyingIterator.hasNext() && currentBatchSize < this.maxBatchSizeBytes && filesInBatch < this.maxFilesPerBatch) {
            int contentSize;
            Pair<List<String>, String> pair = this.underlyingIterator.next();
            List paths = (List)pair.component1();
            String content2 = (String)pair.component2();
            if (paths.isEmpty()) continue;
            String string = content2;
            int n = contentSize = string != null ? string.length() : 0;
            if (currentBatchSize > 0 && currentBatchSize + contentSize > this.maxBatchSizeBytes) {
                this.dataQueue.add((Object)new Pair((Object)CollectionsKt.toList((Iterable)batchPaths), (Object)batchContent.toString()));
                batchPaths.clear();
                StringsKt.clear((StringBuilder)batchContent);
                batchPaths.addAll(paths);
                if (content2 != null) {
                    batchContent.append("--- FILE: " + CollectionsKt.first((List)paths) + " ---").append('\n');
                    batchContent.append(content2).append('\n');
                    batchContent.append('\n');
                }
                currentBatchSize = contentSize;
                filesInBatch = 1;
                continue;
            }
            batchPaths.addAll(paths);
            if (content2 != null) {
                batchContent.append("--- FILE: " + CollectionsKt.first((List)paths) + " ---").append('\n');
                batchContent.append(content2).append('\n');
                batchContent.append('\n');
            }
            currentBatchSize += contentSize;
            ++filesInBatch;
        }
        if (!((Collection)batchPaths).isEmpty()) {
            this.dataQueue.add((Object)new Pair((Object)CollectionsKt.toList((Iterable)batchPaths), (Object)batchContent.toString()));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/git/selfReview/BatchedProjectFilesIterator$Companion;", "", "<init>", "()V", "DEFAULT_MAX_BATCH_SIZE_BYTES", "", "DEFAULT_MAX_FILES_PER_BATCH", "intellij.ml.llm.riderNext.latest.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

