/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.git.selfReview;

import com.intellij.ml.llm.codeEngine.IJVirtualPath;
import com.intellij.ml.llm.codeEngine.IJVirtualPathKt;
import com.intellij.ml.llm.riderNext.latest.git.selfReview.ProjectFilesIterator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fBA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u0012\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0006H\u0002J\b\u0010\u001a\u001a\u00020\u000bH\u0016J\u001c\u0010\u001b\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001cH\u0016R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/ml/llm/riderNext/latest/git/selfReview/RecursiveProjectFilesIterator;", "Lcom/intellij/ml/llm/riderNext/latest/git/selfReview/ProjectFilesIterator;", "project", "Lcom/intellij/openapi/project/Project;", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "roots", "", "filter", "Lkotlin/Function1;", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/Collection;Ljava/util/Set;Lkotlin/jvm/functions/Function1;)V", "fileQueue", "Lkotlin/collections/ArrayDeque;", "processedCount", "", "totalCount", "getTotalCount", "()I", "projectRoot", "Lcom/intellij/ml/llm/codeEngine/IJVirtualPath;", "processFile", "", "file", "hasNext", "next", "Lkotlin/Pair;", "", "", "Companion", "intellij.ml.llm.riderNext.latest.git"})
@SourceDebugExtension(value={"SMAP\nRecursiveProjectFilesIterator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecursiveProjectFilesIterator.kt\ncom/intellij/ml/llm/riderNext/latest/git/selfReview/RecursiveProjectFilesIterator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,83:1\n1869#2,2:84\n13805#3,2:86\n57#4:88\n35#4,2:89\n57#4:91\n35#4,2:92\n57#4:94\n35#4,2:95\n57#4:97\n35#4,2:98\n*S KotlinDebug\n*F\n+ 1 RecursiveProjectFilesIterator.kt\ncom/intellij/ml/llm/riderNext/latest/git/selfReview/RecursiveProjectFilesIterator\n*L\n30#1:84,2\n40#1:86,2\n55#1:88\n55#1:89,2\n61#1:91\n61#1:92,2\n68#1:94\n68#1:95,2\n74#1:97\n74#1:98,2\n*E\n"})
public final class RecursiveProjectFilesIterator
implements ProjectFilesIterator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<VirtualFile, Boolean> filter;
    @NotNull
    private final ArrayDeque<VirtualFile> fileQueue;
    private int processedCount;
    private final int totalCount;
    @NotNull
    private final IJVirtualPath projectRoot;
    public static final int DEFAULT_MAX_BATCH_SIZE_BYTES = 102400;

    public RecursiveProjectFilesIterator(@NotNull Project project2, @NotNull Collection<? extends VirtualFile> files, @NotNull Set<? extends VirtualFile> roots, @NotNull Function1<? super VirtualFile, Boolean> filter2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        this.filter = filter2;
        this.fileQueue = new ArrayDeque();
        Object object = ProjectUtil.guessProjectDir((Project)project2);
        if (object == null || (object = IJVirtualPathKt.toVirtualPath(object)) == null) {
            throw new IllegalStateException("Cannot find project root".toString());
        }
        this.projectRoot = object;
        Iterable $this$forEach$iv = files;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile file2 = (VirtualFile)element$iv;
            boolean bl = false;
            if (!VfsUtil.isUnder((VirtualFile)file2, roots)) continue;
            this.processFile(file2);
        }
        this.totalCount = this.fileQueue.size();
    }

    public /* synthetic */ RecursiveProjectFilesIterator(Project project2, Collection collection, Set set, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            function1 = RecursiveProjectFilesIterator::_init_$lambda$0;
        }
        this(project2, collection, set, (Function1<? super VirtualFile, Boolean>)function1);
    }

    @Override
    public int getTotalCount() {
        return this.totalCount;
    }

    private final void processFile(VirtualFile file2) {
        if (file2.isDirectory()) {
            VirtualFile[] virtualFileArray = file2.getChildren();
            if (virtualFileArray != null) {
                VirtualFile[] $this$forEach$iv = virtualFileArray;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    VirtualFile element$iv;
                    VirtualFile child = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)child);
                    this.processFile(child);
                }
            }
        } else if (((Boolean)this.filter.invoke((Object)file2)).booleanValue()) {
            this.fileQueue.add((Object)file2);
        }
    }

    @Override
    public boolean hasNext() {
        return !((Collection)this.fileQueue).isEmpty();
    }

    @Override
    @NotNull
    public Pair<List<String>, String> next() {
        if (!this.hasNext()) {
            return new Pair((Object)CollectionsKt.emptyList(), null);
        }
        int n = this.processedCount;
        this.processedCount = n + 1;
        VirtualFile file2 = (VirtualFile)this.fileQueue.removeFirst();
        boolean $i$f$fileLogger = false;
        boolean $i$f$currentClassLogger = false;
        Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
        Logger logger = Logger.getInstance(clazz$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info(this.processedCount + "/" + this.getTotalCount() + ". Processing file " + file2.getPath());
        try {
            Object $i$f$currentClassLogger22;
            long fileSize = file2.getLength();
            Path path = PathsKt.relativeTo((Path)IJVirtualPathKt.toVirtualPath(file2).getPath(), (Path)this.projectRoot.getPath());
            if (fileSize > 102400L) {
                boolean $i$f$fileLogger2 = false;
                boolean $i$f$currentClassLogger22 = false;
                Class<?> clazz$iv$iv2 = MethodHandles.lookup().lookupClass();
                Logger logger2 = Logger.getInstance(clazz$iv$iv2);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                logger2.warn("File " + file2.getPath() + " is too large (" + fileSize + " bytes), skipping content");
                return new Pair((Object)CollectionsKt.listOf((Object)file2.getPath()), null);
            }
            try {
                byte[] byArray = file2.contentsToByteArray();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"contentsToByteArray(...)");
                $i$f$currentClassLogger22 = byArray;
                $i$f$currentClassLogger22 = new String((byte[])$i$f$currentClassLogger22, Charsets.UTF_8);
            }
            catch (Exception e) {
                boolean $i$f$fileLogger3 = false;
                boolean $i$f$currentClassLogger3 = false;
                Class<?> clazz$iv$iv3 = MethodHandles.lookup().lookupClass();
                Logger logger3 = Logger.getInstance(clazz$iv$iv3);
                Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getInstance(...)");
                logger3.warn("Error reading file " + file2.getPath() + ": " + e.getMessage());
                $i$f$currentClassLogger22 = null;
            }
            Object content2 = $i$f$currentClassLogger22;
            return new Pair((Object)CollectionsKt.listOf((Object)((Object)path).toString()), content2);
        }
        catch (Exception e) {
            boolean $i$f$fileLogger4 = false;
            boolean $i$f$currentClassLogger4 = false;
            Class<?> clazz$iv$iv4 = MethodHandles.lookup().lookupClass();
            Logger logger4 = Logger.getInstance(clazz$iv$iv4);
            Intrinsics.checkNotNullExpressionValue((Object)logger4, (String)"getInstance(...)");
            logger4.warn("Error processing file " + file2.getPath() + ": " + e.getMessage());
            return new Pair((Object)CollectionsKt.listOf((Object)file2.getPath()), null);
        }
    }

    private static final boolean _init_$lambda$0(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/git/selfReview/RecursiveProjectFilesIterator$Companion;", "", "<init>", "()V", "DEFAULT_MAX_BATCH_SIZE_BYTES", "", "intellij.ml.llm.riderNext.latest.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

