/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.ruby;

import com.intellij.execution.filters.Filter;
import com.intellij.ml.llm.errorExplanation.filters.ErrorExplainFilter;
import com.intellij.ml.llm.errorExplanation.filters.ErrorExplainFilterFactory;
import com.intellij.openapi.project.Project;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00122\u00020\u0001:\u0003\u0012\u0013\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007H\u0016J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007H\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0007H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/ruby/RailsStackTraceExplainFilter;", "Lcom/intellij/ml/llm/errorExplanation/filters/ErrorExplainFilter;", "<init>", "()V", "lastLineWasBlank", "", "blankLines", "", "errorType", "Lcom/intellij/ml/llm/ruby/RailsStackTraceExplainFilter$ErrorType;", "isErrorBegin", "line", "", "entireLength", "isErrorEnd", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "entireOffset", "Companion", "ErrorType", "RailsStackTraceExplainFilterFactory", "intellij.ml.llm.ruby"})
public final class RailsStackTraceExplainFilter
extends ErrorExplainFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean lastLineWasBlank;
    private int blankLines;
    @NotNull
    private ErrorType errorType = ErrorType.NORMAL;
    @NotNull
    private static final Pattern exceptionMessagePattern;
    @NotNull
    private static final Pattern causedByRails8Pattern;
    @NotNull
    private static final String CAUSES_RAILS_7_STRING = "Causes:\n";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isErrorBegin(@NotNull String line, int entireLength) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        if (this.getCurrentState() != ErrorExplainFilter.State.NO_EXCEPTION) return false;
        if (!this.lastLineWasBlank) return false;
        Character c = StringsKt.firstOrNull((CharSequence)line);
        if (c == null) return false;
        if (!Character.isUpperCase(c.charValue())) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!exceptionMessagePattern.matcher(line).find()) return false;
        return true;
    }

    public boolean isErrorEnd(@NotNull String line, int entireLength) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return this.getCurrentState() == ErrorExplainFilter.State.COLLECTING && this.blankLines >= this.errorType.getBlankLinesInError();
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireOffset) {
        Filter.Result result2;
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        boolean lineIsBlank = RailsStackTraceExplainFilter.Companion.countsAsBlank(line);
        if (lineIsBlank) {
            int n = this.blankLines;
            this.blankLines = n + 1;
        }
        if ((result2 = super.applyFilter(line, entireOffset)) != null) {
            this.blankLines = 0;
            this.errorType = ErrorType.NORMAL;
        }
        if (this.getCurrentState() == ErrorExplainFilter.State.COLLECTING && this.errorType == ErrorType.NORMAL) {
            if (Intrinsics.areEqual((Object)line, (Object)CAUSES_RAILS_7_STRING)) {
                this.errorType = ErrorType.WITH_CAUSE_RAILS_7;
            } else if (causedByRails8Pattern.matcher(line).find()) {
                this.errorType = ErrorType.WITH_CAUSE_RAILS_8;
            }
        }
        this.lastLineWasBlank = lineIsBlank;
        return result2;
    }

    static {
        Pattern pattern = Pattern.compile("^\\S+ \\(.+\\):?\\n$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        exceptionMessagePattern = pattern;
        Pattern pattern2 = Pattern.compile("^Caused by: \\S+ \\(.+\\)\\n$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(...)");
        causedByRails8Pattern = pattern2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\t\u001a\u00020\n*\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ml/llm/ruby/RailsStackTraceExplainFilter$Companion;", "", "<init>", "()V", "exceptionMessagePattern", "Ljava/util/regex/Pattern;", "causedByRails8Pattern", "CAUSES_RAILS_7_STRING", "", "countsAsBlank", "", "intellij.ml.llm.ruby"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean countsAsBlank(String $this$countsAsBlank) {
            return Intrinsics.areEqual((Object)$this$countsAsBlank, (Object)"\n") || Intrinsics.areEqual((Object)$this$countsAsBlank, (Object)"  \n");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ml/llm/ruby/RailsStackTraceExplainFilter$ErrorType;", "", "blankLinesInError", "", "<init>", "(Ljava/lang/String;II)V", "getBlankLinesInError", "()I", "NORMAL", "WITH_CAUSE_RAILS_7", "WITH_CAUSE_RAILS_8", "intellij.ml.llm.ruby"})
    public static final class ErrorType
    extends Enum<ErrorType> {
        private final int blankLinesInError;
        public static final /* enum */ ErrorType NORMAL = new ErrorType(2);
        public static final /* enum */ ErrorType WITH_CAUSE_RAILS_7 = new ErrorType(3);
        public static final /* enum */ ErrorType WITH_CAUSE_RAILS_8 = new ErrorType(5);
        private static final /* synthetic */ ErrorType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ErrorType(int blankLinesInError) {
            this.blankLinesInError = blankLinesInError;
        }

        public final int getBlankLinesInError() {
            return this.blankLinesInError;
        }

        public static ErrorType[] values() {
            return (ErrorType[])$VALUES.clone();
        }

        public static ErrorType valueOf(String value) {
            return Enum.valueOf(ErrorType.class, value);
        }

        @NotNull
        public static EnumEntries<ErrorType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = errorTypeArray = new ErrorType[]{ErrorType.NORMAL, ErrorType.WITH_CAUSE_RAILS_7, ErrorType.WITH_CAUSE_RAILS_8};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/ruby/RailsStackTraceExplainFilter$RailsStackTraceExplainFilterFactory;", "Lcom/intellij/ml/llm/errorExplanation/filters/ErrorExplainFilterFactory;", "<init>", "()V", "createErrorExplainFilter", "Lcom/intellij/ml/llm/errorExplanation/filters/ErrorExplainFilter;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.ml.llm.ruby"})
    public static final class RailsStackTraceExplainFilterFactory
    extends ErrorExplainFilterFactory {
        @NotNull
        public ErrorExplainFilter createErrorExplainFilter(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            return new RailsStackTraceExplainFilter();
        }
    }
}

