/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.sql.chatInputLanguage;

import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.ml.llm.sql.UtilsKt;
import com.intellij.ml.llm.sql.chat.context.SqlObjectContext;
import com.intellij.ml.llm.sql.chatInputLanguage.SqlObjectCoord;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.sql.dialects.SqlLanguageDialect;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0002\u001a\"\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0011*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u001a \u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\" \u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"SQL_OBJECT_REFERENCE_TYPE", "", "SQL_SCHEMA_REFERENCE_TYPE", "SQL_OBJECT_REFERENCE_PREFIX", "SEPARATOR", "", "MENTIONED_SQL_OBJECTS_KEY", "Lcom/intellij/openapi/util/Key;", "", "Lcom/intellij/ml/llm/sql/chat/context/SqlObjectContext;", "getMENTIONED_SQL_OBJECTS_KEY", "()Lcom/intellij/openapi/util/Key;", "addMentionedObject", "", "Lcom/intellij/openapi/util/UserDataHolder;", "obj", "resolve", "Lkotlin/Pair;", "Lcom/intellij/database/psi/DbDataSource;", "Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/ml/llm/sql/chatInputLanguage/SqlObjectCoord;", "project", "Lcom/intellij/openapi/project/Project;", "objectToRef", "dataSourceId", "Lcom/intellij/database/model/DasObject;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "intellij.ml.llm.sql"})
public final class SqlObjectChatInputReferenceKt {
    @NotNull
    public static final String SQL_OBJECT_REFERENCE_TYPE = "dbObject";
    @NotNull
    public static final String SQL_SCHEMA_REFERENCE_TYPE = "schema";
    @NotNull
    public static final String SQL_OBJECT_REFERENCE_PREFIX = "#dbObject:";
    private static final char SEPARATOR = '/';
    @NotNull
    private static final Key<List<SqlObjectContext>> MENTIONED_SQL_OBJECTS_KEY;

    @NotNull
    public static final Key<List<SqlObjectContext>> getMENTIONED_SQL_OBJECTS_KEY() {
        return MENTIONED_SQL_OBJECTS_KEY;
    }

    private static final void addMentionedObject(UserDataHolder $this$addMentionedObject, SqlObjectContext obj) {
        List mentioned;
        List list = mentioned = (List)$this$addMentionedObject.getUserData(MENTIONED_SQL_OBJECTS_KEY);
        List updated = list == null ? CollectionsKt.listOf((Object)obj) : CollectionsKt.plus((Collection)list, (Object)obj);
        $this$addMentionedObject.putUserData(MENTIONED_SQL_OBJECTS_KEY, (Object)updated);
    }

    @Nullable
    public static final Pair<DbDataSource, BasicElement> resolve(@NotNull SqlObjectCoord $this$resolve, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)$this$resolve, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        String dataSourceId = $this$resolve.component1();
        ObjectPath path = $this$resolve.component2();
        DbDataSource dbDataSource = UtilsKt.findDataSource(project2, dataSourceId);
        if (dbDataSource == null) {
            return null;
        }
        DbDataSource dataSource = dbDataSource;
        DbElement dbElement = dataSource.findElement(path);
        Object object = dbElement != null ? dbElement.getDelegate() : null;
        BasicElement basicElement = object instanceof BasicElement ? (BasicElement)object : null;
        if (basicElement == null) {
            return null;
        }
        BasicElement obj = basicElement;
        return TuplesKt.to((Object)dataSource, (Object)obj);
    }

    @NotNull
    public static final String objectToRef(@NotNull String dataSourceId, @NotNull DasObject obj, @NotNull SqlLanguageDialect dialect) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)dataSourceId, (String)"dataSourceId");
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        DasObject o = DbUtil.getDasObject((Object)obj);
        CasingProvider normalizer = o instanceof BasicElement ? (CasingProvider)((BasicElement)o).getModel() : (CasingProvider)dialect;
        ObjectPath path = ObjectPaths.of((DasObject)obj, (CasingProvider)normalizer);
        StringBuilder $this$objectToRef_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$objectToRef_u24lambda_u240.append(dataSourceId);
        $this$objectToRef_u24lambda_u240.append('/');
        $this$objectToRef_u24lambda_u240.append(path.serialize());
        return stringBuilder.toString();
    }

    public static final /* synthetic */ void access$addMentionedObject(UserDataHolder $receiver, SqlObjectContext obj) {
        SqlObjectChatInputReferenceKt.addMentionedObject($receiver, obj);
    }

    static {
        Key key = Key.create((String)"CHAT_MENTIONED_SQL_OBJECTS");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        MENTIONED_SQL_OBJECTS_KEY = key;
    }
}

