/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.sql.console;

import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.connection.throwable.info.RuntimeErrorActionProvider;
import com.intellij.database.dialects.BaseDatabaseErrorHandler;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.sql.SqlLLMBundle;
import com.intellij.ml.llm.sql.console.LLMFixErrorActionProvider;
import com.intellij.ml.llm.sql.inspections.SqlFixProblemIntentionBase;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiFile;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/sql/console/LLMFixErrorActionProvider;", "Lcom/intellij/database/connection/throwable/info/RuntimeErrorActionProvider;", "<init>", "()V", "createAction", "Lcom/intellij/database/connection/throwable/info/ErrorInfo$Fix;", "error", "Lcom/intellij/database/connection/throwable/info/ErrorInfo;", "intellij.ml.llm.sql"})
public final class LLMFixErrorActionProvider
implements RuntimeErrorActionProvider {
    @Nullable
    public ErrorInfo.Fix createAction(@NotNull ErrorInfo error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        if (error instanceof BaseDatabaseErrorHandler.IOErrorInfo) {
            return null;
        }
        return new ErrorInfo.Fix(error){
            final /* synthetic */ ErrorInfo $error;
            {
                this.$error = $error;
            }

            public String getName() {
                return SqlLLMBundle.message("fix.error.action.text", new Object[0]);
            }

            public void apply(DataContext dataContext2) {
                Intrinsics.checkNotNullParameter((Object)dataContext2, (String)"dataContext");
                Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
                if (project2 == null) {
                    return;
                }
                Project project3 = project2;
                VirtualFile virtualFile2 = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext2);
                if (virtualFile2 == null) {
                    return;
                }
                VirtualFile virtualFile3 = virtualFile2;
                ConsoleDataRequest request2 = (ConsoleDataRequest)ConsoleDataRequest.CONSOLE_DATA_REQUEST.getData(dataContext2);
                Document document2 = VirtualFileUtil.findDocument((VirtualFile)virtualFile3);
                if (document2 == null) {
                    return;
                }
                Document document3 = document2;
                ConsoleDataRequest consoleDataRequest = request2;
                if (consoleDataRequest == null || (consoleDataRequest = consoleDataRequest.getEditor()) == null) {
                    Optional<T> optional = EditorFactory.getInstance().editors(document3).findFirst();
                    Intrinsics.checkNotNullExpressionValue(optional, (String)"findFirst(...)");
                    consoleDataRequest = (Editor)OptionalsKt.getOrNull(optional);
                    if (consoleDataRequest == null) {
                        return;
                    }
                }
                ConsoleDataRequest editor2 = consoleDataRequest;
                ConsoleDataRequest consoleDataRequest2 = request2;
                if (consoleDataRequest2 == null || (consoleDataRequest2 = consoleDataRequest2.getRange()) == null) {
                    consoleDataRequest2 = new TextRange(0, document3.getTextLength());
                }
                ConsoleDataRequest range = consoleDataRequest2;
                SqlFixProblemIntentionBase action2 = new SqlFixProblemIntentionBase(this, this.$error, (TextRange)range, document3, project3){
                    final /* synthetic */ createAction.1 this$0;
                    final /* synthetic */ ErrorInfo $error;
                    final /* synthetic */ TextRange $range;
                    final /* synthetic */ Document $document;
                    final /* synthetic */ Project $project;
                    {
                        this.this$0 = $receiver;
                        this.$error = $error;
                        this.$range = $range;
                        this.$document = $document;
                        this.$project = $project;
                    }

                    public String getFamilyName() {
                        return this.this$0.getName();
                    }

                    protected PSString getErrorDescription() {
                        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{com.intellij.ml.llm.sql.privacy.extensions.ExtensionsKtKt.getPrivacySafe(this.$error).getMessage()};
                        return ConstantsKt.getPrivacyConst((String)"\"%s\"").format(pSStringConvertibleArray);
                    }

                    protected TextRange getCodeRange() {
                        return this.$range;
                    }

                    protected Object getCodeToFix(Continuation<? super PSString> $completion) {
                        return ExtensionsKtKt.privacySafe(this.$document, this.$project).getText(this.$range);
                    }
                };
                ConsoleDataRequest consoleDataRequest3 = request2;
                if (consoleDataRequest3 == null || (consoleDataRequest3 = consoleDataRequest3.getConsole()) == null || (consoleDataRequest3 = consoleDataRequest3.getFile()) == null) {
                    consoleDataRequest3 = VirtualFileUtil.findPsiFile((VirtualFile)virtualFile3, (Project)project3);
                }
                ConsoleDataRequest psiFile = consoleDataRequest3;
                action2.invoke(project3, (Editor)editor2, (PsiFile)psiFile);
            }
        };
    }
}

