/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.sql.formatting;

import it.unimi.dsi.fastutil.ints.IntImmutableList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public enum SqlAiStatementCategory {
    SQC_ANY(0),
    SQC_SELECT(1),
    SQC_CREATE_VIEW(2),
    SQC_SOURCE_AWARE(3),
    SQC_INSERT(4),
    SQC_UPDATE_DELETE(5),
    SQC_CREATE_TABLE(6),
    SQC_OTHER_DDL(7);

    private static final int[][] distanceMatrix;
    private final int index;

    private SqlAiStatementCategory(int index) {
        this.index = index;
    }

    @NotNull
    public IntImmutableList getDistances() {
        return new IntImmutableList(distanceMatrix[this.index]);
    }

    public int distanceTo(@NotNull SqlAiStatementCategory anotherCategory) {
        if (anotherCategory == null) {
            SqlAiStatementCategory.$$$reportNull$$$0(0);
        }
        if (anotherCategory == this) {
            return 0;
        }
        int anotherIndex = anotherCategory.index;
        if (anotherIndex < 0 || anotherIndex >= distanceMatrix.length) {
            return Integer.MAX_VALUE;
        }
        return distanceMatrix[this.index][anotherIndex];
    }

    @TestOnly
    public static int[][] getDistanceMatrix() {
        return distanceMatrix;
    }

    static {
        distanceMatrix = new int[][]{{0, 9, 9, 7, 9, 9, 9, 7}, {9, 0, 1, 2, 3, 4, 8, 9}, {9, 1, 0, 2, 8, 9, 1, 1}, {7, 6, 3, 0, 2, 1, 5, 4}, {7, 3, 5, 6, 0, 1, 2, 4}, {7, 3, 5, 6, 1, 0, 2, 4}, {9, 8, 2, 7, 3, 4, 0, 1}, {7, 6, 2, 3, 5, 4, 1, 0}};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anotherCategory", "com/intellij/ml/llm/sql/formatting/SqlAiStatementCategory", "distanceTo"));
    }
}

