/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.tokenizer;

import ai.grazie.model.llm.profile.LLMProfileID;
import com.intellij.ml.llm.tokenizer.TokenQuota;
import com.intellij.openapi.util.registry.Registry;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/tokenizer/ExperimentalTokenQuota;", "", "<init>", "()V", "getChatHardTokenLimit", "", "model", "Lai/grazie/model/llm/profile/LLMProfileID;", "getChatSoftTokenLimit", "calculateHardAndSoftLimitRatio", "getPlatformHardTokenLimit", "getPlatformSoftTokenLimit", "intellij.ml.llm.tokenizer"})
@ApiStatus.Experimental
public final class ExperimentalTokenQuota {
    @NotNull
    public static final ExperimentalTokenQuota INSTANCE = new ExperimentalTokenQuota();

    private ExperimentalTokenQuota() {
    }

    public final int getChatHardTokenLimit(@NotNull LLMProfileID model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        int userDefinedLimit = Registry.Companion.intValue("llm.chat.long.limit", 0);
        int modelTokenHardLimit = this.getPlatformHardTokenLimit(model);
        return userDefinedLimit != 0 ? Math.min(modelTokenHardLimit, userDefinedLimit) : modelTokenHardLimit;
    }

    public final int getChatSoftTokenLimit(@NotNull LLMProfileID model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        int userDefinedLimit = Registry.Companion.intValue("llm.chat.long.limit", 0);
        int platformSoftTokenLimit = this.getPlatformSoftTokenLimit(model);
        int userSoftTokenLimit = this.getChatHardTokenLimit(model) / this.calculateHardAndSoftLimitRatio(model);
        return userDefinedLimit != 0 ? Math.min(platformSoftTokenLimit, userSoftTokenLimit) : platformSoftTokenLimit;
    }

    private final int calculateHardAndSoftLimitRatio(LLMProfileID model) {
        return this.getPlatformHardTokenLimit(model) / this.getPlatformSoftTokenLimit(model);
    }

    private final int getPlatformHardTokenLimit(LLMProfileID model) {
        LLMProfileID lLMProfileID = model;
        return TokenQuota.INSTANCE.getMODELS_WITH_EXPERIMENTAL_MULTIPLIER().contains(lLMProfileID) ? TokenQuota.INSTANCE.getHardTokenLimit(model) * TokenQuota.INSTANCE.getExperimentalHardLimitMultiplyer() : TokenQuota.INSTANCE.getHardTokenLimit(model);
    }

    private final int getPlatformSoftTokenLimit(LLMProfileID model) {
        LLMProfileID lLMProfileID = model;
        return TokenQuota.INSTANCE.getMODELS_WITH_EXPERIMENTAL_MULTIPLIER().contains(lLMProfileID) ? TokenQuota.INSTANCE.getMessageSoftTokenLimit(model) * TokenQuota.INSTANCE.getExperimentalSoftLimitMultiplyer() : TokenQuota.INSTANCE.getMessageSoftTokenLimit(model);
    }
}

