/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.vcs.diff.groupedDiff.actions;

import com.intellij.ml.llm.core.settings.LLMDataSharingManager;
import com.intellij.ml.llm.util.ApplicationUtilKt;
import com.intellij.ml.llm.vcs.diff.groupedDiff.AIDiffGlobalSettings;
import com.intellij.ml.llm.vcs.diff.groupedDiff.AIDiffService;
import com.intellij.ml.llm.vcs.diff.groupedDiff.LLMVcsDiffBundle;
import com.intellij.ml.llm.vcs.diff.groupedDiff.collector.GroupedDiffRating;
import com.intellij.ml.llm.vcs.diff.groupedDiff.llmRequest.GroupedDiffData;
import com.intellij.ml.llm.vcs.diff.groupedDiff.ui.GroupedDiffRatingDialog;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.ui.GotItTooltip;
import com.intellij.ui.ToolbarActionTracker;
import com.intellij.util.ApplicationKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H&J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H&J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0019\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ml/llm/vcs/diff/groupedDiff/actions/AIDiffRateAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "rating", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/collector/GroupedDiffRating;", "<init>", "(Lcom/intellij/ml/llm/vcs/diff/groupedDiff/collector/GroupedDiffRating;)V", "getRating", "()Lcom/intellij/ml/llm/vcs/diff/groupedDiff/collector/GroupedDiffRating;", "setSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "state", "", "getService", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/AIDiffService;", "project", "Lcom/intellij/openapi/project/Project;", "isToggleOn", "isSelected", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "shouldShowGotIt", "installGotIt", "intellij.ml.llm.vcs.diff"})
public abstract class AIDiffRateAction
extends ToggleAction
implements DumbAware {
    @NotNull
    private final GroupedDiffRating rating;

    public AIDiffRateAction(@NotNull GroupedDiffRating rating) {
        Intrinsics.checkNotNullParameter((Object)((Object)rating), (String)"rating");
        this.rating = rating;
    }

    @NotNull
    public final GroupedDiffRating getRating() {
        return this.rating;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state2) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        AIDiffService splitService = this.getService(project3);
        GroupedDiffData groupedDiffData = splitService.getLastResult();
        if (groupedDiffData == null) {
            return;
        }
        GroupedDiffData data2 = groupedDiffData;
        GroupedDiffRating newRating = state2 ? this.rating : GroupedDiffRating.NEED_IMPROVEMENTS;
        splitService.setRating(newRating);
        GroupedDiffRatingDialog dialog2 = new GroupedDiffRatingDialog(project3, data2, newRating);
        dialog2.show(e);
    }

    @NotNull
    public abstract AIDiffService getService(@NotNull Project var1);

    public abstract boolean isToggleOn(@NotNull Project var1);

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            return false;
        }
        Project project3 = project2;
        AIDiffService splitService = this.getService(project3);
        GroupedDiffRating groupedDiffRating = splitService.getRating();
        if (groupedDiffRating == null) {
            return false;
        }
        GroupedDiffRating current = groupedDiffRating;
        return current == this.rating;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        boolean featureEnabled;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        boolean bl = featureEnabled = project2 != null && AIDiffGlobalSettings.Companion.getInstance().isEnabled() && !Intrinsics.areEqual((Object)Registry.Companion.get("llm.grouped.diff.show.likes").getSelectedOption(), (Object)"Hide");
        if (!featureEnabled) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        AIDiffService splitService = this.getService(project2);
        boolean toggleOn = this.isToggleOn(project2);
        boolean upToDate = splitService.serviceIsUpToDate();
        e.getPresentation().setEnabledAndVisible(splitService.getLastResult() != null && upToDate && toggleOn && splitService.hasAiChangeLists() && !splitService.serviceIsBusy());
        super.update(e);
    }

    public final boolean shouldShowGotIt(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            return false;
        }
        Project project3 = project2;
        if (!Intrinsics.areEqual((Object)Registry.Companion.get("llm.grouped.diff.show.likes").getSelectedOption(), (Object)"ShowAndRemind")) {
            return false;
        }
        AIDiffService splitService = this.getService(project3);
        return e.getPresentation().isEnabledAndVisible() && splitService.shouldShowFeedbackReminder() && LLMDataSharingManager.Companion.isDataSharingEnabled() && ApplicationUtilKt.isNightly((Application)ApplicationKt.getApplication());
    }

    public final void installGotIt(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!this.shouldShowGotIt(e)) {
            e.getPresentation().putClientProperty(ToolbarActionTracker.Companion.getPRESENTATION_GOT_IT_KEY(), null);
            return;
        }
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"getPresentation(...)");
        Presentation presentation3 = presentation2;
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project3);
        ToolWindowManagerImpl toolWindowManagerImpl = toolWindowManager instanceof ToolWindowManagerImpl ? (ToolWindowManagerImpl)toolWindowManager : null;
        if (toolWindowManagerImpl == null) {
            return;
        }
        ToolWindowManagerImpl manager = toolWindowManagerImpl;
        ToolWindow toolWindow = manager.getToolWindow("Commit");
        if (toolWindow == null) {
            return;
        }
        ToolWindow toolWindow2 = toolWindow;
        GotItTooltip tooltip = new GotItTooltip("grouped.diff.rating", LLMVcsDiffBundle.message("feedback.gotit.text", new Object[0]), null, 4, null).withShowCount(100000);
        tooltip.assignTo(presentation3, GotItTooltip.BOTTOM_MIDDLE);
        Disposer.register((Disposable)toolWindow2.getDisposable(), (Disposable)((Disposable)tooltip));
    }
}

