/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.vcs.diff.groupedDiff.collector;

import com.intellij.ml.llm.vcs.diff.groupedDiff.collector.GroupedDiffFusCollector;
import com.intellij.ml.llm.vcs.diff.groupedDiff.commit.AIChangeListsGroupedDiffData;
import com.intellij.ml.llm.vcs.diff.groupedDiff.commit.AIDiffSplitService;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0012\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0012\u0010\u000f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/vcs/diff/groupedDiff/collector/GroupedDiffCommitHandler;", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler;", "Lcom/intellij/openapi/project/DumbAware;", "panel", "Lcom/intellij/openapi/vcs/CheckinProjectPanel;", "commitContext", "Lcom/intellij/openapi/vcs/changes/CommitContext;", "<init>", "(Lcom/intellij/openapi/vcs/CheckinProjectPanel;Lcom/intellij/openapi/vcs/changes/CommitContext;)V", "id", "", "Ljava/lang/Long;", "fileNumber", "", "Ljava/lang/Integer;", "changeListCount", "percentExcluded", "", "Ljava/lang/Double;", "beforeCheckin", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler$ReturnResult;", "checkinSuccessful", "", "intellij.ml.llm.vcs.diff"})
final class GroupedDiffCommitHandler
extends CheckinHandler
implements DumbAware {
    @NotNull
    private final CheckinProjectPanel panel;
    @NotNull
    private final CommitContext commitContext;
    @Nullable
    private Long id;
    @Nullable
    private Integer fileNumber;
    @Nullable
    private Integer changeListCount;
    @Nullable
    private Double percentExcluded;

    public GroupedDiffCommitHandler(@NotNull CheckinProjectPanel panel2, @NotNull CommitContext commitContext) {
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        Intrinsics.checkNotNullParameter((Object)commitContext, (String)"commitContext");
        this.panel = panel2;
        this.commitContext = commitContext;
    }

    @Nullable
    public CheckinHandler.ReturnResult beforeCheckin() {
        CheckinHandler.ReturnResult result2 = super.beforeCheckin();
        this.id = null;
        Collection selectedChanges = this.panel.getSelectedChanges();
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.panel.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
        ChangeListManager changeListManager2 = changeListManager;
        Project project2 = this.panel.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        AIDiffSplitService aiDiffSplitService = AIDiffSplitService.Companion.getInstance(project2);
        AIChangeListsGroupedDiffData aIChangeListsGroupedDiffData = aiDiffSplitService.getAiChangeListsGroupedData();
        if (aIChangeListsGroupedDiffData == null) {
            return result2;
        }
        AIChangeListsGroupedDiffData aiChangeListsGroupedData = aIChangeListsGroupedDiffData;
        MultiMap multimap = new MultiMap();
        for (Change change : selectedChanges) {
            if (!(change instanceof ChangeListChange) || !aiChangeListsGroupedData.getGroups().containsKey(((ChangeListChange)change).getChangeListId())) continue;
            multimap.putValue((Object)((ChangeListChange)change).getChangeListId(), (Object)change);
        }
        int changeListCount = multimap.size();
        if (changeListCount == 0) {
            return result2;
        }
        double percentExcluded = 0.0;
        for (String changeListId : multimap.keySet()) {
            LocalChangeList changeList;
            if (changeListManager2.getChangeList(changeListId) == null || changeList.isDefault()) continue;
            percentExcluded += 1.0 - (double)multimap.get((Object)changeListId).size() / (double)changeList.getChanges().size();
        }
        double avgPercentExcluded = Math.rint(percentExcluded / (double)changeListCount * (double)100);
        this.id = aiChangeListsGroupedData.getId();
        this.fileNumber = selectedChanges.size();
        this.changeListCount = changeListCount;
        this.percentExcluded = avgPercentExcluded;
        return result2;
    }

    public void checkinSuccessful() {
        Long l = this.id;
        if (l == null) {
            return;
        }
        long id = l;
        Integer n = this.fileNumber;
        if (n == null) {
            return;
        }
        int fileNumber = n;
        Integer n2 = this.changeListCount;
        if (n2 == null) {
            return;
        }
        int changeListCount = n2;
        Double d = this.percentExcluded;
        if (d == null) {
            return;
        }
        double percentExcluded = d;
        GroupedDiffFusCollector.INSTANCE.logCommitWithAIDiff(id, fileNumber, changeListCount, (int)percentExcluded);
    }
}

