/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.vcs.diff.groupedDiff.toolWindow;

import com.intellij.ml.llm.vcs.diff.groupedDiff.ChangesGroup;
import com.intellij.ml.llm.vcs.diff.groupedDiff.DiffIcons;
import com.intellij.ml.llm.vcs.diff.groupedDiff.FileChangeSubset;
import com.intellij.ml.llm.vcs.diff.groupedDiff.LLMVcsDiffBundle;
import com.intellij.ml.llm.vcs.diff.groupedDiff.toolWindow.ChangedFileInGroup;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.issueLinks.TreeLinkMouseListener;
import com.intellij.openapi.vcs.changes.ui.AbstractChangesBrowserFilePathNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0014J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000fH\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/vcs/diff/groupedDiff/toolWindow/ChangedFileInGroupBrowserNode;", "Lcom/intellij/openapi/vcs/changes/ui/AbstractChangesBrowserFilePathNode;", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/toolWindow/ChangedFileInGroup;", "Lcom/intellij/openapi/vcs/changes/issueLinks/TreeLinkMouseListener$HaveTooltip;", "file", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/FileChangeSubset;", "group", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/ChangesGroup;", "<init>", "(Lcom/intellij/ml/llm/vcs/diff/groupedDiff/FileChangeSubset;Lcom/intellij/ml/llm/vcs/diff/groupedDiff/ChangesGroup;)V", "getFile", "()Lcom/intellij/ml/llm/vcs/diff/groupedDiff/FileChangeSubset;", "getTooltip", "", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "userObject", "originPath", "getSortWeight", "", "setIcon", "", "renderer", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeRenderer;", "path", "intellij.ml.llm.vcs.diff"})
public final class ChangedFileInGroupBrowserNode
extends AbstractChangesBrowserFilePathNode<ChangedFileInGroup>
implements TreeLinkMouseListener.HaveTooltip {
    @NotNull
    private final FileChangeSubset file;

    public ChangedFileInGroupBrowserNode(@NotNull FileChangeSubset file2, @NotNull ChangesGroup group) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        super((Object)new ChangedFileInGroup(file2, group), file2.getChange().getFileStatus());
        this.file = file2;
    }

    @NotNull
    public final FileChangeSubset getFile() {
        return this.file;
    }

    @NotNull
    public String getTooltip() {
        return ((ChangedFileInGroup)this.getUserObject()).getFile().getSummary();
    }

    @NotNull
    protected FilePath filePath(@NotNull ChangedFileInGroup userObject) {
        Intrinsics.checkNotNullParameter((Object)userObject, (String)"userObject");
        return userObject.getFilePath();
    }

    @Nullable
    protected FilePath originPath(@NotNull ChangedFileInGroup userObject) {
        Intrinsics.checkNotNullParameter((Object)userObject, (String)"userObject");
        ContentRevision contentRevision = userObject.getFile().getChange().getBeforeRevision();
        return contentRevision != null ? contentRevision.getFile() : null;
    }

    public int getSortWeight() {
        return MathKt.roundToInt((double)(-this.file.getImportance() * (double)1000));
    }

    protected void setIcon(@NotNull ChangesBrowserNodeRenderer renderer2, @NotNull FilePath path) {
        Intrinsics.checkNotNullParameter((Object)renderer2, (String)"renderer");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (this.file.getChanges() == null) {
            renderer2.setIcon(DiffIcons.State.INSTANCE.getLoader());
            renderer2.setToolTipText(LLMVcsDiffBundle.message("grouped.diff.split.in.groups", new Object[0]));
        } else {
            super.setIcon(renderer2, path);
        }
    }
}

