/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.vcs.diff.groupedDiff.toolWindow;

import com.intellij.ml.llm.vcs.diff.groupedDiff.ChangesGroup;
import com.intellij.ml.llm.vcs.diff.groupedDiff.FileChangeSubset;
import com.intellij.ml.llm.vcs.diff.groupedDiff.GroupedRange;
import com.intellij.ml.llm.vcs.diff.groupedDiff.LLMVcsDiffBundle;
import com.intellij.ml.llm.vcs.diff.groupedDiff.llmRequest.GroupedDiffData;
import com.intellij.ml.llm.vcs.diff.groupedDiff.llmRequest.StateTracer;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.ui.components.JBScrollPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0014J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/vcs/diff/groupedDiff/toolWindow/DebugDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "data", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/GroupedDiffData;", "<init>", "(Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/GroupedDiffData;)V", "getData", "()Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/GroupedDiffData;", "textArea", "Ljavax/swing/JTextArea;", "createCenterPanel", "Ljavax/swing/JComponent;", "formatGroupsDebugInfo", "", "groups", "", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/ChangesGroup;", "intellij.ml.llm.vcs.diff"})
@SourceDebugExtension(value={"SMAP\nDebugDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugDialog.kt\ncom/intellij/ml/llm/vcs/diff/groupedDiff/toolWindow/DebugDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,121:1\n1878#2,2:122\n1878#2,2:124\n1878#2,3:126\n1880#2:129\n1880#2:130\n*S KotlinDebug\n*F\n+ 1 DebugDialog.kt\ncom/intellij/ml/llm/vcs/diff/groupedDiff/toolWindow/DebugDialog\n*L\n35#1:122,2\n43#1:124,2\n53#1:126,3\n43#1:129\n35#1:130\n*E\n"})
final class DebugDialog
extends DialogWrapper {
    @NotNull
    private final GroupedDiffData data;
    @NotNull
    private final JTextArea textArea;

    public DebugDialog(@NotNull GroupedDiffData data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        super(data2.getProject());
        this.data = data2;
        this.textArea = new JTextArea();
        this.setTitle(LLMVcsDiffBundle.message("dialog.title.debug.changesgroup.contents", new Object[0]));
        this.textArea.setText(this.formatGroupsDebugInfo(this.data.getGroups()));
        this.textArea.setEditable(false);
        this.textArea.setFont(new Font("Monospaced", 0, 12));
        this.init();
    }

    @NotNull
    public final GroupedDiffData getData() {
        return this.data;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JBScrollPane scrollPane = new JBScrollPane((Component)this.textArea);
        scrollPane.setPreferredSize(new Dimension(800, 600));
        return (JComponent)scrollPane;
    }

    /*
     * WARNING - void declaration
     */
    private final String formatGroupsDebugInfo(List<ChangesGroup> groups) {
        StringBuilder sb;
        StringBuilder stringBuilder = sb = new StringBuilder();
        StateTracer stateTracer = this.data.getTracer();
        stringBuilder.append(stateTracer != null ? stateTracer.getTracesAsString() : null).append('\n');
        Iterable $this$forEachIndexed$iv = groups;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void group;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ChangesGroup changesGroup = (ChangesGroup)item$iv;
            int groupIndex = n;
            boolean bl = false;
            sb.append("=== GROUP " + (groupIndex + 1) + " ===").append('\n');
            sb.append("ID: " + group.getId()).append('\n');
            sb.append("Name: " + group.getName()).append('\n');
            sb.append("Description: " + group.getDescription()).append('\n');
            sb.append("Importance: " + group.getImportance()).append('\n');
            sb.append('\n');
            Iterable $this$forEachIndexed$iv2 = group.getFiles();
            boolean $i$f$forEachIndexed2 = false;
            int index$iv2 = 0;
            for (Object item$iv2 : $this$forEachIndexed$iv2) {
                Object object;
                Object beforeFile;
                void fileSubset;
                int n2;
                if ((n2 = index$iv2++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                FileChangeSubset fileChangeSubset = (FileChangeSubset)item$iv2;
                int fileIndex = n2;
                boolean bl2 = false;
                sb.append("--- FILE " + (fileIndex + 1) + " ---").append('\n');
                Object object2 = fileSubset.getChange().getBeforeRevision();
                if (object2 == null || (object2 = object2.getFile()) == null || (object2 = object2.getPath()) == null) {
                    object2 = beforeFile = "null";
                }
                if ((object = fileSubset.getChange().getAfterRevision()) == null || (object = object.getFile()) == null || (object = object.getPath()) == null) {
                    object = "null";
                }
                Object afterFile = object;
                sb.append("Before: " + (String)beforeFile).append('\n');
                sb.append("After: " + (String)afterFile).append('\n');
                sb.append('\n');
                List<GroupedRange> list = fileSubset.getChanges();
                if (list != null) {
                    Iterable $this$forEachIndexed$iv3 = list;
                    boolean $i$f$forEachIndexed3 = false;
                    int index$iv3 = 0;
                    for (Object item$iv3 : $this$forEachIndexed$iv3) {
                        block22: {
                            int lineNum;
                            String prefix;
                            int i;
                            int endLine;
                            int startLine22;
                            void range;
                            block21: {
                                int n3;
                                if ((n3 = index$iv3++) < 0) {
                                    CollectionsKt.throwIndexOverflow();
                                }
                                GroupedRange groupedRange = (GroupedRange)item$iv3;
                                int rangeIndex = n3;
                                boolean bl3 = false;
                                sb.append("Range " + (rangeIndex + 1) + ":").append('\n');
                                sb.append("  line1: " + range.getAfterLine1() + ", line2: " + range.getAfterLine2()).append('\n');
                                sb.append("  vcsLine1: " + range.getBeforeLine1() + ", vcsLine2: " + range.getBeforeLine2()).append('\n');
                                sb.append("  groupId: " + range.getGroupId()).append('\n');
                                try {
                                    String beforeContent;
                                    ContentRevision contentRevision = fileSubset.getChange().getBeforeRevision();
                                    String string = beforeContent = contentRevision != null ? contentRevision.getContent() : null;
                                    if (beforeContent != null) {
                                        char[] cArray = new char[]{'\n'};
                                        List beforeLines = StringsKt.split$default((CharSequence)beforeContent, (char[])cArray, (boolean)false, (int)0, (int)6, null);
                                        sb.append("  Lines BEFORE:").append('\n');
                                        startLine22 = Math.max(0, range.getBeforeLine1());
                                        endLine = Math.min(beforeLines.size() - 1, range.getBeforeLine2() - 1);
                                        i = startLine22;
                                        if (i > endLine) break block21;
                                        while (true) {
                                            prefix = "  ";
                                            lineNum = i + 1;
                                            if (i < beforeLines.size()) {
                                                sb.append(prefix + lineNum + ": " + beforeLines.get(i)).append('\n');
                                            }
                                            if (i != endLine) {
                                                ++i;
                                                continue;
                                            }
                                            break block21;
                                            break;
                                        }
                                    }
                                    sb.append("  Lines BEFORE: (no content)").append('\n');
                                }
                                catch (VcsException e) {
                                    sb.append("  Lines BEFORE: (error: " + e.getMessage() + ")").append('\n');
                                }
                            }
                            try {
                                String afterContent;
                                ContentRevision contentRevision = fileSubset.getChange().getAfterRevision();
                                String string = afterContent = contentRevision != null ? contentRevision.getContent() : null;
                                if (afterContent != null) {
                                    char[] startLine22 = new char[]{'\n'};
                                    List afterLines = StringsKt.split$default((CharSequence)afterContent, (char[])startLine22, (boolean)false, (int)0, (int)6, null);
                                    sb.append("  Lines AFTER:").append('\n');
                                    startLine22 = Math.max(0, range.getAfterLine1());
                                    endLine = Math.min(afterLines.size() - 1, range.getAfterLine2() - 1);
                                    i = startLine22;
                                    if (i > endLine) break block22;
                                    while (true) {
                                        prefix = "  ";
                                        lineNum = i + 1;
                                        if (i < afterLines.size()) {
                                            sb.append(prefix + lineNum + ": " + afterLines.get(i)).append('\n');
                                        }
                                        if (i != endLine) {
                                            ++i;
                                            continue;
                                        }
                                        break block22;
                                        break;
                                    }
                                }
                                sb.append("  Lines AFTER: (no content)").append('\n');
                            }
                            catch (VcsException e) {
                                sb.append("  Lines AFTER: (error: " + e.getMessage() + ")").append('\n');
                            }
                        }
                        sb.append('\n');
                    }
                }
                sb.append('\n');
            }
            sb.append('\n');
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

