/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.vcs.metrics;

import com.intellij.ml.llm.core.statistics.metrics.CommitMessageChrF;
import com.intellij.ml.llm.core.statistics.metrics.CommitMessageEditDistance;
import com.intellij.ml.llm.core.statistics.metrics.CommitMessageLengthDiff;
import com.intellij.ml.llm.vcs.metrics.CMGMetricsState;
import com.intellij.ml.llm.vcs.metrics.CMGMetricsStateTracker;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u001c\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\u001c\u0010\u0013\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/vcs/metrics/CMGMetricsManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "stateTracker", "Lcom/intellij/ml/llm/vcs/metrics/CMGMetricsStateTracker;", "checkInputValid", "", "generatedMessage", "", "submittedMessage", "calculateMetrics", "initCalculation", "", "initialChanges", "", "Lcom/intellij/openapi/vcs/changes/Change;", "finishCalculation", "actualChanges", "Companion", "intellij.ml.llm.vcs"})
public final class CMGMetricsManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CMGMetricsStateTracker stateTracker;
    private static final int MAX_CHAR_INPUT_SIZE = 5000;
    @NotNull
    private static final Logger logger;

    public CMGMetricsManager(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.stateTracker = new CMGMetricsStateTracker();
    }

    private final boolean checkInputValid(String generatedMessage, String submittedMessage) {
        return generatedMessage.length() <= 5000 && submittedMessage.length() <= 5000;
    }

    private final boolean calculateMetrics(String generatedMessage, String submittedMessage) {
        if (!this.checkInputValid(generatedMessage, submittedMessage)) {
            logger.warn("Skipping metrics calculation due to input size limitation.");
            return false;
        }
        new CommitMessageEditDistance(generatedMessage, submittedMessage, 0, 0, 12, null).calculateAndLog();
        new CommitMessageChrF(generatedMessage, submittedMessage, 0, 0, 12, null).calculateAndLog();
        new CommitMessageLengthDiff(generatedMessage, submittedMessage, 0, 0, 12, null).calculateAndLog();
        return true;
    }

    public final void initCalculation(@NotNull String generatedMessage, @NotNull List<? extends Change> initialChanges) {
        Intrinsics.checkNotNullParameter((Object)generatedMessage, (String)"generatedMessage");
        Intrinsics.checkNotNullParameter(initialChanges, (String)"initialChanges");
        this.stateTracker.setState(new CMGMetricsState(generatedMessage, initialChanges, this.project));
    }

    public final boolean finishCalculation(@NotNull String submittedMessage, @NotNull List<? extends Change> actualChanges) {
        Intrinsics.checkNotNullParameter((Object)submittedMessage, (String)"submittedMessage");
        Intrinsics.checkNotNullParameter(actualChanges, (String)"actualChanges");
        String string = this.stateTracker.getOldMessageOrNullIfExpired(actualChanges, this.project);
        if (string == null) {
            return false;
        }
        String generatedCommitMessage = string;
        boolean wasCalculated = this.calculateMetrics(generatedCommitMessage, submittedMessage);
        this.stateTracker.resetState();
        return wasCalculated;
    }

    static {
        Logger logger = Logger.getInstance((String)"#com.intellij.ml.llm");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        CMGMetricsManager.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/ml/llm/vcs/metrics/CMGMetricsManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ml/llm/vcs/metrics/CMGMetricsManager;", "project", "Lcom/intellij/openapi/project/Project;", "MAX_CHAR_INPUT_SIZE", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.ml.llm.vcs"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CMGMetricsManager getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Object object = project2.getService(CMGMetricsManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (CMGMetricsManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

