/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.vcs.selfReview.ui;

import com.intellij.markdown.utils.CodeFenceSyntaxHighlighterGeneratingProvider;
import com.intellij.markdown.utils.lang.CodeBlockHtmlSyntaxHighlighter;
import com.intellij.markdown.utils.lang.HtmlSyntaxHighlighter;
import com.intellij.openapi.project.Project;
import java.net.URI;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.flavours.commonmark.CommonMarkFlavourDescriptor;
import org.intellij.markdown.flavours.gfm.GFMElementTypes;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.html.SimpleInlineTagProvider;
import org.intellij.markdown.parser.LinkMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0002\u000b\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\u0007\u001a\u00020\b2\u000b\u0010\t\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0000\u00a2\u0006\u0002\b\n\u00a8\u0006\r"}, d2={"Lcom/intellij/ml/llm/vcs/selfReview/ui/MarkdownToHtmlConverter;", "", "<init>", "()V", "convertToHtml", "", "Lcom/intellij/openapi/util/NlsSafe;", "project", "Lcom/intellij/openapi/project/Project;", "textWithMarkdown", "convertToHtml$intellij_ml_llm_vcs", "Companion", "DescriptionFlavourDescriptor", "intellij.ml.llm.vcs"})
public final class MarkdownToHtmlConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex CODE_BLOCK_REGEX = new Regex("\\n+</code></pre>");

    @NotNull
    public final String convertToHtml$intellij_ml_llm_vcs(@NotNull Project project2, @NotNull String textWithMarkdown) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)textWithMarkdown, (String)"textWithMarkdown");
        if (StringsKt.isBlank((CharSequence)textWithMarkdown)) {
            return "";
        }
        DescriptionFlavourDescriptor descriptionFlavourDescriptor = new DescriptionFlavourDescriptor((HtmlSyntaxHighlighter)new CodeBlockHtmlSyntaxHighlighter(project2));
        CharSequence charSequence = com.intellij.markdown.utils.MarkdownToHtmlConverter.convertMarkdownToHtml$default((com.intellij.markdown.utils.MarkdownToHtmlConverter)new com.intellij.markdown.utils.MarkdownToHtmlConverter((MarkdownFlavourDescriptor)descriptionFlavourDescriptor), (String)textWithMarkdown, null, (int)2, null);
        Regex regex = CODE_BLOCK_REGEX;
        String string = "</code></pre>";
        return regex.replace(charSequence, string);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/vcs/selfReview/ui/MarkdownToHtmlConverter$Companion;", "", "<init>", "()V", "CODE_BLOCK_REGEX", "Lkotlin/text/Regex;", "intellij.ml.llm.vcs"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J,\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0018\u00010\rj\u0004\u0018\u0001`\u000eH\u0016J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/vcs/selfReview/ui/MarkdownToHtmlConverter$DescriptionFlavourDescriptor;", "Lorg/intellij/markdown/flavours/commonmark/CommonMarkFlavourDescriptor;", "htmlSyntaxHighlighter", "Lcom/intellij/markdown/utils/lang/HtmlSyntaxHighlighter;", "<init>", "(Lcom/intellij/markdown/utils/lang/HtmlSyntaxHighlighter;)V", "createHtmlGeneratingProviders", "", "Lorg/intellij/markdown/IElementType;", "Lorg/intellij/markdown/html/GeneratingProvider;", "linkMap", "Lorg/intellij/markdown/parser/LinkMap;", "baseURI", "Ljava/net/URI;", "Lorg/intellij/markdown/html/URI;", "htmlEncode", "", "stringToEncode", "intellij.ml.llm.vcs"})
    private static final class DescriptionFlavourDescriptor
    extends CommonMarkFlavourDescriptor {
        @NotNull
        private final HtmlSyntaxHighlighter htmlSyntaxHighlighter;

        public DescriptionFlavourDescriptor(@NotNull HtmlSyntaxHighlighter htmlSyntaxHighlighter) {
            Intrinsics.checkNotNullParameter((Object)htmlSyntaxHighlighter, (String)"htmlSyntaxHighlighter");
            super(false, false, 3, null);
            this.htmlSyntaxHighlighter = htmlSyntaxHighlighter;
        }

        @NotNull
        public Map<IElementType, GeneratingProvider> createHtmlGeneratingProviders(@NotNull LinkMap linkMap, @Nullable URI baseURI) {
            Intrinsics.checkNotNullParameter((Object)linkMap, (String)"linkMap");
            Map parentProviders = MapsKt.toMutableMap((Map)super.createHtmlGeneratingProviders(linkMap, baseURI));
            parentProviders.put(MarkdownElementTypes.EMPH, new SimpleInlineTagProvider("i", 1, -1));
            parentProviders.put(MarkdownElementTypes.STRONG, new SimpleInlineTagProvider("b", 2, -2));
            parentProviders.put(GFMElementTypes.STRIKETHROUGH, new SimpleInlineTagProvider("strike", 2, -2));
            parentProviders.put(MarkdownElementTypes.CODE_FENCE, new CodeFenceSyntaxHighlighterGeneratingProvider(this.htmlSyntaxHighlighter));
            parentProviders.put(MarkdownTokenTypes.HTML_TAG, new GeneratingProvider(this){
                final /* synthetic */ DescriptionFlavourDescriptor this$0;
                {
                    this.this$0 = $receiver;
                }

                public void processNode(HtmlGenerator.HtmlGeneratingVisitor visitor, String text2, ASTNode node) {
                    Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
                    Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    visitor.consumeHtml((CharSequence)DescriptionFlavourDescriptor.access$htmlEncode(this.this$0, ((Object)ASTUtilKt.getTextInNode((ASTNode)node, (CharSequence)text2)).toString()));
                }
            });
            return parentProviders;
        }

        private final String htmlEncode(String stringToEncode) {
            CharSequence charSequence = stringToEncode;
            if (charSequence == null || charSequence.length() == 0) {
                return "";
            }
            if (Intrinsics.areEqual((Object)stringToEncode, (Object)"<br/>")) {
                return stringToEncode;
            }
            StringBuilder result2 = new StringBuilder(stringToEncode.length());
            String string = stringToEncode;
            int n = string.length();
            block21: for (int i = 0; i < n; ++i) {
                char ch = string.charAt(i);
                switch (ch) {
                    case ';': {
                        StringBuilder stringBuilder = result2.append("&semi;");
                        continue block21;
                    }
                    case '&': {
                        StringBuilder stringBuilder = result2.append("&amp;");
                        continue block21;
                    }
                    case '<': {
                        StringBuilder stringBuilder = result2.append("&lt;");
                        continue block21;
                    }
                    case '>': {
                        StringBuilder stringBuilder = result2.append("&gt;");
                        continue block21;
                    }
                    case '\"': {
                        StringBuilder stringBuilder = result2.append("&quot;");
                        continue block21;
                    }
                    case '\'': {
                        StringBuilder stringBuilder = result2.append("&#x27;");
                        continue block21;
                    }
                    case '\\': {
                        StringBuilder stringBuilder = result2.append("&bsol;");
                        continue block21;
                    }
                    case '/': {
                        StringBuilder stringBuilder = result2.append("&#x2F;");
                        continue block21;
                    }
                    case '\u2014': {
                        StringBuilder stringBuilder = result2.append("&mdash;");
                        continue block21;
                    }
                    case '\u2013': {
                        StringBuilder stringBuilder = result2.append("&ndash;");
                        continue block21;
                    }
                    case '\u201c': {
                        StringBuilder stringBuilder = result2.append("&ldquo;");
                        continue block21;
                    }
                    case '\u201d': {
                        StringBuilder stringBuilder = result2.append("&rdquo;");
                        continue block21;
                    }
                    case '\u2018': {
                        StringBuilder stringBuilder = result2.append("&lsquo;");
                        continue block21;
                    }
                    case '\u2019': {
                        StringBuilder stringBuilder = result2.append("&rsquo;");
                        continue block21;
                    }
                    case '\u00ab': {
                        StringBuilder stringBuilder = result2.append("&laquo;");
                        continue block21;
                    }
                    case '\u00bb': {
                        StringBuilder stringBuilder = result2.append("&raquo;");
                        continue block21;
                    }
                    case '\u00a3': {
                        StringBuilder stringBuilder = result2.append("&pound;");
                        continue block21;
                    }
                    case '\u00a9': {
                        StringBuilder stringBuilder = result2.append("&copy;");
                        continue block21;
                    }
                    case '\u00ae': {
                        StringBuilder stringBuilder = result2.append("&reg;");
                        continue block21;
                    }
                    default: {
                        StringBuilder stringBuilder = result2.append(ch);
                    }
                }
            }
            String string2 = result2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            return string2;
        }

        public static final /* synthetic */ String access$htmlEncode(DescriptionFlavourDescriptor $this, String stringToEncode) {
            return $this.htmlEncode(stringToEncode);
        }
    }
}

