/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.vcs.selfReview.ui;

import com.intellij.analysis.problemsView.toolWindow.Node;
import com.intellij.analysis.problemsView.toolWindow.ProblemNodeI;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ml.llm.vcs.selfReview.ui.VcsAISelfReviewDescriptionNode;
import com.intellij.ml.llm.vcs.selfReview.ui.VcsAISelfReviewFileProblem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.tree.LeafState;
import java.util.Collection;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0016\u001a\u00020\u000fH\u0016J\b\u0010\u0017\u001a\u00020\u0012H\u0016J\b\u0010\u0018\u001a\u00020\u0012H\u0016J\b\u0010\u0019\u001a\u00020\u0012H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u000fH\u0016J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00010\"H\u0016J\b\u0010#\u001a\u00020\u0005H\u0016J\b\u0010$\u001a\u00020%H\u0016J\u0018\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0014J\b\u0010,\u001a\u00020\u0012H\u0016J\u0013\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u000100H\u0096\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u00061"}, d2={"Lcom/intellij/ml/llm/vcs/selfReview/ui/VcsAISelfReviewProblemNode;", "Lcom/intellij/analysis/problemsView/toolWindow/Node;", "Lcom/intellij/analysis/problemsView/toolWindow/ProblemNodeI;", "parent", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "problem", "Lcom/intellij/ml/llm/vcs/selfReview/ui/VcsAISelfReviewFileProblem;", "<init>", "(Lcom/intellij/analysis/problemsView/toolWindow/Node;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/ml/llm/vcs/selfReview/ui/VcsAISelfReviewFileProblem;)V", "getFile$intellij_ml_llm_vcs", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getProblem", "()Lcom/intellij/ml/llm/vcs/selfReview/ui/VcsAISelfReviewFileProblem;", "text", "", "Lcom/intellij/openapi/util/NlsSafe;", "lineStart", "", "lineEnd", "column", "severity", "getText", "getLine", "getColumn", "getSeverity", "descriptor", "Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;", "getDescriptor", "()Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;", "getLeafState", "Lcom/intellij/ui/tree/LeafState;", "getName", "getChildren", "", "getVirtualFile", "getNavigatable", "Lcom/intellij/pom/Navigatable;", "update", "", "project", "Lcom/intellij/openapi/project/Project;", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "hashCode", "equals", "", "other", "", "intellij.ml.llm.vcs"})
@SourceDebugExtension(value={"SMAP\nVcsAISelfReviewProblemNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsAISelfReviewProblemNode.kt\ncom/intellij/ml/llm/vcs/selfReview/ui/VcsAISelfReviewProblemNode\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,80:1\n13#2:81\n*S KotlinDebug\n*F\n+ 1 VcsAISelfReviewProblemNode.kt\ncom/intellij/ml/llm/vcs/selfReview/ui/VcsAISelfReviewProblemNode\n*L\n25#1:81\n*E\n"})
public final class VcsAISelfReviewProblemNode
extends Node
implements ProblemNodeI {
    @NotNull
    private final VirtualFile file;
    @NotNull
    private final VcsAISelfReviewFileProblem problem;
    @NotNull
    private String text;
    private int lineStart;
    private int lineEnd;
    private int column;
    private int severity;

    public VcsAISelfReviewProblemNode(@NotNull Node parent, @NotNull VirtualFile file2, @NotNull VcsAISelfReviewFileProblem problem) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        super(parent);
        this.file = file2;
        this.problem = problem;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(VcsAISelfReviewProblemNode.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.assertTrue(this.getProject() != null, (Object)this);
        this.text = "";
    }

    @NotNull
    public final VirtualFile getFile$intellij_ml_llm_vcs() {
        return this.file;
    }

    @NotNull
    public VcsAISelfReviewFileProblem getProblem() {
        return this.problem;
    }

    @NotNull
    public String getText() {
        return this.text;
    }

    public int getLine() {
        return this.lineStart;
    }

    public int getColumn() {
        return this.column;
    }

    public int getSeverity() {
        return this.severity;
    }

    @NotNull
    public OpenFileDescriptor getDescriptor() {
        Project project2 = this.getProject();
        Intrinsics.checkNotNull((Object)project2);
        return new OpenFileDescriptor(project2, this.file, this.lineStart, this.column);
    }

    @NotNull
    public LeafState getLeafState() {
        return LeafState.DEFAULT;
    }

    @NotNull
    public String getName() {
        return this.text;
    }

    @NotNull
    public Collection<Node> getChildren() {
        return CollectionsKt.listOf((Object)((Object)new VcsAISelfReviewDescriptionNode(this)));
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        return this.file;
    }

    @NotNull
    public Navigatable getNavigatable() {
        return (Navigatable)this.getDescriptor();
    }

    protected void update(@NotNull Project project2, @NotNull PresentationData presentation2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
        this.text = this.getProblem().getText();
        this.lineStart = this.getProblem().getLine();
        int lineStartWithOffset = this.lineStart + 1;
        this.lineEnd = this.getProblem().getLineEnd();
        int lineEndWithOffset = this.lineEnd + 1;
        this.column = this.getProblem().getColumn();
        this.severity = this.getProblem().getSeverity().ordinal();
        presentation2.addText(this.text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        presentation2.setIcon(this.getProblem().getIcon());
        if (this.lineStart >= 0) {
            presentation2.addText(" :" + lineStartWithOffset, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
        if (this.lineEnd >= 0 && lineStartWithOffset != lineEndWithOffset) {
            presentation2.addText(" - " + lineEndWithOffset, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getProject(), this.getProblem()};
        return Objects.hash(objectArray);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(((Object)((Object)this)).getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        VcsAISelfReviewProblemNode vcsAISelfReviewProblemNode = object2 instanceof VcsAISelfReviewProblemNode ? (VcsAISelfReviewProblemNode)((Object)object2) : null;
        if (vcsAISelfReviewProblemNode == null) {
            return false;
        }
        VcsAISelfReviewProblemNode that = vcsAISelfReviewProblemNode;
        return Intrinsics.areEqual((Object)that.getProject(), (Object)this.getProject()) && Intrinsics.areEqual((Object)that.getProblem(), (Object)this.getProblem());
    }
}

