/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core;

import ai.grazie.model.llm.chat.v5.LLMChat;
import ai.grazie.model.llm.chat.v5.LLMChatAssistantMessage;
import ai.grazie.model.llm.chat.v5.LLMChatAssistantMessageText;
import ai.grazie.model.llm.chat.v5.LLMChatAssistantMessageTool;
import ai.grazie.model.llm.chat.v5.LLMChatFunctionMessage;
import ai.grazie.model.llm.chat.v5.LLMChatMessage;
import ai.grazie.model.llm.chat.v5.LLMChatToolMessage;
import ai.grazie.model.llm.data.stream.LLMStreamData;
import ai.grazie.model.llm.data.stream.LLMStreamFunctionCall;
import ai.grazie.model.llm.data.stream.LLMStreamToolCall;
import ai.grazie.model.llm.parameters.LLMParameters;
import ai.grazie.model.llm.parameters.OpenAILLMParameters;
import ai.grazie.model.llm.profile.LLMProfileID;
import ai.grazie.model.llm.profile.dto.v3.ChatDefinitionDTO;
import ai.grazie.model.llm.profile.dto.v8.CompletionDefinitionDTO;
import ai.grazie.model.llm.profile.dto.v8.LLMProfileDTO;
import ai.grazie.model.llm.profile.dto.v8.LifeCycleDTO;
import ai.grazie.model.llm.profile.dto.v8.MediaDataDefinitionDTO;
import ai.grazie.model.llm.profile.dto.v8.MultimodalChatDefinitionDTO;
import ai.grazie.utils.attributes.Attributes;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ml.llm.activation.data.model.AieProvisionStatus;
import com.intellij.ml.llm.activation.state.manager.AiaActivationManager;
import com.intellij.ml.llm.activation.state.model.AiEnterpriseActivation;
import com.intellij.ml.llm.activation.state.model.AieAllowanceStep;
import com.intellij.ml.llm.activation.state.model.JbaiActivation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001 B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\rJ\u0006\u0010\u000f\u001a\u00020\tJ\u0006\u0010\u0010\u001a\u00020\rJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0011\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018J\u000e\u0010\u0017\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001d\u00a8\u0006!"}, d2={"Lcom/intellij/ml/llm/core/AiaAiEnterpriseUtils;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "platformVersionRegex", "Lkotlin/text/Regex;", "parsePlatformVersion", "Lcom/intellij/ml/llm/core/AiaAiEnterpriseUtils$PlatformVersion;", "value", "", "isAiEnterprise", "", "isIgnoreModelMappingRules", "getV8CutOutPlatformVersion", "isUseFallbackApiVersion", "toV8", "Lai/grazie/model/llm/profile/dto/v8/LLMProfileDTO;", "profile", "Lai/grazie/model/llm/profile/dto/v3/LLMProfileDTO;", "Lai/grazie/model/llm/data/stream/LLMStreamData;", "data", "toV7", "Lai/grazie/model/llm/chat/v5/LLMChat;", "chat", "allKeysV7", "", "Lai/grazie/utils/attributes/Attributes$Key;", "[Lai/grazie/utils/attributes/Attributes$Key;", "Lai/grazie/utils/attributes/Attributes;", "attributes", "PlatformVersion", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nAiaAiEnterpriseUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AiaAiEnterpriseUtils.kt\ncom/intellij/ml/llm/core/AiaAiEnterpriseUtils\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 util.kt\ncom/intellij/util/containers/UtilKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,189:1\n42#2,3:190\n19#3:193\n19#3:194\n254#4:195\n254#4:196\n254#4:197\n1#5:198\n13#6:199\n*S KotlinDebug\n*F\n+ 1 AiaAiEnterpriseUtils.kt\ncom/intellij/ml/llm/core/AiaAiEnterpriseUtils\n*L\n76#1:190,3\n76#1:193\n77#1:194\n102#1:195\n104#1:196\n150#1:197\n38#1:199\n*E\n"})
public final class AiaAiEnterpriseUtils {
    @NotNull
    public static final AiaAiEnterpriseUtils INSTANCE = new AiaAiEnterpriseUtils();
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Regex platformVersionRegex;
    @NotNull
    private static final Attributes.Key[] allKeysV7;

    private AiaAiEnterpriseUtils() {
    }

    private final PlatformVersion parsePlatformVersion(String value) {
        MatchResult matchResult = platformVersionRegex.matchEntire((CharSequence)value);
        if (matchResult == null) {
            return null;
        }
        MatchResult match = matchResult;
        MatchResult.Destructured destructured = match.getDestructured();
        String major = (String)destructured.getMatch().getGroupValues().get(1);
        String minor = (String)destructured.getMatch().getGroupValues().get(2);
        String patch = (String)destructured.getMatch().getGroupValues().get(3);
        Integer n = StringsKt.toIntOrNull((String)major);
        if (n == null) {
            return null;
        }
        Integer n2 = StringsKt.toIntOrNull((String)minor);
        if (n2 == null) {
            return null;
        }
        Integer n3 = StringsKt.toIntOrNull((String)patch);
        if (n3 == null) {
            return null;
        }
        return new PlatformVersion(n, n2, n3);
    }

    public final boolean isAiEnterprise() {
        JbaiActivation activation2 = AiaActivationManager.Companion.currentJbaiActivation();
        return activation2 instanceof AiEnterpriseActivation;
    }

    public final boolean isIgnoreModelMappingRules() {
        return Registry.Companion.is("llm.ignore.default.prompt.rules.aie");
    }

    @NotNull
    public final PlatformVersion getV8CutOutPlatformVersion() {
        PlatformVersion cutoutVersion = this.parsePlatformVersion(Registry.Companion.stringValue("llm.v8.cutout.version.aie"));
        PlatformVersion platformVersion = cutoutVersion;
        if (platformVersion == null) {
            platformVersion = new PlatformVersion(0, 8, 112);
        }
        return platformVersion;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isUseFallbackApiVersion() {
        AieAllowanceStep.AieAllowed aieAllowed;
        void $this$asSafely$iv;
        AiEnterpriseActivation aiEnterpriseActivation;
        boolean $i$f$service = false;
        Class<AiaActivationManager> serviceClass$iv = AiaActivationManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        JbaiActivation $this$asSafely$iv2 = ((AiaActivationManager)object).getJbaiActivation();
        boolean $i$f$asSafely = false;
        JbaiActivation jbaiActivation = $this$asSafely$iv2;
        if (!(jbaiActivation instanceof AiEnterpriseActivation)) {
            jbaiActivation = null;
        }
        if ((aiEnterpriseActivation = (AiEnterpriseActivation)jbaiActivation) == null) return false;
        $this$asSafely$iv2 = aiEnterpriseActivation.getAllowanceStep();
        if ($this$asSafely$iv2 == null) return false;
        JbaiActivation jbaiActivation2 = $this$asSafely$iv2;
        boolean $i$f$asSafely2 = false;
        Object v2 = $this$asSafely$iv;
        if (!(v2 instanceof AieAllowanceStep.AieAllowed)) {
            v2 = null;
        }
        if ((aieAllowed = (AieAllowanceStep.AieAllowed)v2) == null) return false;
        AieProvisionStatus.AieActivated aieActivated = aieAllowed.getActivatedStatus();
        AieProvisionStatus.AieActivated aieActivationState = aieActivated;
        if (aieActivationState == null) {
            return false;
        }
        if (Registry.Companion.is("llm.use.fallback.api.aie")) {
            return true;
        }
        String aiePlatformVersionString = aieActivationState.getPlatformVersion();
        if (aiePlatformVersionString == null) return false;
        if (Intrinsics.areEqual((Object)aiePlatformVersionString, (Object)"latest")) {
            return false;
        }
        PlatformVersion aiePlatformVersion = this.parsePlatformVersion(aiePlatformVersionString);
        if (aiePlatformVersion == null) {
            logger.error("Failed to parse platform version from: " + aiePlatformVersionString);
            return true;
        }
        if (aiePlatformVersion.compareTo(this.getV8CutOutPlatformVersion()) >= 0) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LLMProfileDTO toV8(@NotNull ai.grazie.model.llm.profile.dto.v3.LLMProfileDTO profile) {
        LifeCycleDTO lifeCycleDTO;
        MultimodalChatDefinitionDTO multimodalChatDefinitionDTO;
        MultimodalChatDefinitionDTO multimodalChatDefinitionDTO2;
        boolean bl;
        Integer n;
        Integer n2;
        boolean bl2;
        String string;
        String string2;
        String string3;
        CompletionDefinitionDTO completionDefinitionDTO;
        CompletionDefinitionDTO completionDefinitionDTO2;
        ai.grazie.model.llm.profile.dto.v8.ChatDefinitionDTO chatDefinitionDTO;
        ai.grazie.model.llm.profile.dto.v8.ChatDefinitionDTO chatDefinitionDTO2;
        MediaDataDefinitionDTO mediaDataDefinitionDTO;
        ai.grazie.model.llm.profile.dto.v3.MediaDataDefinitionDTO $this$map2Array$iv;
        ai.grazie.model.llm.profile.dto.v3.CompletionDefinitionDTO it;
        LLMProfileID lLMProfileID;
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        LLMProfileID lLMProfileID2 = profile.getId();
        String[] stringArray2 = profile.getFeatures();
        ChatDefinitionDTO chatDefinitionDTO3 = profile.getChatDefinition();
        if (chatDefinitionDTO3 != null) {
            String r;
            MediaDataDefinitionDTO mediaDataDefinitionDTO2;
            int n3;
            int n4;
            ChatDefinitionDTO chatDefinitionDTO4 = chatDefinitionDTO3;
            stringArray = stringArray2;
            lLMProfileID = lLMProfileID2;
            boolean bl3 = false;
            $this$map2Array$iv = it.getRoles();
            boolean $i$f$map2Array = false;
            int n5 = ((String[])$this$map2Array$iv).length;
            mediaDataDefinitionDTO = new String[n5];
            for (n4 = 0; n4 < n5; ++n4) {
                String string4;
                n3 = n4;
                String string5 = $this$map2Array$iv[n3];
                int n6 = n3;
                mediaDataDefinitionDTO2 = mediaDataDefinitionDTO;
                boolean bl4 = false;
                mediaDataDefinitionDTO2[n6] = string4 = Intrinsics.areEqual((Object)r, (Object)"function") ? "tool" : r;
            }
            $this$map2Array$iv = it.getParameters();
            mediaDataDefinitionDTO2 = mediaDataDefinitionDTO;
            $i$f$map2Array = false;
            n5 = ((String[])$this$map2Array$iv).length;
            mediaDataDefinitionDTO = new Attributes.Key[n5];
            for (n4 = 0; n4 < n5; ++n4) {
                void p;
                n3 = n4;
                r = $this$map2Array$iv[n3];
                int n7 = n3;
                MediaDataDefinitionDTO mediaDataDefinitionDTO3 = mediaDataDefinitionDTO;
                boolean bl5 = false;
                void var17_19 = Intrinsics.areEqual((Object)p, (Object)LLMParameters.INSTANCE.getFunctions()) ? (Attributes.Key)LLMParameters.INSTANCE.getTools() : p;
                mediaDataDefinitionDTO3[n7] = var17_19;
            }
            MediaDataDefinitionDTO mediaDataDefinitionDTO4 = null;
            MediaDataDefinitionDTO mediaDataDefinitionDTO5 = mediaDataDefinitionDTO;
            MediaDataDefinitionDTO mediaDataDefinitionDTO6 = mediaDataDefinitionDTO2;
            chatDefinitionDTO2 = new ai.grazie.model.llm.profile.dto.v8.ChatDefinitionDTO((String[])mediaDataDefinitionDTO6, (Attributes.Key[])mediaDataDefinitionDTO5, mediaDataDefinitionDTO4);
            lLMProfileID2 = lLMProfileID;
            stringArray2 = stringArray;
            chatDefinitionDTO = chatDefinitionDTO2;
        } else {
            chatDefinitionDTO = null;
        }
        ai.grazie.model.llm.profile.dto.v3.CompletionDefinitionDTO completionDefinitionDTO3 = profile.getCompletionDefinition();
        if (completionDefinitionDTO3 != null) {
            it = completionDefinitionDTO3;
            chatDefinitionDTO2 = chatDefinitionDTO;
            stringArray = stringArray2;
            lLMProfileID = lLMProfileID2;
            boolean bl6 = false;
            completionDefinitionDTO2 = new CompletionDefinitionDTO(it.getParameters());
            lLMProfileID2 = lLMProfileID;
            stringArray2 = stringArray;
            chatDefinitionDTO = chatDefinitionDTO2;
            completionDefinitionDTO = completionDefinitionDTO2;
        } else {
            completionDefinitionDTO = null;
        }
        boolean bl7 = profile.getDeprecated();
        Integer n8 = profile.getContextLimit();
        Integer n9 = profile.getMaxOutputTokens();
        boolean bl8 = profile.getExperimental();
        String string6 = profile.getProvider();
        String string7 = profile.getModelName();
        String string8 = profile.getProviderModelID();
        ai.grazie.model.llm.profile.dto.v3.MultimodalChatDefinitionDTO multimodalChatDefinitionDTO3 = profile.getMultimodalChatDefinition();
        if (multimodalChatDefinitionDTO3 != null) {
            MediaDataDefinitionDTO mediaDataDefinitionDTO7;
            it = multimodalChatDefinitionDTO3;
            string3 = string8;
            string2 = string7;
            string = string6;
            bl2 = bl8;
            n2 = n9;
            n = n8;
            bl = bl7;
            completionDefinitionDTO2 = completionDefinitionDTO;
            chatDefinitionDTO2 = chatDefinitionDTO;
            stringArray = stringArray2;
            lLMProfileID = lLMProfileID2;
            boolean bl9 = false;
            List list = it.getRoles();
            Set set = it.getParameters();
            ai.grazie.model.llm.profile.dto.v3.MediaDataDefinitionDTO mediaDataDefinitionDTO8 = it.getMediaDataDefinition();
            if (mediaDataDefinitionDTO8 != null) {
                void it2;
                $this$map2Array$iv = mediaDataDefinitionDTO8;
                Set set2 = set;
                List list2 = list;
                boolean bl10 = false;
                mediaDataDefinitionDTO = new MediaDataDefinitionDTO(it2.getSupportedTypes(), it2.getMaxElements());
                list = list2;
                set = set2;
                mediaDataDefinitionDTO7 = mediaDataDefinitionDTO;
            } else {
                mediaDataDefinitionDTO7 = null;
            }
            MediaDataDefinitionDTO mediaDataDefinitionDTO9 = mediaDataDefinitionDTO7;
            Set set3 = set;
            List list3 = list;
            multimodalChatDefinitionDTO2 = new MultimodalChatDefinitionDTO(list3, set3, mediaDataDefinitionDTO9);
            lLMProfileID2 = lLMProfileID;
            stringArray2 = stringArray;
            chatDefinitionDTO = chatDefinitionDTO2;
            completionDefinitionDTO = completionDefinitionDTO2;
            bl7 = bl;
            n8 = n;
            n9 = n2;
            bl8 = bl2;
            string6 = string;
            string7 = string2;
            string8 = string3;
            multimodalChatDefinitionDTO = multimodalChatDefinitionDTO2;
        } else {
            multimodalChatDefinitionDTO = null;
        }
        ai.grazie.model.llm.profile.dto.v3.LifeCycleDTO lifeCycleDTO2 = profile.getLifeCycle();
        if (lifeCycleDTO2 != null) {
            it = lifeCycleDTO2;
            multimodalChatDefinitionDTO2 = multimodalChatDefinitionDTO;
            string3 = string8;
            string2 = string7;
            string = string6;
            bl2 = bl8;
            n2 = n9;
            n = n8;
            bl = bl7;
            completionDefinitionDTO2 = completionDefinitionDTO;
            chatDefinitionDTO2 = chatDefinitionDTO;
            stringArray = stringArray2;
            lLMProfileID = lLMProfileID2;
            boolean bl11 = false;
            LifeCycleDTO lifeCycleDTO3 = new LifeCycleDTO(it.getDeprecated(), it.getExperimental(), it.getPreview());
            lLMProfileID2 = lLMProfileID;
            stringArray2 = stringArray;
            chatDefinitionDTO = chatDefinitionDTO2;
            completionDefinitionDTO = completionDefinitionDTO2;
            bl7 = bl;
            n8 = n;
            n9 = n2;
            bl8 = bl2;
            string6 = string;
            string7 = string2;
            string8 = string3;
            multimodalChatDefinitionDTO = multimodalChatDefinitionDTO2;
            lifeCycleDTO = lifeCycleDTO3;
        } else {
            lifeCycleDTO = null;
        }
        LifeCycleDTO lifeCycleDTO4 = lifeCycleDTO;
        MultimodalChatDefinitionDTO multimodalChatDefinitionDTO4 = multimodalChatDefinitionDTO;
        String string9 = string8;
        String string10 = string7;
        String string11 = string6;
        boolean bl12 = bl8;
        Integer n10 = n9;
        Integer n11 = n8;
        boolean bl13 = bl7;
        CompletionDefinitionDTO completionDefinitionDTO4 = completionDefinitionDTO;
        ai.grazie.model.llm.profile.dto.v8.ChatDefinitionDTO chatDefinitionDTO5 = chatDefinitionDTO;
        String[] stringArray3 = stringArray2;
        LLMProfileID lLMProfileID3 = lLMProfileID2;
        return new LLMProfileDTO(lLMProfileID3, stringArray3, chatDefinitionDTO5, completionDefinitionDTO4, bl13, n11, n10, bl12, string11, string10, string9, multimodalChatDefinitionDTO4, lifeCycleDTO4);
    }

    @NotNull
    public final LLMStreamData toV8(@NotNull LLMStreamData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (data instanceof LLMStreamFunctionCall) {
            return (LLMStreamData)new LLMStreamToolCall(((LLMStreamFunctionCall)data).getChoiceIndex(), null, null, ((LLMStreamFunctionCall)data).getName(), ((LLMStreamFunctionCall)data).getContent(), null, 32, null);
        }
        return data;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LLMChat toV7(@NotNull LLMChat chat2) {
        Intrinsics.checkNotNullParameter((Object)chat2, (String)"chat");
        LLMChatMessage[] $this$map2Array$iv = chat2.getMessages();
        boolean $i$f$map2Array = false;
        int n = $this$map2Array$iv.length;
        LLMChatMessage[] lLMChatMessageArray = new LLMChatMessage[n];
        for (int i = 0; i < n; ++i) {
            void it;
            int n2 = i;
            LLMChatMessage lLMChatMessage = $this$map2Array$iv[n2];
            int n3 = n2;
            LLMChatMessage[] lLMChatMessageArray2 = lLMChatMessageArray;
            boolean bl = false;
            void var10_10 = it;
            void var13_13 = var10_10 instanceof LLMChatAssistantMessageText ? (LLMChatMessage)new LLMChatAssistantMessage(((LLMChatAssistantMessageText)it).getContent(), null, null, 6, null) : (var10_10 instanceof LLMChatAssistantMessageTool ? (LLMChatMessage)new LLMChatAssistantMessage(null, new LLMChatAssistantMessage.FunctionCallResponse(((LLMChatAssistantMessageTool)it).getToolName(), ((LLMChatAssistantMessageTool)it).getContent()), null, 4, null) : (var10_10 instanceof LLMChatToolMessage ? (LLMChatMessage)new LLMChatFunctionMessage(((LLMChatToolMessage)it).getToolName(), ((LLMChatToolMessage)it).getContent()) : it));
            lLMChatMessageArray2[n3] = var13_13;
        }
        LLMChatMessage[] lLMChatMessageArray3 = lLMChatMessageArray;
        return new LLMChat(lLMChatMessageArray3);
    }

    @NotNull
    public final Attributes toV7(@NotNull Attributes attributes) {
        Attributes attributes2;
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Attributes $this$toV7_u24lambda_u241 = attributes2 = attributes.clone();
        boolean bl = false;
        $this$toV7_u24lambda_u241.retain(allKeysV7);
        return attributes2;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AiaAiEnterpriseUtils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        AiaAiEnterpriseUtils.logger = logger;
        platformVersionRegex = new Regex("^\\s*(\\d+)\\.(\\d+)\\.(\\d+)(?:-.*)?\\s*$");
        Attributes.Key[] keyArray = new Attributes.Key[]{LLMParameters.INSTANCE.getTemperature(), LLMParameters.INSTANCE.getFunctions(), LLMParameters.INSTANCE.getFunctionCall(), LLMParameters.INSTANCE.getLength(), LLMParameters.INSTANCE.getStopToken(), LLMParameters.INSTANCE.getNoRepeat(), LLMParameters.INSTANCE.getTopP(), LLMParameters.INSTANCE.getTopK(), LLMParameters.INSTANCE.getSeed(), LLMParameters.INSTANCE.getDimension(), LLMParameters.Completion.INSTANCE.getCodeFilename(), LLMParameters.Completion.INSTANCE.getCodeContext(), LLMParameters.INSTANCE.getResponseFormat(), LLMParameters.INSTANCE.getPredictedOutput(), LLMParameters.INSTANCE.getReasoningEffort(), LLMParameters.INSTANCE.getNumberOfChoices(), LLMParameters.INSTANCE.getCachePoints(), OpenAILLMParameters.Chat.INSTANCE.getTemperature(), OpenAILLMParameters.Completion.INSTANCE.getTemperature()};
        allKeysV7 = keyArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0011\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\r\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ml/llm/core/AiaAiEnterpriseUtils$PlatformVersion;", "", "major", "", "minor", "patch", "<init>", "(III)V", "getMajor", "()I", "getMinor", "getPatch", "compareTo", "other", "component1", "component2", "component3", "copy", "equals", "", "", "hashCode", "toString", "", "intellij.ml.llm.core"})
    public static final class PlatformVersion
    implements Comparable<PlatformVersion> {
        private final int major;
        private final int minor;
        private final int patch;

        public PlatformVersion(int major, int minor, int patch) {
            this.major = major;
            this.minor = minor;
            this.patch = patch;
        }

        public final int getMajor() {
            return this.major;
        }

        public final int getMinor() {
            return this.minor;
        }

        public final int getPatch() {
            return this.patch;
        }

        @Override
        public int compareTo(@NotNull PlatformVersion other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            Function1[] function1Array = new Function1[]{PlatformVersion::compareTo$lambda$0, PlatformVersion::compareTo$lambda$1, PlatformVersion::compareTo$lambda$2};
            return ComparisonsKt.compareValuesBy((Object)this, (Object)other, (Function1[])function1Array);
        }

        public final int component1() {
            return this.major;
        }

        public final int component2() {
            return this.minor;
        }

        public final int component3() {
            return this.patch;
        }

        @NotNull
        public final PlatformVersion copy(int major, int minor, int patch) {
            return new PlatformVersion(major, minor, patch);
        }

        public static /* synthetic */ PlatformVersion copy$default(PlatformVersion platformVersion, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = platformVersion.major;
            }
            if ((n4 & 2) != 0) {
                n2 = platformVersion.minor;
            }
            if ((n4 & 4) != 0) {
                n3 = platformVersion.patch;
            }
            return platformVersion.copy(n, n2, n3);
        }

        @NotNull
        public String toString() {
            return "PlatformVersion(major=" + this.major + ", minor=" + this.minor + ", patch=" + this.patch + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.major);
            result2 = result2 * 31 + Integer.hashCode(this.minor);
            result2 = result2 * 31 + Integer.hashCode(this.patch);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PlatformVersion)) {
                return false;
            }
            PlatformVersion platformVersion = (PlatformVersion)other;
            if (this.major != platformVersion.major) {
                return false;
            }
            if (this.minor != platformVersion.minor) {
                return false;
            }
            return this.patch == platformVersion.patch;
        }

        private static final Comparable compareTo$lambda$0(PlatformVersion it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Integer.valueOf(it.major);
        }

        private static final Comparable compareTo$lambda$1(PlatformVersion it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Integer.valueOf(it.minor);
        }

        private static final Comparable compareTo$lambda$2(PlatformVersion it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Integer.valueOf(it.patch);
        }
    }
}

