/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core;

import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.StatefulPresentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001f B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0014\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0014\u0010\u0014\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\b\u0010\u0015\u001a\u00020\u0004H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u000fH\u0016J\u0018\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/ml/llm/core/FeedbackButtonInlayPresentation;", "Lcom/intellij/codeInsight/hints/presentation/StatefulPresentation;", "Lcom/intellij/ml/llm/core/FeedbackButtonInlayPresentation$State;", "noHover", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "hover", "editor", "Lcom/intellij/openapi/editor/Editor;", "cursor", "Ljava/awt/Cursor;", "<init>", "(Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;Lcom/intellij/openapi/editor/Editor;Ljava/awt/Cursor;)V", "onClickListeners", "", "Lkotlin/Function0;", "", "onStateChangedListeners", "addOnClickListener", "", "body", "addOnStateChangedListener", "getPresentation", "toString", "", "mouseMoved", "event", "Ljava/awt/event/MouseEvent;", "translated", "Ljava/awt/Point;", "mouseExited", "mouseClicked", "State", "Companion", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nNotifications.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Notifications.kt\ncom/intellij/ml/llm/core/FeedbackButtonInlayPresentation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,249:1\n1869#2,2:250\n1869#2,2:252\n1869#2,2:254\n*S KotlinDebug\n*F\n+ 1 Notifications.kt\ncom/intellij/ml/llm/core/FeedbackButtonInlayPresentation\n*L\n222#1:250,2\n230#1:252,2\n237#1:254,2\n*E\n"})
final class FeedbackButtonInlayPresentation
extends StatefulPresentation<State> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InlayPresentation noHover;
    @NotNull
    private final InlayPresentation hover;
    @NotNull
    private final Editor editor;
    @NotNull
    private final Cursor cursor;
    @NotNull
    private final List<Function0<Unit>> onClickListeners;
    @NotNull
    private final List<Function0<Unit>> onStateChangedListeners;
    @NotNull
    private static final StatefulPresentation.StateMark<State> STATE_MARK = new StatefulPresentation.StateMark("OnHover");

    public FeedbackButtonInlayPresentation(@NotNull InlayPresentation noHover, @NotNull InlayPresentation hover, @NotNull Editor editor, @NotNull Cursor cursor) {
        Intrinsics.checkNotNullParameter((Object)noHover, (String)"noHover");
        Intrinsics.checkNotNullParameter((Object)hover, (String)"hover");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
        super((Object)new State(false), STATE_MARK);
        this.noHover = noHover;
        this.hover = hover;
        this.editor = editor;
        this.cursor = cursor;
        this.onClickListeners = new ArrayList();
        this.onStateChangedListeners = new ArrayList();
    }

    public final boolean addOnClickListener(@NotNull Function0<Unit> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        return this.onClickListeners.add(body);
    }

    public final boolean addOnStateChangedListener(@NotNull Function0<Unit> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        return this.onStateChangedListeners.add(body);
    }

    @NotNull
    public InlayPresentation getPresentation() {
        InlayPresentation inlayPresentation;
        boolean bl = ((State)this.getState()).isInside();
        if (bl) {
            inlayPresentation = this.hover;
        } else if (!bl) {
            inlayPresentation = this.noHover;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return inlayPresentation;
    }

    @NotNull
    public String toString() {
        String string;
        boolean bl = ((State)this.getState()).isInside();
        if (bl) {
            string = "<hovered>";
        } else if (!bl) {
            string = "";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string + this.getCurrentPresentation();
    }

    public void mouseMoved(@NotNull MouseEvent event, @NotNull Point translated) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
        super.mouseMoved(event, translated);
        if (!((State)this.getState()).isInside()) {
            this.setState(new State(true));
            Editor editor = this.editor;
            EditorImpl editorImpl = editor instanceof EditorImpl ? (EditorImpl)editor : null;
            if (editorImpl != null) {
                editorImpl.setCustomCursor((Object)Reflection.getOrCreateKotlinClass(((Object)((Object)this)).getClass()), this.cursor);
            }
            Iterable $this$forEach$iv = this.onStateChangedListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function0 it = (Function0)element$iv;
                boolean bl = false;
                it.invoke();
            }
        }
    }

    public void mouseExited() {
        if (((State)this.getState()).isInside()) {
            this.setState(new State(false));
            Editor editor = this.editor;
            EditorImpl editorImpl = editor instanceof EditorImpl ? (EditorImpl)editor : null;
            if (editorImpl != null) {
                editorImpl.setCustomCursor((Object)Reflection.getOrCreateKotlinClass(((Object)((Object)this)).getClass()), null);
            }
            Iterable $this$forEach$iv = this.onStateChangedListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function0 it = (Function0)element$iv;
                boolean bl = false;
                it.invoke();
            }
        }
        super.mouseExited();
    }

    public void mouseClicked(@NotNull MouseEvent event, @NotNull Point translated) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
        super.mouseClicked(event, translated);
        Iterable $this$forEach$iv = this.onClickListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
    }

    @NotNull
    public static final StatefulPresentation.StateMark<State> getSTATE_MARK() {
        return Companion.getSTATE_MARK();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\"\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/core/FeedbackButtonInlayPresentation$Companion;", "", "<init>", "()V", "STATE_MARK", "Lcom/intellij/codeInsight/hints/presentation/StatefulPresentation$StateMark;", "Lcom/intellij/ml/llm/core/FeedbackButtonInlayPresentation$State;", "getSTATE_MARK$annotations", "getSTATE_MARK", "()Lcom/intellij/codeInsight/hints/presentation/StatefulPresentation$StateMark;", "intellij.ml.llm.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StatefulPresentation.StateMark<State> getSTATE_MARK() {
            return STATE_MARK;
        }

        @JvmStatic
        public static /* synthetic */ void getSTATE_MARK$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000b\u001a\u00020\fH\u00d6\u0001J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/core/FeedbackButtonInlayPresentation$State;", "", "isInside", "", "<init>", "(Z)V", "()Z", "component1", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.ml.llm.core"})
    public static final class State {
        private final boolean isInside;

        public State(boolean isInside) {
            this.isInside = isInside;
        }

        public final boolean isInside() {
            return this.isInside;
        }

        public final boolean component1() {
            return this.isInside;
        }

        @NotNull
        public final State copy(boolean isInside) {
            return new State(isInside);
        }

        public static /* synthetic */ State copy$default(State state, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = state.isInside;
            }
            return state.copy(bl);
        }

        @NotNull
        public String toString() {
            return "State(isInside=" + this.isInside + ")";
        }

        public int hashCode() {
            return Boolean.hashCode(this.isInside);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state = (State)other;
            return this.isInside == state.isInside;
        }
    }
}

