/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core;

import com.intellij.ml.llm.core.LLMDocumentationSupport;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0003H'J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0017J\u0017\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0012\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0015R\u0012\u0010\u0005\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0016\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ml/llm/core/LLMDocumentationSupportWithBlockComments;", "Lcom/intellij/ml/llm/core/LLMDocumentationSupport;", "getDocComment", "Lcom/intellij/psi/PsiElement;", "element", "commentStart", "", "getCommentStart", "()Ljava/lang/String;", "commentEnd", "getCommentEnd", "isDocumentationStartsInsideTarget", "", "buildDocFromSuggestion", "suggestion", "containsCompleteDoc", "computeDocRange", "Lcom/intellij/openapi/util/TextRange;", "documentationTarget", "computeProcessingInlayOffset", "", "(Lcom/intellij/psi/PsiElement;)Ljava/lang/Integer;", "intellij.ml.llm.core"})
public interface LLMDocumentationSupportWithBlockComments
extends LLMDocumentationSupport {
    @RequiresReadLock
    @Nullable
    public PsiElement getDocComment(@NotNull PsiElement var1);

    @NotNull
    public String getCommentStart();

    @NotNull
    public String getCommentEnd();

    default public boolean isDocumentationStartsInsideTarget(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = this.findNearestDocumentationTarget(element);
        if (psiElement == null) {
            return false;
        }
        PsiElement target = psiElement;
        return target.getTextRange().getStartOffset() < element.getTextRange().getStartOffset();
    }

    @Override
    @NotNull
    default public String buildDocFromSuggestion(@NotNull String suggestion) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)suggestion, (String)"suggestion");
        int startIndex = StringsKt.indexOf$default((CharSequence)suggestion, (String)this.getCommentStart(), (int)0, (boolean)false, (int)6, null);
        if (startIndex < 0) {
            return "";
        }
        String string = suggestion.substring(startIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String docComment = string;
        int endIndex = StringsKt.indexOf$default((CharSequence)docComment, (String)this.getCommentEnd(), (int)this.getCommentStart().length(), (boolean)false, (int)4, null);
        if (endIndex < 0) {
            object = docComment + this.getCommentEnd();
        } else {
            String string2 = docComment.substring(0, endIndex + this.getCommentEnd().length());
            object = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        }
        return object;
    }

    @Override
    default public boolean containsCompleteDoc(@NotNull String suggestion) {
        Intrinsics.checkNotNullParameter((Object)suggestion, (String)"suggestion");
        int startIndex = StringsKt.indexOf$default((CharSequence)suggestion, (String)this.getCommentStart(), (int)0, (boolean)false, (int)6, null);
        if (startIndex < 0) {
            return false;
        }
        return StringsKt.indexOf$default((CharSequence)suggestion, (String)this.getCommentEnd(), (int)(startIndex + this.getCommentStart().length()), (boolean)false, (int)4, null) > 0;
    }

    @Override
    @RequiresReadLock
    @NotNull
    default public TextRange computeDocRange(@NotNull PsiElement documentationTarget) {
        Intrinsics.checkNotNullParameter((Object)documentationTarget, (String)"documentationTarget");
        PsiElement psiElement = this.getDocComment(documentationTarget);
        if (psiElement == null || (psiElement = psiElement.getTextRange()) == null) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            psiElement = textRange;
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"EMPTY_RANGE");
        }
        return psiElement;
    }

    @Override
    @Nullable
    default public Integer computeProcessingInlayOffset(@NotNull PsiElement documentationTarget) {
        Intrinsics.checkNotNullParameter((Object)documentationTarget, (String)"documentationTarget");
        PsiElement psiElement = this.getDocComment(documentationTarget);
        return psiElement != null ? Integer.valueOf(PsiTreeUtilKt.getStartOffset((PsiElement)psiElement)) : null;
    }
}

