/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core;

import com.intellij.ml.llm.core.OsRegistryConfig;
import com.intellij.ml.llm.core.OsRegistrySystemSetting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.system.CpuArch;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\tH\u0016J\u0018\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000e2\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u0018\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u0018\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000e2\u0006\u0010\n\u001a\u00020\u0003H\u0002J.\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000e2\u0006\u0010\n\u001a\u00020\u00032\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J(\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0002J \u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000e2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0015H\u0002J\u0018\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000e2\u0006\u0010\n\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ml/llm/core/OsRegistryConfigProvider;", "Lcom/intellij/ml/llm/core/OsRegistryConfig;", "configName", "", "<init>", "(Ljava/lang/String;)V", "keyRegex", "Lkotlin/text/Regex;", "isTrue", "", "key", "(Ljava/lang/String;)Ljava/lang/Boolean;", "defaultValue", "get", "Lcom/intellij/ml/llm/core/OsRegistrySystemSetting;", "getFromRegistry", "regValue", "getFromXdgConfig", "getFromDirectories", "dirs", "", "Ljava/io/File;", "configDirectoryPath", "getFromKeyFile", "it", "parseFile", "file", "getFromLibraryApplicationSupport", "Companion", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nOsRegistryConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OsRegistryConfig.kt\ncom/intellij/ml/llm/core/OsRegistryConfigProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,217:1\n1#2:218\n1#2:233\n1563#3:219\n1634#3,3:220\n1617#3,9:223\n1869#3:232\n1870#3:234\n1626#3:235\n774#3:236\n865#3,2:237\n1563#3:239\n1634#3,3:240\n1563#3:243\n1634#3,3:244\n1374#3:247\n1460#3,5:248\n1563#3:253\n1634#3,3:254\n13#4:257\n*S KotlinDebug\n*F\n+ 1 OsRegistryConfig.kt\ncom/intellij/ml/llm/core/OsRegistryConfigProvider\n*L\n101#1:233\n99#1:219\n99#1:220,3\n101#1:223,9\n101#1:232\n101#1:234\n101#1:235\n140#1:236\n140#1:237,2\n145#1:239\n145#1:240,3\n149#1:243\n149#1:244,3\n149#1:247\n149#1:248,5\n215#1:253\n215#1:254,3\n28#1:257\n*E\n"})
final class OsRegistryConfigProvider
implements OsRegistryConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String configName;
    @NotNull
    private final Regex keyRegex;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final String configXmlFilename = "config.xml";
    @NotNull
    private static final String etcXdgPath = "/etc/xdg/";

    public OsRegistryConfigProvider(@NotNull String configName) {
        Intrinsics.checkNotNullParameter((Object)configName, (String)"configName");
        this.configName = configName;
        if (!(!StringsKt.contains$default((CharSequence)this.configName, (char)' ', (boolean)false, (int)2, null))) {
            boolean bl = false;
            String string = "'" + this.configName + "' should not contain spaces";
            throw new IllegalArgumentException(string.toString());
        }
        this.keyRegex = new Regex("^\\w+$");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public Boolean isTrue(@NotNull String key) {
        OsRegistrySystemSetting<String> osSetting;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        OsRegistrySystemSetting<String> osRegistrySystemSetting = osSetting = this.get(key);
        Object object = osRegistrySystemSetting;
        if (osRegistrySystemSetting == null) return null;
        String string = ((OsRegistrySystemSetting)object).getValue();
        object = string;
        if (string == null) return null;
        String string2 = ((String)object).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        object = string2;
        if (string2 == null) return null;
        Boolean bl = StringsKt.toBooleanStrictOrNull((String)object);
        return bl;
    }

    @Override
    public boolean isTrue(@NotNull String key, boolean defaultValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        OsRegistrySystemSetting<String> osSetting = this.get(key);
        if (osSetting == null) {
            return defaultValue;
        }
        String string = osSetting.getValue().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        Boolean result2 = StringsKt.toBooleanStrictOrNull((String)string);
        if (result2 != null) {
            return result2;
        }
        logger.warn("Unknown value '" + osSetting.getValue() + "' from " + osSetting.getOsOriginLocation() + " (only 'true' or 'false' are recognized). Assume '" + defaultValue + "'");
        return defaultValue;
    }

    @Override
    @Nullable
    public OsRegistrySystemSetting<String> get(@NotNull String key) {
        OsRegistrySystemSetting<String> systemValue;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        CharSequence charSequence = key;
        if (!this.keyRegex.matches(charSequence)) {
            boolean bl = false;
            String string = "Key '" + key + "' does not match regex '" + this.keyRegex.getPattern() + "'";
            throw new IllegalArgumentException(string.toString());
        }
        OsRegistrySystemSetting<String> osRegistrySystemSetting = SystemInfo.isWindows ? this.getFromRegistry(key) : (SystemInfo.isLinux ? this.getFromXdgConfig(key) : (systemValue = SystemInfo.isMac ? this.getFromLibraryApplicationSupport(key) : null));
        if (systemValue != null) {
            logger.info("OS provided value for '" + key + "' is '" + systemValue.getValue() + "' in config '" + this.configName + "', origin=" + systemValue.getOsOriginLocation());
        } else {
            logger.info("OS provided value for '" + key + "' is not found");
        }
        return systemValue;
    }

    /*
     * WARNING - void declaration
     */
    private final OsRegistrySystemSetting<String> getFromRegistry(String regValue) {
        void $this$mapNotNullTo$iv$iv;
        Collection<String> collection;
        Object object;
        Iterable $this$mapTo$iv$iv;
        void $this$map$iv;
        String regKey = "SOFTWARE\\JetBrains\\" + this.configName;
        logger.debug("Looking for '" + regValue + "' in registry '" + regKey + "', is32Bit=" + CpuArch.isIntel32());
        Object object2 = new Pair[]{TuplesKt.to((Object)"HKLM_64", () -> OsRegistryConfigProvider.getFromRegistry$lambda$0(regKey, regValue)), TuplesKt.to((Object)"HKLM_32", () -> OsRegistryConfigProvider.getFromRegistry$lambda$1(regKey, regValue)), TuplesKt.to((Object)"HKCU_64", () -> OsRegistryConfigProvider.getFromRegistry$lambda$2(regKey, regValue)), TuplesKt.to((Object)"HKCU_32", () -> OsRegistryConfigProvider.getFromRegistry$lambda$3(regKey, regValue))};
        List uris = CollectionsKt.listOf((Object[])object2);
        object2 = uris;
        String string = regValue;
        Logger logger = OsRegistryConfigProvider.logger;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            object = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(OsRegistryConfigProvider.getFromRegistry$readable((Pair<String, ? extends Function0<String>>)it, regKey, regValue));
        }
        collection = (List)destination$iv$iv;
        logger.info("Looking for '" + string + "' value in " + (List)collection);
        Iterable $this$mapNotNull$iv = uris;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            OsRegistrySystemSetting<String> osRegistrySystemSetting;
            String string2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            Pair it = (Pair)element$iv$iv;
            boolean bl2 = false;
            try {
                OsRegistryConfigProvider.logger.debug("Searching for '" + OsRegistryConfigProvider.getFromRegistry$readable((Pair<String, ? extends Function0<String>>)it, regKey, regValue) + "' in registry");
                string2 = (String)((Function0)it.getSecond()).invoke();
            }
            catch (Throwable t) {
                if (t instanceof Win32Exception) {
                    if (((Win32Exception)t).getErrorCode() == 2) {
                        OsRegistryConfigProvider.logger.debug("registry entry not found at " + OsRegistryConfigProvider.getFromRegistry$readable((Pair<String, ? extends Function0<String>>)it, regKey, regValue));
                    } else {
                        OsRegistryConfigProvider.logger.warn("Failed to get registry entry at '" + OsRegistryConfigProvider.getFromRegistry$readable((Pair<String, ? extends Function0<String>>)it, regKey, regValue) + "', HRESULT=" + ((Win32Exception)t).getHR().intValue(), t);
                    }
                } else {
                    OsRegistryConfigProvider.logger.warn("Failed to get registry entry at '" + OsRegistryConfigProvider.getFromRegistry$readable((Pair<String, ? extends Function0<String>>)it, regKey, regValue) + "'", t);
                }
                string2 = null;
            }
            String uri = string2;
            if (uri != null) {
                OsRegistryConfigProvider.logger.info("Found registry entry at '" + OsRegistryConfigProvider.getFromRegistry$readable((Pair<String, ? extends Function0<String>>)it, regKey, regValue) + "', value='" + uri + "'");
                osRegistrySystemSetting = new OsRegistrySystemSetting<String>(uri, OsRegistryConfigProvider.getFromRegistry$readable((Pair<String, ? extends Function0<String>>)it, regKey, regValue));
            } else {
                osRegistrySystemSetting = null;
            }
            if (osRegistrySystemSetting == null) continue;
            OsRegistrySystemSetting<String> it$iv$iv = osRegistrySystemSetting;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (OsRegistrySystemSetting)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final OsRegistrySystemSetting<String> getFromXdgConfig(String key) {
        Collection<File> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String it;
        void $this$filterTo$iv$iv;
        String configDirectoryPath = OsRegistryConfigProvider.Companion.getConfigSubDirectoryPath(this.configName);
        Map map2 = EnvironmentUtil.getEnvironmentMap();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getEnvironmentMap(...)");
        Map env = map2;
        String home = System.getProperty("user.home");
        Object[] objectArray = new String[2];
        objectArray[0] = etcXdgPath;
        Object object = (String)env.get("XDG_CONFIG_HOME");
        if (object == null) {
            object = home + "/.config/";
        }
        objectArray[1] = object;
        List configLookupDirs = CollectionsKt.toMutableList((Collection)CollectionsKt.listOf((Object[])objectArray));
        String string = (String)env.get("XDG_CONFIG_DIRS");
        if (string == null) {
            string = "";
        }
        String[] stringArray = new String[]{":"};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List xdgConfigDirs = (List)destination$iv$iv;
        configLookupDirs.addAll(xdgConfigDirs);
        logger.debug("Looking for " + key + " in xdg config dirs: " + configLookupDirs);
        $this$filter$iv = configLookupDirs;
        String string2 = key;
        OsRegistryConfigProvider osRegistryConfigProvider = this;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new File(it));
        }
        collection = (List)destination$iv$iv;
        return osRegistryConfigProvider.getFromDirectories(string2, (List<? extends File>)collection, configDirectoryPath);
    }

    /*
     * WARNING - void declaration
     */
    private final OsRegistrySystemSetting<String> getFromDirectories(String key, List<? extends File> dirs, String configDirectoryPath) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        File it;
        boolean bl;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = dirs;
        boolean bl2 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            bl = false;
            collection.add(FilesKt.resolve((File)it, (String)configDirectoryPath));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean bl3 = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (File)element$iv$iv;
            bl = false;
            Object[] objectArray = new File[]{FilesKt.resolve((File)it, (String)key), FilesKt.resolve((File)it, (String)configXmlFilename)};
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List allPossibleLocations = (List)destination$iv$iv;
        logger.info("Looking for '" + key + "' value in " + allPossibleLocations);
        for (File file : dirs) {
            OsRegistrySystemSetting<String> valueFromKeyFile = this.getFromKeyFile(file, configDirectoryPath, key);
            if (valueFromKeyFile != null) {
                return valueFromKeyFile;
            }
            File configJsonFile = new File(new File(file, configDirectoryPath), configXmlFilename);
            OsRegistrySystemSetting<String> valueFromJsonFile = this.parseFile(key, configJsonFile);
            if (valueFromJsonFile == null) continue;
            return valueFromJsonFile;
        }
        return null;
    }

    private final OsRegistrySystemSetting<String> getFromKeyFile(File it, String configDirectoryPath, String key) {
        File keyFile = new File(new File(it, configDirectoryPath), key);
        logger.debug("Trying to get '" + key + "' from file '" + keyFile.getCanonicalPath() + "'");
        if (!keyFile.exists()) {
            logger.debug("File '" + keyFile.getCanonicalPath() + "' does not exist.");
            return null;
        }
        try {
            String keyFileContents = ((Object)StringsKt.trim((CharSequence)FilesKt.readText$default((File)keyFile, null, (int)1, null))).toString();
            logger.info("Found '" + keyFile.getCanonicalPath() + "' from file '" + keyFile.getCanonicalPath() + "'. value='" + keyFileContents + "'");
            return new OsRegistrySystemSetting<String>(keyFileContents, keyFile.getCanonicalPath());
        }
        catch (Throwable e) {
            logger.warn("Failed to read setting '" + key + "' from '" + keyFile.getCanonicalPath() + "'", e);
            return null;
        }
    }

    private final OsRegistrySystemSetting<String> parseFile(String key, File file) {
        OsRegistrySystemSetting<String> osRegistrySystemSetting;
        logger.debug("Trying to get key '" + key + "' from file '" + file.getCanonicalPath() + "'");
        if (!file.exists()) {
            logger.debug("File '" + file.getCanonicalPath() + "' does not exist.");
            return null;
        }
        try {
            OsRegistrySystemSetting<String> osRegistrySystemSetting2;
            Element element = JDOMUtil.load((File)file);
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"load(...)");
            Element root = element;
            String resultValue = root.getChild(key).getValue();
            if (resultValue != null) {
                logger.info("Found '" + key + "' in file '" + file.getCanonicalPath() + "'. Value='" + resultValue + "'");
                osRegistrySystemSetting2 = new OsRegistrySystemSetting<String>(resultValue, file.getCanonicalPath());
            } else {
                osRegistrySystemSetting2 = null;
            }
            osRegistrySystemSetting = osRegistrySystemSetting2;
        }
        catch (Throwable t) {
            logger.warn("Failed to read json for '" + key + "' at location '" + file + "'", t);
            osRegistrySystemSetting = null;
        }
        return osRegistrySystemSetting;
    }

    /*
     * WARNING - void declaration
     */
    private final OsRegistrySystemSetting<String> getFromLibraryApplicationSupport(String key) {
        Collection<File> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String home = System.getProperty("user.home");
        Object[] objectArray = new String[]{"/", home + "/"};
        List dirs = CollectionsKt.listOf((Object[])objectArray);
        String configDirectoryPath = "Library/Application Support/JetBrains/" + this.configName;
        Iterable iterable = dirs;
        String string = key;
        OsRegistryConfigProvider osRegistryConfigProvider = this;
        boolean $i$f$map = false;
        void var7_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new File((String)it));
        }
        collection = (List)destination$iv$iv;
        return osRegistryConfigProvider.getFromDirectories(string, (List<? extends File>)collection, configDirectoryPath);
    }

    private static final String getFromRegistry$lambda$0(String $regKey, String $regValue) {
        return Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)$regKey, (String)$regValue, (int)256);
    }

    private static final String getFromRegistry$lambda$1(String $regKey, String $regValue) {
        return Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)$regKey, (String)$regValue, (int)512);
    }

    private static final String getFromRegistry$lambda$2(String $regKey, String $regValue) {
        return Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)$regKey, (String)$regValue, (int)256);
    }

    private static final String getFromRegistry$lambda$3(String $regKey, String $regValue) {
        return Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)$regKey, (String)$regValue, (int)512);
    }

    private static final String getFromRegistry$readable(Pair<String, ? extends Function0<String>> $this$getFromRegistry_u24readable, String regKey, String $regValue) {
        return $this$getFromRegistry_u24readable.getFirst() + "\\" + regKey + "\\" + $regValue;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(OsRegistryConfigProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        OsRegistryConfigProvider.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ml/llm/core/OsRegistryConfigProvider$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "configXmlFilename", "", "etcXdgPath", "getConfigSubDirectoryPath", "configName", "intellij.ml.llm.core"})
    public static final class Companion {
        private Companion() {
        }

        private final String getConfigSubDirectoryPath(String configName) {
            return "JetBrains/" + configName;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

