/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.models;

import ai.grazie.model.llm.prompt.LLMPromptID;
import com.intellij.ml.llm.core.LLMPromptsKt;
import com.intellij.ml.llm.core.models.CompletionUtilsKt;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001a\u001bB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ml/llm/core/models/LlmPromptPolicy;", "", "promptId", "Lai/grazie/model/llm/prompt/LLMPromptID;", "modelCategory", "Lcom/intellij/ml/llm/core/models/LlmPromptPolicy$Category;", "allowThirdParty", "", "<init>", "(Lai/grazie/model/llm/prompt/LLMPromptID;Lcom/intellij/ml/llm/core/models/LlmPromptPolicy$Category;Z)V", "getPromptId", "()Lai/grazie/model/llm/prompt/LLMPromptID;", "getModelCategory", "()Lcom/intellij/ml/llm/core/models/LlmPromptPolicy$Category;", "getAllowThirdParty", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "Category", "Companion", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nLlmPromptPolicy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LlmPromptPolicy.kt\ncom/intellij/ml/llm/core/models/LlmPromptPolicy\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n1208#2,2:66\n1236#2,4:68\n*S KotlinDebug\n*F\n+ 1 LlmPromptPolicy.kt\ncom/intellij/ml/llm/core/models/LlmPromptPolicy\n*L\n50#1:66,2\n50#1:68,4\n*E\n"})
public final class LlmPromptPolicy {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final LLMPromptID promptId;
    @NotNull
    private final Category modelCategory;
    private final boolean allowThirdParty;
    @NotNull
    private static final List<LlmPromptPolicy> llmPromptPolicies;
    @NotNull
    private static final Map<LLMPromptID, LlmPromptPolicy> promptPoliciesMap;

    public LlmPromptPolicy(@NotNull LLMPromptID promptId, @NotNull Category modelCategory, boolean allowThirdParty) {
        Intrinsics.checkNotNullParameter((Object)promptId, (String)"promptId");
        Intrinsics.checkNotNullParameter((Object)((Object)modelCategory), (String)"modelCategory");
        this.promptId = promptId;
        this.modelCategory = modelCategory;
        this.allowThirdParty = allowThirdParty;
    }

    public /* synthetic */ LlmPromptPolicy(LLMPromptID lLMPromptID, Category category, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            category = Category.SMART;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        this(lLMPromptID, category, bl);
    }

    @NotNull
    public final LLMPromptID getPromptId() {
        return this.promptId;
    }

    @NotNull
    public final Category getModelCategory() {
        return this.modelCategory;
    }

    public final boolean getAllowThirdParty() {
        return this.allowThirdParty;
    }

    @NotNull
    public final LLMPromptID component1() {
        return this.promptId;
    }

    @NotNull
    public final Category component2() {
        return this.modelCategory;
    }

    public final boolean component3() {
        return this.allowThirdParty;
    }

    @NotNull
    public final LlmPromptPolicy copy(@NotNull LLMPromptID promptId, @NotNull Category modelCategory, boolean allowThirdParty) {
        Intrinsics.checkNotNullParameter((Object)promptId, (String)"promptId");
        Intrinsics.checkNotNullParameter((Object)((Object)modelCategory), (String)"modelCategory");
        return new LlmPromptPolicy(promptId, modelCategory, allowThirdParty);
    }

    public static /* synthetic */ LlmPromptPolicy copy$default(LlmPromptPolicy llmPromptPolicy, LLMPromptID lLMPromptID, Category category, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            lLMPromptID = llmPromptPolicy.promptId;
        }
        if ((n & 2) != 0) {
            category = llmPromptPolicy.modelCategory;
        }
        if ((n & 4) != 0) {
            bl = llmPromptPolicy.allowThirdParty;
        }
        return llmPromptPolicy.copy(lLMPromptID, category, bl);
    }

    @NotNull
    public String toString() {
        return "LlmPromptPolicy(promptId=" + this.promptId + ", modelCategory=" + this.modelCategory + ", allowThirdParty=" + this.allowThirdParty + ")";
    }

    public int hashCode() {
        int result2 = this.promptId.hashCode();
        result2 = result2 * 31 + this.modelCategory.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.allowThirdParty);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LlmPromptPolicy)) {
            return false;
        }
        LlmPromptPolicy llmPromptPolicy = (LlmPromptPolicy)other;
        if (!Intrinsics.areEqual((Object)this.promptId, (Object)llmPromptPolicy.promptId)) {
            return false;
        }
        if (this.modelCategory != llmPromptPolicy.modelCategory) {
            return false;
        }
        return this.allowThirdParty == llmPromptPolicy.allowThirdParty;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$associateByTo$iv$iv;
        Companion = new Companion(null);
        Object[] objectArray = new LlmPromptPolicy[]{new LlmPromptPolicy(LLMPromptsKt.getNAME_SUGGESTION_PROMPT_ID(), Category.FAST, false, 4, null), new LlmPromptPolicy(LLMPromptsKt.getCHAT_TITLE_GENERATION_PROMPT_ID(), Category.FAST, false, 4, null), new LlmPromptPolicy(LLMPromptsKt.getCLASSIFY_USER_PROMPT_ID(), Category.FAST, false, 4, null), new LlmPromptPolicy(com.intellij.ml.llm.tasks.LLMPromptsKt.getCLASSIFY_USERS_PROMPT_ID(), Category.FAST, false, 4, null), new LlmPromptPolicy(com.intellij.ml.llm.tasks.LLMPromptsKt.getCLASSIFY_CONTEXT_ITEM_PROMPT_ID(), Category.FAST, false, 4, null), new LlmPromptPolicy(com.intellij.ml.llm.tasks.LLMPromptsKt.getSUMMARIZE_CONTEXT_ITEM_PROMPT_ID(), Category.FAST, false, 4, null), new LlmPromptPolicy(com.intellij.ml.llm.tasks.LLMPromptsKt.getSIMPLIFY_AND_DECOMPOSE_REQUEST_PROMPT_ID(), Category.FAST, false, 4, null), new LlmPromptPolicy(LLMPromptsKt.getSHELVE_NAME_PROMPT_ID(), Category.FAST, false, 4, null), new LlmPromptPolicy(LLMPromptsKt.getIMAGE_CODE_PROMPT_ID(), Category.FAST, false, 4, null), new LlmPromptPolicy(LLMPromptsKt.getREWORD_COMMIT_PROMPT_ID(), Category.SMART, false), new LlmPromptPolicy(LLMPromptsKt.getRESOLVE_CONFLICTS_PROMPT_ID(), Category.SMART, false), new LlmPromptPolicy(LLMPromptsKt.getCONVERSION_OF_FILE_PROMPT_ID(), null, false, 2, null), new LlmPromptPolicy(LLMPromptsKt.getCONVERSION_ON_PASTE_PROMPT_ID(), null, false, 2, null), new LlmPromptPolicy(LLMPromptsKt.getCOMPLETION_INLINE_PROMPT_ID(), Category.COMPLETION, false, 4, null), new LlmPromptPolicy(LLMPromptsKt.getAI_SELF_REVIEW(), Category.SMART, false)};
        llmPromptPolicies = CollectionsKt.listOf((Object[])objectArray);
        Iterable $this$associateBy$iv = llmPromptPolicies;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            LlmPromptPolicy llmPromptPolicy = (LlmPromptPolicy)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.promptId, element$iv$iv);
        }
        promptPoliciesMap = destination$iv$iv;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/llm/core/models/LlmPromptPolicy$Category;", "", "<init>", "(Ljava/lang/String;I)V", "SMART", "FAST", "COMPLETION", "intellij.ml.llm.core"})
    public static final class Category
    extends Enum<Category> {
        public static final /* enum */ Category SMART = new Category();
        public static final /* enum */ Category FAST = new Category();
        public static final /* enum */ Category COMPLETION = new Category();
        private static final /* synthetic */ Category[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Category[] values() {
            return (Category[])$VALUES.clone();
        }

        public static Category valueOf(String value) {
            return Enum.valueOf(Category.class, value);
        }

        @NotNull
        public static EnumEntries<Category> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = categoryArray = new Category[]{Category.SMART, Category.FAST, Category.COMPLETION};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\tR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/core/models/LlmPromptPolicy$Companion;", "", "<init>", "()V", "llmPromptPolicies", "", "Lcom/intellij/ml/llm/core/models/LlmPromptPolicy;", "promptPoliciesMap", "", "Lai/grazie/model/llm/prompt/LLMPromptID;", "resolveCategory", "Lcom/intellij/ml/llm/core/models/LlmPromptPolicy$Category;", "promptId", "allowsThirdParty", "", "intellij.ml.llm.core"})
    @SourceDebugExtension(value={"SMAP\nLlmPromptPolicy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LlmPromptPolicy.kt\ncom/intellij/ml/llm/core/models/LlmPromptPolicy$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n1#2:66\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Category resolveCategory(@NotNull LLMPromptID promptId) {
            Category category;
            Intrinsics.checkNotNullParameter((Object)promptId, (String)"promptId");
            LlmPromptPolicy llmPromptPolicy = (LlmPromptPolicy)promptPoliciesMap.get(promptId);
            if (llmPromptPolicy != null && (category = llmPromptPolicy.getModelCategory()) != null) {
                Category it = category;
                boolean bl = false;
                return it;
            }
            return StringsKt.startsWith$default((String)promptId.getId(), (String)"ij.fast.chat", (boolean)false, (int)2, null) ? Category.FAST : (CompletionUtilsKt.isCompletionPrompt(promptId) ? Category.COMPLETION : Category.SMART);
        }

        public final boolean allowsThirdParty(@NotNull LLMPromptID promptId) {
            Intrinsics.checkNotNullParameter((Object)promptId, (String)"promptId");
            LlmPromptPolicy llmPromptPolicy = (LlmPromptPolicy)promptPoliciesMap.get(promptId);
            return llmPromptPolicy != null ? llmPromptPolicy.getAllowThirdParty() : true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

