/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.patching;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\u0002+,B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0003J\u0006\u0010\u001f\u001a\u00020\u001dJ\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010#\u001a\n $*\u0004\u0018\u00010\u00160\u00162\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010%\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010&\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010'\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0014\u0010(\u001a\u00060\rR\u00020\u00002\u0006\u0010)\u001a\u00020\u0007H\u0002J\b\u0010*\u001a\u00020\u001dH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\f\u0012\b\u0012\u00060\rR\u00020\u00000\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0018\u00010\rR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0015\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0012\u00a8\u0006-"}, d2={"Lcom/intellij/ml/llm/core/patching/AITextPatcher;", "", "initialText", "", "<init>", "(Ljava/lang/CharSequence;)V", "state", "Lcom/intellij/ml/llm/core/patching/AITextPatcher$State;", "offset", "", "lastModificationOffset", "chunks", "", "Lcom/intellij/ml/llm/core/patching/AITextPatcher$Chunk;", "currentChunk", "debug", "", "getDebug", "()Z", "setDebug", "(Z)V", "patchedText", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getPatchedText", "()Ljava/lang/StringBuilder;", "hasModifications", "getHasModifications", "appendChunkText", "", "chunk", "finishPatch", "handle", "ch", "", "addToChunk", "kotlin.jvm.PlatformType", "goToStateByFirstChar", "goToNoChunkState", "goToChunkState", "addChunk", "fromState", "applyChunks", "State", "Chunk", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nAITextPatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AITextPatcher.kt\ncom/intellij/ml/llm/core/patching/AITextPatcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,271:1\n1#2:272\n*E\n"})
public final class AITextPatcher {
    @NotNull
    private State state;
    private int offset;
    private int lastModificationOffset;
    @NotNull
    private List<Chunk> chunks;
    @Nullable
    private Chunk currentChunk;
    private boolean debug;
    @NotNull
    private final StringBuilder patchedText;

    public AITextPatcher(@NotNull CharSequence initialText) {
        Intrinsics.checkNotNullParameter((Object)initialText, (String)"initialText");
        this.state = State.MaybeMinusPatchStart;
        this.chunks = new ArrayList();
        this.patchedText = new StringBuilder(initialText);
    }

    public final boolean getDebug() {
        return this.debug;
    }

    public final void setDebug(boolean bl) {
        this.debug = bl;
    }

    @NotNull
    public final StringBuilder getPatchedText() {
        return this.patchedText;
    }

    public final boolean getHasModifications() {
        return this.lastModificationOffset > 0;
    }

    public final void appendChunkText(@NotNull CharSequence chunk) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        for (int i = 0; i < chunk.length(); ++i) {
            char ch = chunk.charAt(i);
            this.handle(ch);
        }
    }

    public final void finishPatch() {
        this.currentChunk = null;
        this.applyChunks();
    }

    private final void handle(char ch) {
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1: {
                if (ch == '-') {
                    this.state = State.MinusPatchStart;
                } else {
                    this.goToStateByFirstChar(ch);
                    if (this.state == State.Skip) {
                        this.state = State.SkipAndThenMaybeMinusPatchStart;
                    }
                }
                return;
            }
            case 2: {
                if (ch == '\n') {
                    this.state = State.MaybeMinusPatchStart;
                }
                return;
            }
            case 3: {
                if (ch == '-') {
                    this.state = State.MinusMinusPatchStart;
                    return;
                }
                this.goToChunkState(State.Remove);
                Object object = this.addToChunk(ch);
                break;
            }
            case 4: {
                if (ch == '-') {
                    this.state = State.MinusMinusMinusPatchStart;
                    return;
                }
                this.goToChunkState(State.Remove);
                this.addToChunk('-');
                Object object = this.addToChunk(ch);
                break;
            }
            case 5: {
                if (ch == '\n') {
                    this.state = State.MaybePlusPatchStart;
                }
                return;
            }
            case 6: {
                if (ch == '+') {
                    this.state = State.PlusPatchStart;
                } else {
                    this.goToStateByFirstChar(ch);
                }
                return;
            }
            case 7: {
                if (ch == '+') {
                    this.state = State.PlusPlusPatchStart;
                    return;
                }
                this.goToChunkState(State.Add);
                Object object = this.addToChunk(ch);
                break;
            }
            case 8: {
                if (ch == '+') {
                    this.state = State.PlusPlusPlusPatchStart;
                    return;
                }
                this.goToChunkState(State.Add);
                this.addToChunk('+');
                Object object = this.addToChunk(ch);
                break;
            }
            case 9: {
                Object object = Unit.INSTANCE;
                break;
            }
            case 10: {
                Object object = Unit.INSTANCE;
                break;
            }
            case 11: {
                this.goToStateByFirstChar(ch);
                return;
            }
            case 12: 
            case 13: 
            case 14: {
                Object object = this.addToChunk(ch);
                break;
            }
            case 15: {
                Object object = Unit.INSTANCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (ch == '\n') {
            this.goToNoChunkState(State.LineStart);
            this.applyChunks();
        }
    }

    private final StringBuilder addToChunk(char ch) {
        Chunk chunk = this.currentChunk;
        Intrinsics.checkNotNull((Object)chunk);
        return chunk.getBuffer().append(ch);
    }

    private final void goToStateByFirstChar(char ch) {
        switch (ch) {
            case '+': {
                this.goToChunkState(State.Add);
                break;
            }
            case '-': {
                this.goToChunkState(State.Remove);
                break;
            }
            case ' ': {
                this.goToChunkState(State.Unmodified);
                break;
            }
            case '/': {
                this.goToNoChunkState(State.Skip);
                break;
            }
            case '@': {
                this.goToNoChunkState(State.HunkHeader);
                break;
            }
            case '\n': {
                this.goToNoChunkState(State.LineStart);
                break;
            }
            default: {
                this.goToNoChunkState(State.Skip);
            }
        }
    }

    private final void goToNoChunkState(State state) {
        if (this.state != state) {
            this.state = state;
            this.currentChunk = null;
        }
    }

    private final void goToChunkState(State state) {
        if (this.state != state) {
            this.state = state;
            this.addChunk(state);
        }
    }

    private final Chunk addChunk(State fromState) {
        Chunk chunk;
        Chunk chunk2;
        Chunk $this$addChunk_u24lambda_u240 = chunk2 = new Chunk();
        boolean bl = false;
        $this$addChunk_u24lambda_u240.setFromState(fromState);
        this.currentChunk = chunk = chunk2;
        this.chunks.add(chunk);
        return chunk;
    }

    private final void applyChunks() {
        block9: {
            for (Chunk chunk : this.chunks) {
                int it;
                Integer n;
                if (this.debug) {
                    System.out.println((Object)"===");
                    n = StringsKt.lastIndexOf$default((CharSequence)this.patchedText, (char)'\n', (int)(this.offset - 1), (boolean)false, (int)4, null);
                    it = ((Number)n).intValue();
                    boolean bl = false;
                    Integer n2 = it >= 0 ? n : null;
                    if (n2 != null) {
                        it = ((Number)n2).intValue();
                        boolean bl2 = false;
                        System.out.print(this.patchedText.subSequence(it + 1, this.offset));
                    }
                    String string = (switch (WhenMappings.$EnumSwitchMapping$0[chunk.getFromState().ordinal()]) {
                        case 12 -> "+";
                        case 13 -> "-";
                        case 14 -> "~";
                        default -> "?";
                    }) + chunk.getBuffer();
                    System.out.print((Object)string);
                }
                chunk.apply();
                if (!this.debug) continue;
                n = StringsKt.indexOf$default((CharSequence)this.patchedText, (char)'\n', (int)this.offset, (boolean)false, (int)4, null);
                it = ((Number)n).intValue();
                boolean bl = false;
                Integer n3 = it >= 0 ? n : null;
                if (n3 != null) {
                    it = ((Number)n3).intValue();
                    boolean bl3 = false;
                    System.out.print(this.patchedText.subSequence(this.offset, it + 1));
                }
                System.out.println((Object)"===");
            }
            this.chunks.clear();
            Chunk chunk = this.currentChunk;
            if (chunk == null) break block9;
            Chunk it = chunk;
            boolean bl = false;
            StringsKt.clear((StringBuilder)it.getBuffer());
            this.chunks.add(it);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0002\b\b\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000f\u001a\u00020\u0010J&\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J&\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J\u0018\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0013H\u0002J\u0018\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0013H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0015\u0010\n\u001a\u00060\u000bj\u0002`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ml/llm/core/patching/AITextPatcher$Chunk;", "", "<init>", "(Lcom/intellij/ml/llm/core/patching/AITextPatcher;)V", "fromState", "Lcom/intellij/ml/llm/core/patching/AITextPatcher$State;", "getFromState", "()Lcom/intellij/ml/llm/core/patching/AITextPatcher$State;", "setFromState", "(Lcom/intellij/ml/llm/core/patching/AITextPatcher$State;)V", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getBuffer", "()Ljava/lang/StringBuilder;", "apply", "", "findMatch", "Lkotlin/Pair;", "", "patchedText", "", "offset", "findMatchSlow", "text", "expandToLineStart", "s", "startIndex", "expandToLineEnd", "intellij.ml.llm.core"})
    @SourceDebugExtension(value={"SMAP\nAITextPatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AITextPatcher.kt\ncom/intellij/ml/llm/core/patching/AITextPatcher$Chunk\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,271:1\n1#2:272\n*E\n"})
    private final class Chunk {
        public State fromState;
        @NotNull
        private final StringBuilder buffer = new StringBuilder();

        @NotNull
        public final State getFromState() {
            State state = this.fromState;
            if (state != null) {
                return state;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"fromState");
            return null;
        }

        public final void setFromState(@NotNull State state) {
            Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"<set-?>");
            this.fromState = state;
        }

        @NotNull
        public final StringBuilder getBuffer() {
            return this.buffer;
        }

        public final void apply() {
            switch (WhenMappings.$EnumSwitchMapping$0[this.getFromState().ordinal()]) {
                case 1: {
                    AITextPatcher.this.getPatchedText().insert(AITextPatcher.this.offset, this.buffer);
                    AITextPatcher.this.offset = AITextPatcher.this.offset + this.buffer.length();
                    AITextPatcher.this.lastModificationOffset = AITextPatcher.this.offset;
                    break;
                }
                case 2: {
                    Pair<Integer, Integer> match;
                    Pair<Integer, Integer> pair = this.findMatch(AITextPatcher.this.getPatchedText(), AITextPatcher.this.offset);
                    if (pair == null) {
                        Integer n = AITextPatcher.this.lastModificationOffset;
                        AITextPatcher aITextPatcher = AITextPatcher.this;
                        int it = ((Number)n).intValue();
                        boolean bl = false;
                        Integer n2 = it != aITextPatcher.offset ? n : null;
                        if (n2 != null) {
                            n = n2;
                            aITextPatcher = AITextPatcher.this;
                            it = ((Number)n).intValue();
                            boolean bl2 = false;
                            pair = this.findMatch(aITextPatcher.getPatchedText(), it);
                        } else {
                            pair = null;
                        }
                    }
                    Pair<Integer, Integer> pair2 = match = pair;
                    if (pair2 != null) {
                        Pair<Integer, Integer> pair3 = pair2;
                        AITextPatcher aITextPatcher = AITextPatcher.this;
                        Pair<Integer, Integer> it = pair3;
                        boolean bl = false;
                        aITextPatcher.getPatchedText().delete(((Number)it.getFirst()).intValue(), ((Number)it.getSecond()).intValue());
                        aITextPatcher.offset = ((Number)it.getFirst()).intValue();
                        aITextPatcher.lastModificationOffset = ((Number)it.getFirst()).intValue();
                    }
                    break;
                }
                case 3: {
                    Pair<Integer, Integer> pair = this.findMatch(AITextPatcher.this.getPatchedText(), AITextPatcher.this.offset);
                    if (pair != null) {
                        Pair<Integer, Integer> pair4 = pair;
                        AITextPatcher aITextPatcher = AITextPatcher.this;
                        Pair<Integer, Integer> it = pair4;
                        boolean bl = false;
                        aITextPatcher.offset = ((Number)it.getSecond()).intValue();
                    }
                    break;
                }
            }
        }

        private final Pair<Integer, Integer> findMatch(CharSequence patchedText, int offset) {
            if (StringsKt.startsWith$default((CharSequence)patchedText, (CharSequence)this.buffer, (int)offset, (boolean)false, (int)4, null)) {
                return new Pair((Object)offset, (Object)(offset + this.buffer.length()));
            }
            return this.findMatchSlow(patchedText, offset);
        }

        private final Pair<Integer, Integer> findMatchSlow(CharSequence text, int offset) {
            int lineStartIndex;
            int lineEndIndex;
            CharSequence trimmed = StringsKt.trim((CharSequence)this.buffer);
            if (trimmed.length() == 0) {
                return null;
            }
            int searchAt = offset;
            String searchString = ((Object)trimmed).toString();
            while (true) {
                int index;
                if ((index = StringsKt.indexOf$default((CharSequence)text, (String)searchString, (int)searchAt, (boolean)false, (int)4, null)) < 0) {
                    return null;
                }
                int endIndex = index + searchString.length();
                lineEndIndex = this.expandToLineEnd(text, endIndex);
                if (lineEndIndex < 0) {
                    searchAt = endIndex + 1;
                    continue;
                }
                lineStartIndex = this.expandToLineStart(text, index);
                if (lineStartIndex >= 0) break;
                searchAt = lineEndIndex;
            }
            return new Pair((Object)lineStartIndex, (Object)lineEndIndex);
        }

        private final int expandToLineStart(CharSequence s, int startIndex) {
            for (int i = startIndex - 1; -1 < i; --i) {
                char ch = s.charAt(i);
                if (!CharsKt.isWhitespace((char)ch)) {
                    return -1;
                }
                if (ch != '\n') continue;
                return i + 1;
            }
            return 0;
        }

        private final int expandToLineEnd(CharSequence s, int startIndex) {
            int n = s.length();
            for (int i = startIndex; i < n; ++i) {
                char ch = s.charAt(i);
                if (!CharsKt.isWhitespace((char)ch)) {
                    return -1;
                }
                if (ch != '\n') continue;
                return i + 1;
            }
            return s.length();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[State.values().length];
                try {
                    nArray[State.Add.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[State.Remove.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[State.Unmodified.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0012\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/core/patching/AITextPatcher$State;", "", "<init>", "(Ljava/lang/String;I)V", "MaybeMinusPatchStart", "SkipAndThenMaybeMinusPatchStart", "MinusPatchStart", "MinusMinusPatchStart", "MinusMinusMinusPatchStart", "MaybePlusPatchStart", "PlusPatchStart", "PlusPlusPatchStart", "PlusPlusPlusPatchStart", "HunkHeader", "LineStart", "Add", "Remove", "Unmodified", "Skip", "intellij.ml.llm.core"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State MaybeMinusPatchStart = new State();
        public static final /* enum */ State SkipAndThenMaybeMinusPatchStart = new State();
        public static final /* enum */ State MinusPatchStart = new State();
        public static final /* enum */ State MinusMinusPatchStart = new State();
        public static final /* enum */ State MinusMinusMinusPatchStart = new State();
        public static final /* enum */ State MaybePlusPatchStart = new State();
        public static final /* enum */ State PlusPatchStart = new State();
        public static final /* enum */ State PlusPlusPatchStart = new State();
        public static final /* enum */ State PlusPlusPlusPatchStart = new State();
        public static final /* enum */ State HunkHeader = new State();
        public static final /* enum */ State LineStart = new State();
        public static final /* enum */ State Add = new State();
        public static final /* enum */ State Remove = new State();
        public static final /* enum */ State Unmodified = new State();
        public static final /* enum */ State Skip = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.MaybeMinusPatchStart, State.SkipAndThenMaybeMinusPatchStart, State.MinusPatchStart, State.MinusMinusPatchStart, State.MinusMinusMinusPatchStart, State.MaybePlusPatchStart, State.PlusPatchStart, State.PlusPlusPatchStart, State.PlusPlusPlusPatchStart, State.HunkHeader, State.LineStart, State.Add, State.Remove, State.Unmodified, State.Skip};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[State.values().length];
            try {
                nArray[State.MaybeMinusPatchStart.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.SkipAndThenMaybeMinusPatchStart.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.MinusPatchStart.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.MinusMinusPatchStart.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.MinusMinusMinusPatchStart.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.MaybePlusPatchStart.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.PlusPatchStart.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.PlusPlusPatchStart.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.PlusPlusPlusPatchStart.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.HunkHeader.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.LineStart.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.Add.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.Remove.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.Unmodified.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.Skip.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

