/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.promptlog;

import com.intellij.ml.llm.core.httpClient.AiaHttpClientCallBody;
import com.intellij.ml.llm.core.httpClient.AiaHttpClientCallEvent;
import com.intellij.ml.llm.core.promptlog.CleanUp;
import com.intellij.ml.llm.core.promptlog.CountingOutputStream;
import com.intellij.ml.llm.core.promptlog.FileDataOutputStreamProvider;
import com.intellij.ml.llm.core.promptlog.LLMPromptLogHelper;
import com.intellij.ml.llm.core.promptlog.LLMPromptLogger;
import com.intellij.ml.llm.core.promptlog.LLMPromptLoggerKt;
import com.intellij.ml.llm.core.promptlog.OutputStreamProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.invoke.LambdaMetafactory;
import java.net.URL;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0086@\u00a2\u0006\u0002\u0010\u0010J\u001c\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\rH\u0016J\u0006\u0010\u0019\u001a\u00020\rJ\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u000e\u0010\u001c\u001a\u00020\rH\u0082@\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ml/llm/core/promptlog/LLMPromptLogger;", "Lcom/intellij/openapi/Disposable;", "outputStreamProvider", "Lcom/intellij/ml/llm/core/promptlog/OutputStreamProvider;", "cleanUp", "Lcom/intellij/ml/llm/core/promptlog/CleanUp;", "maxFileSizeInBytes", "", "<init>", "(Lcom/intellij/ml/llm/core/promptlog/OutputStreamProvider;Lcom/intellij/ml/llm/core/promptlog/CleanUp;I)V", "lock", "Lkotlinx/coroutines/sync/Mutex;", "log", "", "httpCall", "Lcom/intellij/ml/llm/core/httpClient/AiaHttpClientCallEvent;", "(Lcom/intellij/ml/llm/core/httpClient/AiaHttpClientCallEvent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "formatHttpCallHeaders", "", "headers", "", "formatHttpCallBody", "body", "Lcom/intellij/ml/llm/core/httpClient/AiaHttpClientCallBody;", "dispose", "cleanup", "getActiveLogFile", "Ljava/io/File;", "refreshLogFileInEditor", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nLLMPromptLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLMPromptLogger.kt\ncom/intellij/ml/llm/core/promptlog/LLMPromptLogger\n+ 2 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,344:1\n116#2,8:345\n125#2,2:354\n1#3:353\n126#4:356\n153#4,3:357\n13#5:360\n*S KotlinDebug\n*F\n+ 1 LLMPromptLogger.kt\ncom/intellij/ml/llm/core/promptlog/LLMPromptLogger\n*L\n48#1:345,8\n48#1:354,2\n98#1:356\n98#1:357,3\n33#1:360\n*E\n"})
public class LLMPromptLogger
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OutputStreamProvider outputStreamProvider;
    @NotNull
    private final CleanUp cleanUp;
    private final int maxFileSizeInBytes;
    @NotNull
    private final Mutex lock;
    @NotNull
    private static final Logger logger;
    private static final DateTimeFormatter formatter;
    private static final long MAX_FILE_AGE = 2592000000L;
    private static final int MAX_FILE_SIZE_BYTES = 819200;
    private static final long MAX_DIR_SIZE_BYTES = 0x6400000L;

    public LLMPromptLogger(@NotNull OutputStreamProvider outputStreamProvider, @NotNull CleanUp cleanUp, int maxFileSizeInBytes) {
        Intrinsics.checkNotNullParameter((Object)outputStreamProvider, (String)"outputStreamProvider");
        Intrinsics.checkNotNullParameter((Object)cleanUp, (String)"cleanUp");
        this.outputStreamProvider = outputStreamProvider;
        this.cleanUp = cleanUp;
        this.maxFileSizeInBytes = maxFileSizeInBytes;
        this.lock = MutexKt.Mutex$default((boolean)false, (int)1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object log(@NotNull AiaHttpClientCallEvent httpCall, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof log.1)) ** GOTO lbl-1000
        var21_3 = $completion;
        if ((var21_3.label & -2147483648) != 0) {
            var21_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ LLMPromptLogger this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.log(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var22_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.lock;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = httpCall;
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var22_5) {
                    return var22_5;
                }
                ** GOTO lbl31
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                httpCall = (AiaHttpClientCallEvent)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl31:
                // 3 sources

                $i$a$-withLock$default-LLMPromptLogger$log$2 = 0;
                stream = this.outputStreamProvider.getOutputStream();
                if (stream.isJustCreated()) {
                    this.cleanUp.cleanUpOldFiles();
                }
                now = LLMPromptLogger.formatter.format(LocalDateTime.now());
                var9_16 = this;
                try {
                    $this$log_u24lambda_u240_u240 = var9_16;
                    $i$a$-runCatching-LLMPromptLogger$log$2$urlPath$1 = false;
                    $this$log_u24lambda_u240_u240 = Result.constructor-impl((Object)new URL(httpCall.getRequestUrl()).getPath());
                }
                catch (Throwable $i$a$-runCatching-LLMPromptLogger$log$2$urlPath$1) {
                    $this$log_u24lambda_u240_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-LLMPromptLogger$log$2$urlPath$1));
                }
                var9_16 = $this$log_u24lambda_u240_u240;
                v1 = Result.exceptionOrNull-impl((Object)var9_16);
                if (v1 == null) {
                    v2 = var9_16;
                } else {
                    it = v1;
                    $i$a$-getOrElse-LLMPromptLogger$log$2$urlPath$2 = false;
                    v2 = httpCall.getRequestUrl();
                }
                urlPath = (String)v2;
                it = httpCall;
                if (it instanceof AiaHttpClientCallEvent.HttpRequestEvent) {
                    v3 = TuplesKt.to((Object)"Request", (Object)(((AiaHttpClientCallEvent.HttpRequestEvent)httpCall).getRequestMethod() + " " + urlPath));
                } else if (it instanceof AiaHttpClientCallEvent.HttpResponseEvent) {
                    v3 = TuplesKt.to((Object)"Response", (Object)((AiaHttpClientCallEvent.HttpResponseEvent)httpCall).getStatus());
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                var9_16 = v3;
                requestOrResponse = (String)var9_16.component1();
                caption = (String)var9_16.component2();
                var13_25 = stream;
                var14_26 = Charsets.UTF_8;
                $this$log_u24lambda_u240_u242 = new OutputStreamWriter(var13_25, var14_26);
                $i$a$-with-LLMPromptLogger$log$2$1 = false;
                ((Appendable)$this$log_u24lambda_u240_u242).append('\n');
                ((Appendable)$this$log_u24lambda_u240_u242).append("---").append('\n');
                ((Appendable)$this$log_u24lambda_u240_u242).append("#### `[" + now + "]` " + caption + " ####").append('\n');
                ((Appendable)$this$log_u24lambda_u240_u242).append(LLMPromptLoggerKt.access$markdownLineBreak("> Request URL: " + httpCall.getRequestUrl())).append('\n');
                ((Appendable)$this$log_u24lambda_u240_u242).append(LLMPromptLoggerKt.access$markdownLineBreak("> Request Method: " + httpCall.getRequestMethod())).append('\n');
                if (httpCall instanceof AiaHttpClientCallEvent.HttpResponseEvent) {
                    ((Appendable)$this$log_u24lambda_u240_u242).append(LLMPromptLoggerKt.access$markdownLineBreak("> Status Code: " + ((AiaHttpClientCallEvent.HttpResponseEvent)httpCall).getStatus())).append('\n');
                }
                LLMPromptLoggerKt.markdownDetails$default($this$log_u24lambda_u240_u242, requestOrResponse + " Headers", false, (Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, log$lambda$0$2$0(com.intellij.ml.llm.core.promptlog.LLMPromptLogger com.intellij.ml.llm.core.httpClient.AiaHttpClientCallEvent java.io.OutputStreamWriter ), (Ljava/io/OutputStreamWriter;)Lkotlin/Unit;)((LLMPromptLogger)this, (AiaHttpClientCallEvent)httpCall), 2, null).append('\n');
                v4 = httpCall.getBody();
                if (v4 != null) {
                    body = v4;
                    $i$a$-let-LLMPromptLogger$log$2$1$2 = false;
                    LLMPromptLoggerKt.access$markdownDetails($this$log_u24lambda_u240_u242, requestOrResponse + " Body", true, (Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, log$lambda$0$2$1$0(com.intellij.ml.llm.core.promptlog.LLMPromptLogger com.intellij.ml.llm.core.httpClient.AiaHttpClientCallBody java.io.OutputStreamWriter ), (Ljava/io/OutputStreamWriter;)Lkotlin/Unit;)((LLMPromptLogger)this, (AiaHttpClientCallBody)body)).append('\n');
                }
                ((Appendable)$this$log_u24lambda_u240_u242).append('\n');
                $this$log_u24lambda_u240_u242.flush();
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)httpCall);
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.L$2 = stream;
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)now);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)requestOrResponse);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)caption);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)urlPath);
                $continuation.I$0 = $i$f$withLock;
                $continuation.I$1 = $i$a$-withLock$default-LLMPromptLogger$log$2;
                $continuation.label = 2;
                v5 = this.refreshLogFileInEditor((Continuation<? super Unit>)$continuation);
                ** if (v5 != var22_5) goto lbl117
lbl116:
                // 1 sources

                return var22_5;
lbl117:
                // 1 sources

                ** GOTO lbl134
            }
            case 2: {
                $i$a$-withLock$default-LLMPromptLogger$log$2 = $continuation.I$1;
                $i$f$withLock = $continuation.I$0;
                urlPath = (String)$continuation.L$6;
                caption = (String)$continuation.L$5;
                requestOrResponse = (String)$continuation.L$4;
                now = (String)$continuation.L$3;
                stream = (CountingOutputStream)$continuation.L$2;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                httpCall = (AiaHttpClientCallEvent)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v5 = $result;
lbl134:
                    // 2 sources

                    if (stream.getBytesWritten() > (long)this.maxFileSizeInBytes) {
                        this.outputStreamProvider.close();
                    }
                    {
                        catch (IOException e) {
                            LLMPromptLogger.logger.error("Failed to write to prompt log", (Throwable)e);
                        }
                    }
                    var18_30 = Unit.INSTANCE;
                }
                catch (Throwable var19_31) {
                    throw var19_31;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    private final String formatHttpCallHeaders(Map<String, String> headers) {
        void $this$mapTo$iv$iv;
        Map<String, String> $this$map$iv = headers;
        boolean $i$f$map = false;
        Map<String, String> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            collection.add(key + ": " + value);
        }
        return LLMPromptLoggerKt.access$markdownCodeBlock(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), "properties");
    }

    private final String formatHttpCallBody(AiaHttpClientCallBody body) {
        String string;
        String[] stringArray = new String[]{";"};
        String string2 = ((String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)body.getContentType(), (String[])stringArray, (boolean)false, (int)2, (int)2, null))).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String string3 = string2;
        if (Intrinsics.areEqual((Object)string3, (Object)"application/json")) {
            String string4 = body.getContent();
            String string5 = string4 != null ? LLMPromptLoggerKt.access$toPrettyJsonString(string4) : null;
            if (string5 == null) {
                string5 = "";
            }
            string = LLMPromptLoggerKt.access$markdownCodeBlock(string5, "json");
        } else if (Intrinsics.areEqual((Object)string3, (Object)"text/event-stream")) {
            String string6 = body.getContent();
            if (string6 == null) {
                string6 = "";
            }
            string = LLMPromptLoggerKt.access$markdownCodeBlock(string6, "yaml");
        } else {
            String string7 = body.getContent();
            if (string7 == null) {
                string7 = "";
            }
            string = LLMPromptLoggerKt.markdownCodeBlock$default(string7, null, 1, null);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Mutex mutex = this.lock;
        synchronized (mutex) {
            boolean bl = false;
            try {
                this.outputStreamProvider.close();
            }
            catch (IOException e) {
                logger.error("Failed to close prompt log", (Throwable)e);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cleanup() {
        Mutex mutex = this.lock;
        synchronized (mutex) {
            boolean bl = false;
            try {
                this.cleanUp.cleanUp();
            }
            catch (IOException e) {
                logger.error("Failed to close prompt log", (Throwable)e);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final File getActiveLogFile() {
        Mutex mutex = this.lock;
        synchronized (mutex) {
            boolean bl = false;
            File file = this.outputStreamProvider.getActiveFile();
            return file;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final Object refreshLogFileInEditor(Continuation<? super Unit> $completion) {
        if (!($completion instanceof refreshLogFileInEditor.1)) ** GOTO lbl-1000
        var6_2 = $completion;
        if ((var6_2.label & -2147483648) != 0) {
            var6_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ LLMPromptLogger this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return LLMPromptLogger.access$refreshLogFileInEditor(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.getActiveLogFile();
                if (v0 == null) {
                    return Unit.INSTANCE;
                }
                logFile = v0;
                v1 = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(logFile);
                if (v1 == null) {
                    return Unit.INSTANCE;
                }
                virtualFile = v1;
                virtualFile.refresh(false, false);
                v2 = FileDocumentManager.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getInstance(...)");
                fileDocumentManager = v2;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)logFile);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)virtualFile);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)fileDocumentManager);
                $continuation.label = 1;
                v3 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(fileDocumentManager, virtualFile, null){
                    int label;
                    final /* synthetic */ FileDocumentManager $fileDocumentManager;
                    final /* synthetic */ VirtualFile $virtualFile;
                    {
                        this.$fileDocumentManager = $fileDocumentManager;
                        this.$virtualFile = $virtualFile;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = CoroutinesKt.writeAction(() -> refreshLogFileInEditor.2.invokeSuspend$lambda$0(this.$fileDocumentManager, this.$virtualFile), (Continuation)((Continuation)this));
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }

                    private static final Unit invokeSuspend$lambda$0(FileDocumentManager $fileDocumentManager, VirtualFile $virtualFile) {
                        Document document2 = $fileDocumentManager.getDocument($virtualFile);
                        if (document2 == null) {
                            return Unit.INSTANCE;
                        }
                        Document document3 = document2;
                        $fileDocumentManager.reloadFromDisk(document3, null);
                        return Unit.INSTANCE;
                    }
                }), (Continuation)$continuation);
                ** if (v3 != var7_4) goto lbl33
lbl32:
                // 1 sources

                return var7_4;
lbl33:
                // 1 sources

                ** GOTO lbl45
            }
            case 1: {
                fileDocumentManager = (FileDocumentManager)$continuation.L$2;
                virtualFile = (VirtualFile)$continuation.L$1;
                logFile = (File)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
                }
                catch (Exception e) {
                    LLMPromptLogger.logger.error("Failed to refresh log file in editor", (Throwable)e);
                }
lbl45:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final Unit log$lambda$0$2$0(LLMPromptLogger this$0, AiaHttpClientCallEvent $httpCall, OutputStreamWriter $this$markdownDetails) {
        Intrinsics.checkNotNullParameter((Object)$this$markdownDetails, (String)"$this$markdownDetails");
        ((Appendable)$this$markdownDetails).append(this$0.formatHttpCallHeaders($httpCall.getHeaders())).append('\n').append('\n');
        return Unit.INSTANCE;
    }

    private static final Unit log$lambda$0$2$1$0(LLMPromptLogger this$0, AiaHttpClientCallBody $body, OutputStreamWriter $this$markdownDetails) {
        Intrinsics.checkNotNullParameter((Object)$this$markdownDetails, (String)"$this$markdownDetails");
        ((Appendable)$this$markdownDetails).append(this$0.formatHttpCallBody($body)).append('\n').append('\n');
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$refreshLogFileInEditor(LLMPromptLogger $this, Continuation $completion) {
        return $this.refreshLogFileInEditor((Continuation<? super Unit>)$completion);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LLMPromptLogger.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LLMPromptLogger.logger = logger;
        formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss,SSS");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/core/promptlog/LLMPromptLogger$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "formatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "MAX_FILE_AGE", "", "MAX_FILE_SIZE_BYTES", "", "MAX_DIR_SIZE_BYTES", "create", "Lcom/intellij/ml/llm/core/promptlog/LLMPromptLogger;", "suffix", "", "intellij.ml.llm.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LLMPromptLogger create(@NotNull String suffix) {
            Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
            Path dir = LLMPromptLogHelper.Companion.getInstance().getPromptLogPath();
            FileDataOutputStreamProvider provider = new FileDataOutputStreamProvider(dir, suffix);
            return new LLMPromptLogger(provider, provider.new FileDataOutputStreamProvider.DirCleanUp(2592000000L, 0x6400000L), 819200);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

