/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.providers.utils;

import java.net.URI;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u0005J.\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0005J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0002J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0005H\u0002R\u000e\u0010\u0016\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/core/providers/utils/ConnectionErrorDetailsFormatter;", "", "<init>", "()V", "formatHttpError", "", "baseUrl", "endpoint", "method", "statusCode", "", "statusDescription", "responseBody", "providerLabel", "formatNetworkError", "exception", "", "buildFullUrl", "effectivePort", "uri", "Ljava/net/URI;", "timestamp", "MAX_BODY_LENGTH", "intellij.ml.llm.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nConnectionErrorDetailsFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectionErrorDetailsFormatter.kt\ncom/intellij/ml/llm/core/providers/utils/ConnectionErrorDetailsFormatter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1#2:87\n*E\n"})
public final class ConnectionErrorDetailsFormatter {
    @NotNull
    public static final ConnectionErrorDetailsFormatter INSTANCE = new ConnectionErrorDetailsFormatter();
    private static final int MAX_BODY_LENGTH = 500;

    private ConnectionErrorDetailsFormatter() {
    }

    @NotNull
    public final String formatHttpError(@NotNull String baseUrl, @NotNull String endpoint, @NotNull String method, int statusCode, @NotNull String statusDescription, @Nullable String responseBody, @NotNull String providerLabel) {
        Object $this$formatHttpError_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)statusDescription, (String)"statusDescription");
        Intrinsics.checkNotNullParameter((Object)providerLabel, (String)"providerLabel");
        String fullUrl = this.buildFullUrl(baseUrl, endpoint);
        Object object = this;
        try {
            $this$formatHttpError_u24lambda_u240 = object;
            boolean bl = false;
            $this$formatHttpError_u24lambda_u240 = Result.constructor-impl((Object)URI.create(fullUrl));
        }
        catch (Throwable bl) {
            $this$formatHttpError_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$formatHttpError_u24lambda_u240;
        URI uri = (URI)(Result.isFailure-impl((Object)object) ? null : object);
        Object $this$formatHttpError_u24lambda_u241 = object = new StringBuilder();
        boolean bl = false;
        ((StringBuilder)$this$formatHttpError_u24lambda_u241).append(INSTANCE.timestamp() + " ERROR " + providerLabel).append('\n');
        ((StringBuilder)$this$formatHttpError_u24lambda_u241).append("Request failed: " + method + " " + fullUrl).append('\n');
        ((StringBuilder)$this$formatHttpError_u24lambda_u241).append("Status: " + statusCode + " " + statusDescription).append('\n');
        ((StringBuilder)$this$formatHttpError_u24lambda_u241).append('\n');
        ((StringBuilder)$this$formatHttpError_u24lambda_u241).append("Details:").append('\n');
        Object object2 = uri;
        if (object2 != null && (object2 = ((URI)object2).getHost()) != null) {
            Object it = object2;
            boolean bl2 = false;
            ((StringBuilder)$this$formatHttpError_u24lambda_u241).append("- Host: " + (String)it).append('\n');
        }
        URI uRI = uri;
        if (uRI != null) {
            URI it = uRI;
            boolean bl3 = false;
            ((StringBuilder)$this$formatHttpError_u24lambda_u241).append("- Port: " + INSTANCE.effectivePort(it)).append('\n');
        }
        CharSequence charSequence = responseBody;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            ((StringBuilder)$this$formatHttpError_u24lambda_u241).append("- Response: " + StringsKt.take((String)responseBody, (int)500)).append('\n');
        }
        return ((Object)StringsKt.trimEnd((CharSequence)((StringBuilder)object).toString())).toString();
    }

    @NotNull
    public final String formatNetworkError(@NotNull String baseUrl, @NotNull String endpoint, @NotNull String method, @NotNull Throwable exception, @NotNull String providerLabel) {
        Object object;
        block5: {
            Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
            Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            Intrinsics.checkNotNullParameter((Object)providerLabel, (String)"providerLabel");
            String fullUrl = this.buildFullUrl(baseUrl, endpoint);
            Object object2 = this;
            try {
                ConnectionErrorDetailsFormatter $this$formatNetworkError_u24lambda_u240 = object2;
                boolean bl = false;
                object = Result.constructor-impl((Object)URI.create(fullUrl));
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            URI uri = (URI)(Result.isFailure-impl((Object)object2) ? null : object2);
            String string = Reflection.getOrCreateKotlinClass(exception.getClass()).getSimpleName();
            if (string == null) {
                string = "Unknown";
            }
            String errorName = string;
            Object $this$formatNetworkError_u24lambda_u241 = object = new StringBuilder();
            boolean bl = false;
            ((StringBuilder)$this$formatNetworkError_u24lambda_u241).append(INSTANCE.timestamp() + " ERROR " + providerLabel).append('\n');
            ((StringBuilder)$this$formatNetworkError_u24lambda_u241).append("Request failed: " + method + " " + fullUrl).append('\n');
            ((StringBuilder)$this$formatNetworkError_u24lambda_u241).append("Error: " + errorName).append('\n');
            ((StringBuilder)$this$formatNetworkError_u24lambda_u241).append('\n');
            ((StringBuilder)$this$formatNetworkError_u24lambda_u241).append("Details:").append('\n');
            Object object3 = uri;
            if (object3 != null && (object3 = ((URI)object3).getHost()) != null) {
                Object it = object3;
                boolean bl2 = false;
                ((StringBuilder)$this$formatNetworkError_u24lambda_u241).append("- Host: " + (String)it).append('\n');
            }
            URI uRI = uri;
            if (uRI != null) {
                URI it = uRI;
                boolean bl3 = false;
                ((StringBuilder)$this$formatNetworkError_u24lambda_u241).append("- Port: " + INSTANCE.effectivePort(it)).append('\n');
            }
            String string2 = exception.getMessage();
            if (string2 == null) break block5;
            String it = string2;
            boolean bl4 = false;
            ((StringBuilder)$this$formatNetworkError_u24lambda_u241).append("- Message: " + it).append('\n');
        }
        return ((Object)StringsKt.trimEnd((CharSequence)((StringBuilder)object).toString())).toString();
    }

    private final String buildFullUrl(String baseUrl, String endpoint) {
        Object object;
        try {
            object = URI.create(baseUrl).resolve(endpoint).toString();
            Intrinsics.checkNotNull((Object)object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            char[] cArray = new char[]{'/'};
            String string = StringsKt.trimEnd((String)baseUrl, (char[])cArray);
            cArray = new char[]{'/'};
            String fullUrl = string + "/" + StringsKt.trimStart((String)endpoint, (char[])cArray);
            object = fullUrl + " (URL can't be resolved)";
        }
        return object;
    }

    private final int effectivePort(URI uri) {
        if (uri.getPort() > 0) {
            return uri.getPort();
        }
        String string = uri.getScheme();
        return Intrinsics.areEqual((Object)string, (Object)"https") ? 443 : (Intrinsics.areEqual((Object)string, (Object)"http") ? 80 : -1);
    }

    private final String timestamp() {
        String string = DateTimeFormatter.ISO_INSTANT.format(Instant.now());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }
}

