/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.statistics.fus.jcp;

import com.intellij.ml.llm.core.statistics.fus.jcp.IJcpAnalyticsClient;
import com.intellij.ml.llm.core.statistics.fus.jcp.TokenProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.registry.Registry;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.analytics.EventData;
import org.jetbrains.analytics.lifecycle.AnalyticsClient;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00102\u00020\u00012\u00020\u0002:\u0001\u0010B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/core/statistics/fus/jcp/JcpAnalyticsClientImpl;", "Lcom/intellij/ml/llm/core/statistics/fus/jcp/IJcpAnalyticsClient;", "Lcom/intellij/openapi/Disposable;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "jcpTokenProvider", "Lcom/intellij/ml/llm/core/statistics/fus/jcp/TokenProvider;", "analyticsClient", "Lorg/jetbrains/analytics/lifecycle/AnalyticsClient;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/ml/llm/core/statistics/fus/jcp/TokenProvider;Lorg/jetbrains/analytics/lifecycle/AnalyticsClient;)V", "submitEvent", "", "event", "Lorg/jetbrains/analytics/EventData;", "dispose", "Companion", "intellij.ml.llm.core"})
public final class JcpAnalyticsClientImpl
implements IJcpAnalyticsClient,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TokenProvider jcpTokenProvider;
    @NotNull
    private final AnalyticsClient analyticsClient;
    @NotNull
    private static final String JCP_ANALYTICS_ENABLED = "llm.jcp.analytics.enabled";
    @NotNull
    private static final Lazy<Boolean> analyticsEnabled$delegate = LazyKt.lazy(JcpAnalyticsClientImpl::analyticsEnabled_delegate$lambda$0);

    public JcpAnalyticsClientImpl(@NotNull CoroutineScope scope, @NotNull TokenProvider jcpTokenProvider, @NotNull AnalyticsClient analyticsClient) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)jcpTokenProvider, (String)"jcpTokenProvider");
        Intrinsics.checkNotNullParameter((Object)analyticsClient, (String)"analyticsClient");
        this.jcpTokenProvider = jcpTokenProvider;
        this.analyticsClient = analyticsClient;
        if (JcpAnalyticsClientImpl.Companion.getAnalyticsEnabled()) {
            this.analyticsClient.start(scope);
        }
    }

    @Override
    public void submitEvent(@NotNull EventData event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!JcpAnalyticsClientImpl.Companion.getAnalyticsEnabled()) {
            return;
        }
        if (this.jcpTokenProvider.getToken() == null) {
            return;
        }
        this.analyticsClient.recordEvent(event);
    }

    public void dispose() {
        AnalyticsClient.stop$default(this.analyticsClient, false, 1, null);
    }

    private static final boolean analyticsEnabled_delegate$lambda$0() {
        return Registry.Companion.is(JCP_ANALYTICS_ENABLED, false);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/core/statistics/fus/jcp/JcpAnalyticsClientImpl$Companion;", "", "<init>", "()V", "JCP_ANALYTICS_ENABLED", "", "analyticsEnabled", "", "getAnalyticsEnabled", "()Z", "analyticsEnabled$delegate", "Lkotlin/Lazy;", "intellij.ml.llm.core"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean getAnalyticsEnabled() {
            Lazy lazy = analyticsEnabled$delegate;
            return (Boolean)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

