/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.grazie.tasks.errorExplanation;

import ai.grazie.model.llm.prompt.LLMPromptID;
import ai.grazie.model.task.id.TaskID;
import ai.grazie.text.TextTemplate;
import com.intellij.ml.llm.core.LLMPromptsKt;
import com.intellij.ml.llm.grazie.tasks.errorExplanation.ExplainBuildErrorTask;
import com.intellij.ml.llm.grazie.tasks.errorExplanation.ExplainErrorTaskBuilder;
import com.intellij.ml.llm.grazie.tasks.errorExplanation.ExplainRuntimeErrorTask;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u00078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/grazie/tasks/errorExplanation/ExplainBuildErrorTaskBuilder;", "Lcom/intellij/ml/llm/grazie/tasks/errorExplanation/ExplainErrorTaskBuilder;", "<init>", "()V", "id", "Lai/grazie/model/task/id/TaskID;", "consoleOutputVariable", "", "isApplicable", "", "taskId", "prompt", "getPrompt", "()Ljava/lang/String;", "promptId", "Lai/grazie/model/llm/prompt/LLMPromptID;", "getPromptId", "()Lai/grazie/model/llm/prompt/LLMPromptID;", "intellij.ml.llm.core"})
public final class ExplainBuildErrorTaskBuilder
extends ExplainErrorTaskBuilder {
    @NotNull
    private final TaskID id = ExplainRuntimeErrorTask.INSTANCE.getName().tag(ExplainRuntimeErrorTask.LLM.Default.INSTANCE.getTag());
    @NotNull
    private final String consoleOutputVariable = TextTemplate.INSTANCE.variable(ExplainBuildErrorTask.LLM.Default.Schema.INSTANCE.getConsoleOutput().getName());

    public ExplainBuildErrorTaskBuilder() {
        super(null);
    }

    public boolean isApplicable(@NotNull TaskID taskId) {
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        return Intrinsics.areEqual((Object)taskId, (Object)this.id);
    }

    @Override
    @NotNull
    protected String getPrompt() {
        return StringsKt.trimIndent((String)("\n    As a helpful assistant with expertise in analyzing build errors, your objective is to analyze the reasons of build errors by analyzing console logs and sources and providing general solutions to fix the errors. When assisting users, follow these rules:\n\n    1. Always be helpful and professional.\n    2. Use your mastery in analyzing build errors to determine the cause of build errors by looking at build logs.\n    3. Provide fixes to the build errors when given the code.\n    4. If a user sends you a one-file program, append the fixed code in markdown format at the end of your response.\n    This code will be extracted using re.findall(r\"`{{3}}(\\w*)\\n([\\S\\s]+?)\\n`{{3}}\", model_response)\n    so adhere to this formatting strictly.\n    5. If you can fix the problem strictly by modifying the code, do so.\n    6. Focus only on problem mentioned on console output.\n    7. Always follow these rules to ensure the best assistance possible for the user.\n\n    Now, consider this user request:\n\n    Please help me understand what the problem is and try to fix the code. Here's the console output:\n    Console output:\n    ```\n    " + this.consoleOutputVariable + "\n    ```\n\n    Provide a helpful response that addresses the user's concerns, adheres to the rules, and offers a solution for the build error.\n  "));
    }

    @Override
    @NotNull
    protected LLMPromptID getPromptId() {
        return LLMPromptsKt.getEXPLAIN_BUILD_ERROR_PROMPT_ID();
    }
}

