/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.grazie.tasks.vcs.reviewBuddy;

import ai.grazie.model.llm.chat.v5.LLMChat;
import ai.grazie.tone.DocFormalityTone;
import ai.grazie.utils.attributes.AttributeDescriptor;
import ai.grazie.utils.json.JSON;
import com.intellij.ml.llm.grazie.tasks.vcs.reviewBuddy.ReviewBuddyFileData;
import com.intellij.ml.llm.grazie.tasks.vcs.reviewBuddy.SummarizationSettings;
import com.intellij.ml.llm.grazie.tasks.vcs.reviewBuddy.SummaryVerbosity;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.PSStringKt;
import com.intellij.ml.llm.privacy.PrivacySafe;
import com.intellij.ml.llm.privacy.extensions.std.EnumWrapper;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.PSStringOperatorsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0002()B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u0016\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005J\u0016\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005J\u0016\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0006\u001a\u00020\u0005J\u0014\u0010$\u001a\u00020\u00052\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&R\u0011\u0010\u0011\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\u0016\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u0011\u0010\u0018\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/ml/llm/grazie/tasks/vcs/reviewBuddy/ReviewBuddyPromptUtil;", "", "<init>", "()V", "summarizePrompt", "Lcom/intellij/ml/llm/privacy/PSString;", "mergeRequestContent", "fileReviewPrompt", "filename", "patch", "allFileReviewPrompt", "summaryStub", "summary", "discussionComment", "lineNumber", "", "question", "systemPrompt", "getSystemPrompt", "()Lcom/intellij/ml/llm/privacy/PSString;", "systemResponse", "getSystemResponse", "modelReplyToContinue", "getModelReplyToContinue", "discussionSummarizePrompt", "getDiscussionSummarizePrompt", "formalityTones", "verbosities", "summarizeShortPrompt", "settings", "Lcom/intellij/ml/llm/grazie/tasks/vcs/reviewBuddy/SummarizationSettings;", "reviewGuideline", "reviewExamples", "reviewFilePrompt", "reviewAllFilesPrompt", "discussionCommentPrompt", "prepareMergeRequestData", "data", "", "Lcom/intellij/ml/llm/grazie/tasks/vcs/reviewBuddy/ReviewBuddyFileData;", "ReviewFileDataAttr", "LLMChatAttr", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nReviewBuddyPromptUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReviewBuddyPromptUtil.kt\ncom/intellij/ml/llm/grazie/tasks/vcs/reviewBuddy/ReviewBuddyPromptUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,284:1\n1#2:285\n*E\n"})
public final class ReviewBuddyPromptUtil {
    @NotNull
    public static final ReviewBuddyPromptUtil INSTANCE = new ReviewBuddyPromptUtil();
    @NotNull
    private static final PSString systemPrompt = ConstantsKt.getPrivacyConst((String)"\n    System prompt: You are a concise professional Code Review Copilot that helps programmers to perform code reviews.\n    I will send you a Pull Request that I need help reviewing.\n    It will contain a list of files with their contents and diff information.\n    \n    You will then be asked to do one of the following:\n    1. Write a text description with a summary of the Pull Request\n    2. Write down a list of files from the Pull Request in the order that you suggest to use for reviewing: files that require more attention should go earlier\n    3. For a specific file generate a summary that will help the reviewer to perform the review\n    4. For a specific file generate a list of comments in JSON format: {\"line_number\": ..., \"reasoning\": ..., \"comment\": ...}.\n    \n    You MUST use simple language: the reader may be a non-native speaker. Do not use rare and complex wording.\n    Never tell abstract non-specific problems, be short, concise and direct. \n    List only important problems, never mind non-critical problems.\n    In the reasoning field provide reasoning why problem is important and, where possible, demonstrate on what real data it can lead to problems and what can go wrong.\n    \n    Do you understand the guidelines?\n  ").trimIndent();
    @NotNull
    private static final PSString systemResponse = ConstantsKt.getPrivacyConst((String)"\n    Yes, I understand the guidelines:\n    0. Use simple language without difficult words such as \"utter importance\", \"inherently\", etc.\n    1. Provide a concise summary of the PR\n    2. Suggest an order to review the changed files\n    3. Provide summaries of individual files\n    4. Provide a list of comments in JSON format\n    5. Only list important issues\n    6. Explain the importance of any issue found\n    7. Double-check that only important issues are mentioned\n    8. Do not provide abstract/non-specific statements\n  ").trimIndent();
    @NotNull
    private static final PSString modelReplyToContinue = ConstantsKt.getPrivacyConst((String)"Got it! What should I do next?");
    @NotNull
    private static final PSString discussionSummarizePrompt = ConstantsKt.getPrivacyConst((String)"\n    Please write a comment to the DEVELOPER\n    summarizing our discussion telling them what and why they have to fix or check in their implementation.\n    Be concise and do not use any complex language. Do not mention that we discussed it.\n    Just write a comment as if the reviewer was writing it.\n  ").trimIndent();
    @NotNull
    private static final PSString summaryStub = ConstantsKt.getPrivacyConst((String)"\n    The summary of the PR:\n    %s\n  ").trimIndent();
    @NotNull
    private static final PSString summarizePrompt = ConstantsKt.getPrivacyConst((String)"\n    Below, you are given the contents of the Pull Request.\n    It contains the list of files with content for each file before and after the changes.\n    Write a summary that briefly describes the contents of the PR. The summary will be used by the reviewer to ease their work.\n    The summary should answer the following questions:\n    - What has changed in the codebase?\n    - Which parts require special attention from the reviewer?\n    \n    After summarizing the PR, write a single sentence, condensing the summary for the reviewer to quickly get the idea.\n    It should contain the main message in no more than 15 words in very simple language.\n    \n    Do not dive deep into the details for specific changes and files as you will do it later.\n    Keep the summary concise. Do not add any unrelated information.\n    Use simple language.\n    You can do it, I believe in you!\n    \n    Write the summary in the following format:\n    \n    ## Pull Request Summary\n    ... here goes summary ...\n    \n    ## Main idea\n    The Main Idea written in a single sentence\n    \n    Pull Request is given below in the format \"file name, version before, version after\":\n    %s\n  ").trimIndent();
    @NotNull
    private static final PSString formalityTones = PSStringKt.joinToString$default((Iterable)CollectionsKt.minus((Iterable)((Iterable)DocFormalityTone.getEntries()), (Object)DocFormalityTone.MIXED), (PrivacySafe)((PrivacySafe)ConstantsKt.getPrivacyConst((String)", ")), null, null, (int)0, null, ReviewBuddyPromptUtil::formalityTones$lambda$0, (int)30, null);
    @NotNull
    private static final PSString verbosities = PSStringKt.joinToString$default((Iterable)CollectionsKt.minus((Iterable)((Iterable)SummaryVerbosity.getEntries()), (Object)((Object)SummaryVerbosity.MIXED)), (PrivacySafe)((PrivacySafe)ConstantsKt.getPrivacyConst((String)", ")), null, null, (int)0, null, ReviewBuddyPromptUtil::verbosities$lambda$0, (int)30, null);
    @NotNull
    private static final PSString reviewGuideline = ConstantsKt.getPrivacyConst((String)"\n    These are the highlights for the REVIEWER of the Pull Request, not for the developer!\n    Each highlight should point to a specific location in PR and describe what the reviewer should verify or pay attention to.\n    In order to add a highlight, specify the line number where it should be added.\n    The reviewer will then use your suggestions as GUIDANCE during the review.\n    DOUBLE CHECK the suggestions.\n    Suggest to inspect implementations of methods and classes only when you have STRONG SUSPICIONS about their CORRECTNESS or EFFICIENCY.\n    \n    You should highlight places in PR for the following reasons:\n    - complex code\n    - possible bugs\n    - possible performance issues\n    - possible violation of guidelines\n    - potential security concerns\n    - places for significant simplification or improvement\n    \n    Be very concise!\n    Keep in mind that you are writing comments for the REVIEWER.\n    Every highlight should be actionable.\n    Based on the comment, the reviewer should understand how to proceed with the review.\n    Use simple language.\n    Avoid phrase \"aligns with project goals\" as it carries very little meaning.\n  ").trimIndent();
    @NotNull
    private static final PSString reviewExamples = ConstantsKt.getPrivacyConst((String)"\n    Examples of good comments:\n    - Pay attention to the numThreads parameter and its impact on performance and resource utilization.\n      - The comment is very good as changing number of threads from 1 to 4 could have broken the implementation.\n    - Ensure all managed storages are closed correctly to avoid resource leaks.\n      - It is a good comment because things like parallelization, data races, memory management can be tricky and require reviewers attention.\n    - Class ViewerImplementation changed inheritance and the reviewer should verify the introduced architectural changes.\n      - The comment is helpful because architectural changes are an important topic of discussion during reviews.\n    \n    Examples of bad comments:\n    - Please review the implementation of the PhpRemoveCommentsTransformation class to ensure it handles comment removal in PHP files correctly.\n      - The comment is bad because it suggests to check implementation of the existing class without any reason.\n    - Examine the search for the FinallyEndInstruction to ensure it functions as intended.\n      - Again, the comment is bad because it suggests examination of the class/method without a particular reason.\n    - Developer should write documentation for the class AbstractMethodImplementation.\n      - Comment is bad: you should NOT suggest to write documentation.\n    - Check the logic for identifying and filtering comments, including edge cases and performance implications.\n      - It is a bad comment because the logic is rather short and straightforward and does not require much attention from the reviewer.\n    \n    In \"reasoning\" you can discuss why this particular issue is important and why people should take it into account.\n  ").trimIndent();
    @NotNull
    private static final PSString reviewFilePrompt = ConstantsKt.getPrivacyConst((String)"\n    Now let's help reviewer to write a review for file %s\n    You will be given the contents of the file with line numbers below.\n    Use the provided summary of the Pull Request to create a better review.\n    \n    First, write a short summary that the reviewer will read before diving deep into reviewing the file.\n    Then highlight places in the file where reviewer should pay extra attention.\n    Return your suggestions in JSON format.\n    \n    %s\n    \n    %s\n    \n    Your message should have the following format:\n    ```json\n    {{\n        \"summary\": ...,\n        \"comments\": [\n            {{\"line_number\": ..., \"reasoning\": ..., \"comment\": ...}},\n            ...\n        ]\n    }}\n    ```\n    \n    ```\n    %s\n    ```\n  ").trimIndent();
    @NotNull
    private static final PSString reviewAllFilesPrompt;
    @NotNull
    private static final PSString discussionCommentPrompt;

    private ReviewBuddyPromptUtil() {
    }

    @NotNull
    public final PSString summarizePrompt(@NotNull PSString mergeRequestContent) {
        Intrinsics.checkNotNullParameter((Object)mergeRequestContent, (String)"mergeRequestContent");
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{mergeRequestContent};
        return summarizePrompt.format(pSStringConvertibleArray);
    }

    @NotNull
    public final PSString fileReviewPrompt(@NotNull PSString filename, @NotNull PSString patch) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter((Object)patch, (String)"patch");
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{filename, reviewGuideline, reviewExamples, patch};
        return reviewFilePrompt.format(pSStringConvertibleArray);
    }

    @NotNull
    public final PSString allFileReviewPrompt() {
        return reviewAllFilesPrompt;
    }

    @NotNull
    public final PSString summaryStub(@NotNull PSString summary2) {
        Intrinsics.checkNotNullParameter((Object)summary2, (String)"summary");
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{summary2};
        return summaryStub.format(pSStringConvertibleArray);
    }

    @NotNull
    public final PSString discussionComment(int lineNumber, @NotNull PSString question) {
        Intrinsics.checkNotNullParameter((Object)question, (String)"question");
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{PSStringOperatorsKt.toPSString((int)lineNumber), question};
        return discussionCommentPrompt.format(pSStringConvertibleArray);
    }

    @NotNull
    public final PSString getSystemPrompt() {
        return systemPrompt;
    }

    @NotNull
    public final PSString getSystemResponse() {
        return systemResponse;
    }

    @NotNull
    public final PSString getModelReplyToContinue() {
        return modelReplyToContinue;
    }

    @NotNull
    public final PSString getDiscussionSummarizePrompt() {
        return discussionSummarizePrompt;
    }

    @NotNull
    public final PSString summarizeShortPrompt(@NotNull SummarizationSettings settings, @NotNull PSString mergeRequestContent) {
        PSString pSString;
        Object it;
        Object object;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)mergeRequestContent, (String)"mergeRequestContent");
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[7];
        DocFormalityTone docFormalityTone = object = settings.getFormalityTone();
        int n = 0;
        PSStringConvertible[] pSStringConvertibleArray2 = pSStringConvertibleArray;
        PSString pSString2 = ConstantsKt.getPrivacyConst((String)"\n    Below, you are given the contents of the Pull Request.\n    It contains a list of files with content for each file before and after the changes.\n    Try to distinguish meaningful changes from gibberish. For instance, test data may contain gibberish that may not be relevant.\n    \n    Write a summary that describes the contents of the PR.\n    If you're asked to be brief, a summary should contain only the main idea of the changes in no more than 1 or two sentences.\n    The summary will be used by the reviewer to ease their work.\n    It can be helpful to list the main changes as bullet points.\n    \n    The user has specified the following requirements:\n    - They want the tone of the text to be: %s. They were given the choice between %s. Respect this, regardless of previous instructions.\n    - They want the text to be: %s. They were given the choice between %s. Respect this, regardless of previous instructions.\n    %s\n    \n    %s\n    \n    Pull Request is given below in the format \"file name, version before, version after\":\n    %s\n  ").trimIndent();
        boolean bl = false;
        boolean bl2 = it != DocFormalityTone.MIXED;
        Object object2 = bl2 ? object : null;
        if (object2 == null) {
            object2 = DocFormalityTone.NEUTRAL;
        }
        Enum enum_ = (Enum)object2;
        pSStringConvertibleArray2[n] = new EnumWrapper(enum_).getName();
        pSStringConvertibleArray[1] = formalityTones;
        it = object = settings.getVerbosity();
        n = 2;
        pSStringConvertibleArray2 = pSStringConvertibleArray;
        boolean bl3 = false;
        bl2 = it != SummaryVerbosity.MIXED;
        Object object3 = bl2 ? object : null;
        if (object3 == null) {
            object3 = SummaryVerbosity.NEUTRAL;
        }
        Enum enum_2 = (Enum)object3;
        pSStringConvertibleArray2[n] = new EnumWrapper(enum_2).getName();
        pSStringConvertibleArray[3] = verbosities;
        PSStringConvertible[] pSStringConvertibleArray3 = (PSStringConvertible[])settings.getPersonality();
        if (!(pSStringConvertibleArray3 == null || StringsKt.isBlank((CharSequence)pSStringConvertibleArray3))) {
            pSStringConvertibleArray3 = new PSStringConvertible[]{settings.getPersonality()};
            v2 = ConstantsKt.getPrivacyConst((String)"- They want the text to be written completely in the tone of %s").format(pSStringConvertibleArray3);
        } else {
            v2 = pSStringConvertibleArray[4] = ConstantsKt.getEMPTY();
        }
        if (settings.getCustomizationPrompt() != null) {
            pSStringConvertibleArray3 = new PSStringConvertible[]{settings.getCustomizationPrompt()};
            pSString = ConstantsKt.getPrivacyConst((String)"The user has indicated the following specifications:\n%s").format(pSStringConvertibleArray3);
        } else {
            pSString = ConstantsKt.getEMPTY();
        }
        pSStringConvertibleArray[5] = pSString;
        pSStringConvertibleArray[6] = mergeRequestContent;
        return pSString2.format(pSStringConvertibleArray);
    }

    @NotNull
    public final PSString prepareMergeRequestData(@NotNull List<ReviewBuddyFileData> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        return PSStringKt.joinToString$default((Iterable)data, (PrivacySafe)((PrivacySafe)ConstantsKt.getPrivacyConst((String)"\n\n")), null, null, (int)0, null, ReviewBuddyPromptUtil::prepareMergeRequestData$lambda$0, (int)30, null);
    }

    private static final PrivacySafe formalityTones$lambda$0(DocFormalityTone it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (PrivacySafe)new EnumWrapper((Enum)it).getName();
    }

    private static final PrivacySafe verbosities$lambda$0(SummaryVerbosity it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return (PrivacySafe)new EnumWrapper((Enum)it).getName();
    }

    private static final PrivacySafe prepareMergeRequestData$lambda$0(ReviewBuddyFileData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (PrivacySafe)it.getPatch();
    }

    static {
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{reviewGuideline, reviewExamples};
        reviewAllFilesPrompt = ConstantsKt.getPrivacyConst((String)"\n    Now let's help reviewer to write a review.\n    You have can check the contents of all files in the PR above.\n    Use them and the provided summary of the PR to create a better review.\n    \n    Write a short summary for each file that the reviewer will read before diving deep into reviewing the file.\n    Then highlight places in each file where reviewer should pay extra attention.\n    Return your suggestions in JSON format.\n\n    %s\n\n    %s\n    \n    Your message should have the following format:\n    ```json\n    [\n        {{\n            \"filename\": ...,\n            \"summary\": ...,\n            \"comments\": [\n                {{\"line_number\": ..., \"reasoning\": ..., \"comment\": ...}},\n                ...\n            ]\n        }},\n        ...\n    ]\n    ```\n  ").trimIndent().format(pSStringConvertibleArray);
        discussionCommentPrompt = ConstantsKt.getPrivacyConst((String)"\n    I have question about the comment on line %s.\n    %s\n    \n    Answer concisely.\n    Do not use complex language.\n    Your message is a comment to the reviewers question.\n    Be very short, no more than 3 sentences.\n    Do not use complex formatting.\n  ").trimIndent();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0004H\u0014J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0002H\u0014\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/grazie/tasks/vcs/reviewBuddy/ReviewBuddyPromptUtil$LLMChatAttr;", "Lai/grazie/utils/attributes/AttributeDescriptor$Json;", "Lai/grazie/model/llm/chat/v5/LLMChat;", "name", "", "<init>", "(Ljava/lang/String;)V", "fromJson", "value", "toJson", "intellij.ml.llm.core"})
    @SourceDebugExtension(value={"SMAP\nReviewBuddyPromptUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReviewBuddyPromptUtil.kt\ncom/intellij/ml/llm/grazie/tasks/vcs/reviewBuddy/ReviewBuddyPromptUtil$LLMChatAttr\n+ 2 JSON.kt\nai/grazie/utils/json/JSON\n*L\n1#1,284:1\n70#2:285\n28#2:286\n*S KotlinDebug\n*F\n+ 1 ReviewBuddyPromptUtil.kt\ncom/intellij/ml/llm/grazie/tasks/vcs/reviewBuddy/ReviewBuddyPromptUtil$LLMChatAttr\n*L\n274#1:285\n275#1:286\n*E\n"})
    public static final class LLMChatAttr
    extends AttributeDescriptor.Json<LLMChat> {
        public LLMChatAttr(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            super(name, false);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        protected LLMChat fromJson(@NotNull String value) {
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            JSON jSON = (JSON)JSON.Default.INSTANCE;
            String value$iv = value;
            boolean $i$f$parse = false;
            return (LLMChat)this_$iv.parse((DeserializationStrategy)LLMChat.Companion.serializer(), value$iv);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        protected String toJson(@NotNull LLMChat value) {
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            JSON jSON = (JSON)JSON.Default.INSTANCE;
            LLMChat value$iv = value;
            boolean $i$f$string = false;
            return this_$iv.string((SerializationStrategy)LLMChat.Companion.serializer(), (Object)value$iv);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0004H\u0014J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0002H\u0014\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/grazie/tasks/vcs/reviewBuddy/ReviewBuddyPromptUtil$ReviewFileDataAttr;", "Lai/grazie/utils/attributes/AttributeDescriptor$Json;", "Lcom/intellij/ml/llm/grazie/tasks/vcs/reviewBuddy/ReviewBuddyFileData;", "name", "", "<init>", "(Ljava/lang/String;)V", "fromJson", "value", "toJson", "intellij.ml.llm.core"})
    @SourceDebugExtension(value={"SMAP\nReviewBuddyPromptUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReviewBuddyPromptUtil.kt\ncom/intellij/ml/llm/grazie/tasks/vcs/reviewBuddy/ReviewBuddyPromptUtil$ReviewFileDataAttr\n+ 2 JSON.kt\nai/grazie/utils/json/JSON\n*L\n1#1,284:1\n70#2:285\n28#2:286\n*S KotlinDebug\n*F\n+ 1 ReviewBuddyPromptUtil.kt\ncom/intellij/ml/llm/grazie/tasks/vcs/reviewBuddy/ReviewBuddyPromptUtil$ReviewFileDataAttr\n*L\n269#1:285\n270#1:286\n*E\n"})
    public static final class ReviewFileDataAttr
    extends AttributeDescriptor.Json<ReviewBuddyFileData> {
        public ReviewFileDataAttr(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            super(name, false);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        protected ReviewBuddyFileData fromJson(@NotNull String value) {
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            JSON jSON = (JSON)JSON.Default.INSTANCE;
            String value$iv = value;
            boolean $i$f$parse = false;
            return (ReviewBuddyFileData)this_$iv.parse((DeserializationStrategy)ReviewBuddyFileData.Companion.serializer(), value$iv);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        protected String toJson(@NotNull ReviewBuddyFileData value) {
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            JSON jSON = (JSON)JSON.Default.INSTANCE;
            ReviewBuddyFileData value$iv = value;
            boolean $i$f$string = false;
            return this_$iv.string((SerializationStrategy)ReviewBuddyFileData.Companion.serializer(), (Object)value$iv);
        }
    }
}

