/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.hub;

import com.intellij.ml.llm.core.chat.ui.AIAssistantUIUtilKt;
import com.intellij.ml.llm.core.chat.ui.LicenseType;
import com.intellij.ml.llm.core.quota.QuotaInfo;
import com.intellij.ml.llm.hub.AIHubNotificationManager;
import com.intellij.ml.llm.hub.AIHubNotificationManagerKt;
import com.intellij.ml.llm.hub.Notification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00062\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0018\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR#\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\bR\u001d\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ml/llm/hub/AutoHideNotification;", "", "<init>", "()V", "statefulHideRules", "", "Lcom/intellij/ml/llm/hub/Notification;", "getStatefulHideRules", "()Ljava/util/Set;", "licenseDependentHideRules", "", "Lcom/intellij/ml/llm/core/chat/ui/LicenseType;", "getLicenseDependentHideRules", "()Ljava/util/Map;", "paidLicensesHideRules", "getPaidLicensesHideRules", "contradictNotificationsHideRules", "", "getContradictNotificationsHideRules", "()Ljava/util/List;", "getHideReason", "", "notification", "allNotifications", "licenseType", "quotaInfo", "Lcom/intellij/ml/llm/core/quota/QuotaInfo$SuccessfulQuotaInfo;", "intellij.ml.llm.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nAutoHideNotification.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutoHideNotification.kt\ncom/intellij/ml/llm/hub/AutoHideNotification\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,137:1\n1563#2:138\n1634#2,3:139\n*S KotlinDebug\n*F\n+ 1 AutoHideNotification.kt\ncom/intellij/ml/llm/hub/AutoHideNotification\n*L\n40#1:138\n40#1:139,3\n*E\n"})
public final class AutoHideNotification {
    @NotNull
    public static final AutoHideNotification INSTANCE;
    @NotNull
    private static final Set<Notification> statefulHideRules;
    @NotNull
    private static final Map<LicenseType, Set<Notification>> licenseDependentHideRules;
    @NotNull
    private static final Set<Notification> paidLicensesHideRules;
    @NotNull
    private static final List<Set<Notification>> contradictNotificationsHideRules;

    private AutoHideNotification() {
    }

    @NotNull
    public final Set<Notification> getStatefulHideRules() {
        return statefulHideRules;
    }

    @NotNull
    public final Map<LicenseType, Set<Notification>> getLicenseDependentHideRules() {
        return licenseDependentHideRules;
    }

    @NotNull
    public final Set<Notification> getPaidLicensesHideRules() {
        return paidLicensesHideRules;
    }

    @NotNull
    public final List<Set<Notification>> getContradictNotificationsHideRules() {
        return contradictNotificationsHideRules;
    }

    @Nullable
    public final String getHideReason(@NotNull Notification notification, @NotNull Set<? extends Notification> allNotifications, @Nullable LicenseType licenseType, @Nullable QuotaInfo.SuccessfulQuotaInfo quotaInfo) {
        boolean notificationNotPresent;
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        Intrinsics.checkNotNullParameter(allNotifications, (String)"allNotifications");
        boolean bl = notificationNotPresent = !allNotifications.contains(notification);
        if (notificationNotPresent) {
            if (statefulHideRules.contains(notification)) {
                return "statefulHideRules";
            }
            if (notification instanceof Notification.QuotaReachedTopUpExhausting) {
                return "statefulQuotaReachedTopUpExhausting";
            }
            if (notification instanceof Notification.QuotaReaching) {
                return "statefulQuotaReaching";
            }
        }
        if (AIAssistantUIUtilKt.isValid(licenseType)) {
            for (Map.Entry entry : licenseDependentHideRules.entrySet()) {
                LicenseType lt = (LicenseType)((Object)entry.getKey());
                Set allowedNotifications = (Set)entry.getValue();
                if (lt == licenseType || !allowedNotifications.contains(notification)) continue;
                return "licenseDependentHideRules";
            }
        }
        if (notification instanceof Notification.LicenseDependentNotification && licenseType != null && AIAssistantUIUtilKt.isValid(licenseType) && licenseType != ((Notification.LicenseDependentNotification)notification).getLicenseType()) {
            if (licenseType == LicenseType.FREE) {
                if (!AIHubNotificationManagerKt.isExpired(notification) && !Intrinsics.areEqual((Object)notification, (Object)Notification.FREE_ENABLED.INSTANCE)) {
                    return "freeLicenseDependentNotificationHideRule";
                }
            } else if (AIHubNotificationManagerKt.isExpired(notification)) {
                if (Intrinsics.areEqual((Object)AIAssistantUIUtilKt.isPaid(licenseType), (Object)true)) {
                    return "licenseDependentPaidHideRule";
                }
            } else {
                return "licenseDependentNotificationHideRule";
            }
        }
        for (Set set : contradictNotificationsHideRules) {
            int intersectionCount = CollectionsKt.intersect((Iterable)set, (Iterable)allNotifications).size();
            if (intersectionCount > 1) {
                AIHubNotificationManager.Companion.getLog$intellij_ml_llm_core().info("Notifications break contradictNotificationsHideRules: " + allNotifications);
                break;
            }
            if (intersectionCount != 1 || !set.contains(notification) || !notificationNotPresent) continue;
            return "contradictNotificationsHideRules";
        }
        LicenseType licenseType2 = licenseType;
        if (licenseType2 != null ? Intrinsics.areEqual((Object)AIAssistantUIUtilKt.isPaid(licenseType2), (Object)true) : false) {
            if (paidLicensesHideRules.contains(notification)) {
                return "paidLicensesHideRules";
            }
            if (AIHubNotificationManagerKt.isExpired(notification)) {
                return "paidHidesLicenseExpired";
            }
        }
        if (notificationNotPresent && quotaInfo instanceof QuotaInfo.Available) {
            Notification notification2 = notification;
            if (notification2 instanceof Notification.QuotaReached || notification2 instanceof Notification.QuotaReachedTopUpExhausted) {
                return "quotaReachedExpired";
            }
            if ((notification2 instanceof Notification.QuotaReachedTopUp || notification2 instanceof Notification.QuotaReachedTopUpExhausting) && AIAssistantUIUtilKt.isAvailableQuota(AIAssistantUIUtilKt.getTariffQuotaAvailable(quotaInfo))) {
                return "quotaReachedTopUpExpired";
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        INSTANCE = new AutoHideNotification();
        Object[] objectArray = new Notification[]{Notification.THIRD_PARTY_PROVIDERS_BLOCKED.INSTANCE, Notification.QUOTA_ALMOST_REACHED.INSTANCE, Notification.NO_LOCAL_MODELS.INSTANCE, Notification.UPDATE_AVAILABLE.INSTANCE};
        statefulHideRules = SetsKt.setOf((Object[])objectArray);
        licenseDependentHideRules = MapsKt.mapOf((Pair)TuplesKt.to((Object)((Object)LicenseType.FREE), (Object)SetsKt.setOf((Object)Notification.FREE_ENABLED.INSTANCE)));
        paidLicensesHideRules = SetsKt.setOf((Object)Notification.FREE_ENABLED.INSTANCE);
        Iterable $this$map$iv = Notification.LicenseExpiredFreeEnabled.Companion.getAllowedLicenseTypes();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LicenseType licenseType = (LicenseType)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object[] objectArray2 = new Notification[]{Notification.FREE_ENABLED.INSTANCE, new Notification.LicenseExpiredFreeEnabled((LicenseType)it)};
            collection.add(SetsKt.setOf((Object[])objectArray2));
        }
        contradictNotificationsHideRules = (List)var3_3;
    }
}

