/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.util;

import com.intellij.ml.llm.util.ApplicationUtilKt;
import com.intellij.ml.llm.util.NightlyRegistryUtilsKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.registry.Registry;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u0016\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0005\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/util/NightlyRegistryUtils;", "", "<init>", "()V", "stringValue", "", "registryKey", "getNightlyValue", "content", "isNightly", "", "isEnabled", "intellij.ml.llm.core"})
public final class NightlyRegistryUtils {
    @NotNull
    public static final NightlyRegistryUtils INSTANCE = new NightlyRegistryUtils();

    private NightlyRegistryUtils() {
    }

    @NotNull
    public final String stringValue(@NotNull String registryKey) {
        Intrinsics.checkNotNullParameter((Object)registryKey, (String)"registryKey");
        String value = Registry.Companion.stringValue(registryKey);
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
        return this.getNightlyValue(value, ApplicationUtilKt.isNightly(application));
    }

    @NotNull
    public final String getNightlyValue(@NotNull String content2, boolean isNightly) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Regex regex = new Regex("\\s*nightly=\\{(.*?)\\}\\s*");
        MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)content2, (int)0, (int)2, null);
        if (matchResult == null) {
            return content2;
        }
        MatchResult match = matchResult;
        if (isNightly) {
            String string = (String)CollectionsKt.lastOrNull((List)match.getGroupValues());
            if (string == null) {
                throw new IllegalStateException("Failed to parse nightly parameter");
            }
            return string;
        }
        CharSequence charSequence = content2;
        String string = "";
        return regex.replace(charSequence, string);
    }

    /*
     * Unable to fully structure code
     */
    public final boolean isEnabled(@NotNull String registryKey) {
        block10: {
            block8: {
                block9: {
                    Intrinsics.checkNotNullParameter((Object)registryKey, (String)"registryKey");
                    v0 = Registry.Companion.get(registryKey).getSelectedOption();
                    if (v0 != null) {
                        v1 = v0.toUpperCase(Locale.ROOT);
                        v2 = v1;
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"toUpperCase(...)");
                    } else {
                        v2 = value = null;
                    }
                    if (value == null) break block8;
                    switch (value.hashCode()) {
                        case 1053567612: {
                            if (!value.equals("DISABLED")) {
                                ** break;
                            }
                            break block9;
                        }
                        case 1567866983: {
                            if (value.equals("NIGHTLY_ENABLED")) break;
                            ** break;
                        }
                        case -891611359: {
                            if (!value.equals("ENABLED")) ** break;
                            v3 = true;
                            break block10;
                        }
                    }
                    v4 = ApplicationManager.getApplication();
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getApplication(...)");
                    v3 = ApplicationUtilKt.isNightly(v4);
                    break block10;
                }
                v3 = false;
                break block10;
            }
            NightlyRegistryUtilsKt.access$getLogger$p().error("Unknown value for registry key '" + registryKey + "': '" + value + "'");
            v3 = false;
        }
        return v3;
    }
}

