/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.util.file;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u001a\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\tH\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/util/file/FilePathUtils;", "", "<init>", "()V", "resolveFilePath", "Lcom/intellij/openapi/vcs/FilePath;", "project", "Lcom/intellij/openapi/project/Project;", "filePath", "", "verifyFilePath", "path", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nFilePathUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilePathUtils.kt\ncom/intellij/ml/llm/util/file/FilePathUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,35:1\n1#2:36\n*E\n"})
public final class FilePathUtils {
    @NotNull
    public static final FilePathUtils INSTANCE = new FilePathUtils();

    private FilePathUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ApiStatus.Internal
    @Nullable
    public final FilePath resolveFilePath(@NotNull Project project, @NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        String string = FileUtil.toCanonicalPath((String)filePath);
        if (string == null) return null;
        String it = string;
        boolean bl = false;
        String string2 = INSTANCE.verifyFilePath(project, it);
        if (string2 == null) return null;
        it = string2;
        boolean bl2 = false;
        FilePath filePath2 = VcsUtil.getFilePath((String)it);
        return filePath2;
    }

    @ApiStatus.Internal
    @Nullable
    public final String verifyFilePath(@NotNull Project project, @NotNull String path) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string2 = project.getBasePath();
        if (string2 == null) {
            return null;
        }
        String projectPath = string2;
        if (StringsKt.startsWith$default((String)path, (String)projectPath, (boolean)false, (int)2, null)) {
            string = path;
        } else {
            StringBuilder pathBuilder = new StringBuilder(projectPath);
            if (!StringsKt.startsWith$default((CharSequence)path, (char)File.separatorChar, (boolean)false, (int)2, null)) {
                pathBuilder.append(File.separatorChar);
            }
            pathBuilder.append(path);
            String string3 = pathBuilder.toString();
            Intrinsics.checkNotNull((Object)string3);
            string = string3;
        }
        String canonicalFilePath = FileUtil.toCanonicalPath((String)string);
        return canonicalFilePath;
    }
}

