/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.analytics.lifecycle;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.analytics.EventLogMetadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u001f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 62\u00020\u0001:\u00016Bs\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000e\u001a\u00020\b\u0012\b\b\u0002\u0010\u000f\u001a\u00020\b\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0005H\u00c6\u0003J\t\u0010&\u001a\u00020\u0005H\u00c6\u0003J\t\u0010'\u001a\u00020\bH\u00c6\u0003J\t\u0010(\u001a\u00020\bH\u00c6\u0003J\t\u0010)\u001a\u00020\bH\u00c6\u0003J\t\u0010*\u001a\u00020\fH\u00c6\u0003J\t\u0010+\u001a\u00020\u0005H\u00c6\u0003J\t\u0010,\u001a\u00020\bH\u00c6\u0003J\t\u0010-\u001a\u00020\bH\u00c6\u0003J\t\u0010.\u001a\u00020\u0011H\u00c6\u0003Jw\u0010/\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\b2\b\b\u0002\u0010\u000f\u001a\u00020\b2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u00c6\u0001J\u0013\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00103\u001a\u00020\u0005H\u00d6\u0001J\t\u00104\u001a\u000205H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001aR\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001aR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\r\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0017R\u0011\u0010\u000e\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001aR\u0011\u0010\u000f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001aR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u00067"}, d2={"Lorg/jetbrains/analytics/lifecycle/AnalyticsConfig;", "", "metadata", "Lorg/jetbrains/analytics/EventLogMetadata;", "sendThreshold", "", "batchSize", "scheduleInterval", "Ljava/time/Duration;", "retentionTime", "sendOnExitTimeout", "spoolRoot", "Ljava/nio/file/Path;", "maxSendRetries", "initialBackoff", "maxBackoff", "backoffMultiplier", "", "<init>", "(Lorg/jetbrains/analytics/EventLogMetadata;IILjava/time/Duration;Ljava/time/Duration;Ljava/time/Duration;Ljava/nio/file/Path;ILjava/time/Duration;Ljava/time/Duration;D)V", "getMetadata", "()Lorg/jetbrains/analytics/EventLogMetadata;", "getSendThreshold", "()I", "getBatchSize", "getScheduleInterval", "()Ljava/time/Duration;", "getRetentionTime", "getSendOnExitTimeout", "getSpoolRoot", "()Ljava/nio/file/Path;", "getMaxSendRetries", "getInitialBackoff", "getMaxBackoff", "getBackoffMultiplier", "()D", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "Analytics Charts Library"})
@SourceDebugExtension(value={"SMAP\nAnalyticsConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalyticsConfig.kt\norg/jetbrains/analytics/lifecycle/AnalyticsConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,39:1\n1#2:40\n*E\n"})
public final class AnalyticsConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EventLogMetadata metadata;
    private final int sendThreshold;
    private final int batchSize;
    @NotNull
    private final Duration scheduleInterval;
    @NotNull
    private final Duration retentionTime;
    @NotNull
    private final Duration sendOnExitTimeout;
    @NotNull
    private final Path spoolRoot;
    private final int maxSendRetries;
    @NotNull
    private final Duration initialBackoff;
    @NotNull
    private final Duration maxBackoff;
    private final double backoffMultiplier;
    @NotNull
    public static final String JCP_ANALYTICS_ENDPOINT_URL_REGISTRY_KEY = "jcp.analytics.endpoint.url";
    @NotNull
    public static final String JCP_ANALYTICS_ENDPOINT_URL_VM_OPTION_NAME = "JCP_ANALYTICS_ENDPOINT";

    public AnalyticsConfig(@NotNull EventLogMetadata metadata, int sendThreshold, int batchSize, @NotNull Duration scheduleInterval, @NotNull Duration retentionTime, @NotNull Duration sendOnExitTimeout, @NotNull Path spoolRoot, int maxSendRetries, @NotNull Duration initialBackoff, @NotNull Duration maxBackoff, double backoffMultiplier) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)scheduleInterval, (String)"scheduleInterval");
        Intrinsics.checkNotNullParameter((Object)retentionTime, (String)"retentionTime");
        Intrinsics.checkNotNullParameter((Object)sendOnExitTimeout, (String)"sendOnExitTimeout");
        Intrinsics.checkNotNullParameter((Object)spoolRoot, (String)"spoolRoot");
        Intrinsics.checkNotNullParameter((Object)initialBackoff, (String)"initialBackoff");
        Intrinsics.checkNotNullParameter((Object)maxBackoff, (String)"maxBackoff");
        this.metadata = metadata;
        this.sendThreshold = sendThreshold;
        this.batchSize = batchSize;
        this.scheduleInterval = scheduleInterval;
        this.retentionTime = retentionTime;
        this.sendOnExitTimeout = sendOnExitTimeout;
        this.spoolRoot = spoolRoot;
        this.maxSendRetries = maxSendRetries;
        this.initialBackoff = initialBackoff;
        this.maxBackoff = maxBackoff;
        this.backoffMultiplier = backoffMultiplier;
        if (!(this.sendThreshold >= 1)) {
            boolean $i$a$-require-AnalyticsConfig$62 = false;
            String $i$a$-require-AnalyticsConfig$62 = "sendThreshold must be >= 1";
            throw new IllegalArgumentException($i$a$-require-AnalyticsConfig$62.toString());
        }
        if (!(this.batchSize >= 1)) {
            boolean $i$a$-require-AnalyticsConfig$72 = false;
            String $i$a$-require-AnalyticsConfig$72 = "batchSize must be >= 1";
            throw new IllegalArgumentException($i$a$-require-AnalyticsConfig$72.toString());
        }
        if (!(this.scheduleInterval.toMillis() >= 1000L)) {
            boolean $i$a$-require-AnalyticsConfig$82 = false;
            String $i$a$-require-AnalyticsConfig$82 = "scheduleInterval must be >= 1s";
            throw new IllegalArgumentException($i$a$-require-AnalyticsConfig$82.toString());
        }
        if (!(this.maxSendRetries >= 0)) {
            boolean $i$a$-require-AnalyticsConfig$92 = false;
            String $i$a$-require-AnalyticsConfig$92 = "maxSendRetries must be >= 0";
            throw new IllegalArgumentException($i$a$-require-AnalyticsConfig$92.toString());
        }
        if (!(this.backoffMultiplier >= 1.0)) {
            boolean bl = false;
            String string = "backoffMultiplier must be >= 1.0";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ AnalyticsConfig(EventLogMetadata eventLogMetadata, int n, int n2, Duration duration, Duration duration2, Duration duration3, Path path, int n3, Duration duration4, Duration duration5, double d, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 2) != 0) {
            n = 10;
        }
        if ((n4 & 4) != 0) {
            n2 = 50;
        }
        if ((n4 & 8) != 0) {
            Duration duration6 = Duration.ofSeconds(30L);
            Intrinsics.checkNotNullExpressionValue((Object)duration6, (String)"ofSeconds(...)");
            duration = duration6;
        }
        if ((n4 & 0x10) != 0) {
            Duration duration7 = Duration.ofDays(3L);
            Intrinsics.checkNotNullExpressionValue((Object)duration7, (String)"ofDays(...)");
            duration2 = duration7;
        }
        if ((n4 & 0x20) != 0) {
            Duration duration8 = Duration.ofSeconds(2L);
            Intrinsics.checkNotNullExpressionValue((Object)duration8, (String)"ofSeconds(...)");
            duration3 = duration8;
        }
        if ((n4 & 0x40) != 0) {
            String[] stringArray = new String[]{".analytics-outbox"};
            Path path2 = Paths.get(System.getProperty("user.home"), stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
            path = path2;
        }
        if ((n4 & 0x80) != 0) {
            n3 = 5;
        }
        if ((n4 & 0x100) != 0) {
            Duration duration9 = Duration.ofSeconds(10L);
            Intrinsics.checkNotNullExpressionValue((Object)duration9, (String)"ofSeconds(...)");
            duration4 = duration9;
        }
        if ((n4 & 0x200) != 0) {
            Duration duration10 = Duration.ofHours(4L);
            Intrinsics.checkNotNullExpressionValue((Object)duration10, (String)"ofHours(...)");
            duration5 = duration10;
        }
        if ((n4 & 0x400) != 0) {
            d = 2.0;
        }
        this(eventLogMetadata, n, n2, duration, duration2, duration3, path, n3, duration4, duration5, d);
    }

    @NotNull
    public final EventLogMetadata getMetadata() {
        return this.metadata;
    }

    public final int getSendThreshold() {
        return this.sendThreshold;
    }

    public final int getBatchSize() {
        return this.batchSize;
    }

    @NotNull
    public final Duration getScheduleInterval() {
        return this.scheduleInterval;
    }

    @NotNull
    public final Duration getRetentionTime() {
        return this.retentionTime;
    }

    @NotNull
    public final Duration getSendOnExitTimeout() {
        return this.sendOnExitTimeout;
    }

    @NotNull
    public final Path getSpoolRoot() {
        return this.spoolRoot;
    }

    public final int getMaxSendRetries() {
        return this.maxSendRetries;
    }

    @NotNull
    public final Duration getInitialBackoff() {
        return this.initialBackoff;
    }

    @NotNull
    public final Duration getMaxBackoff() {
        return this.maxBackoff;
    }

    public final double getBackoffMultiplier() {
        return this.backoffMultiplier;
    }

    @NotNull
    public final EventLogMetadata component1() {
        return this.metadata;
    }

    public final int component2() {
        return this.sendThreshold;
    }

    public final int component3() {
        return this.batchSize;
    }

    @NotNull
    public final Duration component4() {
        return this.scheduleInterval;
    }

    @NotNull
    public final Duration component5() {
        return this.retentionTime;
    }

    @NotNull
    public final Duration component6() {
        return this.sendOnExitTimeout;
    }

    @NotNull
    public final Path component7() {
        return this.spoolRoot;
    }

    public final int component8() {
        return this.maxSendRetries;
    }

    @NotNull
    public final Duration component9() {
        return this.initialBackoff;
    }

    @NotNull
    public final Duration component10() {
        return this.maxBackoff;
    }

    public final double component11() {
        return this.backoffMultiplier;
    }

    @NotNull
    public final AnalyticsConfig copy(@NotNull EventLogMetadata metadata, int sendThreshold, int batchSize, @NotNull Duration scheduleInterval, @NotNull Duration retentionTime, @NotNull Duration sendOnExitTimeout, @NotNull Path spoolRoot, int maxSendRetries, @NotNull Duration initialBackoff, @NotNull Duration maxBackoff, double backoffMultiplier) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)scheduleInterval, (String)"scheduleInterval");
        Intrinsics.checkNotNullParameter((Object)retentionTime, (String)"retentionTime");
        Intrinsics.checkNotNullParameter((Object)sendOnExitTimeout, (String)"sendOnExitTimeout");
        Intrinsics.checkNotNullParameter((Object)spoolRoot, (String)"spoolRoot");
        Intrinsics.checkNotNullParameter((Object)initialBackoff, (String)"initialBackoff");
        Intrinsics.checkNotNullParameter((Object)maxBackoff, (String)"maxBackoff");
        return new AnalyticsConfig(metadata, sendThreshold, batchSize, scheduleInterval, retentionTime, sendOnExitTimeout, spoolRoot, maxSendRetries, initialBackoff, maxBackoff, backoffMultiplier);
    }

    public static /* synthetic */ AnalyticsConfig copy$default(AnalyticsConfig analyticsConfig, EventLogMetadata eventLogMetadata, int n, int n2, Duration duration, Duration duration2, Duration duration3, Path path, int n3, Duration duration4, Duration duration5, double d, int n4, Object object) {
        if ((n4 & 1) != 0) {
            eventLogMetadata = analyticsConfig.metadata;
        }
        if ((n4 & 2) != 0) {
            n = analyticsConfig.sendThreshold;
        }
        if ((n4 & 4) != 0) {
            n2 = analyticsConfig.batchSize;
        }
        if ((n4 & 8) != 0) {
            duration = analyticsConfig.scheduleInterval;
        }
        if ((n4 & 0x10) != 0) {
            duration2 = analyticsConfig.retentionTime;
        }
        if ((n4 & 0x20) != 0) {
            duration3 = analyticsConfig.sendOnExitTimeout;
        }
        if ((n4 & 0x40) != 0) {
            path = analyticsConfig.spoolRoot;
        }
        if ((n4 & 0x80) != 0) {
            n3 = analyticsConfig.maxSendRetries;
        }
        if ((n4 & 0x100) != 0) {
            duration4 = analyticsConfig.initialBackoff;
        }
        if ((n4 & 0x200) != 0) {
            duration5 = analyticsConfig.maxBackoff;
        }
        if ((n4 & 0x400) != 0) {
            d = analyticsConfig.backoffMultiplier;
        }
        return analyticsConfig.copy(eventLogMetadata, n, n2, duration, duration2, duration3, path, n3, duration4, duration5, d);
    }

    @NotNull
    public String toString() {
        return "AnalyticsConfig(metadata=" + this.metadata + ", sendThreshold=" + this.sendThreshold + ", batchSize=" + this.batchSize + ", scheduleInterval=" + this.scheduleInterval + ", retentionTime=" + this.retentionTime + ", sendOnExitTimeout=" + this.sendOnExitTimeout + ", spoolRoot=" + this.spoolRoot + ", maxSendRetries=" + this.maxSendRetries + ", initialBackoff=" + this.initialBackoff + ", maxBackoff=" + this.maxBackoff + ", backoffMultiplier=" + this.backoffMultiplier + ")";
    }

    public int hashCode() {
        int result2 = this.metadata.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.sendThreshold);
        result2 = result2 * 31 + Integer.hashCode(this.batchSize);
        result2 = result2 * 31 + this.scheduleInterval.hashCode();
        result2 = result2 * 31 + this.retentionTime.hashCode();
        result2 = result2 * 31 + this.sendOnExitTimeout.hashCode();
        result2 = result2 * 31 + ((Object)this.spoolRoot).hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.maxSendRetries);
        result2 = result2 * 31 + this.initialBackoff.hashCode();
        result2 = result2 * 31 + this.maxBackoff.hashCode();
        result2 = result2 * 31 + Double.hashCode(this.backoffMultiplier);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AnalyticsConfig)) {
            return false;
        }
        AnalyticsConfig analyticsConfig = (AnalyticsConfig)other;
        if (!Intrinsics.areEqual((Object)this.metadata, (Object)analyticsConfig.metadata)) {
            return false;
        }
        if (this.sendThreshold != analyticsConfig.sendThreshold) {
            return false;
        }
        if (this.batchSize != analyticsConfig.batchSize) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.scheduleInterval, (Object)analyticsConfig.scheduleInterval)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.retentionTime, (Object)analyticsConfig.retentionTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sendOnExitTimeout, (Object)analyticsConfig.sendOnExitTimeout)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.spoolRoot, (Object)analyticsConfig.spoolRoot)) {
            return false;
        }
        if (this.maxSendRetries != analyticsConfig.maxSendRetries) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.initialBackoff, (Object)analyticsConfig.initialBackoff)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.maxBackoff, (Object)analyticsConfig.maxBackoff)) {
            return false;
        }
        return Double.compare(this.backoffMultiplier, analyticsConfig.backoffMultiplier) == 0;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/analytics/lifecycle/AnalyticsConfig$Companion;", "", "<init>", "()V", "JCP_ANALYTICS_ENDPOINT_URL_REGISTRY_KEY", "", "JCP_ANALYTICS_ENDPOINT_URL_VM_OPTION_NAME", "Analytics Charts Library"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

