/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.vegalite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.spec.OptionsSelectorKt;
import org.jetbrains.letsPlot.core.spec.StatKind;
import org.jetbrains.letsPlot.vegalite.VegaOption;
import org.jetbrains.letsPlot.vegalite.plotson.CoordOptions;
import org.jetbrains.letsPlot.vegalite.plotson.DataMetaOptions;
import org.jetbrains.letsPlot.vegalite.plotson.LayerOptions;
import org.jetbrains.letsPlot.vegalite.plotson.Mapping;
import org.jetbrains.letsPlot.vegalite.plotson.MappingAnnotationOptions;
import org.jetbrains.letsPlot.vegalite.plotson.PlotOptions;
import org.jetbrains.letsPlot.vegalite.plotson.PositionOptions;
import org.jetbrains.letsPlot.vegalite.plotson.PositionOptionsKt;
import org.jetbrains.letsPlot.vegalite.plotson.SeriesAnnotationOptions;
import org.jetbrains.letsPlot.vegalite.plotson.StatOptions;
import org.jetbrains.letsPlot.vegalite.plotson.TitleOptions;
import org.jetbrains.letsPlot.vegalite.plotson.TitleOptionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J?\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u001e\b\u0002\u0010\b\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\t0\u0004H\u0000\u00a2\u0006\u0002\b\nJ*\u0010\u000b\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f0\f2\u000e\u0010\r\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\fJ\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\r\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\fJ\u0016\u0010\u0010\u001a\u00020\u000f2\u000e\u0010\u0011\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\fJ3\u0010\u0012\u001a\u0018\u0012\u0004\u0012\u00020\u0007\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f\u0018\u00010\t2\u000e\u0010\u0013\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\fH\u0000\u00a2\u0006\u0002\b\u0014J\u001e\u0010\u0015\u001a\u00020\u00162\u000e\u0010\r\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f2\u0006\u0010\u0017\u001a\u00020\u0018J4\u0010\u0019\u001a\u00020\u001a2\u000e\u0010\u0011\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f2\u001c\u0010\b\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\t0\u0004J6\u0010\u001b\u001a\u00020\u001c2\u000e\u0010\r\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f2\u001e\b\u0002\u0010\b\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\t0\u0004J\"\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u000e\u0010\u001f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f2\b\u0010 \u001a\u0004\u0018\u00010!J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010\u0001J.\u0010%\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00040\f2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\fJ@\u0010'\u001a\u00020\u0016*\u00020(2\u000e\u0010\u0013\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f2\u001c\u0010\b\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\t0\u00042\u0006\u0010)\u001a\u00020\u001cJ\u0011\u0010*\u001a\u00020\u0007*\u00020\u0007H\u0000\u00a2\u0006\u0002\b+\u00a8\u0006,"}, d2={"Lorg/jetbrains/letsPlot/vegalite/VegaUtil;", "", "()V", "channelToAes", "", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "channel", "", "customChannelMapping", "Lkotlin/Pair;", "channelToAes$lets_plot_vega_lite", "getDefinedChannelEncodings", "", "encoding", "isContinuous", "", "isFlipped", "encodingVegaSpec", "readMark", "layerSpec", "readMark$lets_plot_vega_lite", "transformCoordinateSystem", "", "plotOptions", "Lorg/jetbrains/letsPlot/vegalite/plotson/PlotOptions;", "transformDataMeta", "Lorg/jetbrains/letsPlot/vegalite/plotson/DataMetaOptions;", "transformMappings", "Lorg/jetbrains/letsPlot/vegalite/plotson/Mapping;", "transformPositionAdjust", "Lorg/jetbrains/letsPlot/vegalite/plotson/PositionOptions;", "encodings", "stat", "Lorg/jetbrains/letsPlot/vegalite/plotson/StatOptions;", "transformTitle", "Lorg/jetbrains/letsPlot/vegalite/plotson/TitleOptions;", "vegaTitle", "transposeDataToColumns", "vegaData", "applyConstants", "Lorg/jetbrains/letsPlot/vegalite/plotson/LayerOptions;", "mapping", "unescapeField", "unescapeField$lets_plot_vega_lite", "lets-plot-vega-lite"})
@SourceDebugExtension(value={"SMAP\nVegaUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VegaUtil.kt\norg/jetbrains/letsPlot/vegalite/VegaUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,323:1\n766#2:324\n857#2,2:325\n1603#2,9:327\n1855#2:336\n1856#2:338\n1612#2:339\n1360#2:340\n1446#2,5:341\n1549#2:346\n1620#2,3:347\n1271#2,2:350\n1285#2,2:352\n1549#2:354\n1620#2,3:355\n1288#2:358\n1549#2:362\n1620#2,3:363\n1789#2,3:367\n1477#2:370\n1502#2,3:371\n1505#2,3:381\n1477#2:384\n1502#2,3:385\n1505#2,3:395\n1238#2,2:400\n1549#2:402\n1620#2,3:403\n1241#2:406\n1855#2,2:410\n766#2:413\n857#2,2:414\n1549#2:416\n1620#2,3:417\n1360#2:420\n1446#2,2:421\n1549#2:423\n1620#2,3:424\n1448#2,3:427\n1#3:337\n125#4:359\n152#4,2:360\n154#4:366\n215#4,2:407\n215#4:409\n216#4:412\n372#5,7:374\n372#5,7:388\n453#5:398\n403#5:399\n*S KotlinDebug\n*F\n+ 1 VegaUtil.kt\norg/jetbrains/letsPlot/vegalite/VegaUtil\n*L\n25#1:324\n25#1:325,2\n26#1:327,9\n26#1:336\n26#1:338\n26#1:339\n61#1:340\n61#1:341,5\n61#1:346\n61#1:347,3\n62#1:350,2\n62#1:352,2\n62#1:354\n62#1:355,3\n62#1:358\n100#1:362\n100#1:363,3\n103#1:367,3\n129#1:370\n129#1:371,3\n129#1:381,3\n132#1:384\n132#1:385,3\n132#1:395,3\n135#1:400,2\n135#1:402\n135#1:403,3\n135#1:406\n202#1:410,2\n147#1:413\n147#1:414,2\n148#1:416\n148#1:417,3\n149#1:420\n149#1:421,2\n149#1:423\n149#1:424,3\n149#1:427,3\n26#1:337\n97#1:359\n97#1:360,2\n97#1:366\n161#1:407,2\n173#1:409\n173#1:412\n129#1:374,7\n132#1:388,7\n135#1:398\n135#1:399\n*E\n"})
public final class VegaUtil {
    @NotNull
    public static final VegaUtil INSTANCE = new VegaUtil();

    private VegaUtil() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Map<?, ?>> getDefinedChannelEncodings(@NotNull Map<?, ?> encoding) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(encoding, (String)"encoding");
        Iterable $this$filter$iv = VegaOption.Encoding.INSTANCE.getChannels();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv;
            Object p0 = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!encoding.containsKey(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Pair it$iv$iv;
            Map m;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String ch = (String)element$iv$iv;
            boolean bl2 = false;
            Object[] objectArray = new Object[]{ch};
            Map map2 = m = OptionsSelectorKt.getMap(encoding, (Object[])objectArray);
            if ((map2 != null ? TuplesKt.to((Object)ch, (Object)map2) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    @Nullable
    public final Pair<String, Map<?, ?>> readMark$lets_plot_vega_lite(@NotNull Map<?, ?> layerSpec) {
        Map map2;
        Intrinsics.checkNotNullParameter(layerSpec, (String)"layerSpec");
        Object spec = layerSpec.get("mark");
        if (spec instanceof String) {
            map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"type", spec));
        } else if (spec instanceof Map) {
            map2 = (Map)spec;
        } else {
            return null;
        }
        Map options = map2;
        Object[] objectArray = new Object[]{"type"};
        String string = OptionsSelectorKt.getString((Map)options, (Object[])objectArray);
        if (string == null) {
            return null;
        }
        String mark = string;
        return new Pair((Object)mark, (Object)options);
    }

    @Nullable
    public final TitleOptions transformTitle(@Nullable Object vegaTitle) {
        Object object = vegaTitle;
        return object instanceof String ? TitleOptionsKt.title((Function1<? super TitleOptions, Unit>)((Function1)new Function1<TitleOptions, Unit>(vegaTitle){
            final /* synthetic */ Object $vegaTitle;
            {
                this.$vegaTitle = $vegaTitle;
                super(1);
            }

            public final void invoke(@NotNull TitleOptions $this$title) {
                Intrinsics.checkNotNullParameter((Object)$this$title, (String)"$this$title");
                $this$title.setTitleText((String)this.$vegaTitle);
            }
        })) : (object instanceof Map ? TitleOptionsKt.title((Function1<? super TitleOptions, Unit>)((Function1)new Function1<TitleOptions, Unit>(vegaTitle){
            final /* synthetic */ Object $vegaTitle;
            {
                this.$vegaTitle = $vegaTitle;
                super(1);
            }

            public final void invoke(@NotNull TitleOptions $this$title) {
                Intrinsics.checkNotNullParameter((Object)$this$title, (String)"$this$title");
                Object[] objectArray = new Object[]{"text"};
                $this$title.setTitleText(OptionsSelectorKt.getString((Map)((Map)this.$vegaTitle), (Object[])objectArray));
                objectArray = new Object[]{"subtitle"};
                $this$title.setSubtitleText(OptionsSelectorKt.getString((Map)((Map)this.$vegaTitle), (Object[])objectArray));
            }
        })) : null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, List<Object>> transposeDataToColumns(@NotNull Map<String, ? extends Object> vegaData) {
        String p0;
        Object object;
        void $this$mapTo$iv$iv;
        Iterable list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(vegaData, (String)"vegaData");
        Object[] objectArray = new Object[]{"values"};
        List list = OptionsSelectorKt.getMaps(vegaData, (Object[])objectArray);
        if (list == null) {
            return MapsKt.emptyMap();
        }
        List rows = list;
        Iterable $this$flatMap$iv = rows;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Map it = (Map)element$iv$iv;
            boolean bl = false;
            list$iv$iv = CollectionsKt.filterNotNull((Iterable)it.keySet());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$map$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(p0.toString());
        }
        List columnKeys = (List)destination$iv$iv;
        Iterable $this$associateWith$iv = columnKeys;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            p0 = (String)element$iv$iv;
            Object t = element$iv$iv;
            object = result$iv;
            boolean bl = false;
            Iterable $this$map$iv2 = rows;
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void columnKey;
                void row;
                Map map2 = (Map)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(row.get(columnKey));
            }
            List list2 = (List)destination$iv$iv2;
            object.put(t, list2);
        }
        return result$iv;
    }

    public final boolean isFlipped(@NotNull Map<?, ?> encodingVegaSpec) {
        Intrinsics.checkNotNullParameter(encodingVegaSpec, (String)"encodingVegaSpec");
        return encodingVegaSpec.containsKey("x") && !encodingVegaSpec.containsKey("x2") && encodingVegaSpec.containsKey("y") && encodingVegaSpec.containsKey("y2");
    }

    public final boolean isContinuous(@NotNull String channel, @NotNull Map<?, ?> encoding) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter(encoding, (String)"encoding");
        Object[] objectArray = new Object[]{channel};
        Map map2 = OptionsSelectorKt.getMap(encoding, (Object[])objectArray);
        if (map2 == null) {
            return false;
        }
        Map channelEncoding = map2;
        if (Intrinsics.areEqual((Object)channel, (Object)"longitude")) {
            return true;
        }
        if (Intrinsics.areEqual((Object)channel, (Object)"latitude")) {
            return true;
        }
        if (Intrinsics.areEqual(channelEncoding.get("type"), (Object)"quantitative")) {
            return true;
        }
        if (Intrinsics.areEqual(channelEncoding.get("type"), (Object)"temporal")) {
            return true;
        }
        if (Intrinsics.areEqual(channelEncoding.get("type"), (Object)"ordinal")) {
            return false;
        }
        if (Intrinsics.areEqual(channelEncoding.get("type"), (Object)"nominal")) {
            return false;
        }
        if (channelEncoding.containsKey("bin")) {
            return true;
        }
        if (channelEncoding.containsKey("timeUnit")) {
            return true;
        }
        objectArray = new Object[]{"aggregate"};
        String string = OptionsSelectorKt.getString((Map)channelEncoding, (Object[])objectArray);
        if (string != null) {
            return !(Intrinsics.areEqual((Object)string, (Object)"argmax") ? true : Intrinsics.areEqual((Object)string, (Object)"argmin"));
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Mapping transformMappings(@NotNull Map<?, ?> encoding, @NotNull List<? extends Pair<String, ? extends Aes<?>>> customChannelMapping) {
        void $this$fold$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(encoding, (String)"encoding");
        Intrinsics.checkNotNullParameter(customChannelMapping, (String)"customChannelMapping");
        Object[] objectArray = new Object[]{"detail", "field"};
        String string = OptionsSelectorKt.getString(encoding, (Object[])objectArray);
        String groupingVar = string != null ? this.unescapeField$lets_plot_vega_lite(string) : null;
        Object $this$map$iv = this.getDefinedChannelEncodings(encoding);
        boolean $i$f$map = false;
        Map<String, Map<?, ?>> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            List list;
            Object[] objectArray2;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String channel = (String)entry.getKey();
            Map enc = (Map)entry.getValue();
            String string2 = OptionsSelectorKt.getString((Map)enc, (Object[])(objectArray2 = new Object[]{"field"}));
            if (string2 == null || (string2 = INSTANCE.unescapeField$lets_plot_vega_lite(string2)) == null) {
                list = CollectionsKt.emptyList();
            } else {
                void $this$mapTo$iv$iv2;
                String field = string2;
                List<Aes<?>> aesthetics = INSTANCE.channelToAes$lets_plot_vega_lite(channel, customChannelMapping);
                Iterable $this$map$iv2 = aesthetics;
                boolean $i$f$map2 = false;
                Iterable iterable = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void aes;
                    Aes aes2 = (Aes)item$iv$iv2;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl2 = false;
                    collection2.add(TuplesKt.to((Object)aes, (Object)field));
                }
                list = (List)destination$iv$iv2;
            }
            collection.add(list);
        }
        $this$map$iv = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
        Mapping initial$iv = new Mapping(groupingVar);
        boolean $i$f$fold = false;
        Mapping accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            Pair pair = (Pair)element$iv;
            Mapping mapping = accumulator$iv;
            boolean bl = false;
            Aes aes = (Aes)pair.component1();
            String field = (String)pair.component2();
            accumulator$iv = mapping.plus(TuplesKt.to((Object)aes, (Object)field));
        }
        return accumulator$iv;
    }

    public static /* synthetic */ Mapping transformMappings$default(VegaUtil vegaUtil, Map map2, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        return vegaUtil.transformMappings(map2, list);
    }

    @NotNull
    public final String unescapeField$lets_plot_vega_lite(@NotNull String $this$unescapeField) {
        Intrinsics.checkNotNullParameter((Object)$this$unescapeField, (String)"<this>");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)$this$unescapeField, (String)"\\.", (String)".", (boolean)false, (int)4, null), (String)"\\[", (String)"[", (boolean)false, (int)4, null), (String)"\\]", (String)"]", (boolean)false, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Aes<?>> channelToAes$lets_plot_vega_lite(@NotNull String channel, @NotNull List<? extends Pair<String, ? extends Aes<?>>> customChannelMapping) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object key$iv$iv;
        void $this$groupByTo$iv$iv;
        void $this$groupByTo$iv$iv2;
        void $this$groupBy$iv;
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter(customChannelMapping, (String)"customChannelMapping");
        Object object = new Pair[]{TuplesKt.to((Object)"x", (Object)Aes.Companion.getX()), TuplesKt.to((Object)"y", (Object)Aes.Companion.getY()), TuplesKt.to((Object)"color", (Object)Aes.Companion.getCOLOR()), TuplesKt.to((Object)"fill", (Object)Aes.Companion.getFILL()), TuplesKt.to((Object)"opacity", (Object)Aes.Companion.getALPHA()), TuplesKt.to((Object)"stroke", (Object)Aes.Companion.getCOLOR()), TuplesKt.to((Object)"size", (Object)Aes.Companion.getSIZE()), TuplesKt.to((Object)"angle", (Object)Aes.Companion.getANGLE()), TuplesKt.to((Object)"shape", (Object)Aes.Companion.getSHAPE()), TuplesKt.to((Object)"text", (Object)Aes.Companion.getLABEL()), TuplesKt.to((Object)"longitude", (Object)Aes.Companion.getX()), TuplesKt.to((Object)"latitude", (Object)Aes.Companion.getY())};
        object = CollectionsKt.listOf((Object[])object);
        boolean $i$f$groupBy = false;
        void var6_6 = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv2) {
            Object object2;
            String ch;
            Pair pair = (Pair)element$iv$iv;
            boolean bl = false;
            String key$iv$iv2 = ch = (String)pair.component1();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv2);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv2, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Map defaultChannelMapping = destination$iv$iv;
        Iterable $this$groupBy$iv2 = customChannelMapping;
        boolean $i$f$groupBy22 = false;
        destination$iv$iv = $this$groupBy$iv2;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo2 = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object3;
            Pair bl = (Pair)element$iv$iv;
            boolean bl3 = false;
            String ch = (String)bl.component1();
            key$iv$iv = ch;
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl4 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object3 = answer$iv$iv$iv;
            } else {
                object3 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object3;
            list$iv$iv.add(element$iv$iv);
        }
        Map customChannelMapping2 = destination$iv$iv2;
        Map $i$f$groupBy22 = MapsKt.plus((Map)defaultChannelMapping, (Map)customChannelMapping2);
        boolean $i$f$mapValues = false;
        destination$iv$iv2 = $this$mapValues$iv;
        Map destination$iv$iv3 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$mapTo$iv$iv;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv3;
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl5 = false;
            List mappings = (List)entry.getValue();
            Iterable $this$map$iv = mappings;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv4;
                boolean bl6 = false;
                Aes aes = (Aes)pair.component2();
                collection.add(aes);
            }
            List list = (List)destination$iv$iv4;
            map3.put(k, list);
        }
        Map channelToAes = destination$iv$iv3;
        List list = (List)channelToAes.get(channel);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public static /* synthetic */ List channelToAes$lets_plot_vega_lite$default(VegaUtil vegaUtil, String string, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        return vegaUtil.channelToAes$lets_plot_vega_lite(string, list);
    }

    public final void applyConstants(@NotNull LayerOptions $this$applyConstants, @NotNull Map<?, ?> layerSpec, @NotNull List<? extends Pair<String, ? extends Aes<?>>> customChannelMapping, @NotNull Mapping mapping) {
        Map constants;
        Intrinsics.checkNotNullParameter((Object)$this$applyConstants, (String)"<this>");
        Intrinsics.checkNotNullParameter(layerSpec, (String)"layerSpec");
        Intrinsics.checkNotNullParameter(customChannelMapping, (String)"customChannelMapping");
        Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
        Object[] objectArray = new Object[]{"mark"};
        Map map2 = OptionsSelectorKt.getMap(layerSpec, (Object[])objectArray);
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        Map markSpec = map2;
        Map<Aes<?>, Object> markChannelProps = VegaUtil.applyConstants$readChannel(customChannelMapping, markSpec, new Object[0]);
        Object[] objectArray2 = new Object[]{"encoding"};
        Map map3 = OptionsSelectorKt.getMap(layerSpec, (Object[])objectArray2);
        if (map3 == null) {
            map3 = MapsKt.emptyMap();
        }
        Map encoding = map3;
        objectArray2 = new Object[]{"value"};
        Map<Aes<?>, Object> encodingChannelValues = VegaUtil.applyConstants$readChannel(customChannelMapping, encoding, objectArray2);
        Map $this$forEach$iv = constants = MapsKt.minus((Map)MapsKt.plus(markChannelProps, encodingChannelValues), (Iterable)mapping.getAesthetics().keySet());
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            Aes aes = (Aes)entry.getKey();
            Object value = entry.getValue();
            $this$applyConstants.const(aes, value);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DataMetaOptions transformDataMeta(@NotNull Map<?, ?> encodingVegaSpec, @NotNull List<? extends Pair<String, ? extends Aes<?>>> customChannelMapping) {
        Intrinsics.checkNotNullParameter(encodingVegaSpec, (String)"encodingVegaSpec");
        Intrinsics.checkNotNullParameter(customChannelMapping, (String)"customChannelMapping");
        DataMetaOptions dataMeta = new DataMetaOptions();
        Object[] objectArray = new Object[]{"order", "field"};
        String string = OptionsSelectorKt.getString(encodingVegaSpec, (Object[])objectArray);
        String orderField = string != null ? this.unescapeField$lets_plot_vega_lite(string) : null;
        objectArray = new Object[]{"order", "sort"};
        String orderSort = OptionsSelectorKt.getString(encodingVegaSpec, (Object[])objectArray);
        Map<String, Map<?, ?>> $this$forEach$iv = this.getDefinedChannelEncodings(encodingVegaSpec);
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Map<?, ?>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$forEach$iv2;
            Object[] objectArray2;
            String string2;
            Map.Entry<String, Map<?, ?>> element$iv;
            Map.Entry<String, Map<?, ?>> entry = element$iv = iterator.next();
            boolean bl = false;
            String channel = entry.getKey();
            Map<?, ?> encoding = entry.getValue();
            if (Intrinsics.areEqual((Object)channel, (Object)"x2") || Intrinsics.areEqual((Object)channel, (Object)"y2") || (string2 = OptionsSelectorKt.getString(encoding, (Object[])(objectArray2 = new Object[]{"field"}))) == null || (string2 = INSTANCE.unescapeField$lets_plot_vega_lite(string2)) == null) continue;
            String field = string2;
            if (Intrinsics.areEqual(encoding.get("type"), (Object)"temporal") || encoding.containsKey("timeUnit")) {
                dataMeta.appendSeriesAnnotation((Function1<? super SeriesAnnotationOptions, Unit>)((Function1)new Function1<SeriesAnnotationOptions, Unit>(field){
                    final /* synthetic */ String $field;
                    {
                        this.$field = $field;
                        super(1);
                    }

                    public final void invoke(@NotNull SeriesAnnotationOptions $this$appendSeriesAnnotation) {
                        Intrinsics.checkNotNullParameter((Object)$this$appendSeriesAnnotation, (String)"$this$appendSeriesAnnotation");
                        $this$appendSeriesAnnotation.setType(SeriesAnnotationOptions.Types.DATE_TIME);
                        $this$appendSeriesAnnotation.setColumn(this.$field);
                    }
                }));
            }
            if (encoding.containsKey("timeUnit")) {
                dataMeta.appendMappingAnnotation((Function1<? super MappingAnnotationOptions, Unit>)((Function1)new Function1<MappingAnnotationOptions, Unit>(channel, customChannelMapping, field){
                    final /* synthetic */ String $channel;
                    final /* synthetic */ List<Pair<String, Aes<?>>> $customChannelMapping;
                    final /* synthetic */ String $field;
                    {
                        this.$channel = $channel;
                        this.$customChannelMapping = $customChannelMapping;
                        this.$field = $field;
                        super(1);
                    }

                    public final void invoke(@NotNull MappingAnnotationOptions $this$appendMappingAnnotation) {
                        Intrinsics.checkNotNullParameter((Object)$this$appendMappingAnnotation, (String)"$this$appendMappingAnnotation");
                        $this$appendMappingAnnotation.setAes((Aes)CollectionsKt.firstOrNull(VegaUtil.INSTANCE.channelToAes$lets_plot_vega_lite(this.$channel, this.$customChannelMapping)));
                        $this$appendMappingAnnotation.setAnnotation(MappingAnnotationOptions.AnnotationType.AS_DISCRETE);
                        $this$appendMappingAnnotation.parameters((Function1<? super MappingAnnotationOptions.Parameters, Unit>)((Function1)new Function1<MappingAnnotationOptions.Parameters, Unit>(this.$field){
                            final /* synthetic */ String $field;
                            {
                                this.$field = $field;
                                super(1);
                            }

                            public final void invoke(@NotNull MappingAnnotationOptions.Parameters $this$parameters) {
                                Intrinsics.checkNotNullParameter((Object)$this$parameters, (String)"$this$parameters");
                                $this$parameters.setLabel(this.$field);
                            }
                        }));
                    }
                }));
            }
            if (INSTANCE.isContinuous(channel, encodingVegaSpec)) continue;
            Iterable iterable = INSTANCE.channelToAes$lets_plot_vega_lite(channel, customChannelMapping);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Aes it = (Aes)element$iv2;
                boolean bl2 = false;
                dataMeta.appendMappingAnnotation((Function1<? super MappingAnnotationOptions, Unit>)((Function1)new Function1<MappingAnnotationOptions, Unit>(it, orderField, field, encodingVegaSpec, channel, orderSort){
                    final /* synthetic */ Aes<?> $it;
                    final /* synthetic */ String $orderField;
                    final /* synthetic */ String $field;
                    final /* synthetic */ Map<?, ?> $encodingVegaSpec;
                    final /* synthetic */ String $channel;
                    final /* synthetic */ String $orderSort;
                    {
                        this.$it = $it;
                        this.$orderField = $orderField;
                        this.$field = $field;
                        this.$encodingVegaSpec = $encodingVegaSpec;
                        this.$channel = $channel;
                        this.$orderSort = $orderSort;
                        super(1);
                    }

                    public final void invoke(@NotNull MappingAnnotationOptions $this$appendMappingAnnotation) {
                        Intrinsics.checkNotNullParameter((Object)$this$appendMappingAnnotation, (String)"$this$appendMappingAnnotation");
                        $this$appendMappingAnnotation.setAes(this.$it);
                        $this$appendMappingAnnotation.setAnnotation(MappingAnnotationOptions.AnnotationType.AS_DISCRETE);
                        $this$appendMappingAnnotation.parameters((Function1<? super MappingAnnotationOptions.Parameters, Unit>)((Function1)new Function1<MappingAnnotationOptions.Parameters, Unit>(this.$it, this.$orderField, this.$field, this.$encodingVegaSpec, this.$channel, this.$orderSort){
                            final /* synthetic */ Aes<?> $it;
                            final /* synthetic */ String $orderField;
                            final /* synthetic */ String $field;
                            final /* synthetic */ Map<?, ?> $encodingVegaSpec;
                            final /* synthetic */ String $channel;
                            final /* synthetic */ String $orderSort;
                            {
                                this.$it = $it;
                                this.$orderField = $orderField;
                                this.$field = $field;
                                this.$encodingVegaSpec = $encodingVegaSpec;
                                this.$channel = $channel;
                                this.$orderSort = $orderSort;
                                super(1);
                            }

                            public final void invoke(@NotNull MappingAnnotationOptions.Parameters $this$parameters) {
                                Intrinsics.checkNotNullParameter((Object)$this$parameters, (String)"$this$parameters");
                                if (Intrinsics.areEqual(this.$it, (Object)Aes.Companion.getFILL()) && this.$orderField != null && !Intrinsics.areEqual((Object)this.$orderField, (Object)this.$field)) {
                                    $this$parameters.setOrderBy(this.$orderField);
                                }
                                $this$parameters.setLabel(this.$field);
                                Object[] objectArray = new Object[]{this.$channel, "sort"};
                                $this$parameters.setOrder((MappingAnnotationOptions.OrderType)((Object)(OptionsSelectorKt.has(this.$encodingVegaSpec, (Object[])objectArray) && OptionsSelectorKt.read(this.$encodingVegaSpec, (Object[])(objectArray = new Object[]{this.$channel, "sort"})) == null ? null : (Intrinsics.areEqual((Object)this.$orderSort, (Object)"descending") ? MappingAnnotationOptions.OrderType.DESCENDING : (Intrinsics.areEqual((Object)this.$orderSort, (Object)"ascending") ? MappingAnnotationOptions.OrderType.ASCENDING : (Intrinsics.areEqual((Object)this.$channel, (Object)"y") ? MappingAnnotationOptions.OrderType.DESCENDING : MappingAnnotationOptions.OrderType.ASCENDING))))));
                            }
                        }));
                    }
                }));
            }
        }
        return dataMeta;
    }

    @Nullable
    public final PositionOptions transformPositionAdjust(@NotNull Map<?, ?> encodings, @Nullable StatOptions stat) {
        Object[] yOffsetField;
        Intrinsics.checkNotNullParameter(encodings, (String)"encodings");
        VegaUtil $this$transformPositionAdjust_u24lambda_u2419 = this;
        boolean bl = false;
        Object[] objectArray = new Object[]{"xOffset", "field"};
        String string = OptionsSelectorKt.getString(encodings, (Object[])objectArray);
        String xOffsetField = string != null ? $this$transformPositionAdjust_u24lambda_u2419.unescapeField$lets_plot_vega_lite(string) : null;
        Object[] objectArray2 = new Object[]{"yOffset", "field"};
        String string2 = OptionsSelectorKt.getString(encodings, (Object[])objectArray2);
        Object[] objectArray3 = yOffsetField = string2 != null ? $this$transformPositionAdjust_u24lambda_u2419.unescapeField$lets_plot_vega_lite(string2) : null;
        if (xOffsetField != null || yOffsetField != null) {
            return PositionOptionsKt.dodge$default(null, 1, null);
        }
        VegaUtil $this$transformPositionAdjust_u24lambda_u2420 = this;
        boolean bl2 = false;
        objectArray = new Object[]{"x", "stack"};
        Object xStackDefinition = OptionsSelectorKt.read(encodings, (Object[])objectArray);
        objectArray2 = new Object[]{"y", "stack"};
        Object yStackDefinition = OptionsSelectorKt.read(encodings, (Object[])objectArray2);
        yOffsetField = new Object[]{"x", "stack"};
        boolean hasXStack = OptionsSelectorKt.has(encodings, (Object[])yOffsetField);
        Object[] objectArray4 = new Object[]{"y", "stack"};
        boolean hasYStack = OptionsSelectorKt.has(encodings, (Object[])objectArray4);
        StatOptions statOptions = stat;
        Object object = statOptions != null ? statOptions.getKind() : null;
        PositionOptions defaultPos = (object == null ? -1 : WhenMappings.$EnumSwitchMapping$0[object.ordinal()]) == 1 ? PositionOptionsKt.stack$default(null, 1, null) : null;
        if (!hasXStack && !hasYStack) {
            return defaultPos;
        }
        if (hasXStack && xStackDefinition == null) {
            return PositionOptionsKt.identity$default(null, 1, null);
        }
        if (hasYStack && yStackDefinition == null) {
            return PositionOptionsKt.identity$default(null, 1, null);
        }
        Object object2 = xStackDefinition;
        if (object2 != null || (object2 = yStackDefinition) != null) {
            PositionOptions positionOptions;
            Object stackChannel = object2;
            Object object3 = stackChannel;
            if (Intrinsics.areEqual((Object)object3, (Object)"zero")) {
                positionOptions = PositionOptionsKt.stack$default(null, 1, null);
            } else if (Intrinsics.areEqual((Object)object3, (Object)"normalize")) {
                positionOptions = PositionOptionsKt.fill$default(null, 1, null);
            } else {
                throw new IllegalStateException(("Unsupported stack type: " + stackChannel).toString());
            }
            return positionOptions;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final void transformCoordinateSystem(@NotNull Map<?, ?> encoding, @NotNull PlotOptions plotOptions) {
        CoordOptions.CoordName coordName;
        Intrinsics.checkNotNullParameter(encoding, (String)"encoding");
        Intrinsics.checkNotNullParameter((Object)plotOptions, (String)"plotOptions");
        CoordOptions coordOptions = plotOptions.getCoord();
        Pair<Double, Double> newXDomain = VegaUtil.transformCoordinateSystem$union(coordOptions != null ? coordOptions.getXLim() : null, VegaUtil.transformCoordinateSystem$domain(encoding, "x"));
        CoordOptions coordOptions2 = plotOptions.getCoord();
        Pair<Double, Double> newYDomain = VegaUtil.transformCoordinateSystem$union(coordOptions2 != null ? coordOptions2.getYLim() : null, VegaUtil.transformCoordinateSystem$domain(encoding, "y"));
        CoordOptions.CoordName coordName2 = encoding.containsKey("longitude") ? CoordOptions.CoordName.MAP : (coordName = encoding.containsKey("latitude") ? CoordOptions.CoordName.MAP : null);
        if (newXDomain != null || newYDomain != null || coordName != null) {
            void $this$transformCoordinateSystem_u24lambda_u2421;
            CoordOptions coordOptions3;
            CoordOptions coordOptions4 = plotOptions.getCoord();
            if (coordOptions4 == null) {
                coordOptions4 = new CoordOptions();
            }
            CoordOptions coordOptions5 = coordOptions3 = coordOptions4;
            PlotOptions plotOptions2 = plotOptions;
            boolean bl = false;
            CoordOptions.CoordName coordName3 = coordName;
            if (coordName3 == null) {
                coordName3 = CoordOptions.CoordName.CARTESIAN;
            }
            $this$transformCoordinateSystem_u24lambda_u2421.setName(coordName3);
            $this$transformCoordinateSystem_u24lambda_u2421.setXLim(newXDomain);
            $this$transformCoordinateSystem_u24lambda_u2421.setYLim(newYDomain);
            plotOptions2.setCoord(coordOptions3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<Aes<?>, Object> applyConstants$readChannel(List<? extends Pair<String, ? extends Aes<?>>> $customChannelMapping, Map<?, ?> map2, Object ... path) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        SpreadBuilder spreadBuilder;
        String channel;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = VegaOption.Encoding.INSTANCE.getChannels();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            channel = (String)element$iv$iv;
            boolean bl = false;
            spreadBuilder = new SpreadBuilder(2);
            spreadBuilder.add((Object)channel);
            spreadBuilder.addSpread((Object)path);
            if (!OptionsSelectorKt.has(map2, (Object[])spreadBuilder.toArray(new Object[spreadBuilder.size()]))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            channel = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            List<Aes<?>> list = INSTANCE.channelToAes$lets_plot_vega_lite(channel, $customChannelMapping);
            spreadBuilder = new SpreadBuilder(2);
            spreadBuilder.add((Object)channel);
            spreadBuilder.addSpread((Object)path);
            Object object = OptionsSelectorKt.read(map2, (Object[])spreadBuilder.toArray(new Object[spreadBuilder.size()]));
            Intrinsics.checkNotNull((Object)object);
            collection.add(TuplesKt.to(list, (Object)object));
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            channel = (Pair)element$iv$iv;
            boolean bl = false;
            List aesthetics = (List)channel.component1();
            Object value = channel.component2();
            Iterable $this$map$iv2 = aesthetics;
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void aes;
                Aes aes2 = (Aes)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(TuplesKt.to((Object)aes, (Object)value));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private static final Pair<Double, Double> transformCoordinateSystem$domain(Map<?, ?> $encoding, String channel) {
        Object object;
        Object[] objectArray = new Object[]{channel, "scale", "domainMin"};
        Number domainMin = OptionsSelectorKt.getNumber($encoding, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{channel, "scale", "domainMax"};
        Number domainMax = OptionsSelectorKt.getNumber($encoding, (Object[])objectArray2);
        Object[] objectArray3 = new Object[]{channel, "scale", "domain"};
        List domain = OptionsSelectorKt.getList($encoding, (Object[])objectArray3);
        Number number = domainMin;
        if (number == null) {
            List list = domain;
            object = list != null ? CollectionsKt.getOrNull((List)list, (int)0) : null;
            number = object instanceof Number ? (Number)object : null;
        }
        Double d = number != null ? Double.valueOf(number.doubleValue()) : null;
        Number number2 = domainMax;
        if (number2 == null) {
            List list = domain;
            object = list != null ? CollectionsKt.getOrNull((List)list, (int)1) : null;
            number2 = object instanceof Number ? (Number)object : null;
        }
        return new Pair((Object)d, (Object)(number2 != null ? Double.valueOf(number2.doubleValue()) : null));
    }

    private static final Pair<Double, Double> transformCoordinateSystem$union(Pair<Double, Double> curDomain, Pair<Double, Double> newDomain) {
        Pair pair = curDomain;
        if (pair == null) {
            pair = new Pair(null, null);
        }
        Pair pair2 = pair;
        Double curMin = (Double)pair2.component1();
        Double curMax = (Double)pair2.component2();
        Double newMin = (Double)newDomain.component1();
        Double newMax = (Double)newDomain.component2();
        Object[] objectArray = new Double[]{curMin, newMin};
        Double resultMin = CollectionsKt.minOrNull((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray));
        Object[] objectArray2 = new Double[]{curMax, newMax};
        Double resultMax = CollectionsKt.maxOrNull((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray2));
        return resultMin != null || resultMax != null ? new Pair((Object)resultMin, (Object)resultMax) : null;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StatKind.values().length];
            try {
                nArray[StatKind.DENSITY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

