/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.code.features.diff.algorithms;

import ai.grazie.code.features.diff.Diff;
import ai.grazie.code.features.diff.DiffAlgorithm;
import ai.grazie.code.features.diff.DiffOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J*\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0016J*\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0002J>\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00120\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lai/grazie/code/features/diff/algorithms/LcsDiffAlgorithm;", "T", "Lai/grazie/code/features/diff/DiffAlgorithm;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "diff", "Lai/grazie/code/features/diff/Diff;", "source", "", "target", "computeLCS", "a", "b", "generateDiffOperations", "Lai/grazie/code/features/diff/DiffOperation;", "lcs", "code-features-diff"})
@SourceDebugExtension(value={"SMAP\nLcsDiffAlgorithm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LcsDiffAlgorithm.kt\nai/grazie/code/features/diff/algorithms/LcsDiffAlgorithm\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n1563#2:104\n1634#2,3:105\n*S KotlinDebug\n*F\n+ 1 LcsDiffAlgorithm.kt\nai/grazie/code/features/diff/algorithms/LcsDiffAlgorithm\n*L\n22#1:104\n22#1:105,3\n*E\n"})
public final class LcsDiffAlgorithm<T>
implements DiffAlgorithm<T> {
    @NotNull
    private final String id;

    public LcsDiffAlgorithm() {
        this.id = "lcs";
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Diff<T> diff(@NotNull List<? extends T> source, @NotNull List<? extends T> target) {
        Intrinsics.checkNotNullParameter(source, (String)"source");
        Intrinsics.checkNotNullParameter(target, (String)"target");
        if (Intrinsics.areEqual(source, target)) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = source;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new DiffOperation<void>(DiffOperation.Type.KEEP, it));
            }
            List list2 = (List)destination$iv$iv;
            return new Diff(list2);
        }
        List<? extends T> lcs = this.computeLCS(source, target);
        return new Diff(this.generateDiffOperations(source, target, lcs));
    }

    private final List<T> computeLCS(List<? extends T> a, List<? extends T> b) {
        int n;
        int n2 = 0;
        int n3 = a.size() + 1;
        int[][] nArrayArray = new int[n3][];
        while (n2 < n3) {
            n = n2++;
            nArrayArray[n] = new int[b.size() + 1];
        }
        int[][] lengths = nArrayArray;
        n3 = ((Collection)a).size();
        for (int i = 0; i < n3; ++i) {
            n = ((Collection)b).size();
            for (int j = 0; j < n; ++j) {
                lengths[i + 1][j + 1] = Intrinsics.areEqual(a.get(i), b.get(j)) ? lengths[i][j] + 1 : Math.max(lengths[i + 1][j], lengths[i][j + 1]);
            }
        }
        List result2 = new ArrayList();
        int i = a.size();
        int j = b.size();
        while (i > 0 && j > 0) {
            if (Intrinsics.areEqual(a.get(i - 1), b.get(j - 1))) {
                result2.add(0, a.get(i - 1));
                --i;
                --j;
                continue;
            }
            if (lengths[i - 1][j] > lengths[i][j - 1]) {
                --i;
                continue;
            }
            --j;
        }
        return result2;
    }

    private final List<DiffOperation<T>> generateDiffOperations(List<? extends T> a, List<? extends T> b, List<? extends T> lcs) {
        List result2 = new ArrayList();
        int aIndex = 0;
        int bIndex = 0;
        int lcsIndex = 0;
        while (aIndex < a.size() || bIndex < b.size()) {
            if (lcsIndex < lcs.size() && aIndex < a.size() && bIndex < b.size() && Intrinsics.areEqual(a.get(aIndex), lcs.get(lcsIndex)) && Intrinsics.areEqual(b.get(bIndex), lcs.get(lcsIndex))) {
                result2.add(new DiffOperation<T>(DiffOperation.Type.KEEP, a.get(aIndex)));
                ++aIndex;
                ++bIndex;
                ++lcsIndex;
                continue;
            }
            if (!(aIndex >= a.size() || lcsIndex < lcs.size() && Intrinsics.areEqual(a.get(aIndex), lcs.get(lcsIndex)))) {
                result2.add(new DiffOperation<T>(DiffOperation.Type.DELETE, a.get(aIndex)));
                ++aIndex;
                continue;
            }
            if (bIndex >= b.size() || lcsIndex < lcs.size() && Intrinsics.areEqual(b.get(bIndex), lcs.get(lcsIndex))) continue;
            result2.add(new DiffOperation<T>(DiffOperation.Type.INSERT, b.get(bIndex)));
            ++bIndex;
        }
        return result2;
    }
}

