/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.code.files.vfs.memory;

import ai.grazie.code.files.vfs.VirtualPath;
import ai.grazie.code.files.vfs.memory.VirtualEntry;
import ai.grazie.code.files.vfs.memory.VirtualFile;
import ai.grazie.code.files.vfs.memory.VirtualFileSystem;
import ai.grazie.code.files.vfs.memory.VirtualFolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0002\u001b\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000bH\u0016J\u0018\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000bH\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lai/grazie/code/files/vfs/memory/InMemoryFileSystem;", "Lai/grazie/code/files/vfs/memory/VirtualFileSystem;", "<init>", "()V", "root", "Lai/grazie/code/files/vfs/memory/VirtualFolder;", "getRoot", "()Lai/grazie/code/files/vfs/memory/VirtualFolder;", "getFile", "Lai/grazie/code/files/vfs/memory/VirtualFile;", "path", "Lai/grazie/code/files/vfs/VirtualPath;", "getFolder", "createFolders", "createFile", "content", "", "delete", "", "move", "from", "to", "copy", "moveFolderContents", "", "source", "target", "InMemoryFile", "InMemoryFolder", "code-files-vfs"})
public final class InMemoryFileSystem
implements VirtualFileSystem {
    @NotNull
    private final VirtualFolder root = new InMemoryFolder(VirtualPath.Companion.getROOT(), null, 2, null);

    @Override
    @NotNull
    public VirtualFolder getRoot() {
        return this.root;
    }

    @Override
    @Nullable
    public VirtualFile getFile(@NotNull VirtualPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (path.isRoot()) {
            return null;
        }
        VirtualPath virtualPath = path.getParent();
        Intrinsics.checkNotNull((Object)virtualPath);
        VirtualFolder virtualFolder = this.getFolder(virtualPath);
        if (virtualFolder == null) {
            return null;
        }
        VirtualFolder parent = virtualFolder;
        return parent.getFile(path.getName());
    }

    @Override
    @Nullable
    public VirtualFolder getFolder(@NotNull VirtualPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (path.isRoot()) {
            return this.getRoot();
        }
        VirtualPath virtualPath = path.getParent();
        Intrinsics.checkNotNull((Object)virtualPath);
        VirtualFolder virtualFolder = this.getFolder(virtualPath);
        if (virtualFolder == null) {
            return null;
        }
        VirtualFolder parent = virtualFolder;
        return parent.getFolder(path.getName());
    }

    @Override
    @NotNull
    public VirtualFolder createFolders(@NotNull VirtualPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (path.isRoot()) {
            return this.getRoot();
        }
        VirtualFolder current = this.getRoot();
        for (String component : path.getComponents()) {
            VirtualFolder virtualFolder = current.getFolder(component);
            if (virtualFolder == null) {
                virtualFolder = current.createFolder(component);
            }
            current = virtualFolder;
        }
        return current;
    }

    @Override
    @NotNull
    public VirtualFile createFile(@NotNull VirtualPath path, @NotNull byte[] content2) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        if (path.isRoot()) {
            throw new IllegalArgumentException("Cannot create file at root path");
        }
        VirtualPath virtualPath = path.getParent();
        Intrinsics.checkNotNull((Object)virtualPath);
        VirtualFolder parent = this.createFolders(virtualPath);
        return parent.createFile(path.getName(), content2);
    }

    @Override
    public boolean delete(@NotNull VirtualPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (path.isRoot()) {
            return false;
        }
        VirtualPath virtualPath = path.getParent();
        Intrinsics.checkNotNull((Object)virtualPath);
        VirtualFolder virtualFolder = this.getFolder(virtualPath);
        if (virtualFolder == null) {
            return false;
        }
        VirtualFolder parent = virtualFolder;
        return parent.delete(path.getName());
    }

    @Override
    public boolean move(@NotNull VirtualPath from, @NotNull VirtualPath to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        if (from.isRoot() || to.isRoot()) {
            throw new IllegalArgumentException("Cannot move root path");
        }
        VirtualPath virtualPath = from.getParent();
        Intrinsics.checkNotNull((Object)virtualPath);
        VirtualFolder virtualFolder = this.getFolder(virtualPath);
        if (virtualFolder == null) {
            return false;
        }
        VirtualFolder sourceParent = virtualFolder;
        VirtualPath virtualPath2 = to.getParent();
        Intrinsics.checkNotNull((Object)virtualPath2);
        VirtualFolder targetParent = this.createFolders(virtualPath2);
        String name2 = to.getName();
        VirtualFile sourceFile = sourceParent.getFile(from.getName());
        if (sourceFile != null) {
            sourceParent.delete(from.getName());
            targetParent.createFile(name2, sourceFile.getContent());
            return true;
        }
        VirtualFolder sourceFolder = sourceParent.getFolder(from.getName());
        if (sourceFolder != null) {
            sourceParent.delete(from.getName());
            VirtualFolder targetFolder = targetParent.createFolder(name2);
            this.moveFolderContents(sourceFolder, targetFolder);
            return true;
        }
        return false;
    }

    @Override
    public boolean copy(@NotNull VirtualPath from, @NotNull VirtualPath to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        if (from.isRoot() || to.isRoot()) {
            throw new IllegalArgumentException("Cannot move root path");
        }
        VirtualPath virtualPath = from.getParent();
        Intrinsics.checkNotNull((Object)virtualPath);
        VirtualFolder virtualFolder = this.getFolder(virtualPath);
        if (virtualFolder == null) {
            return false;
        }
        VirtualFolder sourceParent = virtualFolder;
        VirtualPath virtualPath2 = to.getParent();
        Intrinsics.checkNotNull((Object)virtualPath2);
        VirtualFolder targetParent = this.createFolders(virtualPath2);
        String name2 = to.getName();
        VirtualFile sourceFile = sourceParent.getFile(from.getName());
        if (sourceFile != null) {
            targetParent.createFile(name2, sourceFile.getContent());
            return true;
        }
        VirtualFolder sourceFolder = sourceParent.getFolder(from.getName());
        if (sourceFolder != null) {
            VirtualFolder targetFolder = targetParent.createFolder(name2);
            this.moveFolderContents(sourceFolder, targetFolder);
            return true;
        }
        return false;
    }

    private final void moveFolderContents(VirtualFolder source, VirtualFolder target) {
        for (VirtualEntry entry2 : source.getEntries()) {
            VirtualEntry virtualEntry = entry2;
            if (virtualEntry instanceof VirtualFile) {
                target.createFile(entry2.getPath().getName(), ((VirtualFile)entry2).getContent());
                continue;
            }
            if (virtualEntry instanceof VirtualFolder) {
                VirtualFolder newFolder = target.createFolder(entry2.getPath().getName());
                this.moveFolderContents((VirtualFolder)entry2, newFolder);
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lai/grazie/code/files/vfs/memory/InMemoryFileSystem$InMemoryFile;", "Lai/grazie/code/files/vfs/memory/VirtualFile;", "path", "Lai/grazie/code/files/vfs/VirtualPath;", "content", "", "<init>", "(Lai/grazie/code/files/vfs/VirtualPath;[B)V", "getPath", "()Lai/grazie/code/files/vfs/VirtualPath;", "getContent", "()[B", "setContent", "([B)V", "code-files-vfs"})
    private static final class InMemoryFile
    implements VirtualFile {
        @NotNull
        private final VirtualPath path;
        @NotNull
        private byte[] content;

        public InMemoryFile(@NotNull VirtualPath path, @NotNull byte[] content2) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            this.path = path;
            this.content = content2;
        }

        @Override
        @NotNull
        public VirtualPath getPath() {
            return this.path;
        }

        @Override
        @NotNull
        public byte[] getContent() {
            return this.content;
        }

        public void setContent(@NotNull byte[] byArray) {
            Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
            this.content = byArray;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\fH\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00010\fH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lai/grazie/code/files/vfs/memory/InMemoryFileSystem$InMemoryFolder;", "Lai/grazie/code/files/vfs/memory/VirtualFolder;", "path", "Lai/grazie/code/files/vfs/VirtualPath;", "mutableEntries", "", "Lai/grazie/code/files/vfs/memory/VirtualEntry;", "<init>", "(Lai/grazie/code/files/vfs/VirtualPath;Ljava/util/List;)V", "getPath", "()Lai/grazie/code/files/vfs/VirtualPath;", "entries", "", "getEntries", "()Ljava/util/List;", "createFile", "Lai/grazie/code/files/vfs/memory/VirtualFile;", "name", "", "content", "", "createFolder", "writeFile", "getFile", "getFolder", "listFiles", "listFolders", "delete", "", "code-files-vfs"})
    @SourceDebugExtension(value={"SMAP\nInMemoryFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InMemoryFileSystem.kt\nai/grazie/code/files/vfs/memory/InMemoryFileSystem$InMemoryFolder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,163:1\n1#2:164\n808#3,11:165\n808#3,11:176\n808#3,11:187\n808#3,11:198\n360#3,7:209\n*S KotlinDebug\n*F\n+ 1 InMemoryFileSystem.kt\nai/grazie/code/files/vfs/memory/InMemoryFileSystem$InMemoryFolder\n*L\n42#1:165,11\n45#1:176,11\n48#1:187,11\n51#1:198,11\n54#1:209,7\n*E\n"})
    private static final class InMemoryFolder
    implements VirtualFolder {
        @NotNull
        private final VirtualPath path;
        @NotNull
        private final List<VirtualEntry> mutableEntries;

        public InMemoryFolder(@NotNull VirtualPath path, @NotNull List<VirtualEntry> mutableEntries) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(mutableEntries, (String)"mutableEntries");
            this.path = path;
            this.mutableEntries = mutableEntries;
        }

        public /* synthetic */ InMemoryFolder(VirtualPath virtualPath, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                list2 = new ArrayList();
            }
            this(virtualPath, list2);
        }

        @Override
        @NotNull
        public VirtualPath getPath() {
            return this.path;
        }

        @Override
        @NotNull
        public List<VirtualEntry> getEntries() {
            return CollectionsKt.toList((Iterable)this.mutableEntries);
        }

        @Override
        @NotNull
        public VirtualFile createFile(@NotNull String name2, @NotNull byte[] content2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            if (!(!StringsKt.contains$default((CharSequence)name2, (CharSequence)"/", (boolean)false, (int)2, null) && ((CharSequence)name2).length() > 0)) {
                boolean bl = false;
                String string = "Invalid file name: " + name2;
                throw new IllegalArgumentException(string.toString());
            }
            InMemoryFile file = new InMemoryFile(this.getPath().resolve(name2), content2);
            this.mutableEntries.add(file);
            return file;
        }

        @Override
        @NotNull
        public VirtualFolder createFolder(@NotNull String name2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            if (!(!StringsKt.contains$default((CharSequence)name2, (CharSequence)"/", (boolean)false, (int)2, null) && ((CharSequence)name2).length() > 0)) {
                boolean bl = false;
                String string = "Invalid folder name: " + name2;
                throw new IllegalArgumentException(string.toString());
            }
            InMemoryFolder folder = new InMemoryFolder(this.getPath().resolve(name2), null, 2, null);
            this.mutableEntries.add(folder);
            return folder;
        }

        @Override
        @NotNull
        public VirtualFile writeFile(@NotNull String name2, @NotNull byte[] content2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            if (!(!StringsKt.contains$default((CharSequence)name2, (CharSequence)"/", (boolean)false, (int)2, null) && ((CharSequence)name2).length() > 0)) {
                boolean $i$a$-require-InMemoryFileSystem$InMemoryFolder$writeFile$32 = false;
                String $i$a$-require-InMemoryFileSystem$InMemoryFolder$writeFile$32 = "Invalid file name: " + name2;
                throw new IllegalArgumentException($i$a$-require-InMemoryFileSystem$InMemoryFolder$writeFile$32.toString());
            }
            VirtualFile file = this.getFile(name2);
            if (!(file != null)) {
                boolean bl = false;
                String string = "File " + name2 + " does not exist";
                throw new IllegalArgumentException(string.toString());
            }
            this.delete(name2);
            InMemoryFile updated = new InMemoryFile(this.getPath().resolve(name2), content2);
            this.mutableEntries.add(updated);
            return updated;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        public VirtualFile getFile(@NotNull String name2) {
            Object v0;
            block2: {
                void $this$filterIsInstanceTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Iterable $this$filterIsInstance$iv = this.getEntries();
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof VirtualFile)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable iterable2 = (List)destination$iv$iv;
                for (Object e : iterable2) {
                    VirtualFile it = (VirtualFile)e;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getPath().getName(), (Object)name2)) continue;
                    v0 = e;
                    break block2;
                }
                v0 = null;
            }
            return v0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        public VirtualFolder getFolder(@NotNull String name2) {
            Object v0;
            block2: {
                void $this$filterIsInstanceTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Iterable $this$filterIsInstance$iv = this.getEntries();
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof VirtualFolder)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable iterable2 = (List)destination$iv$iv;
                for (Object e : iterable2) {
                    VirtualFolder it = (VirtualFolder)e;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getPath().getName(), (Object)name2)) continue;
                    v0 = e;
                    break block2;
                }
                v0 = null;
            }
            return v0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<VirtualFile> listFiles() {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = this.getEntries();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof VirtualFile)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<VirtualFolder> listFolders() {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = this.getEntries();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof VirtualFolder)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @Override
        public boolean delete(@NotNull String name2) {
            boolean bl;
            int index;
            block4: {
                int n;
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                List<VirtualEntry> $this$indexOfFirst$iv = this.mutableEntries;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<VirtualEntry> iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    VirtualEntry item$iv;
                    VirtualEntry it = item$iv = iterator.next();
                    boolean bl2 = false;
                    if (Intrinsics.areEqual((Object)it.getPath().getName(), (Object)name2)) {
                        n = index$iv;
                        break block4;
                    }
                    ++index$iv;
                }
                n = index = -1;
            }
            if (index >= 0) {
                this.mutableEntries.remove(index);
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }
    }
}

