/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.llm.provider.openai.profile;

import ai.grazie.llm.profile.ConfigurablePricing;
import ai.grazie.llm.utils.LLMPricingUtilsKt;
import ai.grazie.model.bdg.price.FixedResourcePricing;
import ai.grazie.model.bdg.price.ResourcePricing;
import ai.grazie.model.llm.bdg.pricing.BudgetInfo;
import ai.grazie.model.llm.bdg.pricing.LLMPricing;
import ai.grazie.model.llm.bdg.pricing.LLMUsage;
import ai.grazie.utils.PricingException;
import ai.grazie.utils.mpp.money.Money;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u0019*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u0019BG\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0005\u0012\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0005\u00a2\u0006\u0004\b\t\u0010\nB1\b\u0016\u0012\u0006\u0010\u000b\u001a\u00028\u0000\u0012\u0006\u0010\f\u001a\u00028\u0000\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00018\u0000\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0004\b\t\u0010\u000fJ\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0019\u0010\u0007\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0019\u0010\b\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lai/grazie/llm/provider/openai/profile/OpenAILLMPricing;", "T", "Lai/grazie/utils/mpp/money/Money;", "Lai/grazie/model/llm/bdg/pricing/LLMPricing;", "input", "Lai/grazie/model/bdg/price/ResourcePricing;", "output", "cacheRead", "thinking", "<init>", "(Lai/grazie/model/bdg/price/ResourcePricing;Lai/grazie/model/bdg/price/ResourcePricing;Lai/grazie/model/bdg/price/ResourcePricing;Lai/grazie/model/bdg/price/ResourcePricing;)V", "inputPerToken", "outputPerToken", "cacheReadPerToken", "thinkingPerToken", "(Lai/grazie/utils/mpp/money/Money;Lai/grazie/utils/mpp/money/Money;Lai/grazie/utils/mpp/money/Money;Lai/grazie/utils/mpp/money/Money;)V", "getInput", "()Lai/grazie/model/bdg/price/ResourcePricing;", "getOutput", "getCacheRead", "getThinking", "estimate", "Lai/grazie/model/llm/bdg/pricing/BudgetInfo;", "tokens", "Lai/grazie/model/llm/bdg/pricing/LLMUsage;", "Companion", "llm-provider-openai-profile"})
@SourceDebugExtension(value={"SMAP\nOpenAILLMPricing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenAILLMPricing.kt\nai/grazie/llm/provider/openai/profile/OpenAILLMPricing\n+ 2 PricingRequireUtils.kt\nai/grazie/utils/PricingRequireUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n9#2,2:102\n11#2,4:105\n9#2,2:109\n11#2,4:112\n9#2,2:116\n11#2,4:119\n9#2,2:123\n11#2,4:126\n9#2,2:130\n11#2,4:133\n9#2,2:137\n11#2,4:140\n1#3:104\n1#3:111\n1#3:118\n1#3:125\n1#3:132\n1#3:139\n1#3:144\n*S KotlinDebug\n*F\n+ 1 OpenAILLMPricing.kt\nai/grazie/llm/provider/openai/profile/OpenAILLMPricing\n*L\n29#1:102,2\n29#1:105,4\n30#1:109,2\n30#1:112,4\n31#1:116,2\n31#1:119,4\n32#1:123,2\n32#1:126,4\n33#1:130,2\n33#1:133,4\n34#1:137,2\n34#1:140,4\n29#1:104\n30#1:111\n31#1:118\n32#1:125\n33#1:132\n34#1:139\n*E\n"})
public final class OpenAILLMPricing<T extends Money<T>>
implements LLMPricing<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourcePricing<T> input;
    @NotNull
    private final ResourcePricing<T> output;
    @Nullable
    private final ResourcePricing<T> cacheRead;
    @Nullable
    private final ResourcePricing<T> thinking;

    public OpenAILLMPricing(@NotNull ResourcePricing<T> input, @NotNull ResourcePricing<T> output, @Nullable ResourcePricing<T> cacheRead, @Nullable ResourcePricing<T> thinking) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Intrinsics.checkNotNullParameter(output, (String)"output");
        this.input = input;
        this.output = output;
        this.cacheRead = cacheRead;
        this.thinking = thinking;
    }

    public /* synthetic */ OpenAILLMPricing(ResourcePricing resourcePricing, ResourcePricing resourcePricing2, ResourcePricing resourcePricing3, ResourcePricing resourcePricing4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            resourcePricing3 = null;
        }
        if ((n & 8) != 0) {
            resourcePricing4 = null;
        }
        this(resourcePricing, resourcePricing2, resourcePricing3, resourcePricing4);
    }

    @NotNull
    public final ResourcePricing<T> getInput() {
        return this.input;
    }

    @NotNull
    public final ResourcePricing<T> getOutput() {
        return this.output;
    }

    @Nullable
    public final ResourcePricing<T> getCacheRead() {
        return this.cacheRead;
    }

    @Nullable
    public final ResourcePricing<T> getThinking() {
        return this.thinking;
    }

    @Override
    @NotNull
    public BudgetInfo<T> estimate(@NotNull LLMUsage tokens2) {
        Intrinsics.checkNotNullParameter((Object)tokens2, (String)"tokens");
        boolean value$iv = tokens2.getCacheWriteTokens() == 0;
        boolean $i$f$pricingRequire = false;
        try {
            if (!value$iv) {
                boolean $i$a$-require-PricingRequireUtilsKt$pricingRequire$1$iv22 = false;
                boolean bl = false;
                String $i$a$-require-PricingRequireUtilsKt$pricingRequire$1$iv22 = "Cache read tokens are not supported by OpenAILLMPricing".toString();
                throw new IllegalArgumentException($i$a$-require-PricingRequireUtilsKt$pricingRequire$1$iv22.toString());
            }
        }
        catch (Exception e$iv) {
            boolean bl = false;
            Throwable throwable = e$iv;
            String string = "Cache read tokens are not supported by OpenAILLMPricing".toString();
            throw new PricingException(string, throwable);
        }
        value$iv = tokens2.getCacheWriteEphemeral5mTokens() == 0;
        $i$f$pricingRequire = false;
        try {
            if (!value$iv) {
                boolean $i$a$-require-PricingRequireUtilsKt$pricingRequire$1$iv32 = false;
                boolean bl = false;
                String $i$a$-require-PricingRequireUtilsKt$pricingRequire$1$iv32 = "Cache write ephemeral 5m tokens are not supported by OpenAILLMPricing".toString();
                throw new IllegalArgumentException($i$a$-require-PricingRequireUtilsKt$pricingRequire$1$iv32.toString());
            }
        }
        catch (Exception e$iv) {
            boolean bl = false;
            Throwable throwable = e$iv;
            String string = "Cache write ephemeral 5m tokens are not supported by OpenAILLMPricing".toString();
            throw new PricingException(string, throwable);
        }
        value$iv = tokens2.getCacheWriteEphemeral1hTokens() == 0;
        $i$f$pricingRequire = false;
        try {
            if (!value$iv) {
                boolean $i$a$-require-PricingRequireUtilsKt$pricingRequire$1$iv42 = false;
                boolean bl = false;
                String $i$a$-require-PricingRequireUtilsKt$pricingRequire$1$iv42 = "Cache write ephemeral 1h tokens are not supported by OpenAILLMPricing".toString();
                throw new IllegalArgumentException($i$a$-require-PricingRequireUtilsKt$pricingRequire$1$iv42.toString());
            }
        }
        catch (Exception e$iv) {
            boolean bl = false;
            Throwable throwable = e$iv;
            String string = "Cache write ephemeral 1h tokens are not supported by OpenAILLMPricing".toString();
            throw new PricingException(string, throwable);
        }
        value$iv = tokens2.getServerToolWebFetchRequests() == 0;
        $i$f$pricingRequire = false;
        try {
            if (!value$iv) {
                boolean $i$a$-require-PricingRequireUtilsKt$pricingRequire$1$iv52 = false;
                boolean bl = false;
                String $i$a$-require-PricingRequireUtilsKt$pricingRequire$1$iv52 = "Server tool web fetch requests are not supported by OpenAILLMPricing".toString();
                throw new IllegalArgumentException($i$a$-require-PricingRequireUtilsKt$pricingRequire$1$iv52.toString());
            }
        }
        catch (Exception e$iv) {
            boolean bl = false;
            Throwable throwable = e$iv;
            String string = "Server tool web fetch requests are not supported by OpenAILLMPricing".toString();
            throw new PricingException(string, throwable);
        }
        value$iv = tokens2.getServerToolWebSearchRequests() == 0;
        $i$f$pricingRequire = false;
        try {
            if (!value$iv) {
                boolean $i$a$-require-PricingRequireUtilsKt$pricingRequire$1$iv62 = false;
                boolean bl = false;
                String $i$a$-require-PricingRequireUtilsKt$pricingRequire$1$iv62 = "Server tool web search requests are not supported by OpenAILLMPricing".toString();
                throw new IllegalArgumentException($i$a$-require-PricingRequireUtilsKt$pricingRequire$1$iv62.toString());
            }
        }
        catch (Exception e$iv) {
            boolean bl = false;
            Throwable throwable = e$iv;
            String string = "Server tool web search requests are not supported by OpenAILLMPricing".toString();
            throw new PricingException(string, throwable);
        }
        value$iv = tokens2.getServiceTier() == null;
        $i$f$pricingRequire = false;
        try {
            if (!value$iv) {
                boolean $i$a$-require-PricingRequireUtilsKt$pricingRequire$1$iv72 = false;
                boolean bl = false;
                String $i$a$-require-PricingRequireUtilsKt$pricingRequire$1$iv72 = "Service tier is not supported by OpenAILLMPricing".toString();
                throw new IllegalArgumentException($i$a$-require-PricingRequireUtilsKt$pricingRequire$1$iv72.toString());
            }
        }
        catch (Exception e$iv) {
            boolean bl = false;
            Throwable throwable = e$iv;
            String string = "Service tier is not supported by OpenAILLMPricing".toString();
            throw new PricingException(string, throwable);
        }
        T cacheReadPrice = LLMPricingUtilsKt.price(this.cacheRead, tokens2.getCacheReadTokens(), (Function0<? extends Object>)((Function0)OpenAILLMPricing::estimate$lambda$6));
        T thinkingPrice = LLMPricingUtilsKt.price(this.thinking, tokens2.getThinkingTokens(), (Function0<? extends Object>)((Function0)OpenAILLMPricing::estimate$lambda$7));
        T inputPrice = this.input.estimate(tokens2.getInputTokens());
        T outputPrice = this.output.estimate(tokens2.getOutputTokens());
        return new BudgetInfo((Money)inputPrice, (Money)outputPrice, (Money)cacheReadPrice, null, (Money)thinkingPrice, null, null, null, null, 488, null);
    }

    public OpenAILLMPricing(@NotNull T inputPerToken, @NotNull T outputPerToken, @Nullable T cacheReadPerToken, @Nullable T thinkingPerToken) {
        FixedResourcePricing<T> fixedResourcePricing;
        FixedResourcePricing<T> fixedResourcePricing2;
        FixedResourcePricing<T> fixedResourcePricing3;
        T it;
        OpenAILLMPricing<ResourcePricing> openAILLMPricing;
        ResourcePricing resourcePricing;
        ResourcePricing resourcePricing2;
        Intrinsics.checkNotNullParameter(inputPerToken, (String)"inputPerToken");
        Intrinsics.checkNotNullParameter(outputPerToken, (String)"outputPerToken");
        OpenAILLMPricing<ResourcePricing> openAILLMPricing2 = this;
        ResourcePricing resourcePricing3 = new FixedResourcePricing<T>(inputPerToken);
        ResourcePricing resourcePricing4 = new FixedResourcePricing<T>(outputPerToken);
        T t = cacheReadPerToken;
        if (t != null) {
            T t2 = t;
            resourcePricing2 = resourcePricing4;
            resourcePricing = resourcePricing3;
            openAILLMPricing = openAILLMPricing2;
            boolean bl = false;
            fixedResourcePricing3 = new FixedResourcePricing<T>(it);
            openAILLMPricing2 = openAILLMPricing;
            resourcePricing3 = resourcePricing;
            resourcePricing4 = resourcePricing2;
            fixedResourcePricing2 = fixedResourcePricing3;
        } else {
            fixedResourcePricing2 = null;
        }
        FixedResourcePricing<T> fixedResourcePricing4 = fixedResourcePricing2;
        T t3 = thinkingPerToken;
        if (t3 != null) {
            it = t3;
            fixedResourcePricing3 = fixedResourcePricing4;
            resourcePricing2 = resourcePricing4;
            resourcePricing = resourcePricing3;
            openAILLMPricing = openAILLMPricing2;
            boolean bl = false;
            FixedResourcePricing<T> fixedResourcePricing5 = new FixedResourcePricing<T>(it);
            openAILLMPricing2 = openAILLMPricing;
            resourcePricing3 = resourcePricing;
            resourcePricing4 = resourcePricing2;
            fixedResourcePricing4 = fixedResourcePricing3;
            fixedResourcePricing = fixedResourcePricing5;
        } else {
            fixedResourcePricing = null;
        }
        openAILLMPricing2(resourcePricing3, resourcePricing4, fixedResourcePricing4, fixedResourcePricing);
    }

    public /* synthetic */ OpenAILLMPricing(Money money, Money money2, Money money3, Money money4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            money3 = null;
        }
        if ((n & 8) != 0) {
            money4 = null;
        }
        this(money, money2, money3, money4);
    }

    private static final Object estimate$lambda$6() {
        return "Cache read context price is not set";
    }

    private static final Object estimate$lambda$7() {
        return "Thinking price is not set";
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u000e\b\u0001\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lai/grazie/llm/provider/openai/profile/OpenAILLMPricing$Companion;", "", "<init>", "()V", "fromConfigurablePricing", "Lai/grazie/llm/provider/openai/profile/OpenAILLMPricing;", "T", "Lai/grazie/utils/mpp/money/Money;", "configurablePricing", "Lai/grazie/llm/profile/ConfigurablePricing;", "llm-provider-openai-profile"})
    @SourceDebugExtension(value={"SMAP\nOpenAILLMPricing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenAILLMPricing.kt\nai/grazie/llm/provider/openai/profile/OpenAILLMPricing$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n1#2:102\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T extends Money<T>> OpenAILLMPricing<T> fromConfigurablePricing(@NotNull ConfigurablePricing configurablePricing) {
            Object t;
            Object t2;
            Object t3;
            Money<?> it;
            Object obj;
            Object obj2;
            Intrinsics.checkNotNullParameter((Object)configurablePricing, (String)"configurablePricing");
            Money<?> money = configurablePricing.price(ConfigurablePricing.PriceType.INPUT);
            Intrinsics.checkNotNull(money);
            Money<?> inputPrice = money;
            Money<?> money2 = configurablePricing.price(ConfigurablePricing.PriceType.OUTPUT);
            Intrinsics.checkNotNull(money2);
            Money<?> outputPrice = money2;
            Money<?> money3 = configurablePricing.price(ConfigurablePricing.PriceType.CACHE_READ);
            Money<?> cacheReadPrice = money3 instanceof Money ? money3 : null;
            Money<?> money4 = configurablePricing.price(ConfigurablePricing.PriceType.THINKING);
            Money<?> thinkingPrice = money4 instanceof Money ? money4 : null;
            int shift = switch (WhenMappings.$EnumSwitchMapping$0[configurablePricing.getRange().ordinal()]) {
                case 1 -> 6;
                case 2 -> 3;
                case 3 -> 0;
                default -> throw new NoWhenBranchMatchedException();
            };
            Object obj3 = inputPrice.shr(shift);
            Object obj4 = outputPrice.shr(shift);
            Money<?> money5 = cacheReadPrice;
            if (money5 != null) {
                Money<?> money6 = money5;
                obj2 = obj4;
                obj = obj3;
                boolean bl = false;
                t3 = it.shr(shift);
                obj3 = obj;
                obj4 = obj2;
                t2 = t3;
            } else {
                t2 = null;
            }
            Money<?> money7 = thinkingPrice;
            if (money7 != null) {
                it = money7;
                t3 = t2;
                obj2 = obj4;
                obj = obj3;
                boolean bl = false;
                Object obj5 = it.shr(shift);
                obj3 = obj;
                obj4 = obj2;
                t2 = t3;
                t = obj5;
            } else {
                t = null;
            }
            Object t4 = t;
            Object t5 = t2;
            Object obj6 = obj4;
            Object obj7 = obj3;
            return new OpenAILLMPricing<Object>(obj7, obj6, t5, t4);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ConfigurablePricing.PricingRange.values().length];
                try {
                    nArray[ConfigurablePricing.PricingRange.PER_MILLION.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ConfigurablePricing.PricingRange.PER_THOUSAND.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ConfigurablePricing.PricingRange.PER_TOKEN.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

