/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.llm.provider.openai.profile.definitions;

import ai.grazie.model.cloud.exceptions.ExtensionsKt;
import ai.grazie.model.llm.definitions.LLMParameterDescriptor;
import ai.grazie.model.llm.definitions.ParameterDefinition;
import ai.grazie.model.llm.parameters.LLMParameters;
import ai.grazie.model.llm.profile.LLMProfile;
import ai.grazie.model.llm.utils.AttributesExtensionKt;
import ai.grazie.utils.attributes.Attributes;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b \u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013H\u0014J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0002R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Lai/grazie/llm/provider/openai/profile/definitions/OpenAIParameterDefinition;", "Lai/grazie/model/llm/definitions/ParameterDefinition;", "supportedLLMParameterDescriptors", "", "Lai/grazie/model/llm/definitions/LLMParameterDescriptor;", "<init>", "(Ljava/util/Set;)V", "getSupportedLLMParameterDescriptors", "()Ljava/util/Set;", "validateResponseFormat", "", "parameters", "Lai/grazie/utils/attributes/Attributes;", "validateParameters", "name", "", "profile", "Lai/grazie/model/llm/profile/LLMProfile;", "supportedValuesForReasoningEffort", "", "notSupportedTogether", "a", "b", "llm-provider-openai-profile"})
public abstract class OpenAIParameterDefinition
implements ParameterDefinition {
    @NotNull
    private final Set<LLMParameterDescriptor> supportedLLMParameterDescriptors;

    public OpenAIParameterDefinition(@NotNull Set<? extends LLMParameterDescriptor> supportedLLMParameterDescriptors) {
        Intrinsics.checkNotNullParameter(supportedLLMParameterDescriptors, (String)"supportedLLMParameterDescriptors");
        this.supportedLLMParameterDescriptors = supportedLLMParameterDescriptors;
    }

    @Override
    @NotNull
    public Set<LLMParameterDescriptor> getSupportedLLMParameterDescriptors() {
        return this.supportedLLMParameterDescriptors;
    }

    public void validateResponseFormat(@NotNull Attributes parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        AttributesExtensionKt.getResponseFormat(parameters);
    }

    @Override
    public void validateParameters(@NotNull String name2, @NotNull Attributes parameters, @NotNull LLMProfile profile) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        ParameterDefinition.super.validateParameters(name2, parameters, profile);
        if (AttributesExtensionKt.getPredictedOutput(parameters) != null) {
            boolean bl = false;
            ExtensionsKt.requireOrBadRequest(AttributesExtensionKt.getResponseFormat(parameters) == null, (Function0<String>)((Function0)() -> OpenAIParameterDefinition.validateParameters$lambda$4$lambda$0(this)));
            ExtensionsKt.requireOrBadRequest(AttributesExtensionKt.getLength(parameters) == null, (Function0<String>)((Function0)() -> OpenAIParameterDefinition.validateParameters$lambda$4$lambda$1(this)));
            ExtensionsKt.requireOrBadRequest(AttributesExtensionKt.getFunctions(parameters) == null, (Function0<String>)((Function0)() -> OpenAIParameterDefinition.validateParameters$lambda$4$lambda$2(this)));
            ExtensionsKt.requireOrBadRequest(AttributesExtensionKt.getNumberOfChoices(parameters) == null, (Function0<String>)((Function0)() -> OpenAIParameterDefinition.validateParameters$lambda$4$lambda$3(this)));
        }
        Double d = AttributesExtensionKt.getTemperature(parameters);
        if (d != null) {
            double temperature = ((Number)d).doubleValue();
            boolean bl = false;
            ExtensionsKt.requireOrBadRequest(0.0 <= temperature ? temperature <= 2.0 : false, (Function0<String>)((Function0)OpenAIParameterDefinition::validateParameters$lambda$6$lambda$5));
        }
        Double d2 = AttributesExtensionKt.getTopP(parameters);
        if (d2 != null) {
            double topP = ((Number)d2).doubleValue();
            boolean bl = false;
            ExtensionsKt.requireOrBadRequest(0.0 <= topP ? topP <= 1.0 : false, (Function0<String>)((Function0)OpenAIParameterDefinition::validateParameters$lambda$8$lambda$7));
        }
        String string = AttributesExtensionKt.getReasoningEffort(parameters);
        if (string != null) {
            String effort = string;
            boolean bl = false;
            List<String> supportedValues = this.supportedValuesForReasoningEffort();
            ExtensionsKt.requireOrBadRequest(supportedValues.contains(effort), (Function0<String>)((Function0)() -> OpenAIParameterDefinition.validateParameters$lambda$10$lambda$9(effort, supportedValues)));
        }
        String string2 = AttributesExtensionKt.getVerbosity(parameters);
        if (string2 != null) {
            String verbosity = string2;
            boolean bl = false;
            Object[] objectArray = new String[]{"low", "medium", "high"};
            ExtensionsKt.requireOrBadRequest(CollectionsKt.listOf((Object[])objectArray).contains(verbosity), (Function0<String>)((Function0)OpenAIParameterDefinition::validateParameters$lambda$12$lambda$11));
        }
        this.validateResponseFormat(parameters);
    }

    @NotNull
    protected List<String> supportedValuesForReasoningEffort() {
        Object[] objectArray = new String[]{"low", "medium", "high"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final String notSupportedTogether(String a, String b) {
        return "Parameter " + a + " not supported with parameter " + b;
    }

    private static final String validateParameters$lambda$4$lambda$0(OpenAIParameterDefinition this$0) {
        return this$0.notSupportedTogether(LLMParameters.INSTANCE.getPredictedOutput().getFqdn(), LLMParameters.INSTANCE.getResponseFormat().getFqdn());
    }

    private static final String validateParameters$lambda$4$lambda$1(OpenAIParameterDefinition this$0) {
        return this$0.notSupportedTogether(LLMParameters.INSTANCE.getPredictedOutput().getFqdn(), LLMParameters.INSTANCE.getLength().getFqdn());
    }

    private static final String validateParameters$lambda$4$lambda$2(OpenAIParameterDefinition this$0) {
        return this$0.notSupportedTogether(LLMParameters.INSTANCE.getPredictedOutput().getFqdn(), LLMParameters.INSTANCE.getFunctions().getFqdn());
    }

    private static final String validateParameters$lambda$4$lambda$3(OpenAIParameterDefinition this$0) {
        return this$0.notSupportedTogether(LLMParameters.INSTANCE.getPredictedOutput().getFqdn(), LLMParameters.INSTANCE.getNumberOfChoices().getFqdn());
    }

    private static final String validateParameters$lambda$6$lambda$5() {
        return "Acceptable values of temperature: [0.0: 2.0]";
    }

    private static final String validateParameters$lambda$8$lambda$7() {
        return "Acceptable values of top-p: [0.0: 1.0]";
    }

    private static final String validateParameters$lambda$10$lambda$9(String $effort, List $supportedValues) {
        return "Invalid reasoning effort: " + $effort + ". Acceptable values: " + $supportedValues;
    }

    private static final String validateParameters$lambda$12$lambda$11() {
        return "Acceptable values of verbosity: [low, medium, high]";
    }
}

