/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.utils.mpp;

import ai.grazie.utils.mpp.DataLoader;
import ai.grazie.utils.mpp.Resources;
import ai.grazie.utils.mpp.RootStreamDataLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000e"}, d2={"Lai/grazie/utils/mpp/FromServerResourcesDataLoader;", "Lai/grazie/utils/mpp/RootStreamDataLoader;", "<init>", "()V", "stream", "Ljava/io/InputStream;", "path", "Lai/grazie/utils/mpp/DataLoader$Path;", "bytes", "", "(Lai/grazie/utils/mpp/DataLoader$Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "text", "", "absolute", "utils-common"})
@SourceDebugExtension(value={"SMAP\nLoaders.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Loaders.kt\nai/grazie/utils/mpp/FromServerResourcesDataLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,165:1\n1863#2,2:166\n*S KotlinDebug\n*F\n+ 1 Loaders.kt\nai/grazie/utils/mpp/FromServerResourcesDataLoader\n*L\n73#1:166,2\n*E\n"})
public final class FromServerResourcesDataLoader
implements RootStreamDataLoader {
    @NotNull
    public static final FromServerResourcesDataLoader INSTANCE = new FromServerResourcesDataLoader();

    private FromServerResourcesDataLoader() {
    }

    @Override
    @NotNull
    public InputStream stream(@NotNull DataLoader.Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        InputStream inputStream2 = Resources.INSTANCE.streamOrNull(path.toAbsolutePath());
        if (inputStream2 == null) {
            inputStream2 = new FileInputStream(new File(this.absolute(path).toAbsolutePath()));
        }
        return inputStream2;
    }

    @Override
    @Nullable
    public Object bytes(@NotNull DataLoader.Path path, @NotNull Continuation<? super byte[]> $completion) {
        byte[] byArray = Resources.INSTANCE.bytesOrNull(path.toAbsolutePath());
        if (byArray == null) {
            byArray = FilesKt.readBytes((File)new File(this.absolute(path).toAbsolutePath()));
        }
        return byArray;
    }

    @Override
    @Nullable
    public Object text(@NotNull DataLoader.Path path, @NotNull Continuation<? super String> $completion) {
        String string = Resources.INSTANCE.textOrNull(path.toAbsolutePath());
        if (string == null) {
            string = FilesKt.readText$default((File)new File(this.absolute(path).toAbsolutePath()), null, (int)1, null);
        }
        return string;
    }

    @Override
    @NotNull
    public DataLoader.Path absolute(@NotNull DataLoader.Path path) {
        List lfsResourceDirectories;
        List list2;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        DataLoader.Path serverRoot = new DataLoader.Path("/server/lib", path);
        if (new File(serverRoot.toAbsolutePath()).exists()) {
            return serverRoot;
        }
        DataLoader.Path serverUser = new DataLoader.Path("/home/grazie/server/lib", path);
        if (new File(serverUser.toAbsolutePath()).exists()) {
            return serverUser;
        }
        DataLoader.Path test = new DataLoader.Path("build/resources/main", path);
        if (new File(test.toRelativePath()).exists()) {
            String string = new File(test.toRelativePath()).getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            return new DataLoader.Path(string);
        }
        String string = System.getenv("LFS_RESOURCES");
        if (string != null) {
            String[] stringArray = new String[]{";"};
            list2 = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        } else {
            list2 = null;
        }
        List list3 = lfsResourceDirectories = list2;
        if (list3 != null) {
            Iterable $this$forEach$iv = list3;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                DataLoader.Path lfsFilePath = new DataLoader.Path(it, path);
                if (!new File(lfsFilePath.toAbsolutePath()).exists()) continue;
                String string2 = new File(lfsFilePath.toAbsolutePath()).getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
                return new DataLoader.Path(string2);
            }
        }
        throw new IllegalStateException(("Can't find " + path.toAbsolutePath() + " in test resources, lfs resources or in server/lib directory").toString());
    }
}

