/*
 * Decompiled with CFR 0.152.
 */
package ai.koog.agents.features.opentelemetry.span;

import ai.koog.agents.features.opentelemetry.attribute.CommonAttributes;
import ai.koog.agents.features.opentelemetry.attribute.SpanAttributes;
import ai.koog.agents.features.opentelemetry.span.GenAIAgentSpan;
import ai.koog.prompt.llm.LLModel;
import io.opentelemetry.api.trace.SpanKind;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lai/koog/agents/features/opentelemetry/span/CreateAgentSpan;", "Lai/koog/agents/features/opentelemetry/span/GenAIAgentSpan;", "model", "Lai/koog/prompt/llm/LLModel;", "agentId", "", "<init>", "(Lai/koog/prompt/llm/LLModel;Ljava/lang/String;)V", "getModel", "()Lai/koog/prompt/llm/LLModel;", "getAgentId", "()Ljava/lang/String;", "spanId", "getSpanId", "kind", "Lio/opentelemetry/api/trace/SpanKind;", "getKind", "()Lio/opentelemetry/api/trace/SpanKind;", "Companion", "agents-features-opentelemetry"})
public final class CreateAgentSpan
extends GenAIAgentSpan {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LLModel model;
    @NotNull
    private final String agentId;
    @NotNull
    private final String spanId;
    @NotNull
    private final SpanKind kind;

    public CreateAgentSpan(@NotNull LLModel model, @NotNull String agentId) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        super(null);
        this.model = model;
        this.agentId = agentId;
        this.spanId = Companion.createId(this.agentId);
        this.kind = SpanKind.CLIENT;
        this.addAttribute(new SpanAttributes.Operation.Name(SpanAttributes.Operation.OperationNameType.CREATE_AGENT));
        this.addAttribute(new CommonAttributes.System(this.model.getProvider()));
        this.addAttribute(new SpanAttributes.Agent.Id(this.agentId));
        this.addAttribute(new SpanAttributes.Request.Model(this.model));
    }

    @NotNull
    public final LLModel getModel() {
        return this.model;
    }

    @NotNull
    public final String getAgentId() {
        return this.agentId;
    }

    @Override
    @NotNull
    public String getSpanId() {
        return this.spanId;
    }

    @Override
    @NotNull
    public SpanKind getKind() {
        return this.kind;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u00a8\u0006\u0007"}, d2={"Lai/koog/agents/features/opentelemetry/span/CreateAgentSpan$Companion;", "", "<init>", "()V", "createId", "", "agentId", "agents-features-opentelemetry"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String createId(@NotNull String agentId) {
            Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
            return "agent." + agentId;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

