/*
 * Decompiled with CFR 0.152.
 */
package ai.koog.prompt.executor.llms.all;

import ai.koog.prompt.executor.clients.anthropic.AnthropicLLMClient;
import ai.koog.prompt.executor.clients.google.GoogleLLMClient;
import ai.koog.prompt.executor.clients.mistralai.MistralAILLMClient;
import ai.koog.prompt.executor.clients.openai.OpenAILLMClient;
import ai.koog.prompt.executor.clients.openai.azure.AzureKt;
import ai.koog.prompt.executor.clients.openai.azure.AzureOpenAIServiceVersion;
import ai.koog.prompt.executor.clients.openrouter.OpenRouterLLMClient;
import ai.koog.prompt.executor.llms.SingleLLMPromptExecutor;
import ai.koog.prompt.executor.ollama.client.OllamaClient;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a&\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0003\u001a\u000e\u0010\f\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0003\u001a\u000e\u0010\r\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0003\u001a\u0010\u0010\u000e\u001a\u00020\u00012\b\b\u0002\u0010\t\u001a\u00020\u0003\u001a\u000e\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0003\u00a8\u0006\u0010"}, d2={"simpleOpenAIExecutor", "Lai/koog/prompt/executor/llms/SingleLLMPromptExecutor;", "apiToken", "", "simpleAzureOpenAIExecutor", "resourceName", "deploymentName", "version", "Lai/koog/prompt/executor/clients/openai/azure/AzureOpenAIServiceVersion;", "baseUrl", "simpleAnthropicExecutor", "apiKey", "simpleOpenRouterExecutor", "simpleGoogleAIExecutor", "simpleOllamaAIExecutor", "simpleMistralAIExecutor", "prompt-executor-llms-all"})
public final class SimplePromptExecutorsKt {
    @NotNull
    public static final SingleLLMPromptExecutor simpleOpenAIExecutor(@NotNull String apiToken) {
        Intrinsics.checkNotNullParameter((Object)apiToken, (String)"apiToken");
        return new SingleLLMPromptExecutor(new OpenAILLMClient(apiToken, null, null, null, 14, null));
    }

    @NotNull
    public static final SingleLLMPromptExecutor simpleAzureOpenAIExecutor(@NotNull String resourceName, @NotNull String deploymentName, @NotNull AzureOpenAIServiceVersion version, @NotNull String apiToken) {
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        Intrinsics.checkNotNullParameter((Object)deploymentName, (String)"deploymentName");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)apiToken, (String)"apiToken");
        return new SingleLLMPromptExecutor(new OpenAILLMClient(apiToken, AzureKt.AzureOpenAIClientSettings$default(resourceName, deploymentName, version, null, 8, null), null, null, 12, null));
    }

    @NotNull
    public static final SingleLLMPromptExecutor simpleAzureOpenAIExecutor(@NotNull String baseUrl, @NotNull AzureOpenAIServiceVersion version, @NotNull String apiToken) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)apiToken, (String)"apiToken");
        return new SingleLLMPromptExecutor(new OpenAILLMClient(apiToken, AzureKt.AzureOpenAIClientSettings$default(baseUrl, version, null, 4, null), null, null, 12, null));
    }

    @NotNull
    public static final SingleLLMPromptExecutor simpleAnthropicExecutor(@NotNull String apiKey) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        return new SingleLLMPromptExecutor(new AnthropicLLMClient(apiKey, null, null, null, 14, null));
    }

    @NotNull
    public static final SingleLLMPromptExecutor simpleOpenRouterExecutor(@NotNull String apiKey) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        return new SingleLLMPromptExecutor(new OpenRouterLLMClient(apiKey, null, null, null, 14, null));
    }

    @NotNull
    public static final SingleLLMPromptExecutor simpleGoogleAIExecutor(@NotNull String apiKey) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        return new SingleLLMPromptExecutor(new GoogleLLMClient(apiKey, null, null, null, 14, null));
    }

    @NotNull
    public static final SingleLLMPromptExecutor simpleOllamaAIExecutor(@NotNull String baseUrl) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        return new SingleLLMPromptExecutor(new OllamaClient(baseUrl, null, null, null, null, 30, null));
    }

    public static /* synthetic */ SingleLLMPromptExecutor simpleOllamaAIExecutor$default(String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "http://localhost:11434";
        }
        return SimplePromptExecutorsKt.simpleOllamaAIExecutor(string);
    }

    @NotNull
    public static final SingleLLMPromptExecutor simpleMistralAIExecutor(@NotNull String apiKey) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        return new SingleLLMPromptExecutor(new MistralAILLMClient(apiKey, null, null, null, 14, null));
    }
}

