/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.auth;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import org.apache.hc.client5.http.AuthenticationStrategy;
import org.apache.hc.client5.http.auth.AuthChallenge;
import org.apache.hc.client5.http.auth.AuthExchange;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthenticationException;
import org.apache.hc.client5.http.auth.ChallengeType;
import org.apache.hc.client5.http.auth.MalformedChallengeException;
import org.apache.hc.client5.http.impl.auth.AuthChallengeParser;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.FormattedHeader;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.ParserCursor;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Asserts;
import org.apache.hc.core5.util.CharArrayBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
@Contract(threading=ThreadingBehavior.STATELESS)
public class AuthenticationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationHandler.class);
    private final AuthChallengeParser parser = new AuthChallengeParser();

    public boolean isChallenged(HttpHost host, ChallengeType challengeType, HttpResponse response2, AuthExchange authExchange, HttpContext context2) {
        HttpClientContext clientContext = HttpClientContext.cast(context2);
        if (this.checkChallenged(challengeType, response2, clientContext)) {
            return true;
        }
        switch (authExchange.getState()) {
            case CHALLENGED: 
            case HANDSHAKE: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} Server has accepted authentication", (Object)clientContext.getExchangeId());
                }
                authExchange.setState(AuthExchange.State.SUCCESS);
                break;
            }
            case SUCCESS: {
                break;
            }
            default: {
                authExchange.setState(AuthExchange.State.UNCHALLENGED);
            }
        }
        return false;
    }

    private boolean checkChallenged(ChallengeType challengeType, HttpResponse response2, HttpClientContext clientContext) {
        int challengeCode;
        switch (challengeType) {
            case TARGET: {
                challengeCode = 401;
                break;
            }
            case PROXY: {
                challengeCode = 407;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected challenge type: " + (Object)((Object)challengeType));
            }
        }
        if (response2.getCode() == challengeCode) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Authentication required", (Object)clientContext.getExchangeId());
            }
            return true;
        }
        return false;
    }

    public boolean isChallengeExpected(AuthExchange authExchange) {
        AuthScheme authScheme = authExchange.getAuthScheme();
        return authScheme != null && authScheme.isChallengeExpected();
    }

    public Map<String, AuthChallenge> extractChallengeMap(ChallengeType challengeType, HttpResponse response2, HttpClientContext context2) {
        HashMap<String, AuthChallenge> challengeMap = new HashMap<String, AuthChallenge>();
        Iterator<Header> headerIterator = response2.headerIterator(challengeType == ChallengeType.PROXY ? "Proxy-Authenticate" : "WWW-Authenticate");
        while (headerIterator.hasNext()) {
            List<AuthChallenge> authChallenges;
            int pos;
            CharArrayBuffer buffer;
            Header header = headerIterator.next();
            if (header instanceof FormattedHeader) {
                buffer = ((FormattedHeader)header).getBuffer();
                pos = ((FormattedHeader)header).getValuePos();
            } else {
                String s = header.getValue();
                if (s == null) continue;
                buffer = new CharArrayBuffer(s.length());
                buffer.append(s);
                pos = 0;
            }
            ParserCursor cursor = new ParserCursor(pos, buffer.length());
            try {
                authChallenges = this.parser.parse(challengeType, buffer, cursor);
            }
            catch (ParseException ex) {
                if (!LOG.isWarnEnabled()) continue;
                HttpClientContext clientContext = HttpClientContext.cast(context2);
                String exchangeId = clientContext.getExchangeId();
                LOG.warn("{} Malformed challenge: {}", (Object)exchangeId, (Object)header.getValue());
                continue;
            }
            for (AuthChallenge authChallenge : authChallenges) {
                String schemeName = authChallenge.getSchemeName().toLowerCase(Locale.ROOT);
                if (challengeMap.containsKey(schemeName)) continue;
                challengeMap.put(schemeName, authChallenge);
            }
        }
        return challengeMap;
    }

    /*
     * Unable to fully structure code
     */
    public boolean handleResponse(HttpHost host, ChallengeType challengeType, HttpResponse response, AuthenticationStrategy authStrategy, AuthExchange authExchange, HttpContext context) throws AuthenticationException, MalformedChallengeException {
        clientContext = HttpClientContext.cast(context);
        exchangeId = clientContext.getExchangeId();
        challenged = this.checkChallenged(challengeType, response, clientContext);
        isChallengeExpected = this.isChallengeExpected(authExchange);
        if (AuthenticationHandler.LOG.isDebugEnabled()) {
            AuthenticationHandler.LOG.debug("{} {} requested authentication", (Object)exchangeId, (Object)host.toHostString());
        }
        if ((challengeMap = this.extractChallengeMap(challengeType, response, clientContext)).isEmpty()) {
            if (AuthenticationHandler.LOG.isDebugEnabled()) {
                AuthenticationHandler.LOG.debug("{} Response contains no valid authentication challenges", (Object)exchangeId);
            }
            if (!isChallengeExpected) {
                authExchange.reset();
                return false;
            }
        }
        switch (1.$SwitchMap$org$apache$hc$client5$http$auth$AuthExchange$State[authExchange.getState().ordinal()]) {
            case 4: {
                return false;
            }
            case 3: {
                if (!isChallengeExpected) {
                    authExchange.reset();
                    break;
                }
            }
            case 1: 
            case 2: {
                Asserts.notNull(authExchange.getAuthScheme(), "AuthScheme");
            }
            case 5: {
                authScheme = authExchange.getAuthScheme();
                if (authScheme == null) break;
                schemeName = authScheme.getName();
                challenge = challengeMap.get(schemeName.toLowerCase(Locale.ROOT));
                if (challenge == null && !isChallengeExpected) ** GOTO lbl51
                if (AuthenticationHandler.LOG.isDebugEnabled()) {
                    AuthenticationHandler.LOG.debug("{} Processing authentication challenge {}", (Object)exchangeId, (Object)challenge);
                }
                try {
                    authScheme.processChallenge(host, challenged, challenge, clientContext);
                }
                catch (AuthenticationException | MalformedChallengeException ex) {
                    if (AuthenticationHandler.LOG.isWarnEnabled()) {
                        AuthenticationHandler.LOG.warn("Exception processing challenge {}", (Object)exchangeId, (Object)ex);
                    }
                    authExchange.reset();
                    authExchange.setState(AuthExchange.State.FAILURE);
                    if (!isChallengeExpected) ** GOTO lbl40
                    throw ex;
                }
lbl40:
                // 2 sources

                if (authScheme.isChallengeComplete()) {
                    if (AuthenticationHandler.LOG.isDebugEnabled()) {
                        AuthenticationHandler.LOG.debug("{} Authentication failed", (Object)exchangeId);
                    }
                    authExchange.reset();
                    authExchange.setState(AuthExchange.State.FAILURE);
                    return false;
                }
                if (!challenged) {
                    authExchange.setState(AuthExchange.State.SUCCESS);
                    return false;
                }
                authExchange.setState(AuthExchange.State.HANDSHAKE);
                return true;
lbl51:
                // 1 sources

                authExchange.reset();
            }
        }
        preferredSchemes = authStrategy.select(challengeType, challengeMap, clientContext);
        credsProvider = clientContext.getCredentialsProvider();
        if (credsProvider == null) {
            if (AuthenticationHandler.LOG.isDebugEnabled()) {
                AuthenticationHandler.LOG.debug("{} Credentials provider not set in the context", (Object)exchangeId);
            }
            return false;
        }
        authOptions = new LinkedList<AuthScheme>();
        if (AuthenticationHandler.LOG.isDebugEnabled()) {
            AuthenticationHandler.LOG.debug("{} Selecting authentication options", (Object)exchangeId);
        }
        for (AuthScheme authScheme : preferredSchemes) {
            try {
                schemeName = authScheme.getName();
                challenge = challengeMap.get(schemeName.toLowerCase(Locale.ROOT));
                authScheme.processChallenge(host, challenged, challenge, clientContext);
                if (!authScheme.isResponseReady(host, credsProvider, clientContext)) continue;
                authOptions.add(authScheme);
            }
            catch (AuthenticationException | MalformedChallengeException ex) {
                if (!AuthenticationHandler.LOG.isWarnEnabled()) continue;
                AuthenticationHandler.LOG.warn("Exception while processing Challange", (Throwable)ex);
            }
        }
        if (!authOptions.isEmpty()) {
            if (AuthenticationHandler.LOG.isDebugEnabled()) {
                AuthenticationHandler.LOG.debug("{} Selected authentication options: {}", (Object)exchangeId, authOptions);
            }
            authExchange.reset();
            authExchange.setState(AuthExchange.State.CHALLENGED);
            authExchange.setOptions(authOptions);
            return true;
        }
        return false;
    }

    public void addAuthResponse(HttpHost host, ChallengeType challengeType, HttpRequest request, AuthExchange authExchange, HttpContext context2) {
        block14: {
            HttpClientContext clientContext = HttpClientContext.cast(context2);
            String exchangeId = clientContext.getExchangeId();
            AuthScheme authScheme = authExchange.getAuthScheme();
            switch (authExchange.getState()) {
                case FAILURE: {
                    return;
                }
                case SUCCESS: {
                    Asserts.notNull(authScheme, "AuthScheme");
                    if (!authScheme.isConnectionBased()) break;
                    return;
                }
                case HANDSHAKE: {
                    Asserts.notNull(authScheme, "AuthScheme");
                    break;
                }
                case CHALLENGED: {
                    Queue<AuthScheme> authOptions = authExchange.getAuthOptions();
                    if (authOptions != null) {
                        while (!authOptions.isEmpty()) {
                            authScheme = authOptions.remove();
                            authExchange.select(authScheme);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("{} Generating response to an authentication challenge using {} scheme", (Object)exchangeId, (Object)authScheme.getName());
                            }
                            try {
                                String authResponse = authScheme.generateAuthResponse(host, request, clientContext);
                                if (authResponse == null) break;
                                BasicHeader header = new BasicHeader(challengeType == ChallengeType.TARGET ? "Authorization" : "Proxy-Authorization", authResponse);
                                request.addHeader(header);
                                break;
                            }
                            catch (AuthenticationException ex) {
                                if (!LOG.isWarnEnabled()) continue;
                                LOG.warn("{} {} authentication error: {}", new Object[]{exchangeId, authScheme, ex.getMessage()});
                            }
                        }
                        return;
                    }
                    Asserts.notNull(authScheme, "AuthScheme");
                }
            }
            if (authScheme != null) {
                try {
                    String authResponse = authScheme.generateAuthResponse(host, request, clientContext);
                    BasicHeader header = new BasicHeader(challengeType == ChallengeType.TARGET ? "Authorization" : "Proxy-Authorization", authResponse);
                    request.addHeader(header);
                }
                catch (AuthenticationException ex) {
                    if (!LOG.isErrorEnabled()) break block14;
                    LOG.error("{} {} authentication error: {}", new Object[]{exchangeId, authScheme, ex.getMessage()});
                }
            }
        }
    }
}

